/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.helper.MetaDataHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XlogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LevelFieldsInfo;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeTypeEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import org.apache.commons.lang3.ArrayUtils;

public class XBillLogHelper {
    public static Map<String, String> compareSrcBillNXBill(DynamicObject srcBill, DynamicObject xBill, Map<String, Map<String, String>> xBillEntryAndField) {
        if (srcBill != null && xBill != null) {
            HashMap<String, String> rs = new HashMap<String, String>();
            String[] billfields = ChangeModelHelper.getCanLogProperty((IDataEntityType)xBill.getDynamicObjectType());
            StringBuilder billMD = new StringBuilder();
            billMD.append("### ").append(srcBill.getDataEntityType().getDisplayName()).append('\u3010').append(srcBill.getString("billno")).append('\u3011').append(ResManager.loadKDString((String)"\u53d8\u66f4\u60c5\u51b5", (String)"XBillLogHelper_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(" ### \n --- \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u4eba\uff1a", (String)"XBillLogHelper_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(XBillLogHelper.displayFieldValue(xBill.get("modifier"))).append("  \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u65e5\u671f\uff1a", (String)"XBillLogHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(XBillLogHelper.displayFieldValue(xBill.get("changebizdate"))).append("  \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u7248\u672c\uff1a", (String)"XBillLogHelper_3", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(xBill.get("version")).append("  \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u539f\u56e0\uff1a", (String)"XBillLogHelper_4", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(xBill.get("changereason")).append("   \n").append("#### ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u5185\u5bb9", (String)"XBillLogHelper_13", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(" ####\n").append('|').append(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0", (String)"XBillLogHelper_6", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append('|').append(ResManager.loadKDString((String)"\u539f\u503c", (String)"XBillLogHelper_7", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append('|').append(ResManager.loadKDString((String)"\u53d8\u66f4\u503c", (String)"XBillLogHelper_8", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append("|\n|-|-|-|\n");
            if (!CommonUtils.isNull((Object)billfields)) {
                for (int fi = 0; fi < billfields.length; ++fi) {
                    try {
                        Object srcField = srcBill.get(billfields[fi]);
                        Object newField = xBill.get(billfields[fi]);
                        String s1 = MetaDataHelper.getPropertyAlias(srcBill.getDataEntityType(), billfields[fi]);
                        DynamicProperty srcdp = srcBill.getDynamicObjectType().getProperty(billfields[fi]);
                        String s2 = XBillLogHelper.displayFieldValue(srcField, srcdp);
                        String s3 = XBillLogHelper.displayFieldValue(newField, srcdp);
                        billMD.append('|').append(s1).append(' ').append('|').append(s2).append(' ').append('|').append(s3).append("|\n");
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            rs.put(xBill.getDataEntityType().getName(), billMD.toString());
            rs.put("mdText", billMD.toString());
            List<EntityType> entryEntities = ChangeModelHelper.getChildEntities(xBill.getDataEntityType());
            for (EntityType entryEntity : entryEntities) {
                String[] canLogProperty;
                if (xBillEntryAndField == null || xBillEntryAndField.get(entryEntity.getName()) == null || entryEntity instanceof SubEntryType || CommonUtils.isNull((Object)(canLogProperty = ChangeModelHelper.getCanLogProperty(xBill.getDataEntityType(), entryEntity.getName())))) continue;
                String infoKey = xBillEntryAndField.get(entryEntity.getName()).get("subEntryInfo");
                if (StringUtils.isEmpty((CharSequence)infoKey)) {
                    String billEntryMD = "\n#### " + String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u5185\u5bb9", (String)"XBillLogHelper_5", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), entryEntity.getDisplayName()) + " ####\n";
                    billEntryMD = billEntryMD + XBillLogHelper.genMDFormatString(srcBill, xBill, entryEntity.getName(), entryEntity.getName(), canLogProperty, xBillEntryAndField.get(entryEntity.getName()).get("srcid"), xBillEntryAndField.get(entryEntity.getName()).get("changetype"));
                    rs.put(entryEntity.getName(), billEntryMD);
                    rs.put("mdText", rs.get("mdText") + billEntryMD);
                    continue;
                }
                String seqKey = xBillEntryAndField.get(entryEntity.getName()).get("seq") != null ? xBillEntryAndField.get(entryEntity.getName()).get("seq") : "seq";
                Set<String> changeEntryItems = XBillLogHelper.findChangeEntryItems(srcBill, xBill, entryEntity, xBillEntryAndField);
                String billEntryMD = XBillLogHelper.genMDFormatString(srcBill, xBill, entryEntity.getName(), entryEntity.getName(), entryEntity.getDisplayName(), canLogProperty, xBillEntryAndField.get(entryEntity.getName()).get("srcid"), xBillEntryAndField.get(entryEntity.getName()).get("changetype"), changeEntryItems);
                rs.put(entryEntity.getName(), billEntryMD);
                rs.put("mdText", rs.get("mdText") + billEntryMD);
                List subEntryTypes = entryEntities.stream().filter(v -> v instanceof SubEntryType).filter(v -> xBillEntryAndField.containsKey(v.getName())).filter(v -> v.getParent().getExtendName().equals(entryEntity.getExtendName())).collect(Collectors.toList());
                for (EntityType subEntryType : subEntryTypes) {
                    canLogProperty = ChangeModelHelper.getCanLogProperty(xBill.getDataEntityType(), subEntryType.getName());
                    if (CommonUtils.isNull((Object)canLogProperty)) continue;
                    billEntryMD = XBillLogHelper.genMDFormatStringOfSubEntry(srcBill, xBill, entryEntity.getName(), entryEntity.getName(), entryEntity.getDisplayName(), subEntryType.getDisplayName(), infoKey, seqKey, subEntryType.getName(), subEntryType.getName(), canLogProperty, xBillEntryAndField.get(entryEntity.getName()).get("srcid"), xBillEntryAndField.get(subEntryType.getName()).get("srcid"), xBillEntryAndField.get(subEntryType.getName()).get("changetype"), changeEntryItems);
                    rs.put(subEntryType.getName(), billEntryMD);
                    rs.put("mdText", rs.get("mdText") + billEntryMD);
                }
            }
            return rs;
        }
        return null;
    }

    public static Map<String, String> createMdLogByLogFields(DynamicObject bill, DynamicObject curVerXlog, Set<String> needLogFields) {
        return XBillLogHelper.createMdLogByLogFields(bill, curVerXlog, needLogFields, null);
    }

    public static Map<String, String> createMdLogByLogFields(DynamicObject bill, DynamicObject curVerXlog, Set<String> needLogFields, DynamicObject xbill) {
        if (bill != null) {
            HashMap<String, String> rs = new HashMap<String, String>();
            DynamicObjectCollection logEntrys = curVerXlog.getDynamicObjectCollection("entryentity");
            if (logEntrys == null || logEntrys.size() == 0) {
                return rs;
            }
            HashSet<DynamicObject> headFields = new HashSet<DynamicObject>(8);
            HashMap<String, Map> entryLogs = new HashMap<String, Map>(8);
            HashMap<String, List> cancelEntryLogs = new HashMap<String, List>(8);
            for (DynamicObject entry : logEntrys) {
                if (StringUtils.isBlank((CharSequence)entry.getString("entrykey"))) {
                    headFields.add(entry);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)entry.getString("fieldkey"))) continue;
                if (ChangeTypeEnum.CANCEL.getValue().equals(entry.getString("changetype"))) {
                    List list = cancelEntryLogs.computeIfAbsent(entry.getString("entrykey"), k -> new ArrayList());
                    HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
                    map.put(entry.getString("fieldkey"), entry);
                    list.add(map);
                    continue;
                }
                Map map = entryLogs.computeIfAbsent(entry.getString("entrykey"), k -> new HashMap());
                map.put(entry.getString("rowid") + entry.getString("fieldkey"), entry);
            }
            LevelFieldsInfo levelFields = XlogHelper.getLevelFields(bill.getDataEntityType().getName(), needLogFields);
            if (levelFields == null) {
                return rs;
            }
            String billNoId = ((BillEntityType)bill.getDataEntityType()).getBillNo();
            Date changBillDate = xbill != null && xbill.getDynamicObjectType().getProperty("changedate") != null ? xbill.getDate("changedate") : curVerXlog.getDate("biztime");
            StringBuilder billMD = new StringBuilder();
            billMD.append("### ").append(bill.getDataEntityType().getDisplayName()).append('\u3010').append(bill.getString(billNoId)).append('\u3011').append(ResManager.loadKDString((String)"\u53d8\u66f4\u60c5\u51b5", (String)"XBillLogHelper_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(" ### \n --- \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u4eba\uff1a", (String)"XBillLogHelper_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(XBillLogHelper.displayFieldValue(curVerXlog.get("creator"))).append("  \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u65e5\u671f\uff1a", (String)"XBillLogHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(XBillLogHelper.displayFieldValue(changBillDate)).append("  \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\uff1a", (String)"XBillLogHelper_12", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(BizChangeStatusEnum.getName(curVerXlog.getString("changestatus"))).append("  \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u7248\u672c\uff1a", (String)"XBillLogHelper_3", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(curVerXlog.getInt("srcbillversion") + 1).append("  \n").append("> ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u539f\u56e0\uff1a", (String)"XBillLogHelper_4", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(curVerXlog.get("xreason")).append("   \n").append("#### ").append(ResManager.loadKDString((String)"\u53d8\u66f4\u5185\u5bb9", (String)"XBillLogHelper_13", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(" ####\n").append('|').append(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0", (String)"XBillLogHelper_6", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append('|').append(ResManager.loadKDString((String)"\u539f\u503c", (String)"XBillLogHelper_7", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append('|').append(ResManager.loadKDString((String)"\u53d8\u66f4\u503c", (String)"XBillLogHelper_8", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append("|\n|-|-|-|\n");
            for (DynamicObject dynamicObject : headFields) {
                String field = dynamicObject.getString("fieldkey");
                String s1 = MetaDataHelper.getPropertyAlias(bill.getDataEntityType(), field);
                billMD.append('|').append(s1).append(' ').append('|').append(dynamicObject.getString("beforevalue")).append(' ').append('|').append(dynamicObject.getString("aftervalue")).append("|\n");
            }
            rs.put(bill.getDataEntityType().getName(), billMD.toString());
            rs.put("mdText", billMD.toString());
            HashMap<String, List<String>> entryFields = new HashMap<String, List<String>>(8);
            for (LevelFieldsInfo level : levelFields.getNextLeves()) {
                entryFields.put(level.getCurrentApKey(), level.getFields());
            }
            List<EntityType> list = ChangeModelHelper.getChildEntities(bill.getDataEntityType());
            for (EntityType entryEntity : list) {
                List cancelLogs;
                String[] canLogProperty;
                if (!entryFields.containsKey(entryEntity.getName()) || CommonUtils.isNull((Object)(canLogProperty = ((List)entryFields.get(entryEntity.getName())).toArray(new String[0])))) continue;
                String billEntryMD = "\n#### " + String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u5185\u5bb9", (String)"XBillLogHelper_5", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), entryEntity.getDisplayName()) + " ####\n";
                Map logs = (Map)entryLogs.get(entryEntity.getName());
                if (logs != null && logs.size() > 0) {
                    billEntryMD = billEntryMD + XBillLogHelper.genMDFormatString(bill, entryEntity.getName(), canLogProperty, logs);
                }
                if ((cancelLogs = (List)cancelEntryLogs.get(entryEntity.getName())) != null && cancelLogs.size() > 0) {
                    billEntryMD = billEntryMD + XBillLogHelper.genMDFormatString4Cancel(bill, entryEntity.getName(), canLogProperty, cancelLogs);
                }
                rs.put(entryEntity.getName(), billEntryMD);
                rs.put("mdText", rs.get("mdText") + billEntryMD);
            }
            return rs;
        }
        return null;
    }

    private static String genMDFormatString4Cancel(DynamicObject bill, String entryName, String[] billEntryFields, List<Map<String, DynamicObject>> cancelLogs) {
        int fi;
        StringBuilder billEntryMD = new StringBuilder("\n|");
        IDataEntityType srcBilldt = bill.getDataEntityType();
        for (fi = 0; fi < billEntryFields.length; ++fi) {
            billEntryMD.append(MetaDataHelper.getEntryPropertyAlias(srcBilldt, entryName, billEntryFields[fi]));
            billEntryMD.append('|');
        }
        billEntryMD.append("\n|");
        for (fi = 0; fi < billEntryFields.length; ++fi) {
            billEntryMD.append(":-:|");
        }
        for (Map<String, DynamicObject> logs : cancelLogs) {
            billEntryMD.append("\n|");
            for (int i = 0; i < billEntryFields.length; ++i) {
                DynamicObject log = logs.get(billEntryFields[i]);
                if (log == null) continue;
                billEntryMD.append("~~");
                billEntryMD.append(log.getString("beforevalue"));
                billEntryMD.append("~~|");
            }
        }
        return billEntryMD.toString();
    }

    public static String genMDFormatString(DynamicObject bill, String entryName, String[] billEntryFields, Map<String, DynamicObject> entryLogs) {
        StringBuilder billEntryMD = new StringBuilder("\n|");
        IDataEntityType srcBilldt = bill.getDataEntityType();
        for (int fi = 0; fi < billEntryFields.length; ++fi) {
            billEntryMD.append(MetaDataHelper.getEntryPropertyAlias(srcBilldt, entryName, billEntryFields[fi]));
            billEntryMD.append('|');
        }
        DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection(entryName);
        billEntryMD.append("\n|");
        for (int fi = 0; fi < billEntryFields.length; ++fi) {
            billEntryMD.append(":-:|");
        }
        if (!CommonUtils.isNull((Object)billEntrys)) {
            for (int i = 0; i < billEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)billEntrys.get(i);
                StringBuilder rowMD = new StringBuilder("\n|");
                boolean isChange = false;
                for (int fi = 0; fi < billEntryFields.length; ++fi) {
                    Object newValue = entry.get(billEntryFields[fi]);
                    DynamicProperty newdp = entry.getDynamicObjectType().getProperty(billEntryFields[fi]);
                    DynamicObject entryLog = entryLogs.get(entry.getPkValue() + billEntryFields[fi]);
                    if (entryLog != null) {
                        if (newdp instanceof DecimalProp) {
                            BigDecimal afterValue;
                            BigDecimal beforeValue = StringUtils.isBlank((CharSequence)entryLog.getString("beforevalue")) ? BigDecimal.ZERO : new BigDecimal(entryLog.getString("beforevalue"));
                            BigDecimal bigDecimal = afterValue = StringUtils.isBlank((CharSequence)entryLog.getString("aftervalue")) ? BigDecimal.ZERO : new BigDecimal(entryLog.getString("aftervalue"));
                            if (beforeValue.compareTo(afterValue) < 0) {
                                rowMD.append(entryLog.getString("beforevalue")).append(" >> **").append(entryLog.getString("aftervalue")).append("**&uarr;");
                            } else {
                                rowMD.append(entryLog.getString("beforevalue")).append(" >> **").append(entryLog.getString("aftervalue")).append("**&darr;");
                            }
                        } else if (StringUtils.isEmpty((CharSequence)entryLog.getString("aftervalue"))) {
                            rowMD.append(entryLog.getString("beforevalue")).append(" >> ");
                        } else {
                            rowMD.append(entryLog.getString("beforevalue")).append(" >> **").append(entryLog.getString("aftervalue")).append("**");
                        }
                        rowMD = rowMD.append('|');
                        isChange = true;
                        continue;
                    }
                    rowMD = rowMD.append(XBillLogHelper.displayFieldValue(newValue, newdp));
                    rowMD = rowMD.append('|');
                }
                if (!isChange) continue;
                billEntryMD.append((CharSequence)rowMD);
            }
        }
        return billEntryMD.toString();
    }

    private static Set<String> findChangeEntryItems(DynamicObject srcBill, DynamicObject xBill, EntityType entryEntity, Map<String, Map<String, String>> xBillEntryAndField) {
        HashSet<String> results = new HashSet<String>();
        String[] canLogProperty = ChangeModelHelper.getCanLogProperty(xBill.getDataEntityType(), entryEntity.getName());
        if (CommonUtils.isNull((Object)canLogProperty)) {
            return results;
        }
        if (xBillEntryAndField == null) {
            return results;
        }
        if (xBillEntryAndField.get(entryEntity.getName()) == null && StringUtils.isEmpty((CharSequence)xBillEntryAndField.get(entryEntity.getName()).get("subEntryInfo"))) {
            return results;
        }
        List subEntryTypes = ChangeModelHelper.getChildEntities(xBill.getDataEntityType()).stream().filter(v -> v instanceof SubEntryType).filter(v -> xBillEntryAndField.containsKey(v.getName())).filter(v -> v.getParent().getExtendName().equals(entryEntity.getExtendName())).collect(Collectors.toList());
        DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(entryEntity.getName());
        DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(entryEntity.getName());
        for (DynamicObject xBillEntry : xBillEntrys) {
            Object changeTypeEntry = xBillEntry.get(xBillEntryAndField.get(entryEntity.getName()).get("changetype"));
            if (ChangeTypeEnum.ADDNEW.getValue().equals(changeTypeEntry) || ChangeTypeEnum.CANCEL.getValue().equals(changeTypeEntry)) {
                results.add(xBillEntry.getString("id"));
                for (EntityType subEntryType : subEntryTypes) {
                    xBillEntry.getDynamicObjectCollection(subEntryType.getName()).stream().peek(v -> results.add(v.getString("id"))).collect(Collectors.toList());
                }
                continue;
            }
            DynamicObject srcEntry = srcBillEntrys.stream().filter(v -> v.getString("id").equals(xBillEntry.getString((String)((Map)xBillEntryAndField.get(entryEntity.getName())).get("srcid")))).findFirst().orElse(null);
            if (srcEntry == null) continue;
            for (String prop : canLogProperty) {
                if (XBillLogHelper.compareField(srcEntry.get(prop), xBillEntry.get(prop))) continue;
                results.add(xBillEntry.getString("id"));
            }
            for (EntityType subEntryType : subEntryTypes) {
                String[] subEntryCanLogProperty = ChangeModelHelper.getCanLogProperty(xBill.getDataEntityType(), subEntryType.getName());
                if (CommonUtils.isNull((Object)subEntryCanLogProperty)) continue;
                xBillEntry.getDynamicObjectCollection(subEntryType.getName()).stream().peek(v -> {
                    String subEntryChangeTypeKey = (String)((Map)xBillEntryAndField.get(subEntryType.getName())).get("changetype");
                    if (ChangeTypeEnum.ADDNEW.getValue().equals(v.get(subEntryChangeTypeKey)) || ChangeTypeEnum.CANCEL.getValue().equals(v.get(subEntryChangeTypeKey))) {
                        results.add(v.getString("id"));
                        results.add(xBillEntry.getString("id"));
                    } else {
                        DynamicObject srcSubEntry = Optional.of(srcEntry).map(p -> p.getDynamicObjectCollection(subEntryType.getName())).map(p -> p.stream().filter(t -> t.getString("id").equals(v.getString((String)((Map)xBillEntryAndField.get(subEntryType.getName())).get("srcid")))).findFirst().orElse(null)).orElse(null);
                        if (srcSubEntry == null) {
                            return;
                        }
                        for (String prop : subEntryCanLogProperty) {
                            if (prop.equals(subEntryChangeTypeKey) || XBillLogHelper.compareField(srcSubEntry.get(prop), v.get(prop))) continue;
                            results.add(v.getString("id"));
                            results.add(xBillEntry.getString("id"));
                        }
                    }
                }).collect(Collectors.toList());
            }
        }
        return results;
    }

    public static String genMDFormatString(DynamicObject srcBill, DynamicObject xBill, String entryName, String xEntryName, String[] billEntryFields, String SrcBillEntryID, String EntryChangeType) {
        StringBuilder billEntryMD = new StringBuilder("\n|");
        IDataEntityType srcBilldt = srcBill.getDataEntityType();
        for (int fi = 0; fi < billEntryFields.length; ++fi) {
            billEntryMD.append(MetaDataHelper.getEntryPropertyAlias(srcBilldt, entryName, billEntryFields[fi]));
            billEntryMD.append('|');
        }
        DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(xEntryName);
        billEntryMD.append("\n|");
        for (int fi = 0; fi < billEntryFields.length; ++fi) {
            billEntryMD.append(":-:|");
        }
        if (!CommonUtils.isNull((Object)xBillEntrys)) {
            DynamicProperty newdp;
            DynamicObject xBillEntry;
            int i;
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                Long srcBillEntryID = xBillEntry.getLong(SrcBillEntryID);
                if (!ChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                for (int j = 0; j < srcBillEntrys.size(); ++j) {
                    DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(j);
                    Long xBillEntryID = (Long)srcBillEntry.getPkValue();
                    if (srcBillEntryID.longValue() != xBillEntryID.longValue()) continue;
                    StringBuilder rowMD = new StringBuilder("\n|");
                    boolean isChange = false;
                    for (int fi = 0; fi < billEntryFields.length; ++fi) {
                        Object srcField = srcBillEntry.get(billEntryFields[fi]);
                        DynamicProperty srcdp = srcBillEntry.getDynamicObjectType().getProperty(billEntryFields[fi]);
                        Object newField = xBillEntry.get(billEntryFields[fi]);
                        DynamicProperty newdp2 = xBillEntry.getDynamicObjectType().getProperty(billEntryFields[fi]);
                        if (XBillLogHelper.compareField(srcField, newField)) {
                            rowMD = rowMD.append(XBillLogHelper.displayFieldValue(newField, newdp2));
                            rowMD = rowMD.append('|');
                            continue;
                        }
                        rowMD = rowMD.append(XBillLogHelper.displayCompareFieldValue(srcField, srcdp, newField, newdp2));
                        rowMD = rowMD.append('|');
                        isChange = true;
                    }
                    if (!isChange) continue;
                    billEntryMD.append((CharSequence)rowMD);
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                billEntryMD.append("\n|");
                for (int n = 0; n < billEntryFields.length; ++n) {
                    Object newField = xBillEntry.get(billEntryFields[n]);
                    String displayFieldValue = XBillLogHelper.displayFieldValue(newField, newdp = xBillEntry.getDynamicObjectType().getProperty(billEntryFields[n]));
                    if (displayFieldValue.trim().isEmpty()) {
                        billEntryMD.append('|');
                        continue;
                    }
                    billEntryMD.append('*');
                    billEntryMD.append(displayFieldValue);
                    billEntryMD.append("*|");
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                billEntryMD.append("\n|");
                for (int c = 0; c < billEntryFields.length; ++c) {
                    Object newField = xBillEntry.get(billEntryFields[c]);
                    newdp = xBillEntry.getDynamicObjectType().getProperty(billEntryFields[c]);
                    billEntryMD.append("~~");
                    billEntryMD.append(XBillLogHelper.displayFieldValue(newField, newdp));
                    billEntryMD.append("~~|");
                }
            }
        }
        return billEntryMD.toString();
    }

    public static String genMDFormatString(DynamicObject srcBill, DynamicObject xBill, String entryName, String xEntryName, LocaleString srcDisplayName, String[] billEntryFields, String SrcBillEntryID, String EntryChangeType, Set<String> changeEntryItems) {
        int fi;
        StringBuilder billEntryMD = new StringBuilder();
        IDataEntityType srcBilldt = srcBill.getDataEntityType();
        billEntryFields = (String[])ArrayUtils.addFirst((Object[])billEntryFields, (Object)"seq");
        DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(xEntryName);
        if (!CommonUtils.isNull((Object)xBillEntrys)) {
            DynamicProperty newdp;
            DynamicObject xBillEntry;
            int i;
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                Long srcBillEntryID = xBillEntry.getLong(SrcBillEntryID);
                if (!changeEntryItems.contains(xBillEntry.getString("id")) || !ChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                for (int j = 0; j < srcBillEntrys.size(); ++j) {
                    DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(j);
                    Long xBillEntryID = (Long)srcBillEntry.getPkValue();
                    if (srcBillEntryID.longValue() != xBillEntryID.longValue()) continue;
                    StringBuilder rowMD = new StringBuilder("\n|");
                    for (int fi2 = 0; fi2 < billEntryFields.length; ++fi2) {
                        Object srcField = srcBillEntry.get(billEntryFields[fi2]);
                        DynamicProperty srcdp = srcBillEntry.getDynamicObjectType().getProperty(billEntryFields[fi2]);
                        Object newField = xBillEntry.get(billEntryFields[fi2]);
                        DynamicProperty newdp2 = xBillEntry.getDynamicObjectType().getProperty(billEntryFields[fi2]);
                        if (XBillLogHelper.compareField(srcField, newField)) {
                            rowMD = rowMD.append(XBillLogHelper.displayFieldValue(newField, newdp2));
                            rowMD = rowMD.append('|');
                            continue;
                        }
                        rowMD = rowMD.append(XBillLogHelper.displayCompareFieldValue(srcField, srcdp, newField, newdp2));
                        rowMD = rowMD.append('|');
                    }
                    billEntryMD.append((CharSequence)rowMD);
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                billEntryMD.append("\n|");
                for (int n = 0; n < billEntryFields.length; ++n) {
                    Object newField = xBillEntry.get(billEntryFields[n]);
                    String displayFieldValue = XBillLogHelper.displayFieldValue(newField, newdp = xBillEntry.getDynamicObjectType().getProperty(billEntryFields[n]));
                    if (displayFieldValue.trim().isEmpty()) {
                        billEntryMD.append('|');
                        continue;
                    }
                    billEntryMD.append('*');
                    billEntryMD.append(displayFieldValue);
                    billEntryMD.append("*|");
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                billEntryMD.append("\n|");
                for (int c = 0; c < billEntryFields.length; ++c) {
                    Object newField = xBillEntry.get(billEntryFields[c]);
                    newdp = xBillEntry.getDynamicObjectType().getProperty(billEntryFields[c]);
                    billEntryMD.append("~~");
                    billEntryMD.append(XBillLogHelper.displayFieldValue(newField, newdp));
                    billEntryMD.append("~~|");
                }
            }
        }
        StringBuilder titleMD = new StringBuilder("\n");
        titleMD.append("#### ");
        titleMD.append(String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u5185\u5bb9", (String)"XBillLogHelper_5", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), srcDisplayName));
        titleMD.append(" ####");
        titleMD.append("\n\n|");
        for (fi = 0; fi < billEntryFields.length; ++fi) {
            titleMD.append(MetaDataHelper.getEntryPropertyAlias(srcBilldt, entryName, billEntryFields[fi]));
            titleMD.append('|');
        }
        titleMD.append("\n|");
        for (fi = 0; fi < billEntryFields.length; ++fi) {
            titleMD.append(":-:|");
        }
        if (billEntryMD.toString().length() > 0) {
            return titleMD.append((CharSequence)billEntryMD).toString();
        }
        return billEntryMD.toString();
    }

    public static String genMDFormatStringOfSubEntry(DynamicObject srcBill, DynamicObject xBill, String parentEntryName, String parentXEntryName, LocaleString parentDisplayName, LocaleString subDisplayName, String infoKey, String parentSeqKey, String subEntryName, String subXEntryName, String[] billEntryFields, String srcBillEntryID, String srcBillSubEntryID, String EntryChangeType, Set<String> changeEntryItems) {
        DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(parentEntryName);
        DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(parentXEntryName);
        if (CommonUtils.isNull((Object)xBillEntrys)) {
            return "";
        }
        StringBuilder billEntryMD = new StringBuilder();
        billEntryFields = (String[])ArrayUtils.addFirst((Object[])billEntryFields, (Object)"seq");
        for (DynamicObject xBillEntry : xBillEntrys) {
            int fi;
            if (!changeEntryItems.contains(xBillEntry.getString("id"))) continue;
            DynamicObject srcEntry = srcBillEntrys.stream().filter(v -> v.getString("id").equals(xBillEntry.getString(srcBillEntryID))).findFirst().orElse(null);
            DynamicObjectCollection subXEntrys = xBillEntry.getDynamicObjectCollection(subXEntryName);
            if (subXEntrys.stream().map(v -> v.getString("id")).filter(changeEntryItems::contains).findFirst().orElse(null) == null) continue;
            billEntryMD.append("\n").append(parentDisplayName).append(ResManager.loadKDString((String)"\u884c", (String)"XBillLogHelper_14", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0])).append(xBillEntry.get(parentSeqKey)).append(":").append(xBillEntry.getString(infoKey)).append("\n\n").append("|");
            for (fi = 0; fi < billEntryFields.length; ++fi) {
                IDataEntityType srcBilldt = srcBill.getDataEntityType();
                billEntryMD.append(MetaDataHelper.getEntryPropertyAlias(srcBilldt, subEntryName, billEntryFields[fi]));
                billEntryMD.append('|');
            }
            billEntryMD.append("\n|");
            for (fi = 0; fi < billEntryFields.length; ++fi) {
                billEntryMD.append(":-:|");
            }
            for (DynamicObject subXEntry : subXEntrys) {
                Object newField;
                if (!changeEntryItems.contains(subXEntry.getString("id"))) continue;
                DynamicObject srcSubEntry = Optional.ofNullable(srcEntry).map(v -> v.getDynamicObjectCollection(subEntryName)).map(v -> v.stream().filter(p -> p.getString("id").equals(subXEntry.getString(srcBillSubEntryID))).findFirst().orElse(null)).orElse(null);
                if (ChangeTypeEnum.UPDATE.getValue().equals(subXEntry.get(EntryChangeType))) {
                    StringBuilder rowMD = new StringBuilder("\n|");
                    if (srcSubEntry == null) continue;
                    for (String billEntryField : billEntryFields) {
                        Object srcField = srcSubEntry.get(billEntryField);
                        DynamicProperty srcdp = srcSubEntry.getDynamicObjectType().getProperty(billEntryField);
                        Object newField2 = subXEntry.get(billEntryField);
                        DynamicProperty newdp = subXEntry.getDynamicObjectType().getProperty(billEntryField);
                        if (XBillLogHelper.compareField(srcField, newField2)) {
                            rowMD.append(XBillLogHelper.displayFieldValue(newField2, newdp));
                        } else {
                            rowMD.append(XBillLogHelper.displayCompareFieldValue(srcField, srcdp, newField2, newdp));
                        }
                        rowMD.append('|');
                    }
                    billEntryMD.append((CharSequence)rowMD);
                    continue;
                }
                if (ChangeTypeEnum.ADDNEW.getValue().equals(subXEntry.get(EntryChangeType))) {
                    billEntryMD.append("\n|");
                    for (int n = 0; n < billEntryFields.length; ++n) {
                        DynamicProperty newdp;
                        newField = subXEntry.get(billEntryFields[n]);
                        String displayFieldValue = XBillLogHelper.displayFieldValue(newField, newdp = subXEntry.getDynamicObjectType().getProperty(billEntryFields[n]));
                        if (displayFieldValue.trim().isEmpty()) {
                            billEntryMD.append('|');
                            continue;
                        }
                        billEntryMD.append('*');
                        billEntryMD.append(displayFieldValue);
                        billEntryMD.append("*|");
                    }
                    continue;
                }
                if (!ChangeTypeEnum.CANCEL.getValue().equals(subXEntry.get(EntryChangeType))) continue;
                billEntryMD.append("\n|");
                for (int c = 0; c < billEntryFields.length; ++c) {
                    newField = subXEntry.get(billEntryFields[c]);
                    DynamicProperty newdp = subXEntry.getDynamicObjectType().getProperty(billEntryFields[c]);
                    billEntryMD.append("~~");
                    billEntryMD.append(XBillLogHelper.displayFieldValue(newField, newdp));
                    billEntryMD.append("~~|");
                }
            }
        }
        if (billEntryMD.toString().length() > 0) {
            return "\n#### " + String.format(ResManager.loadKDString((String)"%s\u53d8\u66f4\u5185\u5bb9", (String)"XBillLogHelper_5", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), parentDisplayName + "-" + subDisplayName) + " ####\n" + billEntryMD;
        }
        return "";
    }

    public static boolean compareField(Object srcField, Object newField) {
        if (srcField == null && newField == null) {
            return true;
        }
        if (srcField instanceof OrmLocaleValue && ((OrmLocaleValue)srcField).isEmpty() && newField instanceof OrmLocaleValue && ((OrmLocaleValue)newField).isEmpty()) {
            return true;
        }
        if (srcField instanceof BigDecimal && newField instanceof BigDecimal && ((BigDecimal)srcField).compareTo((BigDecimal)newField) == 0) {
            return true;
        }
        if (srcField instanceof DynamicObject && newField instanceof DynamicObject && ((DynamicObject)srcField).getPkValue().equals(((DynamicObject)newField).getPkValue())) {
            return true;
        }
        if (srcField instanceof DynamicObjectCollection && newField instanceof MulBasedataDynamicObjectCollection) {
            DynamicObject value;
            DynamicObjectCollection srcCollection = (DynamicObjectCollection)srcField;
            DynamicObjectCollection newCollection = (DynamicObjectCollection)newField;
            HashSet<Object> srcPKSet = new HashSet<Object>(16);
            HashSet<Object> newPKSet = new HashSet<Object>(16);
            for (DynamicObject row : srcCollection) {
                value = row.getDynamicObject("fbasedataid");
                if (value == null) continue;
                srcPKSet.add(value.getPkValue());
            }
            for (DynamicObject row : newCollection) {
                value = row.getDynamicObject("fbasedataid");
                if (value == null) continue;
                newPKSet.add(value.getPkValue());
            }
            if (newPKSet.size() == srcPKSet.size() && newPKSet.containsAll(srcPKSet) && srcPKSet.containsAll(newPKSet)) {
                return true;
            }
        }
        if (newField != null && newField.equals(srcField)) {
            return true;
        }
        if (srcField != null && srcField.equals(newField)) {
            return true;
        }
        if (srcField != null && newField != null) {
            String srcFieldStr = srcField.toString();
            String newFieldStr = newField.toString();
            if (srcFieldStr == null && newFieldStr == null) {
                return true;
            }
            if (srcFieldStr != null && srcFieldStr.equals(newFieldStr)) {
                return true;
            }
        }
        return false;
    }

    public static String displayCompareFieldValue(Object srcField, DynamicProperty srcdp, Object newField, DynamicProperty newdp) {
        if (srcField == null && newField == null) {
            return "";
        }
        if (srcField instanceof OrmLocaleValue && ((OrmLocaleValue)srcField).isEmpty() && newField instanceof OrmLocaleValue && ((OrmLocaleValue)newField).isEmpty()) {
            return "";
        }
        if (newField != null && newField.equals(srcField)) {
            return "";
        }
        if (srcField != null && srcField.equals(newField)) {
            return "";
        }
        if (srcField instanceof BigDecimal && newField instanceof BigDecimal) {
            if (((BigDecimal)srcField).compareTo((BigDecimal)newField) == 0) {
                return "";
            }
            if (((BigDecimal)srcField).compareTo((BigDecimal)newField) < 0) {
                return XBillLogHelper.displayFieldValue(srcField, srcdp) + " >> **" + XBillLogHelper.displayFieldValue(newField, newdp) + "**&uarr;";
            }
            if (((BigDecimal)srcField).compareTo((BigDecimal)newField) > 0) {
                return XBillLogHelper.displayFieldValue(srcField, srcdp) + " >> **" + XBillLogHelper.displayFieldValue(newField, newdp) + "**&darr;";
            }
        }
        if (StringUtils.isEmpty((CharSequence)XBillLogHelper.displayFieldValue(newField, newdp))) {
            return XBillLogHelper.displayFieldValue(srcField, srcdp) + " >> ";
        }
        return XBillLogHelper.displayFieldValue(srcField, srcdp) + " >> **" + XBillLogHelper.displayFieldValue(newField, newdp) + "**";
    }

    public static String displayFieldValue(Object newField) {
        if (newField == null) {
            return "";
        }
        if (newField instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)newField;
            return b.stripTrailingZeros().toPlainString();
        }
        if (newField instanceof Date) {
            Date d = (Date)newField;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            return df.format(d);
        }
        if (newField instanceof Boolean) {
            Boolean b = (Boolean)newField;
            return b != false ? "Yes" : "No";
        }
        if (newField instanceof DynamicObject) {
            DynamicObject dyo = (DynamicObject)newField;
            if (dyo.getDataEntityType() instanceof BasedataEntityType) {
                if ("bd_materialsalinfo".equals(dyo.getDataEntityType().getName()) || "bd_materialpurchaseinfo".equals(dyo.getDataEntityType().getName())) {
                    return dyo.getDynamicObject("masterid").getString("name");
                }
                if ("bd_operator".equals(dyo.getDataEntityType().getName())) {
                    return dyo.getDynamicObject("operatorid").getString("name");
                }
                if ("bd_supplierlinkman".equals(dyo.getDataEntityType().getName())) {
                    return dyo.getString("contactperson");
                }
                String nameProp = ((BasedataEntityType)dyo.getDataEntityType()).getNameProperty();
                if (StringUtils.isNotBlank((CharSequence)nameProp)) {
                    return dyo.getString(nameProp);
                }
                return dyo.getString("name");
            }
            return dyo.toString();
        }
        return newField.toString();
    }

    public static String displayFieldValue(Object newField, DynamicProperty newdp) {
        if (newField == null) {
            return "";
        }
        if (newField instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)newField;
            return b.stripTrailingZeros().toPlainString();
        }
        if (newField instanceof Date) {
            Date d = (Date)newField;
            String format = InteServiceHelper.getUserFormat((Long)UserServiceHelper.getCurrentUserId()).getDateFormat().getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat(format);
            return df.format(d);
        }
        if (newField instanceof Boolean) {
            Boolean b = (Boolean)newField;
            return b != false ? ResManager.loadKDString((String)"\u662f", (String)"XBillLogHelper_9", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"XBillLogHelper_10", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
        }
        if (newField instanceof DynamicObject) {
            DynamicObject dyo = (DynamicObject)newField;
            if (newdp instanceof BasedataProp) {
                if (newdp instanceof FlexProp) {
                    return XBillLogHelper.getTransString(dyo.toString());
                }
                BasedataProp bdProp = (BasedataProp)newdp;
                return XBillLogHelper.getTransString(bdProp.getDisplayValue(newField));
            }
            if (newdp instanceof RefBillProp) {
                RefBillProp bdProp = (RefBillProp)newdp;
                return XBillLogHelper.getTransString(bdProp.getDisplayValue(newField));
            }
        } else {
            String str;
            if (newField instanceof DynamicObjectCollection) {
                DynamicObjectCollection dyoCol = (DynamicObjectCollection)newField;
                if (dyoCol.isEmpty()) {
                    return "";
                }
                if (newdp instanceof MulBasedataProp) {
                    if (newdp instanceof AttachmentProp) {
                        AttachmentProp panel = (AttachmentProp)newdp;
                        return XBillLogHelper.getTransString(panel.getDisplayValue(newField));
                    }
                    MulBasedataProp mulbdPro = (MulBasedataProp)newdp;
                    return XBillLogHelper.getTransString(mulbdPro.getDisplayValue(newField));
                }
                return XBillLogHelper.getTransString(newField.toString());
            }
            if (newdp instanceof MulComboProp) {
                MulComboProp cbPros = (MulComboProp)newdp;
                return XBillLogHelper.getTransString(cbPros.getItemByName((String)newField));
            }
            if (newdp instanceof ComboProp) {
                ComboProp cbPro = (ComboProp)newdp;
                List cbItems = cbPro.getComboItems();
                for (int i = 0; i < cbItems.size(); ++i) {
                    ValueMapItem cbitem;
                    if (cbItems.get(i) == null || !newField.equals((cbitem = (ValueMapItem)cbItems.get(i)).getValue())) continue;
                    return XBillLogHelper.getTransString(cbitem.getName().toString());
                }
            } else if (newField instanceof OrmLocaleValue && (str = ((OrmLocaleValue)newField).getLocaleValue()) == null) {
                return "";
            }
        }
        return XBillLogHelper.getTransString(newField.toString());
    }

    public static String getTransString(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            if (str.contains("|")) {
                str = str.replaceAll("\\|", "&#124;");
            }
        } else {
            str = "";
        }
        return str;
    }
}

