/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.xlog.builder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XBillLogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.builder.AbstractXlogBuilder;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;

public class ChangeXlogBuilder
extends AbstractXlogBuilder {
    public ChangeXlogBuilder(DynamicObject srcBill, DynamicObject changeBill, String xLogEntity, String changeStatus) {
        super(srcBill, changeBill, xLogEntity, changeStatus);
    }

    @Override
    public void buildHeadBaseInfo() {
        super.buildHeadBaseInfo();
        if (Boolean.TRUE.equals(this.isNewVersion)) {
            this.curVerXlog.set("xbillid", this.changeBill.getPkValue());
            this.curVerXlog.set("xbillentity", (Object)this.changeBill.getDataEntityType().getName());
            this.curVerXlog.set("xbillno", (Object)this.changeBill.getString(((BillEntityType)this.changeBill.getDataEntityType()).getBillNo()));
            this.curVerXlog.set("xreason", this.changeBill.get("changereason"));
        }
    }

    @Override
    public void buildEntry() {
        DynamicObjectCollection entrys;
        super.buildEntry();
        if (!BizChangeStatusEnum.CHANGED.getValue().equals(this.changeStatus) && (entrys = this.curVerXlog.getDynamicObjectCollection("entryentity")) != null) {
            String key;
            HashMap<String, DynamicObject> needClearEntryMap = new HashMap<String, DynamicObject>(8);
            for (DynamicObject entry : entrys) {
                key = entry.getString("rowid") + entry.getString("fieldkey");
                if (this.valueMap.get(key) != null) continue;
                needClearEntryMap.put(key, entry);
            }
            if (this.firstVerXlog != null) {
                DynamicObjectCollection firstXlogEntry = this.firstVerXlog.getDynamicObjectCollection("entryentity");
                Iterator entryIt = firstXlogEntry.iterator();
                while (entryIt.hasNext()) {
                    String beforeValue;
                    DynamicObject entry = (DynamicObject)entryIt.next();
                    String key2 = entry.getString("rowid") + entry.getString("fieldkey");
                    DynamicObject clearEntry = (DynamicObject)needClearEntryMap.get(key2);
                    if (clearEntry == null || (beforeValue = clearEntry.getString("beforevalue")) == null || !beforeValue.equals(entry.getString("beforevalue"))) continue;
                    entryIt.remove();
                }
            }
            Iterator entryIt = entrys.iterator();
            while (entryIt.hasNext()) {
                DynamicObject entry;
                entry = (DynamicObject)entryIt.next();
                key = entry.getString("rowid") + entry.getString("fieldkey");
                if (this.valueMap.get(key) != null) continue;
                entryIt.remove();
            }
        }
    }

    @Override
    public void buildHeadMD() {
        if (!BizChangeStatusEnum.CHANGED.getValue().equals(this.changeStatus)) {
            DynamicObject changeModel = ChangeModelHelper.getChangeModel4SrcBill(this.srcBill.getDataEntityType().getName());
            Map<String, String> map = XBillLogHelper.compareSrcBillNXBill(this.srcBill, this.changeBill, ChangeModelHelper.getXBillEntryAndOp(changeModel));
            String xmdlog = map.get("mdText");
            this.curVerXlog.set("xmdjson_tag", (Object)xmdlog);
        }
    }
}

