/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.xlog.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.mpscmm.msbd.changemodel.business.helper.XlogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LevelFieldsInfo;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LogEntryInfo;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeTypeEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class XlogTreeBuilder {
    private Object srcId;
    private Object xId;
    private String entityId;
    private String xlogEntityId;
    private MainEntityType dataEntityType;
    private Map<String, Integer> rowIdSeqInfo;
    private Map<String, List<LogEntryInfo>> allLog;
    private boolean isLastest = true;
    private String curversionName = ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c", (String)"XlogTreeBuilder_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
    private String lastVersionName = ResManager.loadKDString((String)"\u4e0a\u4e00\u7248\u672c", (String)"XlogTreeBuilder_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);

    public XlogTreeBuilder(Object srcId, String entityId, Map<String, Integer> rowIdSeqInfo, String xlogEntityId) {
        this.srcId = srcId;
        this.entityId = entityId;
        this.rowIdSeqInfo = rowIdSeqInfo;
        this.xlogEntityId = xlogEntityId;
    }

    public XlogTreeBuilder(Object srcId, Object xId, String entityId, Map<String, Integer> rowIdSeqInfo, String xlogEntityId) {
        this.srcId = srcId;
        this.xId = xId;
        this.entityId = entityId;
        this.rowIdSeqInfo = rowIdSeqInfo;
        this.xlogEntityId = xlogEntityId;
    }

    public TreeNode buildLastestVerTree() {
        return this.buildChangeContentTree();
    }

    public TreeNode buildAllVerTree() {
        this.isLastest = Boolean.FALSE;
        return this.buildChangeContentTree();
    }

    private TreeNode buildChangeContentTree() {
        this.allLog = this.xId != null ? XlogHelper.getXBillLogsById(this.srcId, this.xId, this.xlogEntityId) : XlogHelper.getXLogsById(this.srcId, this.xlogEntityId, this.isLastest);
        Set<String> allFields = this.getAllFields(this.allLog);
        LevelFieldsInfo levelFields = XlogHelper.getLevelFields(this.entityId, allFields);
        this.dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        LocaleString displayName = this.dataEntityType.getDisplayName();
        TreeNode root = new TreeNode("", String.valueOf(this.srcId), displayName.toString());
        if (levelFields != null && this.allLog != null && this.allLog.size() > 0) {
            this.buildTreeNode(root, levelFields);
        }
        return root;
    }

    private void buildTreeNode(TreeNode root, LevelFieldsInfo levelFields) {
        if (levelFields.getParentApKey() == null) {
            for (String field : levelFields.getFields()) {
                IDataEntityProperty property = this.dataEntityType.findProperty(field);
                TreeNode fieldNode = new TreeNode(root.getId(), root.getId() + field, property.getDisplayName().toString());
                List<LogEntryInfo> logs = this.allLog.get(field);
                this.setVerNode(fieldNode, logs);
                root.addChild(fieldNode);
            }
            List<LevelFieldsInfo> nextLeves = levelFields.getNextLeves();
            this.buildEntryTreeNode(root, nextLeves);
        } else {
            List<LogEntryInfo> logEntryInfos = this.allLog.get(root.getId());
            LinkedHashMap<Integer, List> logEntryMap = new LinkedHashMap<Integer, List>(8);
            for (LogEntryInfo entryInfo : logEntryInfos) {
                Integer rowNum = this.rowIdSeqInfo.get(entryInfo.getRowid());
                if (rowNum == null) continue;
                List infos = logEntryMap.computeIfAbsent(rowNum, k -> new ArrayList());
                infos.add(entryInfo);
            }
            TreeMap sortedMap = new TreeMap(logEntryMap);
            for (Map.Entry row : sortedMap.entrySet()) {
                List logInfos = (List)row.getValue();
                if (logInfos == null || logInfos.size() == 0) continue;
                Integer rowNum = (Integer)row.getKey();
                String rowid = ((LogEntryInfo)logInfos.get(0)).getRowid();
                String rowName = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c", (String)"XlogTreeBuilder_3", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), rowNum);
                TreeNode rowNode = new TreeNode(root.getId(), rowid, rowName);
                if (BizChangeTypeEnum.ADDNEW.getValue().equals(((LogEntryInfo)logInfos.get(0)).getChangetype())) {
                    rowName = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff08\u589e\u884c\uff09", (String)"XlogTreeBuilder_4", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), rowNum);
                    rowNode.setText(rowName);
                    rowNode.setColor("green");
                }
                if (BizChangeTypeEnum.CANCEL.getValue().equals(((LogEntryInfo)logInfos.get(0)).getChangetype())) {
                    rowName = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff08\u5220\u884c\uff09", (String)"XlogTreeBuilder_5", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), rowNum);
                    rowNode.setText(rowName);
                    rowNode.setColor("red");
                }
                LinkedHashMap<String, List> fieldsmap = new LinkedHashMap<String, List>(8);
                for (LogEntryInfo logInfo : logInfos) {
                    List logs;
                    if (!StringUtils.isNotBlank((CharSequence)logInfo.getFieldkey()) || (logs = fieldsmap.computeIfAbsent(logInfo.getFieldkey(), k -> new ArrayList())) == null) continue;
                    logs.add(logInfo);
                }
                for (Map.Entry fieldRow : fieldsmap.entrySet()) {
                    IDataEntityProperty property = this.dataEntityType.findProperty((String)fieldRow.getKey());
                    List logs = (List)fieldRow.getValue();
                    TreeNode fieldNode = new TreeNode(rowNode.getId(), rowid + (String)fieldRow.getKey(), property.getDisplayName().toString());
                    this.setVerNode(fieldNode, logs);
                    rowNode.addChild(fieldNode);
                }
                root.addChild(rowNode);
                List<LevelFieldsInfo> nextLeves = levelFields.getNextLeves();
                if (nextLeves == null || nextLeves.size() <= 0) continue;
                this.buildEntryTreeNode(rowNode, nextLeves);
            }
        }
    }

    private void buildEntryTreeNode(TreeNode root, List<LevelFieldsInfo> nextLeves) {
        if (!CommonUtils.isNull(nextLeves)) {
            for (LevelFieldsInfo levelInfo : nextLeves) {
                String logKey = root.getId() + levelInfo.getCurrentApKey();
                if (this.allLog.get(logKey) == null) continue;
                IDataEntityProperty property = this.dataEntityType.findProperty(levelInfo.getCurrentApKey());
                TreeNode node = new TreeNode(root.getId(), logKey, property.getDisplayName().toString());
                root.addChild(node);
                this.buildTreeNode(node, levelInfo);
            }
        }
    }

    private void setVerNode(TreeNode fieldNode, List<LogEntryInfo> logs) {
        if (this.isLastest) {
            TreeNode verNode0;
            LogEntryInfo log = logs.get(0);
            if (ChangeTypeEnum.UPDATE.getValue().equals(log.getChangetype())) {
                verNode0 = new TreeNode(fieldNode.getId(), fieldNode.getId() + log.getVersion() + "after", this.curversionName + " : " + log.getAfterValue());
                TreeNode verNode1 = new TreeNode(fieldNode.getId(), fieldNode.getId() + log.getVersion() + "before", this.lastVersionName + " : " + log.getBeforeValue());
                fieldNode.addChild(verNode0);
                fieldNode.addChild(verNode1);
            }
            if (ChangeTypeEnum.ADDNEW.getValue().equals(log.getChangetype())) {
                verNode0 = new TreeNode(fieldNode.getId(), fieldNode.getId() + log.getVersion() + "after", this.curversionName + " : " + log.getAfterValue());
                fieldNode.addChild(verNode0);
            }
            if (ChangeTypeEnum.CANCEL.getValue().equals(log.getChangetype())) {
                TreeNode verNode1 = new TreeNode(fieldNode.getId(), fieldNode.getId() + log.getVersion() + "before", this.lastVersionName + " : " + log.getBeforeValue());
                fieldNode.addChild(verNode1);
            }
        } else {
            for (LogEntryInfo log : logs) {
                String versionName = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u7248", (String)"XlogTreeBuilder_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), log.getVersion());
                TreeNode verNode = new TreeNode(fieldNode.getId(), fieldNode.getId() + log.getVersion(), versionName + " : " + log.getAfterValue());
                fieldNode.addChild(verNode);
            }
        }
    }

    private Set<String> getAllFields(Map<String, List<LogEntryInfo>> allLog) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>(8);
        if (allLog == null || allLog.size() == 0) {
            return fields;
        }
        for (List<LogEntryInfo> infos : allLog.values()) {
            for (LogEntryInfo info : infos) {
                fields.add(info.getFieldkey());
            }
        }
        return fields;
    }
}

