/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mpscmm.msbd.business.helper.TreeNodeHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeContentHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XlogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.builder.XlogTreeBuilder;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class ChangeContentPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"collapse"});
        this.addClickListeners(new String[]{"refresh"});
        this.addClickListeners(new String[]{"expand"});
        TreeView treeView = (TreeView)this.getView().getControl("changetreeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("treesearch");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("parentPageId");
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (parentView == null) {
            return;
        }
        DynamicObject bill = parentView.getModel().getDataEntity(true);
        String contentType = (String)this.getView().getFormShowParameter().getCustomParam("content_type");
        if ("xbill".equals(contentType)) {
            this.getModel().setValue("billpkid", bill.get("sourcebillid"));
            this.getModel().setValue("billname", bill.get("sourcebillentity"));
            this.getView().setVisible(Boolean.FALSE, new String[]{"isallversion"});
        } else {
            this.getModel().setValue("billpkid", bill.getPkValue());
            this.getModel().setValue("billname", (Object)bill.getDataEntityType().getName());
        }
        this.initTreeView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block6: for (int i = 0; i < valueSet.length; ++i) {
            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
            switch (fieldName) {
                case "isallversion": {
                    this.initTreeView();
                    continue block6;
                }
            }
        }
    }

    public void search(SearchEnterEvent e) {
        TreeView treeView;
        String text = e.getText();
        if (StringUtils.isNotBlank((CharSequence)text) && (treeView = (TreeView)this.getView().getControl("changetreeview")) != null) {
            List allMatchedNodes;
            String rootCache = this.getPageCache().get(this.getView().getPageId() + "_treeNodes");
            if (rootCache == null) {
                return;
            }
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootCache, TreeNode.class);
            if (root != null && (allMatchedNodes = TreeNodeHelper.findNodesByText((TreeNode)root, (String)text)) != null && allMatchedNodes.size() > 0) {
                int index;
                String preIndexCache = this.getPageCache().get(this.getView().getPageId() + "_preNodeIndex_" + text);
                if (StringUtils.isBlank((CharSequence)preIndexCache)) {
                    index = 0;
                } else {
                    index = Integer.parseInt(preIndexCache);
                    ++index;
                    index %= allMatchedNodes.size();
                }
                this.getPageCache().put(this.getView().getPageId() + "_preNodeIndex_" + text, String.valueOf(index));
                Object o = allMatchedNodes.get(index);
                if (o == null) {
                    return;
                }
                TreeNode curNode = (TreeNode)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(o), TreeNode.class);
                allMatchedNodes.get(index);
                if (curNode.getChildren() != null) {
                    for (TreeNode child : curNode.getChildren()) {
                        treeView.showNode(child.getId());
                    }
                } else {
                    treeView.showNode(curNode.getId());
                }
                treeView.focusNode(curNode);
            }
        }
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        String key = control.getKey();
        TreeView treeView = (TreeView)this.getView().getControl("changetreeview");
        switch (key) {
            case "refresh": {
                this.initTreeView();
                break;
            }
            case "expand": {
                TreeNode root;
                if (treeView == null) break;
                String searchNodesCacheKey = this.getView().getPageId() + "_treeNodes";
                String rootStr = this.getPageCache().get(searchNodesCacheKey);
                if (rootStr == null || (root = (TreeNode)SerializationUtils.fromJsonString((String)rootStr, TreeNode.class)) == null) break;
                List leafNodes = TreeNodeHelper.getLeafNodes((TreeNode)root);
                for (TreeNode node : leafNodes) {
                    treeView.showNode(node.getId());
                }
                break;
            }
            case "collapse": {
                TreeNode root;
                if (treeView == null) break;
                String searchNodesCacheKey = this.getView().getPageId() + "_treeNodes";
                String rootStr = this.getPageCache().get(searchNodesCacheKey);
                if (rootStr == null || (root = (TreeNode)SerializationUtils.fromJsonString((String)rootStr, TreeNode.class)) == null) break;
                List allNodes = TreeNodeHelper.getAllNodes((TreeNode)root);
                for (TreeNode node : allNodes) {
                    if (root.getId().equals(node.getId())) continue;
                    treeView.collapse(node.getId());
                }
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("parentPageId");
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        String entityId = (String)this.getModel().getValue("billname");
        String xlogEntityId = ChangeModelHelper.getXlogEntityId(entityId);
        Boolean isAllVersion = (Boolean)this.getModel().getValue("isallversion");
        String srcBillId = (String)this.getModel().getValue("billpkid");
        if (StringUtils.isBlank((CharSequence)srcBillId)) {
            return;
        }
        String contentType = (String)this.getView().getFormShowParameter().getCustomParam("content_type");
        if ("xbill".equals(contentType)) {
            DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(parentView.getEntityId());
            String[] canLogProps = ChangeModelHelper.getAllCanLogProperty(changeModel);
            if (canLogProps != null) {
                ChangeContentHelper.clearChangeFieldMark4XBill(parentView, canLogProps);
            }
        } else {
            Map<String, Map<String, List<String>>> logFieldsMap = XlogHelper.getLogFieldsMap(Long.valueOf(srcBillId), xlogEntityId, isAllVersion);
            ChangeContentHelper.clearChangeFieldMark(parentView, logFieldsMap);
        }
        List plugins = parentView.getFormShowParameter().getFormConfig().getPlugins();
        plugins.removeIf(plugin -> "kd.bos.ext.scmc.changemodel.plugin.ChangeContentPlugin".equals(plugin.getClassName()));
        parentView.cacheFormShowParameter();
        this.getView().sendFormAction(parentView);
    }

    private void initTreeView() {
        Label changeLable;
        TreeNode root;
        Map<String, Object> latestVersion;
        Boolean isAllVer = (Boolean)this.getModel().getValue("isallversion");
        String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("parentPageId");
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (parentView == null) {
            return;
        }
        DynamicObject bill = parentView.getModel().getDataEntity(true);
        if (bill == null) {
            return;
        }
        String contentType = (String)this.getView().getFormShowParameter().getCustomParam("content_type");
        TreeView treeView = (TreeView)this.getView().getControl("changetreeview");
        String srcBillId = (String)this.getModel().getValue("billpkid");
        treeView.deleteNode(srcBillId);
        if ("xbill".equals(contentType)) {
            if (!String.valueOf(bill.get("sourcebillid")).equals(srcBillId)) {
                srcBillId = String.valueOf(bill.get("sourcebillid"));
                this.getModel().setValue("billpkid", (Object)srcBillId);
                this.getModel().setValue("billname", bill.get("sourcebillentity"));
            }
        } else if (!String.valueOf(bill.getPkValue()).equals(srcBillId)) {
            srcBillId = String.valueOf(bill.getPkValue());
            this.getModel().setValue("billpkid", (Object)srcBillId);
            this.getModel().setValue("billname", (Object)bill.getDataEntityType().getName());
        }
        String xlogEntityId = ChangeModelHelper.getXlogEntityId(bill.getDataEntityType().getName());
        Map<String, Map<String, List<String>>> logFieldsMap = XlogHelper.getLogFieldsMap(Long.valueOf(srcBillId), xlogEntityId, Boolean.TRUE);
        XlogTreeBuilder builder = null;
        if ("xbill".equals(contentType)) {
            Map customParams = parentView.getFormShowParameter().getCustomParams();
            Map entryAndOp = (Map)customParams.get("XBillEntryAndOp");
            Map<String, Integer> rowIdSeqMap = XlogHelper.getEntryIdSeqMap4XBill(bill, entryAndOp);
            if (rowIdSeqMap != null) {
                builder = new XlogTreeBuilder(Long.valueOf(srcBillId), (Long)bill.getPkValue(), bill.getDataEntityType().getName(), rowIdSeqMap, xlogEntityId);
            }
            latestVersion = XlogHelper.getLatestVersion(Long.valueOf(srcBillId), (Long)bill.getPkValue(), xlogEntityId);
        } else {
            Map<String, Integer> rowIdSeqMap = XlogHelper.getEntryIdSeqMap(bill);
            if (rowIdSeqMap != null) {
                builder = new XlogTreeBuilder(Long.valueOf(srcBillId), bill.getDataEntityType().getName(), rowIdSeqMap, xlogEntityId);
            }
            latestVersion = XlogHelper.getLatestVersion(Long.valueOf(srcBillId), xlogEntityId);
        }
        if (builder == null) {
            return;
        }
        Integer srcBillVersion = (Integer)latestVersion.get("srcbillversion");
        srcBillVersion = srcBillVersion + 1;
        Label label = (Label)this.getView().getControl("versioninfo");
        label.setText(String.format(ResManager.loadKDString((String)"\u7248\u672c\u4fe1\u606f(\u7b2c%1$s\u7248)", (String)"ChangeContentPlugin_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), srcBillVersion));
        if (Boolean.TRUE.equals(isAllVer)) {
            root = builder.buildAllVerTree();
            if ("xbill".equals(contentType)) {
                ChangeContentHelper.markChangeField4XBill(parentView, logFieldsMap);
            } else {
                ChangeContentHelper.markChangeField(parentView, logFieldsMap);
            }
            changeLable = (Label)this.getView().getControl("changelabel");
            changeLable.setText(String.format(ResManager.loadKDString((String)"\u5168\u90e8\u53d8\u66f4", (String)"ChangeContentPlugin_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), srcBillVersion));
        } else {
            root = builder.buildLastestVerTree();
            if ("xbill".equals(contentType)) {
                DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(parentView.getEntityId());
                String[] canLogProps = ChangeModelHelper.getAllCanLogProperty(changeModel);
                if (canLogProps != null) {
                    ChangeContentHelper.clearChangeFieldMark4XBill(parentView, canLogProps);
                }
                Map<String, Map<String, List<String>>> lastestLogFieldsMap = XlogHelper.getXBillLogFieldsMap(Long.valueOf(srcBillId), (Long)bill.getPkValue(), xlogEntityId);
                ChangeContentHelper.markChangeField4XBill(parentView, lastestLogFieldsMap);
            } else {
                ChangeContentHelper.clearChangeFieldMark(parentView, logFieldsMap);
                Map<String, Map<String, List<String>>> lastestLogFieldsMap = XlogHelper.getLogFieldsMap(Long.valueOf(srcBillId), xlogEntityId, Boolean.FALSE);
                ChangeContentHelper.markChangeField(parentView, lastestLogFieldsMap);
            }
            changeLable = (Label)this.getView().getControl("changelabel");
            changeLable.setText(String.format(ResManager.loadKDString((String)"\u6700\u8fd1\u4e00\u6b21\u53d8\u66f4", (String)"ChangeContentPlugin_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), srcBillVersion));
        }
        if (root != null) {
            treeView.addNode(root);
            treeView.expand(root.getId());
            String searchNodesCacheKey = this.getView().getPageId() + "_treeNodes";
            this.getPageCache().put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)root));
        }
        this.getView().sendFormAction(parentView);
    }
}

