/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.formplugin;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mpscmm.msbd.changemodel.common.enums.ChangeListTypeEnum;
import kd.mpscmm.msbd.changemodel.common.pojo.ChangeListEntryInfo;
import kd.mpscmm.msbd.changemodel.common.pojo.ChangeListInfo;

public class ChangeListListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ChangeListListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean isAdmin;
        super.preOpenForm(e);
        String formId = ((ListShowParameter)e.getSource()).getBillFormId();
        if ("msbd_changeblacklist".equals(formId) && !(isAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId()))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChangeListPlugin_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent e) {
        List listFilter;
        QFilter qFilter1;
        super.setFilter(e);
        String formId = ((BillList)e.getSource()).getBillFormId();
        if ("msbd_changewhitelist".equals(formId)) {
            qFilter1 = new QFilter("type", "=", (Object)ChangeListTypeEnum.WHITELIST.getValue());
            listFilter = e.getQFilters();
            listFilter.add(qFilter1);
        }
        if ("msbd_changeblacklist".equals(formId)) {
            qFilter1 = new QFilter("type", "=", (Object)ChangeListTypeEnum.BLACKLIST.getValue());
            listFilter = e.getQFilters();
            listFilter.add(qFilter1);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        String entityId = op.getEntityId();
        switch (key) {
            case "exportlist_expt": 
            case "exportlistbyselectfields": 
            case "exportlist": {
                if (!"msbd_changewhitelist".equals(entityId)) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                if (billList.getSelectedRows() != null && billList.getSelectedRows().size() > 0) {
                    QFilter filter;
                    Map map;
                    ArrayList<Long> idList = new ArrayList<Long>(8);
                    for (ListSelectedRow listSelectedRow : billList.getSelectedRows()) {
                        if (listSelectedRow == null || listSelectedRow.getPrimaryKeyValue() == null) continue;
                        idList.add((Long)listSelectedRow.getPrimaryKeyValue());
                    }
                    if (idList.isEmpty() || (map = BusinessDataServiceHelper.loadFromCache((String)"msbd_changewhitelist", (String)"id,changebill,hashcode,entryentity.id,entryentity.fieldid,entryentity.canrevise,entryentity.canchange,entryentity.canbatchange", (QFilter[])new QFilter[]{filter = new QFilter("id", "in", idList)})) == null || map.isEmpty()) break;
                    ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(8);
                    for (DynamicObject changeList : map.values()) {
                        String changeListId = changeList.getPkValue().toString();
                        DynamicObject changeBill = changeList.getDynamicObject("changebill");
                        String changeBillNumber = changeBill.getString("number");
                        ChangeListInfo changeListInfo = new ChangeListInfo();
                        changeListInfo.setId(changeListId);
                        changeListInfo.setChangeBill(changeBillNumber);
                        ArrayList<ChangeListEntryInfo> entryList = new ArrayList<ChangeListEntryInfo>(8);
                        DynamicObjectCollection entrys = changeList.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entry : entrys) {
                            String entryId = entry.getPkValue().toString();
                            String fieldId = (String)entry.get("fieldid");
                            Boolean canRevise = (Boolean)entry.get("canrevise");
                            Boolean canChange = (Boolean)entry.get("canchange");
                            Boolean canBatChange = (Boolean)entry.get("canbatchange");
                            ChangeListEntryInfo changeListEntryInfo = new ChangeListEntryInfo(entryId, fieldId, canRevise, canChange, canBatChange);
                            entryList.add(changeListEntryInfo);
                        }
                        changeListInfo.setEntryList(entryList);
                        String reHashCode = this.calculateObjectSHA(changeListInfo);
                        changeList.set("hashcode", (Object)reHashCode);
                        updateData.add(changeList);
                    }
                    SaveServiceHelper.update((DynamicObject[])updateData.toArray(new DynamicObject[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ChangeListListPlugin_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private String calculateObjectSHA(Object obj) {
        StringBuilder hexString = new StringBuilder();
        try {
            byte[] digest;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            byte[] data = baos.toByteArray();
            oos.close();
            baos.close();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (byte b : digest = md.digest(data)) {
                hexString.append(String.format("%02x", b));
            }
        }
        catch (Exception e1) {
            log.error("ChangeListListPlugin : calculateObjectSHA error : " + e1.getMessage());
        }
        return hexString.toString();
    }
}

