/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.formplugin;

import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeResumeFormConst;
import kd.mpscmm.msbd.common.enums.StatusEnum;

public class SrcBillChangeListPlugin
extends AbstractListPlugin {
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getListSelectedData() == null || args.getListSelectedData().size() == 0) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("bizchange")) {
            if (args.getListSelectedData().getPrimaryKeyValues().length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u5f20\u5355\u636e\u53d8\u66f4\uff0c\u8bf7\u9009\u62e91\u5f20\u5355\u636e\u3002", (String)"SrcBillChangeListPlugin_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                this.getPageCache().put(ChangeResumeFormConst.ENABLE_CHANGERESUME, "true");
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bizchange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u8981\u5bf9\u5f53\u524d\u5355\u636e\u8fdb\u884c\u53d8\u66f4?", (String)"SrcBillChangeListPlugin_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("bizchange") && evt.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            operateOption.setVariableValue(ChangeResumeFormConst.ENABLE_CHANGERESUME, this.getPageCache().get(ChangeResumeFormConst.ENABLE_CHANGERESUME));
            this.getView().invokeOperation("bizchange", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IListView listview = (IListView)this.getView();
        FormOperate operate = (FormOperate)args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if (args.getOperateKey().equals("bizchange")) {
                OperationResult opRes = args.getOperationResult();
                List billPks = opRes.getSuccessPkIds();
                String srcBillEntity = listview.getListModel().getDataEntityType().getName();
                String xBillEntityID = operate.getOption().getVariableValue("xBillEntityID", "");
                if (!billPks.isEmpty()) {
                    DynamicObject changeModel;
                    if (StringUtils.isEmpty((String)xBillEntityID) && (changeModel = ChangeModelHelper.getChangeModel4SrcBill(srcBillEntity)) != null && changeModel.getDynamicObject("xbill") != null) {
                        xBillEntityID = changeModel.getDynamicObject("xbill").getString("id");
                    }
                    MainEntityType xBillDt = MetadataServiceHelper.getDataEntityType((String)xBillEntityID);
                    boolean isText = xBillDt.findProperty("sourcebillid") instanceof TextProp;
                    for (Object billPk : billPks) {
                        QFilter q1 = isText ? new QFilter("sourcebillid", "=", (Object)String.valueOf(billPk)) : new QFilter("sourcebillid", "=", billPk);
                        QFilter q2 = new QFilter("billstatus", "=", (Object)StatusEnum.SAVE.getValue());
                        QFilter q3 = new QFilter("changestatus", "!=", (Object)"D");
                        DynamicObject xbill = QueryServiceHelper.queryOne((String)xBillEntityID, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
                        BillShowParameter fsp = new BillShowParameter();
                        fsp.setFormId(xBillEntityID);
                        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        fsp.setPkId(xbill.get("id"));
                        fsp.setCustomParam(ChangeResumeFormConst.ENABLE_CHANGERESUME, (Object)this.getPageCache().get(ChangeResumeFormConst.ENABLE_CHANGERESUME));
                        this.getView().showForm((FormShowParameter)fsp);
                    }
                }
            } else if (args.getOperateKey().equals("bizchangelog")) {
                StringBuilder billids = new StringBuilder();
                List successbillids = args.getOperationResult().getSuccessPkIds();
                for (Object bid : successbillids) {
                    billids.append(bid).append(',');
                }
                ListShowParameter fsp = new ListShowParameter();
                String XBillLogEntityKey = "plat_xbilllog";
                String srcBillEntity = ((IListView)this.getView()).getBillFormId();
                ((IListView)this.getView()).getBillFormId();
                DynamicObject changeModel = ChangeModelHelper.getChangeModel4SrcBill(srcBillEntity);
                if (changeModel != null && changeModel.getDynamicObject("xbilllog") != null) {
                    XBillLogEntityKey = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
                }
                fsp.setBillFormId(XBillLogEntityKey);
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsp.setCustomParam("srcbillid", (Object)billids.substring(0, billids.length() - 1));
                this.getView().showForm((FormShowParameter)fsp);
            } else if (args.getOperateKey().equals("bizchangeresume")) {
                List successbillids = args.getOperationResult().getSuccessPkIds();
                if (successbillids.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u5f20\u5355\u636e\u67e5\u770b\u53d8\u66f4\u5c65\u5386\uff0c\u8bf7\u9009\u62e91\u5f20\u5355\u636e\u3002", (String)"SrcBillChangeListPlugin_3", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                } else if (successbillids.size() == 1) {
                    QFilter qFilter2;
                    long srcbillid = (Long)successbillids.get(0);
                    QFilter qFilter1 = new QFilter("srcbillid", "=", (Object)srcbillid);
                    DynamicObject changerecord = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_changeresume", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("currentchangenumber", "!=", (Object)0)});
                    if (changerecord != null) {
                        FormShowParameter changeResume = new FormShowParameter();
                        changeResume.setFormId("msbd_changeresumeform");
                        changeResume.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        changeResume.setStatus(OperationStatus.VIEW);
                        changeResume.setCustomParam("srcbillid", (Object)srcbillid);
                        changeResume.setCustomParam("srcbillno", changerecord.get("srcbillno"));
                        this.getView().showForm(changeResume);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9e\u9645\u5f55\u5165\u53d8\u66f4\u6570\u636e\uff0c\u6682\u672a\u8bb0\u5f55\u53d8\u66f4\u5c65\u5386\u4fe1\u606f\u3002", (String)"XBillChangeListPlugin_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                    }
                }
            }
        }
    }
}

