/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeResumeFormConst;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class XBillChangePlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
EntryGridBindDataListener {
    public static Log logger = LogFactory.getLog(XBillChangePlugin.class);
    private static final String DELETEROWNOTSHOWMSG = "deleteRowNotShowMsg";

    public void preOpenForm(PreOpenFormEventArgs e) {
        String billtype;
        DynamicObject changeModel;
        super.preOpenForm(e);
        FormShowParameter formShowPar = e.getFormShowParameter();
        OperationStatus operationStatus = formShowPar.getStatus();
        if (OperationStatus.ADDNEW.getValue() != operationStatus.getValue() && formShowPar.getFormConfig() != null && !CommonUtils.isNull((Object)formShowPar.getFormConfig().getEntityTypeId()) && (changeModel = ChangeModelHelper.getChangeModel4XBill(billtype = formShowPar.getFormConfig().getEntityTypeId())) == null) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u542f\u7528\u7684\u53d8\u66f4\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u670d\u52a1\u4eba\u5458\u7ef4\u62a4\u53d8\u66f4\u65b9\u6848\u6570\u636e\u3002", (String)"SrcBillBizChangeOpValidator_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    protected Map<String, Map<String, String>> getXBillEntryAndOp() {
        Map<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(this.getModel().getDataEntityType().getName());
        if (changeModel != null) {
            result = ChangeModelHelper.getXBillEntryAndOp(changeModel);
            if (result.size() != 0) {
                return result;
            }
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("entity", "billentry");
            value.put("entry_toolbar", "tbmainentry");
            value.put("btn_add", "addrow");
            value.put("btn_delete", "deleterow");
            value.put("btn_modify", "modifyrow");
            value.put("changetype", "billentrychangetype");
            value.put("srcid", "billentrysrcid");
            result.put("entity", value);
        }
        return result;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        if (rows == null || rows.size() == 0) {
            return;
        }
        Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
        if (xBillEntrys == null || xBillEntrys.isEmpty()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryEntity = entryGrid.getKey();
        if (!xBillEntrys.containsKey(entryEntity)) {
            return;
        }
        Map<String, String> xBillEntry = xBillEntrys.get(entryEntity);
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String daterangeitems = this.getPageCache().get("daterangeitems");
        Map<String, List<String>> allDateRangeItems = new HashMap<String, List<String>>(8);
        if (StringUtils.isNotBlank((CharSequence)daterangeitems)) {
            allDateRangeItems = (Map)SerializationUtils.fromJsonString((String)daterangeitems, Map.class);
        }
        String[] unEnableEntryPropertys = ChangeModelHelper.getUnEnableProperty(dt, entryEntity, allDateRangeItems);
        String[] enableEntryProperrtys = ChangeModelHelper.getEnableProperty(dt, entryEntity, allDateRangeItems);
        for (RowDataEntity row : rows) {
            int index = row.getRowIndex();
            String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), index);
            if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                this.getView().setEnable(Boolean.FALSE, index, unEnableEntryPropertys);
                this.getView().setEnable(Boolean.TRUE, index, enableEntryProperrtys);
                continue;
            }
            if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
            this.getView().setEnable(Boolean.FALSE, index, unEnableEntryPropertys);
            this.getView().setEnable(Boolean.FALSE, index, enableEntryProperrtys);
        }
    }

    public void beforeBindData(EventObject e) {
        Map<String, List<String>> allDateRangeItems;
        String daterangeitems;
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (entityType instanceof BillEntityType) {
            ((BillEntityType)entityType).setBillNo("changebillno");
        }
        if ((daterangeitems = this.getPageCache().get("daterangeitems")) == null && (allDateRangeItems = ChangeModelHelper.getAllDateRangeItems(entityType.getName())) != null && allDateRangeItems.size() > 0) {
            this.getPageCache().put("daterangeitems", SerializationUtils.toJsonString(allDateRangeItems));
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel bill = this.getModel();
        for (IDataEntityProperty entityProperty : bill.getDataEntityType().getProperties()) {
            if (entityProperty instanceof SubEntryProp || !(entityProperty instanceof EntryProp)) continue;
            DynamicObjectCollection entrys = (DynamicObjectCollection)bill.getValue(entityProperty.getName());
            for (DynamicObject entry : entrys) {
                entry.getDataEntityState().setDirty(true);
                entry.getDataEntityState().setBizChanged(true);
                entry.getDataEntityState().setBizChangeFlags(entry.getDataEntityState().getDirtyFlags());
                for (IDataEntityProperty subEntityProperty : entry.getDataEntityType().getProperties()) {
                    if (!(subEntityProperty instanceof SubEntryProp)) continue;
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection(subEntityProperty.getName());
                    for (DynamicObject subEntry : subEntrys) {
                        subEntry.getDataEntityState().setDirty(true);
                        subEntry.getDataEntityState().setBizChanged(true);
                        subEntry.getDataEntityState().setBizChangeFlags(subEntry.getDataEntityState().getDirtyFlags());
                    }
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        long begintime = System.currentTimeMillis();
        logger.info("BizChangePerformance----Function(afterBindData)EntryEditedSetBegin\uff1a" + new Date(begintime));
        String daterangeitems = this.getPageCache().get("daterangeitems");
        HashMap<String, List<String>> allDateRangeItems = new HashMap(8);
        if (StringUtils.isNotBlank((CharSequence)daterangeitems)) {
            allDateRangeItems = (Map)SerializationUtils.fromJsonString((String)daterangeitems, Map.class);
        }
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnablePropertys = ChangeModelHelper.getUnEnableProperty(dt, allDateRangeItems);
        String[] enablePropertys = ChangeModelHelper.getEnableProperty(dt, allDateRangeItems);
        if (!CommonUtils.isNull((Object)unEnablePropertys)) {
            this.getView().setEnable(Boolean.FALSE, unEnablePropertys);
        }
        if (!CommonUtils.isNull((Object)enablePropertys)) {
            this.getView().setEnable(Boolean.TRUE, enablePropertys);
        }
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            DynamicObject[] dynamicObjects;
            String entryEntity = entry.getKey();
            EntryGrid entrygrid = (EntryGrid)this.getControl(entryEntity);
            if (entrygrid == null || entrygrid.getEntryData() == null) {
                logger.info("I can't find the entry that name's  " + entryEntity);
                continue;
            }
            Map<String, String> xBillEntry = result.get(entryEntity);
            String[] unEnableEntryPropertys = ChangeModelHelper.getUnEnableProperty(dt, entryEntity, allDateRangeItems);
            String[] enableEntryProperrtys = ChangeModelHelper.getEnableProperty(dt, entryEntity, allDateRangeItems);
            EntryData entrydata = entrygrid.getEntryData();
            boolean isSplitPage = entrygrid.isSplitPage();
            int pageCount = entrydata.getPageCount();
            if (isSplitPage) {
                if (pageCount > 0) {
                    int startIdx = entrydata.getStartIndex();
                    int endIdx = entrydata.getEndIndex();
                    for (int i = startIdx; i < endIdx; ++i) {
                        String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), i);
                        if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                            this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                            this.getView().setEnable(Boolean.TRUE, i, enableEntryProperrtys);
                            continue;
                        }
                        if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                        this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                        this.getView().setEnable(Boolean.FALSE, i, enableEntryProperrtys);
                    }
                }
            } else if (entrydata.getDataEntitys() != null && (dynamicObjects = entrydata.getDataEntitys()).length > 0) {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), i);
                    if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                        this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                        this.getView().setEnable(Boolean.TRUE, i, enableEntryProperrtys);
                        continue;
                    }
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                    this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                    this.getView().setEnable(Boolean.FALSE, i, enableEntryProperrtys);
                }
            }
            logger.info("\u53d8\u66f4\u8c03\u4f18----afterbindata...........entry\uff1a " + entryEntity + "pagerowcount:" + pageCount);
        }
        long endtime = System.currentTimeMillis();
        logger.info("BizChangePerformance----Function(afterBindData)EntryEditedSetEnd \uff1a" + new Date(endtime));
        logger.info("BizChangePerformance----Function(afterBindData)EntryEditedSetUseTime \uff1a" + (endtime - begintime) + " ms");
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        int row = evt.getRow();
        if (evt.getSource() instanceof EntryGrid && row > -1) {
            EntryGrid entrygrid = (EntryGrid)evt.getSource();
            String clickEntryKey = entrygrid.getKey();
            ArrayList<String> clickEntryAndSubList = new ArrayList<String>();
            clickEntryAndSubList.add(clickEntryKey);
            List subEntryGrids = entrygrid.getSubEntryGrids();
            if (subEntryGrids != null) {
                clickEntryAndSubList.addAll(subEntryGrids);
            }
            Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
            String daterangeitems = this.getPageCache().get("daterangeitems");
            HashMap<String, List<String>> allDateRangeItems = new HashMap(8);
            if (StringUtils.isNotBlank((CharSequence)daterangeitems)) {
                allDateRangeItems = (Map)SerializationUtils.fromJsonString((String)daterangeitems, Map.class);
            }
            for (String entryKey : clickEntryAndSubList) {
                DynamicObject[] dynamicObjects;
                if (!xBillEntrys.containsKey(entryKey)) {
                    logger.info("ChangeModel's plugin hasn't registed the subentry that name's  " + entryKey);
                    continue;
                }
                Map<String, String> xBillEntry = xBillEntrys.get(entryKey);
                String[] unEnableEntryPropertys = ChangeModelHelper.getUnEnableProperty(dt, entryKey, allDateRangeItems);
                String[] enableEntryProperrtys = ChangeModelHelper.getEnableProperty(dt, entryKey, allDateRangeItems);
                if (entryKey.equals(clickEntryKey)) {
                    String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), row);
                    if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                        this.getView().setEnable(Boolean.FALSE, row, unEnableEntryPropertys);
                        this.getView().setEnable(Boolean.TRUE, row, enableEntryProperrtys);
                        continue;
                    }
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                    this.getView().setEnable(Boolean.FALSE, row, unEnableEntryPropertys);
                    this.getView().setEnable(Boolean.FALSE, row, enableEntryProperrtys);
                    continue;
                }
                EntryGrid subEntrygrid = (EntryGrid)this.getControl(entryKey);
                if (subEntrygrid == null || subEntrygrid.getEntryData() == null) {
                    logger.info("I can't find the entry that name's  " + entryKey);
                    continue;
                }
                EntryData subEntryData = subEntrygrid.getEntryData();
                boolean isSplitPage = subEntrygrid.isSplitPage();
                int pageCount = subEntryData.getPageCount();
                if (isSplitPage) {
                    if (pageCount <= 0) continue;
                    int startIdx = subEntryData.getStartIndex();
                    int endIdx = subEntryData.getEndIndex();
                    for (int i = startIdx; i < endIdx; ++i) {
                        String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), i);
                        if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                            this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                            this.getView().setEnable(Boolean.TRUE, i, enableEntryProperrtys);
                            continue;
                        }
                        if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                        this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                        this.getView().setEnable(Boolean.FALSE, i, enableEntryProperrtys);
                    }
                    continue;
                }
                if (subEntryData.getDataEntitys() == null || (dynamicObjects = subEntryData.getDataEntitys()).length <= 0) continue;
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), i);
                    if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                        this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                        this.getView().setEnable(Boolean.TRUE, i, enableEntryProperrtys);
                        continue;
                    }
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                    this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                    this.getView().setEnable(Boolean.FALSE, i, enableEntryProperrtys);
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        RowDataEntity[] rowDataEntitys;
        IDataModel xBill = this.getModel();
        String entryEntity = evt.getEntryProp().getName();
        Map<String, String> xBillEntry = this.getXBillEntryAndOp().get(entryEntity);
        if (xBillEntry == null) {
            return;
        }
        for (RowDataEntity rowDataEntity : rowDataEntitys = evt.getRowDataEntities()) {
            int rowindex = rowDataEntity.getRowIndex();
            xBill.setValue(xBillEntry.get("changetype"), (Object)ChangeTypeEnum.ADDNEW.getValue(), rowindex);
            long id = DBServiceHelper.genGlobalLongId();
            xBill.setValue(entryEntity + ".id", (Object)id, rowindex);
            xBill.setValue(xBillEntry.get("srcid"), (Object)id, rowindex);
        }
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        String changeType = result.get(entryEntity).get("changetype");
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String daterangeitems = this.getPageCache().get("daterangeitems");
        Map<String, List<String>> allDateRangeItems = new HashMap<String, List<String>>(8);
        if (StringUtils.isNotBlank((CharSequence)daterangeitems)) {
            allDateRangeItems = (Map)SerializationUtils.fromJsonString((String)daterangeitems, Map.class);
        }
        String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty(dt, entryEntity, allDateRangeItems);
        String[] enableProperty = ChangeModelHelper.getEnableProperty(dt, entryEntity, allDateRangeItems);
        int rowCount = this.getModel().getEntryRowCount(entryEntity);
        for (int i = 0; i < rowCount; ++i) {
            if (!ChangeTypeEnum.UPDATE.getValue().equals(xBill.getValue(changeType, i))) continue;
            if (!CommonUtils.isNull((Object)unEnableProperty)) {
                this.getView().setEnable(Boolean.FALSE, i, unEnableProperty);
            }
            if (CommonUtils.isNull((Object)enableProperty)) continue;
            this.getView().setEnable(Boolean.TRUE, i, enableProperty);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        IDataModel xBill = this.getModel();
        String entryEntity = evt.getEntryProp().getName();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        Map<String, String> xBillEntry = this.getXBillEntryAndOp().get(entryEntity);
        if (xBillEntry == null) {
            return;
        }
        String[] allEntryProperties = ChangeModelHelper.getProperty4Entry(dt, entryEntity);
        HashSet<Object> changeTypeNumber = new HashSet<Object>(8);
        for (int curRow : evt.getRowIndexs()) {
            changeTypeNumber.add(xBill.getValue(xBillEntry.get("changetype"), curRow));
        }
        if (changeTypeNumber.size() > 1) {
            if ("true".equals(this.getPageCache().get(DELETEROWNOTSHOWMSG))) {
                this.getPageCache().remove(DELETEROWNOTSHOWMSG);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u66f4\u65b9\u5f0f\u76f8\u540c\u7684\u5206\u5f55\u884c\u3002", (String)"XBillChangePlugin_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
            }
            evt.setCancel(true);
            return;
        }
        for (int curRow : evt.getRowIndexs()) {
            if (!ChangeTypeEnum.UPDATE.getValue().equals(xBill.getValue(xBillEntry.get("changetype"), curRow)) && !ChangeTypeEnum.CANCEL.getValue().equals(xBill.getValue(xBillEntry.get("changetype"), curRow))) continue;
            xBill.setValue(xBillEntry.get("changetype"), (Object)ChangeTypeEnum.CANCEL.getValue(), curRow);
            this.getView().setEnable(Boolean.FALSE, curRow, allEntryProperties);
            evt.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : xBillEntrys.entrySet()) {
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid)) continue;
            ((EntryGrid)entryGrid).addDataBindListener((EntryGridBindDataListener)this);
            ((EntryGrid)entryGrid).addRowClickListener((RowClickEventListener)this);
            this.addItemClickListeners(new String[]{entry.getValue().get("entry_toolbar")});
        }
    }

    public void initialize() {
        Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : xBillEntrys.entrySet()) {
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid)) continue;
            ((EntryGrid)entryGrid).addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String evtItemKey = evt.getItemKey();
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            int[] selectRows;
            if (!evtItemKey.equals(entry.getValue().get("btn_modify")) && !evt.getItemKey().equals(entry.getValue().get("btn_delete"))) continue;
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid) || (selectRows = ((EntryGrid)entryGrid).getSelectRows()).length > 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"XBillChangePlugin_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        IDataModel xBill = this.getModel();
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            int[] selectRows;
            if (!evt.getItemKey().equals(entry.getValue().get("btn_modify"))) continue;
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid) || (selectRows = ((EntryGrid)entryGrid).getSelectRows()).length <= 0) continue;
            boolean nocanmodidataflag = true;
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            String daterangeitems = this.getPageCache().get("daterangeitems");
            Map<String, List<String>> allDateRangeItems = new HashMap<String, List<String>>(8);
            if (StringUtils.isNotBlank((CharSequence)daterangeitems)) {
                allDateRangeItems = (Map)SerializationUtils.fromJsonString((String)daterangeitems, Map.class);
            }
            String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty(dt, entryEntity, allDateRangeItems);
            String[] enableProperty = ChangeModelHelper.getEnableProperty(dt, entryEntity, allDateRangeItems);
            for (int selectRow : selectRows) {
                if (ChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue(result.get(entryEntity).get("changetype"), selectRow)) || ChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue(result.get(entryEntity).get("changetype"), selectRow))) continue;
                xBill.setValue(result.get(entryEntity).get("changetype"), (Object)ChangeTypeEnum.UPDATE.getValue(), selectRow);
                this.getView().setEnable(Boolean.FALSE, selectRow, unEnableProperty);
                this.getView().setEnable(Boolean.TRUE, selectRow, enableProperty);
                nocanmodidataflag = false;
            }
            if (!nocanmodidataflag) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\u72b6\u6001\u7684\u5206\u5f55\u884c\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002", (String)"XBillChangePlugin_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String xBillEntity = this.getModel().getDataEntityType().getName();
        switch (operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "bizvalid": {
                DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(xBillEntity);
                if (changeModel == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u542f\u7528\u7684\u53d8\u66f4\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u670d\u52a1\u4eba\u5458\u7ef4\u62a4\u53d8\u66f4\u65b9\u6848\u6570\u636e\u3002", (String)"SrcBillBizChangeOpValidator_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                String enableChangeResume = (String)showParameter.getCustomParam(ChangeResumeFormConst.ENABLE_CHANGERESUME);
                if (CommonUtils.isNull((Object)enableChangeResume) && CommonUtils.isNull((Object)(enableChangeResume = this.getPageCache().get(ChangeResumeFormConst.ENABLE_CHANGERESUME)))) {
                    enableChangeResume = "true";
                    this.getPageCache().put(ChangeResumeFormConst.ENABLE_CHANGERESUME, enableChangeResume);
                }
                operate.getOption().setVariableValue(ChangeResumeFormConst.ENABLE_CHANGERESUME, enableChangeResume);
            }
        }
        Long xBillID = (Long)this.getModel().getValue("id");
        if (xBillID != null && "bizchangeresume".equals(operate.getOperateKey())) {
            QFilter qFilter = new QFilter("xbillid", "=", (Object)xBillID);
            QFilter qFilter2 = new QFilter("currentchangenumber", "!=", (Object)0);
            DynamicObject changerecord = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_changeresume", (QFilter[])new QFilter[]{qFilter, qFilter2});
            if (changerecord != null) {
                FormShowParameter changeResume = new FormShowParameter();
                changeResume.setFormId("msbd_changeresumeform");
                changeResume.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                changeResume.setStatus(OperationStatus.VIEW);
                changeResume.setCustomParam("srcbillid", changerecord.get("srcbillid"));
                changeResume.setCustomParam("srcbillno", changerecord.get("srcbillno"));
                changeResume.setCustomParam("xbillid", (Object)xBillID);
                this.getView().showForm(changeResume);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9e\u9645\u5f55\u5165\u53d8\u66f4\u6570\u636e\uff0c\u6682\u672a\u8bb0\u5f55\u53d8\u66f4\u5c65\u5386\u4fe1\u606f\u3002", (String)"XBillChangeListPlugin_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (xBillID != null && "bizchangelog".equals(operate.getOperateKey())) {
            DynamicObject xPurOrderBillLog;
            QFilter qf = new QFilter("xbillid", "=", (Object)xBillID);
            String XBillLogEntityKey = "plat_xbilllog";
            DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(xBillEntity);
            if (changeModel != null && changeModel.getDynamicObject("xbilllog") != null) {
                XBillLogEntityKey = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
            }
            if ((xPurOrderBillLog = BusinessDataServiceHelper.loadSingleFromCache((String)XBillLogEntityKey, (QFilter[])new QFilter[]{qf})) != null) {
                String xMDJson = xPurOrderBillLog.getString("xmdjson_tag");
                if (xMDJson != null) {
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setFormId("plat_xbilllogshow");
                    fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    fsp.setCustomParam("mdlog", (Object)xMDJson);
                    this.getView().showForm(fsp);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9e\u9645\u5f55\u5165\u53d8\u66f4\u6570\u636e\uff0c\u6682\u672a\u8bb0\u5f55\u65e5\u5fd7\u3002", (String)"XBillChangeListPlugin_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject changeModel;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("audit".equalsIgnoreCase(args.getOperateKey()) && args.getOperationResult().isSuccess() && (changeModel = ChangeModelHelper.getChangeModel4XBill(operate.getEntityId())) != null && "auto".equals(changeModel.getString("updatetype"))) {
            this.getView().invokeOperation("bizvalid");
        }
    }
}

