/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.ConditionValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.AttachmentsHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.XlogDirector;
import kd.mpscmm.msbd.changemodel.business.xlog.builder.ChangeXlogBuilder;
import kd.mpscmm.msbd.changemodel.business.xlog.comparator.ChangeBillComparator;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeTypeEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizValidStatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class XBillBizValidOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(XBillBizValidOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcebillentity");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("changebillno");
        e.getFieldKeys().add("xvalidstatus");
        e.getFieldKeys().add("rowcancel");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (this.billEntityType != null) {
            String opkey = (String)this.operateMeta.get("key");
            List<ConditionValidation> vallist = ChangeModelHelper.getValidConditionList(this.billEntityType.getName(), opkey);
            if (vallist != null && vallist.size() > 0) {
                for (int i = 0; i < vallist.size(); ++i) {
                    ConditionValidator XBillBizValidCV = new ConditionValidator();
                    XBillBizValidCV.setValidation(vallist.get(i).createValidate());
                    e.addValidator((AbstractValidator)XBillBizValidCV);
                }
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if ("bizvalid".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            Long beginTime = System.currentTimeMillis();
            LOGGER.info("BizValidPerformance--BeginTime: " + new Date(beginTime));
            DynamicObject[] bills = e.getDataEntities();
            HashMap<String, Set<String>> panelsMap = new HashMap<String, Set<String>>(16);
            for (DynamicObject bill : bills) {
                Set<String> srcAttachPanels;
                String xValidStatus;
                DynamicObject srcBill;
                DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill((bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName())).getDataEntityType().getName());
                if (CommonUtils.isNull((Object)changeModel)) continue;
                String sourcebillentity = bill.getString("sourcebillentity");
                long sourceBillId = bill.get("sourcebillid") instanceof String ? Long.parseLong(bill.getString("sourcebillid")) : bill.getLong("sourcebillid");
                if (sourceBillId == 0L || sourcebillentity == null || CommonUtils.isNull((Object)(srcBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourcebillentity)))) continue;
                if (!changeModel.getBoolean("isnotupdateversion")) {
                    String version = srcBill.getString("version");
                    if (version == null || version.length() == 0 || version.equals("0") || version.startsWith("0.") || version.startsWith("1.")) {
                        version = "1";
                    }
                    int newVersion = 1;
                    try {
                        newVersion = Integer.parseInt(version) + 1;
                    }
                    catch (NumberFormatException ee) {
                        LOGGER.warn((Throwable)ee);
                    }
                    srcBill.set("version", (Object)String.valueOf(newVersion));
                    srcBill.set("subversion", (Object)"1");
                } else {
                    String subversion = srcBill.getString("subversion");
                    if (subversion == null || subversion.length() == 0 || subversion.equals("0") || subversion.startsWith("0.") || subversion.startsWith("1.")) {
                        subversion = "1";
                    }
                    int newSubVersion = 1;
                    try {
                        newSubVersion = Integer.parseInt(subversion) + 1;
                    }
                    catch (NumberFormatException ee) {
                        LOGGER.warn((Throwable)ee);
                    }
                    srcBill.set("subversion", (Object)String.valueOf(newSubVersion));
                }
                srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGED.getValue());
                srcBill.set("changer", (Object)BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
                srcBill.set("changedate", (Object)new Date(System.currentTimeMillis()));
                String[] enablePropertys = ChangeModelHelper.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType());
                DataEntityPropertyCollection headProps = srcBill.getDynamicObjectType().getProperties();
                for (String string : enablePropertys) {
                    try {
                        Object oldObject = srcBill.get(string);
                        Object newObject = bill.get(string);
                        IDataEntityProperty prop = (IDataEntityProperty)headProps.get((Object)string);
                        if (prop instanceof LargeTextProp) {
                            oldObject = srcBill.get(string + "_tag");
                            newObject = bill.get(string + "_tag");
                        }
                        if (!CommonUtils.isRealChanged((Object)oldObject, (Object)newObject)) continue;
                        srcBill.set(string, bill.get(string));
                        if (prop instanceof LargeTextProp) {
                            srcBill.set(string + "_tag", bill.get(string + "_tag"));
                        }
                        if (!(prop instanceof MulBasedataProp)) continue;
                        DynamicObjectCollection xRows = (DynamicObjectCollection)bill.get(string);
                        DynamicObjectCollection rows = ChangeModelHelper.copyNewMulBaseData(xRows);
                        srcBill.set(string, (Object)rows);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                Long finishBillHeadValueTime = System.currentTimeMillis();
                LOGGER.info("BizValidPerformance--finishBillHeadValueTime: " + new Date(finishBillHeadValueTime));
                LOGGER.info("BizValidPerformance--finishBillHeadValueUse: " + (finishBillHeadValueTime - beginTime) + "ms");
                List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(bill.getDataEntityType());
                HashMap<String, String[]> enableWBEntryPropertysMap = new HashMap<String, String[]>(1024);
                for (EntityType xBillentryEntity : xBillentryEntitys) {
                    DynamicObjectCollection xBillEntrys;
                    String xBillEntryEntityKey = xBillentryEntity.getName();
                    Map<String, String> fieldmap = this.getXBillEntryAndField(changeModel).get(xBillEntryEntityKey);
                    String[] enableEntryPropertys = null;
                    String[] xBillEntryEntityInfo = (String[])enableWBEntryPropertysMap.get(xBillEntryEntityKey);
                    if (xBillEntryEntityInfo != null) {
                        enableEntryPropertys = xBillEntryEntityInfo;
                    } else {
                        enableEntryPropertys = ChangeModelHelper.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType(), xBillEntryEntityKey);
                        if (enableEntryPropertys != null) {
                            enableWBEntryPropertysMap.put(xBillEntryEntityKey, enableEntryPropertys);
                        }
                    }
                    if (xBillentryEntity.getClass() != EntryType.class && xBillentryEntity.getClass() != TreeEntryType.class || CommonUtils.isNull((Object)(xBillEntrys = bill.getDynamicObjectCollection(xBillEntryEntityKey))) || CommonUtils.isNull((Object)enableEntryPropertys) || CommonUtils.isNull(fieldmap)) continue;
                    DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(xBillentryEntity.getName());
                    DataEntityPropertyCollection entryProps = srcBillEntrys.getDynamicObjectType().getProperties();
                    block26: for (DynamicObject xBillEntry : xBillEntrys) {
                        Object srcBillEntry22;
                        if (BizChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(fieldmap.get("changetype")))) {
                            for (Object srcBillEntry22 : srcBillEntrys) {
                                if (srcBillEntry22.getLong("id") != xBillEntry.getLong(fieldmap.get("srcid"))) continue;
                                for (String entryProperty : enableEntryPropertys) {
                                    srcBillEntry22.set(entryProperty, xBillEntry.get(entryProperty));
                                    IDataEntityProperty prop = (IDataEntityProperty)entryProps.get((Object)entryProperty);
                                    if (prop instanceof LargeTextProp) {
                                        srcBillEntry22.set(entryProperty + "_tag", xBillEntry.get(entryProperty + "_tag"));
                                    }
                                    if (!(prop instanceof MulBasedataProp)) continue;
                                    DynamicObjectCollection xRows = (DynamicObjectCollection)xBillEntry.get(entryProperty);
                                    DynamicObjectCollection rows = ChangeModelHelper.copyNewMulBaseData(xRows);
                                    srcBillEntry22.set(entryProperty, (Object)rows);
                                }
                                for (IDataEntityProperty entityProperty : xBillEntry.getDataEntityType().getProperties()) {
                                    String entityProName = entityProperty.getName();
                                    if (!(xBillEntry.get(entityProName) instanceof DynamicObjectCollection) || xBillEntry.get(entityProName) instanceof MulBasedataDynamicObjectCollection) continue;
                                    String[] subEnableEntryPropertys = null;
                                    String[] tempInfo = (String[])enableWBEntryPropertysMap.get(entityProName);
                                    if (tempInfo != null) {
                                        subEnableEntryPropertys = tempInfo;
                                    } else {
                                        subEnableEntryPropertys = ChangeModelHelper.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType(), entityProName);
                                        if (subEnableEntryPropertys != null) {
                                            enableWBEntryPropertysMap.put(entityProName, subEnableEntryPropertys);
                                        }
                                    }
                                    Map<String, String> subfieldmap = this.getXBillEntryAndField(changeModel).get(entityProName);
                                    if (subEnableEntryPropertys == null || subEnableEntryPropertys.length == 0 || subfieldmap == null || subfieldmap.size() == 0) continue;
                                    DynamicObjectCollection subXBillEntrys = (DynamicObjectCollection)xBillEntry.get(entityProName);
                                    DynamicObjectCollection subSrcBillEntrys = srcBillEntry22.getDynamicObjectCollection(entityProName);
                                    DataEntityPropertyCollection subProps = subSrcBillEntrys.getDynamicObjectType().getProperties();
                                    Iterator iterator = subXBillEntrys.iterator();
                                    block30: while (iterator.hasNext()) {
                                        DynamicObject subXBillEntry = (DynamicObject)iterator.next();
                                        if (BizChangeTypeEnum.CANCEL.getValue().equals(subXBillEntry.get(subfieldmap.get("changetype")))) {
                                            for (Object subSrcBillEntry : subSrcBillEntrys) {
                                                if (subSrcBillEntry.getLong("id") != subXBillEntry.getLong(subfieldmap.get("srcid"))) continue;
                                                subSrcBillEntrys.remove(subSrcBillEntry);
                                                continue block30;
                                            }
                                            continue;
                                        }
                                        if (BizChangeTypeEnum.ADDNEW.getValue().equals(subXBillEntry.get(subfieldmap.get("changetype")))) {
                                            Object subSrcBillEntry;
                                            DynamicObject subSrcBillEntry2 = subSrcBillEntrys.addNew();
                                            subXBillEntry.set(subfieldmap.get("srcid"), subXBillEntry.getPkValue());
                                            subSrcBillEntry = subSrcBillEntry2.getDataEntityType().getProperties().iterator();
                                            while (subSrcBillEntry.hasNext()) {
                                                String[] subEntityProperty = (String[])subSrcBillEntry.next();
                                                String subEntityProName = subEntityProperty.getName();
                                                if ((subXBillEntry.get(subEntityProName) instanceof DynamicObjectCollection || subXBillEntry.get(subEntityProName) instanceof LinkEntryProp) && !(subXBillEntry.get(subEntityProName) instanceof MulBasedataDynamicObjectCollection)) continue;
                                                try {
                                                    if (subEntityProName.equals(subfieldmap.get("changetype"))) {
                                                        subSrcBillEntry2.set(subEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                                                        continue;
                                                    }
                                                    subSrcBillEntry2.set(subEntityProName, subXBillEntry.get(subEntityProName));
                                                    if (!(subEntityProperty instanceof LargeTextProp)) continue;
                                                    subSrcBillEntry2.set(subEntityProName + "_tag", subXBillEntry.get(subEntityProName + "_tag"));
                                                }
                                                catch (Exception e1) {}
                                            }
                                            continue;
                                        }
                                        if (!BizChangeTypeEnum.UPDATE.getValue().equals(subXBillEntry.get(subfieldmap.get("changetype")))) continue;
                                        for (Object subSrcBillEntry : subSrcBillEntrys) {
                                            if (subSrcBillEntry.getLong("id") != subXBillEntry.getLong(subfieldmap.get("srcid"))) continue;
                                            for (String subEnableEntryProperty : subEnableEntryPropertys) {
                                                subSrcBillEntry.set(subEnableEntryProperty, subXBillEntry.get(subEnableEntryProperty));
                                                IDataEntityProperty subEntityProperty = (IDataEntityProperty)subProps.get((Object)subEnableEntryProperty);
                                                if (subEntityProperty instanceof LargeTextProp) {
                                                    subSrcBillEntry.set(subEnableEntryProperty + "_tag", subXBillEntry.get(subEnableEntryProperty + "_tag"));
                                                }
                                                if (!(subEntityProperty instanceof MulBasedataProp)) continue;
                                                DynamicObjectCollection xRows = (DynamicObjectCollection)subXBillEntry.get(subEnableEntryProperty);
                                                DynamicObjectCollection rows = ChangeModelHelper.copyNewMulBaseData(xRows);
                                                subSrcBillEntry.set(subEnableEntryProperty, (Object)rows);
                                            }
                                        }
                                    }
                                }
                                continue block26;
                            }
                            continue;
                        }
                        if (BizChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get(fieldmap.get("changetype")))) {
                            String rowCancel = fieldmap.get("rowcancel");
                            if (rowCancel != null && !Boolean.parseBoolean(rowCancel)) continue;
                            srcBillEntry22 = srcBillEntrys.iterator();
                            while (srcBillEntry22.hasNext()) {
                                DynamicObject srcBillEntry3 = (DynamicObject)srcBillEntry22.next();
                                if (srcBillEntry3.getLong("id") != xBillEntry.getLong(fieldmap.get("srcid"))) continue;
                                try {
                                    srcBillEntrys.remove((Object)srcBillEntry3);
                                    continue block26;
                                }
                                catch (Exception e1) {
                                }
                            }
                            continue;
                        }
                        if (!BizChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(fieldmap.get("changetype")))) continue;
                        DynamicObject srcBillEntry4 = srcBillEntrys.addNew();
                        xBillEntry.set(fieldmap.get("srcid"), xBillEntry.getPkValue());
                        srcBillEntry22 = srcBillEntry4.getDataEntityType().getProperties().iterator();
                        while (srcBillEntry22.hasNext()) {
                            IDataEntityProperty entityProperty = (IDataEntityProperty)srcBillEntry22.next();
                            try {
                                String newEntityProName = entityProperty.getName();
                                if (!(xBillEntry.get(newEntityProName) instanceof DynamicObjectCollection) && !(xBillEntry.get(newEntityProName) instanceof LinkEntryProp) || xBillEntry.get(newEntityProName) instanceof MulBasedataDynamicObjectCollection) {
                                    if (newEntityProName.equals(fieldmap.get("changetype"))) {
                                        srcBillEntry4.set(newEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                                    } else {
                                        srcBillEntry4.set(newEntityProName, xBillEntry.get(newEntityProName));
                                        IDataEntityProperty prop = (IDataEntityProperty)entryProps.get((Object)newEntityProName);
                                        if (prop instanceof LargeTextProp) {
                                            srcBillEntry4.set(newEntityProName + "_tag", xBillEntry.get(newEntityProName + "_tag"));
                                        }
                                        if (prop instanceof MulBasedataProp) {
                                            DynamicObjectCollection xRows = (DynamicObjectCollection)xBillEntry.get(newEntityProName);
                                            DynamicObjectCollection rows = ChangeModelHelper.copyNewMulBaseData(xRows);
                                            srcBillEntry4.set(newEntityProName, (Object)rows);
                                        }
                                    }
                                }
                                if (!(xBillEntry.get(newEntityProName) instanceof DynamicObjectCollection) || xBillEntry.get(newEntityProName) instanceof MulBasedataDynamicObjectCollection) continue;
                                Map<String, String> newSubFieldmap = this.getXBillEntryAndField(changeModel).get(newEntityProName);
                                String subEntityChangeTypePro = newSubFieldmap.get("changetype");
                                DynamicObjectCollection subXBillEntrys = (DynamicObjectCollection)xBillEntry.get(newEntityProName);
                                DynamicObjectCollection subSrcBillEntrys = srcBillEntry4.getDynamicObjectCollection(newEntityProName);
                                for (DynamicObject subXBillEntry : subXBillEntrys) {
                                    DynamicObject subSrcBillEntry = subSrcBillEntrys.addNew();
                                    subXBillEntry.set(newSubFieldmap.get("srcid"), subXBillEntry.getPkValue());
                                    for (IDataEntityProperty subEntityProperty : subSrcBillEntry.getDataEntityType().getProperties()) {
                                        String newSubEntityProName = subEntityProperty.getName();
                                        if ((subXBillEntry.get(newSubEntityProName) instanceof DynamicObjectCollection || subXBillEntry.get(newSubEntityProName) instanceof LinkEntryProp) && !(subXBillEntry.get(newSubEntityProName) instanceof MulBasedataDynamicObjectCollection)) continue;
                                        if (StringUtils.isNotEmpty((CharSequence)subEntityChangeTypePro) && subEntityChangeTypePro.equals(newSubEntityProName)) {
                                            subSrcBillEntry.set(newSubEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                                            continue;
                                        }
                                        subSrcBillEntry.set(newSubEntityProName, subXBillEntry.get(newSubEntityProName));
                                        if (subEntityProperty instanceof LargeTextProp) {
                                            subSrcBillEntry.set(newSubEntityProName + "_tag", subXBillEntry.get(newSubEntityProName + "_tag"));
                                        }
                                        if (!(subEntityProperty instanceof MulBasedataProp)) continue;
                                        DynamicObjectCollection xRows = (DynamicObjectCollection)subXBillEntry.get(newSubEntityProName);
                                        DynamicObjectCollection rows = ChangeModelHelper.copyNewMulBaseData(xRows);
                                        subSrcBillEntry.set(newSubEntityProName, (Object)rows);
                                    }
                                }
                            }
                            catch (Exception e1) {
                            }
                        }
                    }
                }
                long l = System.currentTimeMillis();
                LOGGER.info("BizValidPerformance--finishBillEntryValueTime: " + new Date(l));
                LOGGER.info("BizValidPerformance--finishBillEntryValueUse: " + (l - finishBillHeadValueTime) + "ms");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBill});
                long finishTime = System.currentTimeMillis();
                LOGGER.info("BizValidPerformance--finishTime: " + new Date(finishTime));
                LOGGER.info("BizValidPerformance--finishUse: " + (finishTime - beginTime) + "ms");
                QFilter qFilter = new QFilter("xbillid", "in", bill.getPkValue());
                DynamicObject changeReCordObj = BusinessDataServiceHelper.loadSingle((String)"msbd_changeresume", (String)"xvalidstatus", (QFilter[])new QFilter[]{qFilter});
                if (!CommonUtils.isNull((Object)changeReCordObj) && (xValidStatus = (String)changeReCordObj.get("xvalidstatus")).equals(BizValidStatusEnum.UNVALID.getValue())) {
                    changeReCordObj.set("xvalidstatus", (Object)BizValidStatusEnum.VALID.getValue());
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{changeReCordObj});
                }
                String XBillLogEntityKey = "plat_xbilllog";
                if (changeModel.getDynamicObject("xbilllog") != null) {
                    XBillLogEntityKey = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
                }
                String status = BizChangeStatusEnum.CHANGED.getValue();
                ChangeXlogBuilder builder = new ChangeXlogBuilder(srcBill, bill, XBillLogEntityKey, status);
                String[] billfields = ChangeModelHelper.getAllCanLogProperty(changeModel);
                Map<String, Map<String, String>> entryAndOp = ChangeModelHelper.getXBillEntryAndOp(changeModel);
                if (billfields != null) {
                    ChangeBillComparator comparator = new ChangeBillComparator(srcBill, bill, new LinkedHashSet<String>(Arrays.asList(billfields)), entryAndOp);
                    XlogDirector director = new XlogDirector(builder, comparator);
                    director.constructXlog();
                    director.saveXlog();
                }
                String customParameter = changeModel.getString("customparameter_tag");
                HashMap srcAttachKeyMap = new HashMap(16);
                HashMap changeAttachKeyMap = new HashMap(16);
                if (StringUtils.isNotBlank((CharSequence)customParameter)) {
                    try {
                        List customParameters = (List)SerializationUtils.fromJsonString((String)customParameter, List.class);
                        if (customParameters != null && !customParameters.isEmpty()) {
                            for (Map map : customParameters) {
                                if (map.get("name") != null && ((String)map.get("name")).startsWith("srcattachkey")) {
                                    srcAttachKeyMap.put(map.get("name"), map.get("val"));
                                }
                                if (map.get("name") == null || !((String)map.get("name")).startsWith("changeattachkey")) continue;
                                changeAttachKeyMap.put(map.get("name"), map.get("val"));
                            }
                        }
                    }
                    catch (Exception ee) {
                        String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"XBillBizValidOp_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
                        throw new KDBizException(errMsg);
                    }
                }
                if (srcAttachKeyMap.isEmpty() || changeAttachKeyMap.isEmpty()) continue;
                Set<String> changeAttachPanels = (Set<String>)panelsMap.get(bill.getDataEntityType().getName());
                if (changeAttachPanels == null) {
                    changeAttachPanels = this.getAttachmentPanels(bill.getDataEntityType().getName());
                    panelsMap.put(bill.getDataEntityType().getName(), changeAttachPanels);
                }
                if ((srcAttachPanels = (Set<String>)panelsMap.get(sourcebillentity)) == null) {
                    srcAttachPanels = this.getAttachmentPanels(sourcebillentity);
                    panelsMap.put(sourcebillentity, srcAttachPanels);
                }
                String billNo = bill.getString("changebillno");
                String appendRemark = String.format(ResManager.loadKDString((String)"\u7531\u53d8\u66f4\u5355%1$s\u53cd\u5199\u751f\u6210\u3002", (String)"XBillBizValidOp_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), billNo);
                for (Map.Entry entry : srcAttachKeyMap.entrySet()) {
                    String srcAttachParam = (String)entry.getKey();
                    String srcAttachKey = (String)entry.getValue();
                    String changeAttachParam = "changeattachkey" + srcAttachParam.substring("srcattachkey".length());
                    String changeAttachKey = (String)changeAttachKeyMap.get(changeAttachParam);
                    if (changeAttachKey == null || !StringUtils.isNotBlank((CharSequence)changeAttachKey) || !StringUtils.isNotBlank((CharSequence)srcAttachKey)) continue;
                    if (changeAttachPanels.contains(changeAttachKey) && srcAttachPanels.contains(srcAttachKey)) {
                        TXHandle tx = TX.requiresNew();
                        Throwable throwable = null;
                        try {
                            AttachmentsHelper.copyAttachments(bill.getDataEntityType().getName(), bill.getPkValue(), changeAttachKey, sourcebillentity, srcBill.getPkValue(), srcAttachKey, appendRemark);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                continue;
                            }
                            tx.close();
                            continue;
                        }
                    }
                    String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u7684\u9644\u4ef6\u9762\u677f\u5728\u5355\u636e\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"XBillBizValidOp_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
                    throw new KDBizException(errMsg);
                }
            }
        }
    }

    private Set<String> getAttachmentPanels(String formId) {
        HashSet<String> attachmentPanels = new HashSet<String>(16);
        try {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            List allAps = formMetadata.getItems();
            if (allAps != null && !allAps.isEmpty()) {
                for (ControlAp item : allAps) {
                    if (!(item instanceof AttachmentPanelAp)) continue;
                    attachmentPanels.add(item.getKey());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attachmentPanels;
    }

    protected Map<String, Map<String, String>> getXBillEntryAndField(DynamicObject changeModel) {
        Map<Object, Object> result = new HashMap();
        result = ChangeModelHelper.getXBillEntryAndOp(changeModel);
        if (result.size() != 0) {
            return result;
        }
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("entity", "billentry");
        value.put("changetype", "billentrychangetype");
        value.put("srcid", "billentrysrcid");
        result.put(value.get("entity"), value);
        return result;
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
            childEntities.addAll(XBillBizValidOp.getChildEntities((IDataEntityType)childEntity));
        }
        return childEntities;
    }
}

