/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeStatusEnum;

public class XBillDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("sourcebillentity");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            if (bills == null || bills.length <= 0) {
                return;
            }
            IDataEntityType xbillET = bills[0].getDataEntityType();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>();
            ArrayList<Object> xBillPks = new ArrayList<Object>();
            ArrayList<Object> srcBillPks = new ArrayList<Object>();
            ArrayList<Object> zeroXBillAr = new ArrayList<Object>();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                xBillPks.add(bill.getPkValue());
                long sourceBillId = bill.get("sourcebillid") instanceof String ? Long.parseLong(bill.getString("sourcebillid")) : bill.getLong("sourcebillid");
                srcBillPks.add(sourceBillId);
                String sourceBillEntity = bill.getString("sourcebillentity");
                if (sourceBillId == 0L || sourceBillEntity == null) continue;
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillEntity);
                if (null == srcBill.get("changer")) {
                    srcBill.set("changestatus", (Object)BizChangeStatusEnum.UNCHANGE.getValue());
                } else {
                    srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGED.getValue());
                }
                srcBills.add(srcBill);
                QFilter zeroXBillQFilter1 = new QFilter("sourcebillid", "=", bill.get("sourcebillid"));
                QFilter zeroXBillQFilter2 = new QFilter("changestatus", "=", (Object)"D");
                QFilter zeroXBillQFilter3 = new QFilter("changebillno", "=", (Object)(srcBill.getString("billno") + "_0"));
                DynamicObjectCollection zeroXBillDOCol = QueryServiceHelper.query((String)xbillET.getName(), (String)"id", (QFilter[])new QFilter[]{zeroXBillQFilter1, zeroXBillQFilter2, zeroXBillQFilter3}, null);
                for (DynamicObject zeroXBill : zeroXBillDOCol) {
                    if (zeroXBill == null || !BizChangeStatusEnum.UNCHANGE.getValue().equals(srcBill.getString("changestatus"))) continue;
                    zeroXBillAr.add(zeroXBill.get("id"));
                }
            }
            if (zeroXBillAr != null && zeroXBillAr.size() > 0) {
                xBillPks.addAll(zeroXBillAr);
                DeleteServiceHelper.delete((IDataEntityType)xbillET, (Object[])zeroXBillAr.toArray());
            }
            if (srcBills.size() != 0) {
                SaveServiceHelper.update((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
            }
            if (xBillPks.size() != 0) {
                DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(xbillET.getName());
                if (changeModel == null) {
                    return;
                }
                String XBillLogEntityKey = "plat_xbilllog";
                if (changeModel.getDynamicObject("xbilllog") != null) {
                    XBillLogEntityKey = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
                }
                this.deleteFirstVerLogs(srcBillPks, XBillLogEntityKey);
                QFilter qFilter = new QFilter("xbillid", "in", xBillPks);
                DeleteServiceHelper.delete((String)XBillLogEntityKey, (QFilter[])new QFilter[]{qFilter});
                DeleteServiceHelper.delete((String)"msbd_changeresume", (QFilter[])new QFilter[]{qFilter});
                DeleteServiceHelper.delete((String)"msbd_changeresumedetail", (QFilter[])new QFilter[]{qFilter});
            }
        }
    }

    private void deleteFirstVerLogs(ArrayList<Object> srcBillPks, String XBillLogEntityKey) {
        HashMap<Long, Set> onlyFirstVerFields = new HashMap<Long, Set>(8);
        QFilter q = new QFilter("srcbillid", "in", srcBillPks);
        QFilter q1 = new QFilter("changestatus", "=", (Object)ChangeStatusEnum.CHANGED.getValue());
        QFilter q2 = new QFilter("changestatus", "=", (Object)"");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)XBillLogEntityKey, (String)"srcbillid,entryentity.rowid entryrowid,entryentity.fieldkey fieldkey", (QFilter[])new QFilter[]{q, q1.or(q2)}, null);){
            if (ds != null) {
                DataSet countDs = ds.groupBy(new String[]{"srcbillid", "entryrowid", "fieldkey"}).count("count").finish();
                for (Row row : countDs) {
                    if (!StringUtils.isNotBlank((CharSequence)row.getString("fieldkey")) || row.getInteger("count") != 1) continue;
                    DynamicObject[] fields = onlyFirstVerFields.computeIfAbsent(row.getLong("srcbillid"), k -> new HashSet());
                    fields.add(row.get("entryrowid") + row.getString("fieldkey"));
                }
            }
        }
        if (onlyFirstVerFields.size() > 0) {
            QFilter q3 = new QFilter("srcbillid", "in", onlyFirstVerFields.keySet());
            QFilter q4 = "pm_xpurplanbilllog".equals(XBillLogEntityKey) || "pm_xpurapplybilllog".equals(XBillLogEntityKey) ? new QFilter("srcbillversion", "=", (Object)"0") : new QFilter("srcbillversion", "=", (Object)0);
            DynamicObject[] logs = BusinessDataServiceHelper.load((String)XBillLogEntityKey, (String)"id,changestatus,srcbillid,srcbillversion,entryentity.rowid,entryentity.fieldkey", (QFilter[])new QFilter[]{q3, q4}, null);
            ArrayList<Long> needDeleteIds = new ArrayList<Long>();
            ArrayList<DynamicObject> needUpdateDyn = new ArrayList<DynamicObject>();
            for (DynamicObject log : logs) {
                if (!onlyFirstVerFields.containsKey(log.getLong("srcbillid"))) continue;
                DynamicObjectCollection entrys = log.getDynamicObjectCollection("entryentity");
                Set fields = (Set)onlyFirstVerFields.get(log.getLong("srcbillid"));
                if (entrys == null) continue;
                if (entrys.size() == fields.size()) {
                    needDeleteIds.add((Long)log.getPkValue());
                    continue;
                }
                Iterator it = entrys.iterator();
                while (it.hasNext()) {
                    DynamicObject entry = (DynamicObject)it.next();
                    if (!fields.contains(entry.getString("rowid") + entry.get("fieldkey"))) continue;
                    it.remove();
                }
                needUpdateDyn.add(log);
            }
            if (needDeleteIds.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", needDeleteIds);
                DeleteServiceHelper.delete((String)XBillLogEntityKey, (QFilter[])new QFilter[]{qFilter});
            }
            if (needUpdateDyn.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])needUpdateDyn.toArray(new DynamicObject[0]));
            }
        } else {
            QFilter q4 = "pm_xpurplanbilllog".equals(XBillLogEntityKey) || "pm_xpurapplybilllog".equals(XBillLogEntityKey) ? new QFilter("srcbillversion", "=", (Object)"0") : new QFilter("srcbillversion", "=", (Object)0);
            DeleteServiceHelper.delete((String)XBillLogEntityKey, (QFilter[])new QFilter[]{q, q4});
        }
    }
}

