/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.opplugin;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeResumeLogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.XlogDirector;
import kd.mpscmm.msbd.changemodel.business.xlog.builder.ChangeXlogBuilder;
import kd.mpscmm.msbd.changemodel.business.xlog.comparator.ChangeBillComparator;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeResumeFormConst;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;

public class XBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("changebillno");
        e.getFieldKeys().add("changebizdate");
        e.getFieldKeys().add("changereason");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("subversion");
        e.getFieldKeys().add("validstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(bills[0].getDataEntityType().getName());
            if (changeModel == null) {
                return;
            }
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                ChangeModelHelper.excutePluginMethod(changeModel, "beforeXBillSave", bill);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(bills[0].getDataEntityType().getName());
            if (changeModel == null) {
                return;
            }
            String XBillLogEntityKey = "plat_xbilllog";
            if (changeModel.getDynamicObject("xbilllog") != null) {
                XBillLogEntityKey = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
            }
            String enableChangeResume = this.getOption().getVariableValue(ChangeResumeFormConst.ENABLE_CHANGERESUME, "true");
            String dbRouteKey = bills[0].getDataEntityType().getDBRouteKey();
            if (!"scm".equals(dbRouteKey)) {
                enableChangeResume = "false";
            }
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                long sourceBillId = bill.get("sourcebillid") instanceof String ? Long.parseLong(bill.getString("sourcebillid")) : bill.getLong("sourcebillid");
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceBillId, (String)((String)changeModel.getDynamicObject("srcbill").getPkValue()));
                if (!BizChangeStatusEnum.CHANGING.getValue().equals(srcBill.get("changestatus"))) {
                    srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGING.getValue());
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{srcBill});
                } else if (bill.getPkValue() != null) {
                    QFilter qFilter = new QFilter("changebillno", "=", bill.get("changebillno"));
                    DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)bill.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (temp != null && !temp.getPkValue().equals(bill.getPkValue())) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6b63\u5728\u53d8\u66f4\u7684\u6570\u636e\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"XBillSaveOp_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                    }
                }
                DynamicObject xBill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getPkValue(), (String)((String)changeModel.getDynamicObject("xbill").getPkValue()));
                String status = BizChangeStatusEnum.CHANGING.getValue();
                ChangeXlogBuilder builder = new ChangeXlogBuilder(srcBill, xBill, XBillLogEntityKey, status);
                String[] billfields = ChangeModelHelper.getAllCanLogProperty(changeModel);
                Map<String, Map<String, String>> entryAndOp = ChangeModelHelper.getXBillEntryAndOp(changeModel);
                if (billfields != null) {
                    ChangeBillComparator comparator = new ChangeBillComparator(srcBill, xBill, new LinkedHashSet<String>(Arrays.asList(billfields)), entryAndOp);
                    XlogDirector director = new XlogDirector(builder, comparator);
                    director.constructXlog();
                    director.saveXlog();
                }
                if ("true".equals(enableChangeResume)) {
                    long srcbillid = (Long)srcBill.getPkValue();
                    String srcBillEntity = srcBill.getDataEntityType().getName();
                    String srcBillNo = srcBill.getString("billno");
                    String srcBillVersion = srcBill.getString("version");
                    long xbillid = (Long)bill.getPkValue();
                    String xbillno = bill.getString("changebillno");
                    String xbillentity = bill.getDataEntityType().getName();
                    DynamicObject creator = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
                    Date biztime = bill.getDate("changebizdate");
                    String xreason = bill.getString("changereason");
                    String srcBillSubVersion = srcBill.getString("subversion");
                    MainEntityType changeResumeDetailET = MetadataServiceHelper.getDataEntityType((String)"msbd_changeresumedetail");
                    QFilter qFilter1 = new QFilter("srcbillid", "=", (Object)srcbillid);
                    QFilter qFilter2 = new QFilter("xbillid", "=", (Object)xbillid);
                    DeleteServiceHelper.delete((String)"msbd_changeresumedetail", (QFilter[])new QFilter[]{qFilter1, qFilter2});
                    DynamicObject resumeDetailDO = new DynamicObject((DynamicObjectType)changeResumeDetailET);
                    resumeDetailDO.set("srcbillid", (Object)srcbillid);
                    resumeDetailDO.set("srcbillno", (Object)srcBillNo);
                    resumeDetailDO.set("srcbillentity", (Object)srcBillEntity);
                    resumeDetailDO.set("srcbillversion", (Object)srcBillVersion);
                    resumeDetailDO.set("xbillid", (Object)xbillid);
                    resumeDetailDO.set("xbillentity", (Object)xbillentity);
                    resumeDetailDO.set("xbillno", (Object)xbillno);
                    resumeDetailDO.set("xbiztime", (Object)biztime);
                    resumeDetailDO.set("xcreator", (Object)creator);
                    resumeDetailDO.set("xreason", (Object)xreason);
                    resumeDetailDO.set("crdheadjson_tag", (Object)ChangeResumeLogHelper.getBilljson(srcBill, xBill));
                    resumeDetailDO.set("crdentryjson_tag", (Object)ChangeResumeLogHelper.getBillEntryjson(srcBill, xBill, ChangeModelHelper.getAllXBillInfoMapping(changeModel)));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resumeDetailDO});
                    QFilter qFilter3 = new QFilter("srcbillid", "=", (Object)srcbillid);
                    QFilter qFilter4 = new QFilter("xbillid", "=", (Object)xbillid);
                    QFilter qFilter5 = new QFilter("currentchangenumber", "!=", (Object)0);
                    DeleteServiceHelper.delete((String)"msbd_changeresume", (QFilter[])new QFilter[]{qFilter3, qFilter4, qFilter5});
                    MainEntityType changeResumeET = MetadataServiceHelper.getDataEntityType((String)"msbd_changeresume");
                    QFilter qFilterZero1 = new QFilter("srcbillid", "=", (Object)srcbillid);
                    QFilter qFilterZero2 = new QFilter("currentchangenumber", "=", (Object)0);
                    boolean isExistsZero = QueryServiceHelper.exists((String)"msbd_changeresume", (QFilter[])new QFilter[]{qFilterZero1, qFilterZero2});
                    if (!isExistsZero && "1".equals(srcBillVersion) && "1".equals(srcBillSubVersion)) {
                        DynamicObject zeroXBill = ChangeModelHelper.generateXBilll(srcBillEntity, srcbillid);
                        zeroXBill.set("changestatus", (Object)"D");
                        zeroXBill.set("changebillno", (Object)(srcBillNo + "_0"));
                        Object[] inDBZeroXBill = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{zeroXBill});
                        if (inDBZeroXBill != null && inDBZeroXBill.length > 0 && inDBZeroXBill[0] != null) {
                            MainEntityType changeReCordlist = MetadataServiceHelper.getDataEntityType((String)"msbd_changeresume");
                            DynamicObject zeroChangeResumeDO = new DynamicObject((DynamicObjectType)changeReCordlist);
                            zeroChangeResumeDO.set("xbillid", ((DynamicObject)inDBZeroXBill[0]).getPkValue());
                            zeroChangeResumeDO.set("xbillno", (Object)((DynamicObject)inDBZeroXBill[0]).getString("changebillno"));
                            zeroChangeResumeDO.set("xvalidstatus", (Object)bill.getString("validstatus"));
                            zeroChangeResumeDO.set("xbillentity", (Object)xbillentity);
                            zeroChangeResumeDO.set("xbiztime", (Object)biztime);
                            zeroChangeResumeDO.set("xcreator", (Object)creator);
                            zeroChangeResumeDO.set("srcbillid", (Object)srcbillid);
                            zeroChangeResumeDO.set("srcbillentity", (Object)srcBillEntity);
                            zeroChangeResumeDO.set("srcbillno", (Object)srcBillNo);
                            zeroChangeResumeDO.set("srcbillversion", (Object)srcBillVersion);
                            zeroChangeResumeDO.set("srcbillsubversion", (Object)srcBillSubVersion);
                            zeroChangeResumeDO.set("changemodel", changeModel.getPkValue());
                            zeroChangeResumeDO.set("currentchangenumber", (Object)0);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{zeroChangeResumeDO});
                        }
                    }
                    DynamicObject currentChangeResumeDO = new DynamicObject((DynamicObjectType)changeResumeET);
                    DynamicObjectCollection num = QueryServiceHelper.query((String)"msbd_changeresume", (String)"currentchangenumber", (QFilter[])new QFilter[]{qFilter3, qFilter5}, (String)"currentchangenumber");
                    int currentChangeNumber = 0;
                    currentChangeNumber = num != null && num.size() > 0 ? num.size() + 1 : 1;
                    currentChangeResumeDO.set("srcbillid", (Object)srcbillid);
                    currentChangeResumeDO.set("srcbillentity", (Object)srcBillEntity);
                    currentChangeResumeDO.set("srcbillno", (Object)srcBillNo);
                    currentChangeResumeDO.set("srcbillversion", (Object)srcBillVersion);
                    currentChangeResumeDO.set("srcbillsubversion", (Object)srcBillSubVersion);
                    currentChangeResumeDO.set("currentchangenumber", (Object)currentChangeNumber);
                    currentChangeResumeDO.set("xvalidstatus", (Object)bill.getString("validstatus"));
                    currentChangeResumeDO.set("xbillid", (Object)xbillid);
                    currentChangeResumeDO.set("xbillentity", (Object)xbillentity);
                    currentChangeResumeDO.set("xbillno", (Object)xbillno);
                    currentChangeResumeDO.set("xbiztime", (Object)biztime);
                    currentChangeResumeDO.set("xreason", (Object)xreason);
                    currentChangeResumeDO.set("xcreator", (Object)creator);
                    currentChangeResumeDO.set("changemodel", changeModel.getPkValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentChangeResumeDO});
                }
                ChangeModelHelper.excutePluginMethod(changeModel, "afterXBillSave", bill);
            }
        }
    }
}

