/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.invbillscene.invbillapi;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mpscmm.msbd.mservice.invbillscene.InvBillApiServiceImpl;
import kd.mpscmm.msbd.mservice.invbillscene.algorithm.TaxAlgorithmForBotp;
import kd.mpscmm.msbd.mservice.invbillscene.enums.PrecisionAccountEnum;
import kd.mpscmm.msbd.mservice.invbillscene.invbillconsts.BigDecimalConstants;
import kd.mpscmm.msbd.mservice.invbillscene.pojo.BotpParamInfo;
import kd.mpscmm.msbd.mservice.invbillscene.util.ApiResultUtils;
import org.apache.commons.lang3.StringUtils;

public class InvBillBotpApiServiceImpl
extends InvBillApiServiceImpl {
    private static Log log = LogFactory.getLog(InvBillBotpApiServiceImpl.class);
    private Map<Object, BotpParamInfo> taskIdToParamInfoMap = new HashMap<Object, BotpParamInfo>(64);
    private Set<Object> deleteBillList = new HashSet<Object>(16);
    private Set<Object> unSubmitBillList = new HashSet<Object>(16);
    private MainEntityType entityType = null;
    private String srcBillType = null;
    private String tarBillType = null;
    private String entryIdMatchKey = null;
    private String billIdMatchKey = null;
    private String entryKey = null;

    private BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            return srcQty;
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
        if (muConv != null && muConv.getInt("numerator") != 0) {
            int precision = desUnit.getInt("precision");
            String precisionAccount = desUnit.getString("precisionaccount");
            if (StringUtils.isNotEmpty((CharSequence)precisionAccount) && muConv.getInt("denominator") != 0) {
                return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, PrecisionAccountEnum.getEnumByVal(Integer.parseInt(precisionAccount)));
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    protected void beforeBuildBill(List<DynamicObject> tasks, Map<Long, ApiResult> resultMap) {
        HashSet<Object> dirSrcBillIds = new HashSet<Object>(tasks.size());
        ArrayList<DynamicObject> failedTasks = new ArrayList<DynamicObject>(16);
        for (DynamicObject task : tasks) {
            ApiResult result = null;
            try {
                BotpParamInfo paramInfo = this.parseParam(task, dirSrcBillIds);
                this.taskIdToParamInfoMap.put(task.getPkValue(), paramInfo);
            }
            catch (KDBizException bizException) {
                result = ApiResultUtils.createFailResult(bizException.getErrorCode().getMessage());
            }
            catch (Exception exception) {
                result = ApiResultUtils.createFailResult(ResManager.loadKDString((String)"\u8c03\u7528\u670d\u52a1\u5f02\u5e38\uff1a{0}", (String)"InvBillApiServiceImpl_1", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)exception)}));
            }
            if (result == null) continue;
            resultMap.put((Long)task.getPkValue(), result);
            failedTasks.add(task);
        }
        tasks.removeAll(failedTasks);
        this.rebuildBotpParamInfo(dirSrcBillIds);
    }

    @Override
    protected Map<Long, List<DynamicObject>> buildBill(List<DynamicObject> tasks, Map<Long, ApiResult> resultMap) {
        HashMap<Long, List<DynamicObject>> taskIdToBillMap = new HashMap<Long, List<DynamicObject>>(tasks.size());
        for (DynamicObject task : tasks) {
            ApiResult result = null;
            Long taskId = (Long)task.getPkValue();
            List<DynamicObject> bill = null;
            try {
                bill = this.doBuildBill(task);
                if (bill != null && !bill.isEmpty()) {
                    taskIdToBillMap.computeIfAbsent(taskId, k -> new ArrayList()).addAll(bill);
                }
            }
            catch (KDBizException bizException) {
                result = ApiResultUtils.createFailResult(bizException.getErrorCode().getMessage());
            }
            catch (Exception exception) {
                result = ApiResultUtils.createFailResult(ResManager.loadKDString((String)"\u8c03\u7528\u670d\u52a1\u5f02\u5e38\uff1a{0}", (String)"InvBillApiServiceImpl_1", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)exception)}));
            }
            if (result == null) continue;
            resultMap.put(taskId, result);
        }
        return taskIdToBillMap;
    }

    public List<DynamicObject> doBuildBill(DynamicObject task) {
        BotpParamInfo paramInfo = this.taskIdToParamInfoMap.get(task.getPkValue());
        List<DynamicObject> bills = this.pushBill(paramInfo);
        for (DynamicObject bill : bills) {
            this.handleBillHead(bill, paramInfo.getBillHeadInfo());
            this.handleBillEntry(bill, paramInfo.getSrcSysEntryIdGroupRowsMap());
        }
        return bills;
    }

    private void handleBillHead(DynamicObject bill, Map<String, Object> billHeadInfo) {
        this.setValueByParam(bill, billHeadInfo, this.entityType.getProperties());
    }

    private void handleBillEntry(DynamicObject bill, Map<Long, List<Map<String, Object>>> relationEntryIdGroupMap) {
        DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
        EntryProp iDataEntityProperty = (EntryProp)properties.get((Object)"billentry");
        DataEntityPropertyCollection entryProp = iDataEntityProperty.getItemType().getProperties();
        DynamicObjectCollection entryCollection = bill.getDynamicObjectCollection("billentry");
        DynamicObjectCollection newRows = new DynamicObjectCollection();
        for (DynamicObject entry : entryCollection) {
            Object srcBillEntryId = entry.get("srcbillentryid");
            if (ObjectUtils.isEmpty((Object)srcBillEntryId)) continue;
            Long srcBillEntryIdLong = srcBillEntryId instanceof Long ? (Long)srcBillEntryId : Long.valueOf(srcBillEntryId.toString());
            List<Map<String, Object>> entryInfos = relationEntryIdGroupMap.get(srcBillEntryIdLong);
            newRows.addAll((Collection)this.splitRow(bill, entry, entryInfos, entryProp));
        }
        entryCollection.addAll((Collection)newRows);
        TaxAlgorithmForBotp algorithm = new TaxAlgorithmForBotp(bill);
        algorithm.reCalFields();
    }

    private DynamicObjectCollection splitRow(DynamicObject bill, DynamicObject entry, List<Map<String, Object>> entryInfos, DataEntityPropertyCollection entryProp) {
        DynamicObjectCollection newRows = new DynamicObjectCollection();
        if (entryInfos == null || entryInfos.isEmpty()) {
            return newRows;
        }
        for (int i = 0; i < entryInfos.size(); ++i) {
            Map<String, Object> entryInfo = entryInfos.get(i);
            if (i == 0) {
                this.setValueByParam(entry, entryInfo, entryProp);
                this.reCalQty(entry, entryInfo);
                continue;
            }
            DynamicObject newRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)entry, (boolean)true, (boolean)true);
            this.setValueByParam(newRow, entryInfo, entryProp);
            this.reCalQty(newRow, entryInfo);
            newRow.setParent((Object)bill);
            newRows.add((Object)newRow);
        }
        return newRows;
    }

    private void reCalQty(DynamicObject entry, Map<String, Object> entryInfo) {
        boolean isConvert;
        if (entryInfo.isEmpty()) {
            return;
        }
        Object extraInfo = entryInfo.get("multitenant_extra");
        if (ObjectUtils.isEmpty((Object)extraInfo)) {
            return;
        }
        Map extraInfoMap = (Map)extraInfo;
        Object reCalQtyKey = extraInfoMap.get("recalqtykey");
        if (ObjectUtils.isEmpty(reCalQtyKey)) {
            return;
        }
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal reCalQty = entry.getBigDecimal(reCalQtyKey.toString());
        if (materialInvInfo == null || unit == null || baseUnit == null || reCalQty == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null || reCalQty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal desQtyConv = this.getDesQtyConv(material, unit, reCalQty, baseUnit);
        if (desQtyConv.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            return;
        }
        entry.set("baseqty", (Object)desQtyConv);
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = "A".equals(unitConvertDir) || "C".equals(unitConvertDir);
        if (!isConvert || BigDecimal.ZERO.compareTo(desQtyConv) == 0) {
            return;
        }
        BigDecimal qtyUnit2nd = this.getDesQtyConv(material, baseUnit, desQtyConv, auxptyUnit);
        if (qtyUnit2nd.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            entry.set("qtyunit2nd", (Object)BigDecimal.ZERO);
            return;
        }
        entry.set("qtyunit2nd", (Object)qtyUnit2nd);
    }

    private void rebuildBotpParamInfo(Set<Object> dirSrcBillIds) {
        if (dirSrcBillIds.isEmpty()) {
            return;
        }
        String entryIdKey = this.entryKey + ".id";
        String selectFields = "id," + entryIdKey + "," + this.billIdMatchKey + "," + this.entryIdMatchKey;
        DataSet dirSrcBillDataSet = QueryServiceHelper.queryDataSet((String)InvBillBotpApiServiceImpl.class.getName(), (String)this.srcBillType, (String)selectFields, (QFilter[])new QFilter("id", "in", dirSrcBillIds).toArray(), null);
        if (dirSrcBillDataSet.isEmpty()) {
            return;
        }
        HashMap<Long, Object> srcSysEntryIdToDirSrcEntryId = new HashMap<Long, Object>(64);
        for (Row row : dirSrcBillDataSet) {
            Object dirSrcEntryId = row.get(entryIdKey);
            Object srcSysEntryId = row.get(this.entryIdMatchKey);
            if (ObjectUtils.isEmpty((Object)dirSrcEntryId) || ObjectUtils.isEmpty((Object)srcSysEntryId)) continue;
            Long dirSrcEntryIdLong = dirSrcEntryId instanceof Long ? (Long)dirSrcEntryId : Long.valueOf(dirSrcEntryId.toString());
            Long srcSysEntryIdLong = srcSysEntryId instanceof Long ? (Long)srcSysEntryId : Long.valueOf(srcSysEntryId.toString());
            srcSysEntryIdToDirSrcEntryId.put(srcSysEntryIdLong, dirSrcEntryIdLong);
        }
        for (BotpParamInfo paramInfo : this.taskIdToParamInfoMap.values()) {
            Map<Long, List<Map<String, Object>>> relationEntryIdGroupMap = paramInfo.getSrcSysEntryIdGroupRowsMap();
            HashSet<Long> realSrcSysEntryIds = new HashSet<Long>(relationEntryIdGroupMap.size());
            realSrcSysEntryIds.addAll(relationEntryIdGroupMap.keySet());
            for (Long realSrcSysEntryId : realSrcSysEntryIds) {
                Long needPushDownDirEntryId;
                if (paramInfo.getDirSrcBillId().compareTo(paramInfo.getSrcSysBillId()) == 0 || (needPushDownDirEntryId = (Long)srcSysEntryIdToDirSrcEntryId.get(realSrcSysEntryId)).compareTo(realSrcSysEntryId) == 0) continue;
                List<Map<String, Object>> entryInfos = relationEntryIdGroupMap.remove(realSrcSysEntryId);
                relationEntryIdGroupMap.put(needPushDownDirEntryId, entryInfos);
            }
            paramInfo.setSrcSysEntryIdGroupRowsMap(relationEntryIdGroupMap);
            ArrayList<ListSelectedRow> pushDownRows = new ArrayList<ListSelectedRow>(relationEntryIdGroupMap.size());
            Long dirSrcBillId = paramInfo.getDirSrcBillId();
            for (Long dirSrcBillEntryId : relationEntryIdGroupMap.keySet()) {
                ListSelectedRow currentRow = new ListSelectedRow();
                currentRow.setPrimaryKeyValue((Object)dirSrcBillId);
                currentRow.setEntryEntityKey(this.entryKey);
                currentRow.setEntryPrimaryKeyValue((Object)dirSrcBillEntryId);
                pushDownRows.add(currentRow);
            }
            paramInfo.setPushDownRows(pushDownRows);
        }
    }

    private void setValueByParam(DynamicObject bill, Map<String, Object> billInfo, DataEntityPropertyCollection properties) {
        for (Map.Entry<String, Object> info : billInfo.entrySet()) {
            IDataEntityProperty property;
            String key = info.getKey();
            Object value = info.getValue();
            if (value == null || (property = (IDataEntityProperty)properties.get((Object)key)) == null) continue;
            if ("billentry".equals(key) || "afterentity".equals(key)) {
                List entryList = (List)value;
                DynamicObjectCollection entryCollection = bill.getDynamicObjectCollection(key);
                EntryProp iDataEntityProperty = (EntryProp)property;
                DataEntityPropertyCollection entryProp = iDataEntityProperty.getItemType().getProperties();
                int loopSize = Math.min(entryList.size(), entryCollection.size());
                for (int i = 0; i < loopSize; ++i) {
                    DynamicObject entryDym = (DynamicObject)entryCollection.get(i);
                    Map entryInfoMap = (Map)entryList.get(i);
                    this.setValueByParam(entryDym, entryInfoMap, entryProp);
                }
                continue;
            }
            this.setValue(bill, property, key, value);
        }
    }

    private void setValue(DynamicObject bill, IDataEntityProperty property, String key, Object value) {
        if (!(property instanceof ItemClassProp) && !(property instanceof BasedataProp)) {
            if (property instanceof DateTimeProp) {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd").parse((String)value);
                    property.setValueFast((Object)bill, (Object)date);
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u5fc5\u987b\u7b26\u5408 yyyy-MM-dd\u683c\u5f0f\u3002", (String)"InvBillBotpApiServiceImpl_1", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[0]));
                }
            } else {
                property.setValueFast((Object)bill, value);
            }
        }
    }

    private List<DynamicObject> pushBill(BotpParamInfo paramInfo) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(this.srcBillType);
        pushArgs.setTargetEntityNumber(this.tarBillType);
        pushArgs.setHasRight(true);
        if (StringUtils.isNotBlank((CharSequence)paramInfo.getRuleId())) {
            pushArgs.setRuleId(paramInfo.getRuleId());
        }
        pushArgs.setBuildConvReport(true);
        pushArgs.setShowReport(true);
        pushArgs.setSelectedRows(paramInfo.getPushDownRows());
        ConvertOperationResult operationResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u5931\u8d25\uff1a{0}", (String)"InvBillBotpApiServiceImpl_2", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{this.getConvertErrorMsg(operationResult)}));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)this.tarBillType);
        return operationResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
    }

    private String getConvertErrorMsg(ConvertOperationResult result) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)result.getMessage())) {
            errorMsgBuilder.append(result.getMessage()).append("\n");
        }
        if (result.getBillReports() != null && !result.getBillReports().isEmpty()) {
            errorMsgBuilder.append(result.getBillReports().toString()).append("\n");
        }
        return errorMsgBuilder.toString();
    }

    private BotpParamInfo parseParam(DynamicObject task, Set<Object> dirSrcBillIds) {
        Map bizData;
        Object srcSysBillId;
        Object entryMatchKey;
        Object param = task.get("param_tag");
        if (param == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"param_tag"}));
        }
        Map params = (Map)JSON.parseObject((String)param.toString(), Map.class);
        if (this.srcBillType == null) {
            if (ObjectUtils.isEmpty(params.get("srcbilltype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"srcbilltype"}));
            }
            this.srcBillType = params.get("srcbilltype").toString();
        }
        if (this.tarBillType == null) {
            if (ObjectUtils.isEmpty(params.get("tarbilltype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"tarbilltype"}));
            }
            this.tarBillType = params.get("tarbilltype").toString();
            this.entityType = EntityMetadataCache.getDataEntityType((String)this.tarBillType);
        }
        if (ObjectUtils.isEmpty(params.get("data"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"data"}));
        }
        Object ruleId = params.get("botpid");
        if (ObjectUtils.isEmpty(ruleId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"botpid"}));
        }
        if (this.billIdMatchKey == null) {
            Object billMatchKey = params.get("billidmatchkey");
            if (ObjectUtils.isEmpty(billMatchKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"billidmatchkey"}));
            }
            this.billIdMatchKey = billMatchKey.toString();
        }
        if (ObjectUtils.isEmpty(entryMatchKey = params.get("entryidmatchkey"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"entrymatchkey"}));
        }
        if (this.entryIdMatchKey == null) {
            this.entryIdMatchKey = entryMatchKey.toString();
        }
        if (this.entryKey == null) {
            if (ObjectUtils.isEmpty(params.get("entryidkey"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"entryidkey"}));
            }
            this.entryKey = params.get("entryidkey").toString();
        }
        if (ObjectUtils.isEmpty(srcSysBillId = (bizData = (Map)params.get("data")).get("srcsysbillid"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"srcsysbillid"}));
        }
        Object dirSrcBillId = bizData.get("dirsrcbillid");
        if (ObjectUtils.isEmpty(dirSrcBillId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"dirsrcbillid"}));
        }
        dirSrcBillIds.add(Long.parseLong(dirSrcBillId.toString()));
        if (ObjectUtils.isEmpty(bizData.get("billinfo"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5165\u53c2\uff1a{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvBillBotpApiServiceImpl_0", (String)"mpscmm-msbd-scmcapi", (Object[])new Object[]{"billinfo"}));
        }
        BotpParamInfo botpParamInfo = new BotpParamInfo();
        botpParamInfo.setRuleId(ruleId.toString());
        botpParamInfo.setDirSrcBillId(dirSrcBillId instanceof Long ? (Long)dirSrcBillId : Long.valueOf(dirSrcBillId.toString()));
        botpParamInfo.setSrcSysBillId(srcSysBillId instanceof Long ? (Long)srcSysBillId : Long.valueOf(srcSysBillId.toString()));
        botpParamInfo.setEntryIdMatchKey(entryMatchKey.toString());
        Map billInfo = (Map)bizData.get("billinfo");
        Map<String, Object> billHeadInfo = this.getBillHeadInfo(billInfo);
        botpParamInfo.setBillHeadInfo(billHeadInfo);
        Map<Long, List<Map<String, Object>>> relationEntryIdCountMap = this.getRelationEntryIdGroupMap(billInfo);
        botpParamInfo.setSrcSysEntryIdGroupRowsMap(relationEntryIdCountMap);
        return botpParamInfo;
    }

    private Map<String, Object> getBillHeadInfo(Map<String, Object> billInfo) {
        HashMap<String, Object> billHeadInfo = new HashMap<String, Object>(billInfo.size());
        for (Map.Entry<String, Object> info : billInfo.entrySet()) {
            String key = info.getKey();
            Object value = info.getValue();
            if ("billentry".equals(key)) continue;
            billHeadInfo.put(key, value);
        }
        return billHeadInfo;
    }

    private Map<Long, List<Map<String, Object>>> getRelationEntryIdGroupMap(Map<String, Object> billInfo) {
        HashMap<Long, List<Map<String, Object>>> relationEntryIdGroupMap = new HashMap<Long, List<Map<String, Object>>>(4);
        Object billEntry = billInfo.get("billentry");
        if (ObjectUtils.isEmpty((Object)billEntry)) {
            return relationEntryIdGroupMap;
        }
        List billEntryList = (List)billEntry;
        for (Map entryInfo : billEntryList) {
            Object relationEntryId;
            Map extraInfoMap;
            Object extraInfo = entryInfo.get("multitenant_extra");
            if (ObjectUtils.isEmpty(extraInfo) || ObjectUtils.isEmpty((extraInfoMap = (Map)extraInfo).get("relationentryid")) || ObjectUtils.isEmpty(relationEntryId = extraInfoMap.get("relationentryid"))) continue;
            Long relationId = relationEntryId instanceof Long ? (Long)relationEntryId : Long.valueOf(relationEntryId.toString());
            List curEntryParam = relationEntryIdGroupMap.computeIfAbsent(relationId, k -> new ArrayList(4));
            curEntryParam.add(entryInfo);
        }
        return relationEntryIdGroupMap;
    }

    @Override
    protected Map<Long, ApiResult> doBizOperation(Map<Long, List<DynamicObject>> taskIdToBillMap) {
        HashMap<Long, ApiResult> bizOpResult = new HashMap<Long, ApiResult>(taskIdToBillMap.size());
        if (taskIdToBillMap.isEmpty()) {
            return bizOpResult;
        }
        Map<Object, Long> billIdToTaskIdMap = this.getBillIdToTaskIdMap(taskIdToBillMap);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ishasright", "true");
        List<Object> succeedIdList = this.doSaveBill(taskIdToBillMap, billIdToTaskIdMap, bizOpResult, option);
        if (succeedIdList != null && !succeedIdList.isEmpty() && (succeedIdList = this.doSubmitBill(taskIdToBillMap, billIdToTaskIdMap, bizOpResult, option, succeedIdList)) != null && !succeedIdList.isEmpty()) {
            this.doAuditBill(taskIdToBillMap, billIdToTaskIdMap, bizOpResult, option, succeedIdList);
        }
        this.clearData(option);
        return bizOpResult;
    }

    private void clearData(OperateOption option) {
        Throwable throwable;
        TXHandle txHandle;
        String dt = this.entityType.getName();
        if (!this.unSubmitBillList.isEmpty()) {
            txHandle = TX.requiresNew();
            throwable = null;
            try {
                try {
                    OperationResult unSubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)dt, (Object[])this.unSubmitBillList.toArray(), (OperateOption)option);
                    this.deleteBillList.addAll(unSubmitResult.getSuccessPkIds());
                    if (log.isDebugEnabled()) {
                        log.debug("InvBillBotpApiServiceImpl#clearData \u6267\u884cunsubmit\u7ed3\u675f\uff0cunSubmitBillList={}, successIdList={}", this.unSubmitBillList, (Object)unSubmitResult.getSuccessPkIds());
                    }
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    log.error("InvBillBotpApiServiceImpl#clearData \u6267\u884cunsubmit\u5f02\u5e38:unSubmitBillList={}, \u5f02\u5e38\u4fe1\u606f={}", this.unSubmitBillList, (Object)e);
                }
            }
            catch (Throwable e) {
                throwable = e;
                throw e;
            }
            finally {
                if (txHandle != null) {
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
        }
        if (!this.deleteBillList.isEmpty()) {
            txHandle = TX.requiresNew();
            throwable = null;
            try {
                try {
                    OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)dt, (Object[])this.deleteBillList.toArray(), (OperateOption)option);
                    if (log.isDebugEnabled()) {
                        log.debug("InvBillBotpApiServiceImpl#clearData \u6267\u884cdelete\u7ed3\u675f\uff0cdeleteBillList={}, successIdList={}", this.deleteBillList, (Object)deleteResult.getSuccessPkIds());
                    }
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    log.error("InvBillBotpApiServiceImpl#clearData \u6267\u884cdelete\u5f02\u5e38:deleteBillList={}, \u5f02\u5e38\u4fe1\u606f={}", this.deleteBillList, (Object)e);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txHandle != null) {
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
        }
    }

    private void doAuditBill(Map<Long, List<DynamicObject>> taskIdToBillMap, Map<Object, Long> billIdToTaskIdMap, Map<Long, ApiResult> bizOpResult, OperateOption option, List<Object> succeedIdList) {
        String dt = this.entityType.getName();
        ArrayList<Object> rollBackList = new ArrayList<Object>(succeedIdList);
        try (TXHandle txHandle = TX.requiresNew();){
            OperationResult opResult = null;
            try {
                opResult = OperationServiceHelper.executeOperate((String)"audit", (String)dt, (Object[])succeedIdList.toArray(), (OperateOption)option);
                List auditIds = opResult.getSuccessPkIds();
                if (!opResult.isSuccess()) {
                    ApiResultUtils.buildApiResult(opResult, billIdToTaskIdMap, bizOpResult);
                    succeedIdList.removeAll(auditIds);
                    this.unSubmitBillList.addAll(succeedIdList);
                }
                ApiResultUtils.buildSucceedApiResult(auditIds, billIdToTaskIdMap, bizOpResult);
                if (log.isDebugEnabled()) {
                    log.debug("InvBillBotpApiServiceImpl#doAuditBill \u6267\u884c\u7ed3\u675f\uff0c\u6267\u884c\u64cd\u4f5c\u5355\u636eid\u96c6\u5408={}, \u6210\u529f\u5355\u636eid\u96c6\u5408={}", rollBackList, (Object)auditIds);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                this.unSubmitBillList.addAll(rollBackList);
                ApiResultUtils.buildExceptionApiResult(taskIdToBillMap.keySet(), bizOpResult, e);
                log.error("InvBillBotpApiServiceImpl#doAuditBill \u6267\u884c\u5f02\u5e38:\u6267\u884c\u64cd\u4f5c\u5355\u636eid\u96c6\u5408={}, \u5f02\u5e38\u4fe1\u606f={}", rollBackList, (Object)e);
            }
        }
    }

    private List<Object> doSubmitBill(Map<Long, List<DynamicObject>> taskIdToBillMap, Map<Object, Long> billIdToTaskIdMap, Map<Long, ApiResult> bizOpResult, OperateOption option, List<Object> succeedIdList) {
        String dt = this.entityType.getName();
        ArrayList<Object> rollBackList = new ArrayList<Object>(succeedIdList);
        try (TXHandle txHandle = TX.requiresNew();){
            OperationResult opResult = null;
            try {
                opResult = OperationServiceHelper.executeOperate((String)"submit", (String)dt, (Object[])succeedIdList.toArray(), (OperateOption)option);
                List submittedIds = opResult.getSuccessPkIds();
                if (!opResult.isSuccess()) {
                    ApiResultUtils.buildApiResult(opResult, billIdToTaskIdMap, bizOpResult);
                    succeedIdList.removeAll(submittedIds);
                    this.deleteBillList.addAll(succeedIdList);
                }
                succeedIdList = submittedIds;
                if (log.isDebugEnabled()) {
                    log.debug("InvBillBotpApiServiceImpl#doSubmitBill \u6267\u884c\u7ed3\u675f\uff0c\u6267\u884c\u64cd\u4f5c\u5355\u636eid\u96c6\u5408={}, \u6210\u529f\u5355\u636eid\u96c6\u5408={}", rollBackList, (Object)submittedIds);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                this.deleteBillList.addAll(rollBackList);
                succeedIdList.clear();
                ApiResultUtils.buildExceptionApiResult(taskIdToBillMap.keySet(), bizOpResult, e);
                log.error("InvBillBotpApiServiceImpl#doSubmitBill \u6267\u884c\u5f02\u5e38:\u6267\u884c\u64cd\u4f5c\u5355\u636eid\u96c6\u5408={}, \u5f02\u5e38\u4fe1\u606f={}", rollBackList, (Object)e);
            }
        }
        return succeedIdList;
    }

    private List<Object> doSaveBill(Map<Long, List<DynamicObject>> taskIdToBillMap, Map<Object, Long> billIdToTaskIdMap, Map<Long, ApiResult> bizOpResult, OperateOption option) {
        List succeedIdList;
        ArrayList bills = new ArrayList(16);
        taskIdToBillMap.values().forEach(bills::addAll);
        String dt = this.entityType.getName();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)dt, (DynamicObject[])bills.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!opResult.isSuccess()) {
                    ApiResultUtils.buildApiResult(opResult, billIdToTaskIdMap, bizOpResult);
                }
                succeedIdList = opResult.getSuccessPkIds();
            }
            catch (Exception e) {
                txHandle.markRollback();
                ApiResultUtils.buildExceptionApiResult(taskIdToBillMap.keySet(), bizOpResult, e);
                log.error("InvBillBotpApiServiceImpl#doSaveBill \u6267\u884c\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
                List<Object> list = Collections.emptyList();
                if (txHandle != null) {
                    if (var9_8 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return list;
            }
        }
        return succeedIdList;
    }

    private Map<Object, Long> getBillIdToTaskIdMap(Map<Long, List<DynamicObject>> taskIdToBillMap) {
        HashMap<Object, Long> billIdToTaskIdMap = new HashMap<Object, Long>(taskIdToBillMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : taskIdToBillMap.entrySet()) {
            Long taskId = entry.getKey();
            if (taskId == null) continue;
            List<DynamicObject> billList = entry.getValue();
            for (DynamicObject bill : billList) {
                Object billId = bill.getPkValue();
                billIdToTaskIdMap.put(billId, taskId);
            }
        }
        return billIdToTaskIdMap;
    }
}

