/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.mservice.invbillscene.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.util.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;

public class ApiResultUtils {
    public static ApiResult createFailResult(String errorMessage) {
        ApiResult result = new ApiResult();
        result.setSuccess(false);
        result.setMessage(errorMessage);
        return result;
    }

    public static void buildExceptionApiResult(Set<Long> taskIdSet, Map<Long, ApiResult> bizOpResult, Exception exception) {
        if (taskIdSet.isEmpty()) {
            return;
        }
        String stackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)exception);
        for (Long taskId : taskIdSet) {
            ApiResult result = bizOpResult.computeIfAbsent(taskId, k -> new ApiResult());
            String apiResultMessage = result.getMessage();
            apiResultMessage = apiResultMessage == null ? stackTraceMessage : apiResultMessage + "\n" + stackTraceMessage;
            result.setMessage(apiResultMessage);
            result.setSuccess(false);
        }
    }

    public static void buildSucceedApiResult(List<Object> auditIds, Map<Object, Long> billIdToTaskIdMap, Map<Long, ApiResult> bizOpResult) {
        if (auditIds == null || auditIds.isEmpty()) {
            return;
        }
        for (Object auditId : auditIds) {
            Long taskId = billIdToTaskIdMap.get(auditId);
            ApiResult result = bizOpResult.computeIfAbsent(taskId, k -> new ApiResult());
            if (!result.getSuccess() || result.getMessage() != null) continue;
            result.setSuccess(true);
        }
    }

    public static void buildApiResult(OperationResult opResult, Map<Object, Long> billIdToTaskIdMap, Map<Long, ApiResult> bizOpResult) {
        List validateInfo;
        String message = opResult.getMessage();
        if (!StringUtils.isBlank((CharSequence)message)) {
            for (Long taskId : billIdToTaskIdMap.values()) {
                ApiResult result = bizOpResult.computeIfAbsent(taskId, k -> new ApiResult());
                String apiResultMessage = result.getMessage();
                apiResultMessage = apiResultMessage == null ? message : apiResultMessage + "\n" + message;
                result.setMessage(apiResultMessage);
                result.setSuccess(false);
            }
        }
        if ((validateInfo = opResult.getAllErrorOrValidateInfo()) == null || validateInfo.isEmpty()) {
            return;
        }
        for (IOperateInfo operateInfo : validateInfo) {
            Object billPk = operateInfo.getPkValue();
            String validateMessage = operateInfo.getMessage();
            Long taskId = billIdToTaskIdMap.get(billPk);
            ApiResult result = bizOpResult.computeIfAbsent(taskId, k -> new ApiResult());
            String apiResultMessage = result.getMessage();
            apiResultMessage = apiResultMessage == null ? validateMessage : apiResultMessage + "\n" + validateMessage;
            result.setMessage(apiResultMessage);
            result.setSuccess(false);
        }
    }
}

