/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.biz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.lotmainfile.helper.LotMainFileConfigHelper;

public class LotMainFileGenerator {
    private DynamicObject cfg;
    private Long masterfiletypeid;
    private String materialcol;
    private String invorgcol;
    private String creatorcol;
    private String firstindatecol;
    private String lotnumcol;
    private LinkedHashMap<String, DynamicObject> lotmainfMaps;
    private Map<Long, DynamicObject> billentriesMap;
    private Integer unqCtrl;
    private DynamicObject bill;
    private DynamicObjectCollection billentries;
    private Set<Long> removeEntryIdsSet;

    public static LotMainFileGenerator build(DynamicObject cfg, DynamicObject bill, DynamicObjectCollection entry, Set<Long> removeEntryIdsSet) {
        return new LotMainFileGenerator(cfg, bill, entry, removeEntryIdsSet);
    }

    private LotMainFileGenerator(DynamicObject cfg, DynamicObject bill, DynamicObjectCollection entry, Set<Long> removeEntryIdsSet) {
        this.cfg = cfg;
        this.bill = bill;
        this.billentries = entry;
        this.removeEntryIdsSet = removeEntryIdsSet;
        this.buildOperator();
    }

    private void buildOperator() {
        this.masterfiletypeid = this.cfg.getDynamicObject("masterfiletype").getLong("id");
        this.materialcol = LotMainFileConfigHelper.getParamField(this.cfg, "material");
        this.invorgcol = LotMainFileConfigHelper.getParamField(this.cfg, "createorg");
        this.creatorcol = LotMainFileConfigHelper.getParamField(this.cfg, "creator");
        this.firstindatecol = LotMainFileConfigHelper.getParamField(this.cfg, "instockdate");
        this.lotnumcol = LotMainFileConfigHelper.getParamField(this.cfg, "number");
        this.lotmainfMaps = LotMainFileConfigHelper.getLotmainfMaps(this.cfg);
        if (this.billentries != null && this.billentries.size() > 0) {
            this.billentriesMap = new HashMap<Long, DynamicObject>(this.billentries.size());
            for (DynamicObject billentry : this.billentries) {
                Long entryId = billentry.getLong("id");
                if (this.removeEntryIdsSet.contains(entryId)) continue;
                this.billentriesMap.put(entryId, billentry);
            }
        }
    }

    public void saveLotMainFileExec(Map<Integer, String> msgMap) {
        if (this.billentriesMap.isEmpty()) {
            return;
        }
        this.unqCtrl = LotMainFileConfigHelper.getUnqctrl();
        try (TXHandle tx = TX.requiresNew();
             DataSet lotMainFileDataSet = this.getBillLotMainFileDataSet();){
            this.saveLotMainFileData(lotMainFileDataSet, msgMap);
        }
    }

    private DataSet getBillLotMainFileDataSet() {
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("billentryid", (DataType)DataType.LongType), new Field("materialmasterid", (DataType)DataType.LongType), new Field("invorgid", (DataType)DataType.LongType), new Field("lotnum", (DataType)DataType.StringType), new Field("creator", (DataType)DataType.LongType), new Field("firstindate", (DataType)DataType.DateType), new Field("seq", (DataType)DataType.IntegerType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        HashSet<String> lotnums = new HashSet<String>(this.billentriesMap.size());
        for (DynamicObject billentry : this.billentriesMap.values()) {
            Long billentryid = billentry.getLong("id");
            Long materialmasterid = ((DynamicObject)LotMainFileConfigHelper.getDynamicVal(this.bill, billentry, this.materialcol, false)).getDynamicObject("masterid").getLong("id");
            Long invorgid = (Long)LotMainFileConfigHelper.getDynamicVal(this.bill, billentry, this.invorgcol, true);
            Long creatorid = (Long)LotMainFileConfigHelper.getDynamicVal(this.bill, billentry, this.creatorcol, true);
            Date firstindate = (Date)LotMainFileConfigHelper.getDynamicVal(this.bill, billentry, this.firstindatecol, true);
            String lotnum = (String)LotMainFileConfigHelper.getDynamicVal(this.bill, billentry, this.lotnumcol, true);
            int seq = billentry.getInt("seq");
            lotnums.add(lotnum);
            billentryDsBuilder.append(new Object[]{billentryid, materialmasterid, invorgid, lotnum, creatorid, firstindate, seq});
        }
        DataSet billentryDataSet = billentryDsBuilder.build();
        DataSet lotMainFileDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lot", (String)"id as mainfileid,number as mfsnnumber, material as mfmaterialid,createorg as mfinvorg", (QFilter[])new QFilter("number", "in", lotnums).and("masterfiletype", "=", (Object)this.masterfiletypeid).toArray(), (String)"");
        JoinDataSet tempDataSet = billentryDataSet.leftJoin(lotMainFileDataSet).on("lotnum", "mfsnnumber");
        if (this.unqCtrl == 2 || this.unqCtrl == 4) {
            tempDataSet.on("materialmasterid", "mfmaterialid");
        }
        if (this.unqCtrl == 3 || this.unqCtrl == 4) {
            tempDataSet.on("invorgid", "mfinvorg");
        }
        DataSet billLotRelWithMatDataSet = tempDataSet.select(billentryDataSet.getRowMeta().getFieldNames(), lotMainFileDataSet.getRowMeta().getFieldNames()).finish();
        return billLotRelWithMatDataSet;
    }

    private void saveLotMainFileData(DataSet lotMainFileDataSet, Map<Integer, String> msgMap) {
        String lotMainfInsertSql = this.buildLotMainFileInsertSql();
        ArrayList<Object[]> lotMainFileInsertParams = new ArrayList<Object[]>(1000);
        HashMap lotnumMap = new HashMap(50);
        long[] mainfileids = null;
        int mainfileidsIdx = 0;
        for (Row row : lotMainFileDataSet) {
            Long mfmaterialid;
            HashMap<String, Long> lotnumAttrs;
            Long mainfileid = row.getLong("mainfileid");
            String lotnum = row.getString("lotnum");
            Long invorgid = row.getLong("invorgid");
            Long materialmasterid = row.getLong("materialmasterid");
            Integer seq = row.getInteger("seq");
            String lotnumUnq = this.buildUnqstr(lotnum, materialmasterid, invorgid);
            if (lotnumMap.containsKey(lotnumUnq)) {
                lotnumAttrs = (HashMap<String, Long>)lotnumMap.get(lotnumUnq);
                mfmaterialid = (Long)lotnumAttrs.get("materialmasterid");
                if (!materialmasterid.equals(mfmaterialid)) {
                    msgMap.put(seq, "ERRORLOTNUMBERCLEAR" + String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6279\u53f7\u5df2\u5b58\u5728,\u4f46\u7269\u6599\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u518d\u751f\u6210\u4e00\u6b21\u3002", (String)"LotMainFileServiceImpl_MaterialNotSame", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]), seq));
                    continue;
                }
                mainfileid = (Long)((Map)lotnumMap.get(lotnumUnq)).get("mainfileid");
            } else {
                lotnumAttrs = new HashMap<String, Long>(2);
                if (LotMainFileGenerator.isEmpty(mainfileid)) {
                    if (mainfileids == null) {
                        mainfileids = LotMainFileConfigHelper.batchGenId("t_bd_lot", this.billentriesMap.size());
                    }
                    mainfileid = mainfileidsIdx < mainfileids.length ? Long.valueOf(mainfileids[mainfileidsIdx]) : Long.valueOf(LotMainFileConfigHelper.genId("t_bd_lot"));
                    ++mainfileidsIdx;
                    Object[] snmainfInsertParam = this.genLotMainFileInsertParam(row, mainfileid);
                    lotMainFileInsertParams.add(snmainfInsertParam);
                    if (lotMainFileInsertParams.size() == 1000) {
                        LotMainFileGenerator.executeBatchSql(lotMainFileInsertParams, lotMainfInsertSql);
                    }
                } else {
                    mfmaterialid = row.getLong("mfmaterialid");
                    if (!materialmasterid.equals(mfmaterialid)) {
                        msgMap.put(seq, "ERRORLOTNUMBERCLEAR" + String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6279\u53f7\u5df2\u5b58\u5728,\u4f46\u7269\u6599\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u518d\u751f\u6210\u4e00\u6b21\u3002", (String)"LotMainFileServiceImpl_MaterialNotSame", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]), seq));
                        lotnumAttrs.put("materialmasterid", mfmaterialid);
                        lotnumAttrs.put("mainfileid", mainfileid);
                        lotnumMap.put(lotnumUnq, lotnumAttrs);
                        continue;
                    }
                }
                lotnumAttrs.put("materialmasterid", materialmasterid);
                lotnumAttrs.put("mainfileid", mainfileid);
                lotnumMap.put(lotnumUnq, lotnumAttrs);
            }
            msgMap.put(seq, mainfileid.toString());
        }
        if (lotMainFileInsertParams.size() > 0) {
            LotMainFileGenerator.executeBatchSql(lotMainFileInsertParams, lotMainfInsertSql);
        }
    }

    private String buildUnqstr(String lotnum, Long materialmasterid, Long invorgid) {
        StringBuilder unqstrbuilder = new StringBuilder(lotnum);
        if (this.unqCtrl == 2 || this.unqCtrl == 4) {
            unqstrbuilder.append('.').append(materialmasterid);
        }
        if (this.unqCtrl == 3 || this.unqCtrl == 4) {
            unqstrbuilder.append('.').append(invorgid);
        }
        return unqstrbuilder.toString();
    }

    private Object[] genLotMainFileInsertParam(Row row, Long mainfileid) {
        Object[] lotMainFileInsertParam = new Object[9 + this.lotmainfMaps.size()];
        lotMainFileInsertParam[0] = mainfileid;
        lotMainFileInsertParam[1] = "B";
        lotMainFileInsertParam[2] = row.getLong("materialmasterid");
        lotMainFileInsertParam[3] = "1";
        lotMainFileInsertParam[4] = "C";
        lotMainFileInsertParam[5] = new Date();
        lotMainFileInsertParam[6] = this.masterfiletypeid;
        lotMainFileInsertParam[7] = mainfileid;
        Long entryid = row.getLong("billentryid");
        DynamicObject billentry = this.billentriesMap.get(entryid);
        int i = 9;
        DynamicObject orgColumn = this.lotmainfMaps.get("createorg");
        for (Map.Entry<String, DynamicObject> entry : this.lotmainfMaps.entrySet()) {
            Object dynamicVal;
            String lotMinFileCol = entry.getKey();
            String srcBillCol = entry.getValue().getString("mainfsrcbillcol");
            lotMainFileInsertParam[i] = dynamicVal = LotMainFileConfigHelper.getDynamicVal(this.bill, billentry, srcBillCol, true);
            if (orgColumn != null && lotMinFileCol.equals(orgColumn.getString("mainfcol"))) {
                lotMainFileInsertParam[8] = dynamicVal;
            }
            ++i;
        }
        if (lotMainFileInsertParam[8] == null) {
            lotMainFileInsertParam[8] = 0L;
        }
        return lotMainFileInsertParam;
    }

    private String buildLotMainFileInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into t_bd_lot(").append("fid,flotstatus,fmaterialid,fenable,fstatus,fcreatetime,fmasterfiletypeid,fmasterid,fcurrentorgid");
        if (this.lotmainfMaps.size() > 0) {
            Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_lot").getAllFields();
            for (String tarcol : this.lotmainfMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)fieldTypes.get(tarcol)).getAlias());
            }
        }
        builder.append(") values(").append(String.join((CharSequence)",", Collections.nCopies(9 + this.lotmainfMaps.size(), "?"))).append(')');
        return builder.toString();
    }

    private static void executeBatchSql(List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        params.clear();
    }

    private static boolean isEmpty(Long id) {
        return id == null || id.equals(0L);
    }
}

