/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.formPlugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.business.helper.MetaHelper;
import kd.mpscmm.mscommon.business.strategy.CompositeStrategy;
import kd.mpscmm.mscommon.business.strategy.EntryNodeStrategy;
import kd.mpscmm.mscommon.business.strategy.EntryStrategy;
import kd.mpscmm.mscommon.business.strategy.FilterStrategy;
import kd.mpscmm.mscommon.business.strategy.IColsSelectStrategy;
import kd.mpscmm.mscommon.business.strategy.SimpleStrategy;
import kd.mpscmm.mscommon.business.strategy.TypeSelectStategy;
import kd.mpscmm.mscommon.common.colsAssist.SelectParams;
import kd.mpscmm.mscommon.common.utils.ColsTreeUtil;
import kd.mpscmm.mscommon.common.utils.FormUtil;
import kd.mpscmm.mscommon.lotmainfile.formPlugin.FieldFormTranslator;

public class LotBillConfigEditPlugin
extends AbstractBasePlugIn
implements EntryGridBindDataListener {
    private static final String SRCBILLENTRYCB = "srcbillentryCB";
    private static final String LOTIDCB = "LotidCB";
    private static final String LOTNUMBERCB = "LotNumberCB";
    private static final String MAINF_COLCB = "mainfColCB";
    private static final String MAINFSRC_COLCB = "mainfsrcbillColCB";
    private static final String TRACK_COLCB = "trackColCB";
    private static final String TRACKSRC_COLCB = "tracksrcbillColCB";
    private static final String LOTMFRETURN_COLCB = "lotMFReturnColCB";
    private static final String LOTMFRETURNSRC_COLCB = "lotMFReturnSrcbillColCB";
    private static final List<String> mainfileFixCols = Arrays.asList("masterfiletype", "auxpty", "lot", "supplier", "supplierlot", "model", "supplierlot", "producedept", "createtime", "customer", "modifytime", "modifier", "disabler", "disabledate", "name", "status", "enable", "lotstatus");
    private static final List<String> movetrackFixCols = Arrays.asList("lot", "billentity", "movedirect", "dseq", "srclotnum", "billid", "billentrytype", "billentryid", "lotidfield", "lotbillconf", "invdc", "entrydc", "createtime");
    private static final String[] LOCK_UPD_KEYS = new String[]{"creator", "material", "number", "instockdate", "createorg"};

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("lotmfreturnentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setCols4FilterGridAndOpe();
        this.bindBillFilterInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("mainfentry");
        HashSet<String> lockKeys = new HashSet<String>();
        for (String key : LOCK_UPD_KEYS) {
            lockKeys.add(key);
        }
        for (int i = 0; i < rowCount; ++i) {
            String tarCol = (String)model.getValue("mainfcol", i);
            if (StringUtils.isBlank((CharSequence)tarCol) || !lockKeys.contains(tarCol)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"updateconditon"});
        }
        this.setEnable();
    }

    private void setCols4FilterGridAndOpe() {
        IFormView view = this.getView();
        FilterGrid filterGrid = (FilterGrid)view.getControl("billfiltergrid");
        MainEntityType entityType = this.getSourceBillMainEntityType();
        if (entityType == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        view.updateView("billfiltergrid");
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        IFormView view = this.getView();
        entities.forEach(entry -> {
            int rowIndex = entry.getRowIndex();
            DynamicObject entryObj = entry.getDataEntity();
            String returnMainfcol = entryObj.getString("lotmfreturncol");
            if ("number".equals(returnMainfcol) || "material".equals(returnMainfcol)) {
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"selectcondition"});
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"returnbill"});
            } else if ("createorg".equals(returnMainfcol)) {
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"returnbill"});
            }
        });
    }

    private void bindBillFilterInfo() {
        String billFilterStr = this.getModel().getDataEntity().getString("billfilter");
        FilterCondition condition = null;
        condition = StringUtils.isBlank((CharSequence)billFilterStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)billFilterStr, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl("billfiltergrid");
        filterGrid.SetValue(condition);
    }

    private MainEntityType getSourceBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject sourceBill = model.getDataEntity().getDynamicObject("srcbillobj");
        if (sourceBill == null) {
            return null;
        }
        String metaDataNo = sourceBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    private void setEnable() {
        Boolean isPreset = this.getModel().getDataEntity().getBoolean("ispreset");
        if (isPreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"conentpanel"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcbillentry", "mainfcolno", "mainfsrcbillcolno", "trackcolno", "tracksrcbillcolno", "lotmfreturncolno", "lotmfreturnsrcbillcolno", "lotidfield", "lotnumberfield"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "srcbillentry": {
                this.clickSrcBillEntry();
                break;
            }
            case "lotidfield": 
            case "lotnumberfield": {
                this.clickCtrlCol(key);
                break;
            }
            case "mainfcolno": 
            case "trackcolno": 
            case "lotmfreturncolno": {
                this.clickTargetObjCol(key);
                break;
            }
            case "mainfsrcbillcolno": 
            case "tracksrcbillcolno": 
            case "lotmfreturnsrcbillcolno": {
                this.clickSourceObjCol(key);
                break;
            }
        }
    }

    private void clickCtrlCol(String key) {
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        String sourceBillEntry = this.checkSourceBillEntry(model);
        if (sourceBillEntry == null) {
            return;
        }
        MainEntityType billTplEntityType = EntityMetadataCache.getDataEntityType((String)"im_billtpl");
        IDataEntityProperty property = null;
        String colCBName = null;
        switch (key) {
            case "lotidfield": {
                property = billTplEntityType.findProperty("lot");
                colCBName = LOTIDCB;
                break;
            }
            case "lotnumberfield": {
                property = billTplEntityType.findProperty("lotnumber");
                colCBName = LOTNUMBERCB;
            }
        }
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(property, false);
        EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(Collections.singletonList(sourceBillEntry), false);
        CompositeStrategy compStrategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy));
        this.showColsTreePage(sourcebilltype, (IColsSelectStrategy)compStrategy, colCBName, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"plsselectfield_0", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
    }

    private void clickSrcBillEntry() {
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        this.showColsTreePage(sourcebilltype, (IColsSelectStrategy)new EntryStrategy(), SRCBILLENTRYCB, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53", (String)"plsselectfield_1", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
    }

    private void clickTargetObjCol(String key) {
        String entryName = null;
        String colName = null;
        String colCBName = null;
        String targetObj = null;
        switch (key) {
            case "mainfcolno": {
                entryName = "mainfentry";
                colName = "mainfcol";
                colCBName = MAINF_COLCB;
                targetObj = "bd_lot";
                break;
            }
            case "trackcolno": {
                entryName = "trackentry";
                colName = "trackcol";
                colCBName = TRACK_COLCB;
                targetObj = "bd_lotmovetrack";
                break;
            }
            case "lotmfreturncolno": {
                entryName = "lotmfreturnentry";
                colName = "lotmfreturncol";
                colCBName = LOTMFRETURN_COLCB;
                targetObj = "bd_lot";
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<String> existCols = new ArrayList<String>(16);
        existCols.add("currentorgid");
        DynamicObjectCollection colsMap = this.getModel().getEntryEntity(entryName);
        for (DynamicObject colMap : colsMap) {
            String targetObjCol = colMap.getString(colName);
            if (!StringUtils.isNotEmpty((CharSequence)targetObjCol)) continue;
            existCols.add(targetObjCol);
        }
        if ("bd_lot".equals(targetObj)) {
            existCols.add("entryentity");
            existCols.addAll(mainfileFixCols);
        } else if ("bd_lotmovetrack".equals(targetObj)) {
            existCols.addAll(movetrackFixCols);
        }
        this.showColsTreePage(targetObj, (IColsSelectStrategy)new FilterStrategy(existCols, true), colCBName, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"plsselectfield_0", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
    }

    private void clickSourceObjCol(String key) {
        EntityType billEntryEntityType;
        IDataEntityType billEntryParent;
        String targetObjtype = null;
        String entryName = null;
        String targetColName = null;
        String srcColCBName = null;
        boolean chooseParantEntity = false;
        switch (key) {
            case "mainfsrcbillcolno": {
                targetObjtype = "bd_lot";
                entryName = "mainfentry";
                targetColName = "mainfcol";
                srcColCBName = MAINFSRC_COLCB;
                break;
            }
            case "tracksrcbillcolno": {
                targetObjtype = "bd_lotmovetrack";
                entryName = "trackentry";
                targetColName = "trackcol";
                srcColCBName = TRACKSRC_COLCB;
                chooseParantEntity = true;
                break;
            }
            case "lotmfreturnsrcbillcolno": {
                targetObjtype = "bd_lot";
                entryName = "lotmfreturnentry";
                targetColName = "lotmfreturncol";
                srcColCBName = LOTMFRETURNSRC_COLCB;
                break;
            }
            default: {
                return;
            }
        }
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSourcebilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        String sourceBillEntry = this.checkSourceBillEntry(model);
        if (sourceBillEntry == null) {
            return;
        }
        int index = model.getEntryCurrentRowIndex(entryName);
        String prop = (String)model.getValue(targetColName, index);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u540d\u79f0\u3002", (String)"PlsCheckTargetObjCol", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetObjtype);
        String[] props = prop.split("\\.");
        if (props.length > 1) {
            prop = props[props.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(prop);
        String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u7684\u6620\u5c04\u5b57\u6bb5\u3002", (String)"plsselectmapfield", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]), property.getDisplayName().getLocaleValue());
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(property);
        ArrayList<String> chooseEntries = new ArrayList<String>(2);
        chooseEntries.add(sourceBillEntry);
        if (chooseParantEntity && !((billEntryParent = (billEntryEntityType = (EntityType)EntityMetadataCache.getDataEntityType((String)sourcebilltype).getAllEntities().get(sourceBillEntry)).getParent()) instanceof MainEntityType)) {
            chooseEntries.add(billEntryParent.getName());
        }
        EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(chooseEntries, true);
        CompositeStrategy compStrategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy));
        this.showColsTreePage(sourcebilltype, (IColsSelectStrategy)compStrategy, srcColCBName, caption);
    }

    private String checkSourcebilltype(IDataModel model) {
        DynamicObject sourceBill = (DynamicObject)model.getValue("srcbillobj");
        if (sourceBill == null) {
            String message = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"PlsSelectSourceBill", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return null;
        }
        return sourceBill.getString("number");
    }

    private String checkSourceBillEntry(IDataModel model) {
        String sourceBillEntry = model.getDataEntity().getString("srcbillentry");
        if (sourceBillEntry == null || sourceBillEntry.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4f53\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u4f53\u3002", (String)"PlsSelectSourceEntry", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return null;
        }
        return sourceBillEntry;
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String key, String caption) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormUtil.readyColsTreePage((SelectParams)params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            fp.setCaption(caption);
        }
        this.getView().showForm(fp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "srcbillentryCB": 
            case "LotidCB": 
            case "LotNumberCB": {
                this.objCloseCallBack(e, actionId);
                break;
            }
            case "mainfColCB": 
            case "trackColCB": 
            case "lotMFReturnColCB": 
            case "mainfsrcbillColCB": 
            case "tracksrcbillColCB": 
            case "lotMFReturnSrcbillColCB": {
                this.objColCloseCallBack(e, actionId);
                break;
            }
        }
    }

    private void objCloseCallBack(ClosedCallBackEvent e, String actionId) {
        MainEntityType meta;
        String col = null;
        String colName = null;
        boolean valProp = false;
        boolean valDBCol = false;
        switch (actionId) {
            case "srcbillentryCB": {
                col = "srcbillentry";
                colName = "srcbillentryname";
                break;
            }
            case "LotidCB": {
                col = "lotidfield";
                colName = "lotid";
                valProp = true;
                valDBCol = true;
                break;
            }
            case "LotNumberCB": {
                col = "lotnumberfield";
                valProp = true;
                valDBCol = true;
                break;
            }
            default: {
                return;
            }
        }
        IDataModel model = this.getModel();
        JSONArray data = ColsTreeUtil.parseReturnData((ClosedCallBackEvent)e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        if (valProp && this.checkChooseEntity(id)) {
            return;
        }
        if (valDBCol && !this.checkDatabaseCol(meta = this.getSourceBillMainEntityType(), id)) {
            return;
        }
        model.setValue(col, (Object)id);
        if (colName != null) {
            model.setValue(colName, (Object)info.getString("text"));
        }
    }

    private void objColCloseCallBack(ClosedCallBackEvent e, String actionId) {
        MainEntityType meta;
        String entryName = null;
        String colNo = null;
        String col = null;
        String clrColNo = null;
        String clrCol = null;
        boolean valSrcEntry = false;
        switch (actionId) {
            case "mainfColCB": {
                entryName = "mainfentry";
                colNo = "mainfcolno";
                col = "mainfcol";
                clrColNo = "mainfsrcbillcolno";
                clrCol = "mainfsrcbillcol";
                meta = EntityMetadataCache.getDataEntityType((String)"bd_lot");
                break;
            }
            case "trackColCB": {
                entryName = "trackentry";
                colNo = "trackcolno";
                col = "trackcol";
                clrColNo = "tracksrcbillcolno";
                clrCol = "tracksrcbillcol";
                meta = EntityMetadataCache.getDataEntityType((String)"bd_lotmovetrack");
                break;
            }
            case "lotMFReturnColCB": {
                entryName = "lotmfreturnentry";
                colNo = "lotmfreturncolno";
                col = "lotmfreturncol";
                clrColNo = "lotmfreturnsrcbillcolno";
                clrCol = "lotmfreturnsrcbillcol";
                meta = EntityMetadataCache.getDataEntityType((String)"bd_lot");
                break;
            }
            case "mainfsrcbillColCB": {
                entryName = "mainfentry";
                colNo = "mainfsrcbillcolno";
                col = "mainfsrcbillcol";
                valSrcEntry = true;
                meta = this.getSourceBillMainEntityType();
                break;
            }
            case "tracksrcbillColCB": {
                entryName = "trackentry";
                colNo = "tracksrcbillcolno";
                col = "tracksrcbillcol";
                valSrcEntry = true;
                meta = this.getSourceBillMainEntityType();
                break;
            }
            case "lotMFReturnSrcbillColCB": {
                entryName = "lotmfreturnentry";
                colNo = "lotmfreturnsrcbillcolno";
                col = "lotmfreturnsrcbillcol";
                valSrcEntry = true;
                meta = this.getSourceBillMainEntityType();
                break;
            }
            default: {
                return;
            }
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(entryName);
        JSONArray data = ColsTreeUtil.parseReturnData((ClosedCallBackEvent)e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        if (valSrcEntry && this.checkChooseEntity(id)) {
            return;
        }
        if (!this.checkDatabaseCol(meta, id)) {
            return;
        }
        model.beginInit();
        model.setValue(col, (Object)id, index);
        model.setValue(colNo, (Object)info.getString("text"), index);
        if (clrColNo != null) {
            model.setValue(clrColNo, null, index);
        }
        if (clrCol != null) {
            model.setValue(clrCol, null, index);
        }
        model.endInit();
        view.updateView(col, index);
        view.updateView(colNo, index);
        if (clrColNo != null) {
            view.updateView(clrColNo, index);
        }
        if (clrCol != null) {
            view.updateView(clrCol, index);
        }
        HashSet<String> lockKeys = new HashSet<String>();
        for (String key : LOCK_UPD_KEYS) {
            lockKeys.add(key);
        }
        if (StringUtils.isNotBlank((CharSequence)id) && lockKeys.contains(id)) {
            model.setValue("updateconditon", (Object)"2", index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"updateconditon"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"updateconditon"});
        }
        if (LOTMFRETURN_COLCB.equals(actionId)) {
            if (id.equals("number")) {
                model.setValue("selectcondition", (Object)false, index);
                model.setValue("returnbill", (Object)true, index);
            } else if (id.equals("material")) {
                model.setValue("selectcondition", (Object)true, index);
                model.setValue("returnbill", (Object)false, index);
            } else if (id.equals("createorg")) {
                model.setValue("returnbill", (Object)false, index);
            }
        }
    }

    private boolean checkChooseEntity(String prop) {
        MainEntityType meta = this.getSourceBillMainEntityType();
        if (meta != null) {
            return meta.getAllEntities().containsKey(prop);
        }
        return true;
    }

    private boolean checkDatabaseCol(MainEntityType meta, String id) {
        IDataEntityProperty prop;
        if (meta == null) {
            return false;
        }
        String[] keys = id.split("\\.");
        if (keys.length >= 2) {
            String entry = keys[keys.length - 2];
            String key = keys[keys.length - 1];
            prop = (IDataEntityProperty)((EntityType)meta.getAllEntities().get(entry)).getFields().get(key);
        } else {
            prop = (IDataEntityProperty)meta.getAllFields().get(id);
        }
        String dbCol = prop.getAlias();
        if (dbCol == null || dbCol.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u4e3a\u7a7a\u7684\u5b57\u6bb5\u3002", (String)"PlsSelectDBCol", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "srcbillobj": 
            case "srcbillentry": {
                this.changeSourceBill(e, key);
                break;
            }
            case "mainfcolno": 
            case "trackcolno": 
            case "lotmfreturncolno": 
            case "mainfsrcbillcolno": 
            case "tracksrcbillcolno": 
            case "lotmfreturnsrcbillcolno": {
                this.changeTargetObjCol(e, key);
            }
        }
    }

    private void changeTargetObjCol(PropertyChangedArgs e, String key) {
        String entryName = null;
        String tarCol = null;
        String srcColNo = null;
        String srcCol = null;
        switch (key) {
            case "mainfcolno": {
                entryName = "mainfentry";
                tarCol = "mainfcol";
                srcColNo = "mainfsrcbillcolno";
                srcCol = "mainfsrcbillcol";
                break;
            }
            case "trackcolno": {
                entryName = "trackentry";
                tarCol = "trackcol";
                srcColNo = "tracksrcbillcolno";
                srcCol = "tracksrcbillcol";
                break;
            }
            case "lotmfreturncolno": {
                entryName = "lotmfreturnentry";
                tarCol = "lotmfreturncol";
                srcColNo = "lotmfreturnsrcbillcolno";
                srcCol = "lotmfreturnsrcbillcol";
                break;
            }
            case "mainfsrcbillcolno": {
                entryName = "mainfentry";
                tarCol = "mainfsrcbillcol";
                break;
            }
            case "tracksrcbillcolno": {
                entryName = "trackentry";
                tarCol = "tracksrcbillcol";
                break;
            }
            case "lotmfreturnsrcbillcolno": {
                entryName = "lotmfreturnentry";
                tarCol = "lotmfreturnsrcbillcol";
            }
        }
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            model.setValue(tarCol, null, rowIndex);
            if (srcColNo != null) {
                model.setValue(srcColNo, null, rowIndex);
            }
            if (srcCol != null) {
                model.setValue(srcCol, null, rowIndex);
            }
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"updateconditon"});
        }
    }

    private void changeSourceBill(PropertyChangedArgs e, String key) {
        int i;
        IDataModel model = this.getModel();
        model.beginInit();
        if ("srcbillobj".equals(key)) {
            model.setValue("srcbillentry", null);
            model.setValue("srcbillentryname", null);
            FilterGrid filterGrid = (FilterGrid)this.getControl("billfiltergrid");
            filterGrid.SetValue(new FilterCondition());
            model.setValue("billfilter", (Object)"");
            this.setCols4FilterGridAndOpe();
        }
        if ("srcbillentry".equals(key)) {
            model.setValue("srcbillentryname", null);
        }
        model.setValue("lotid", null);
        model.setValue("lotidfield", null);
        model.setValue("lotnumberfield", null);
        DynamicObjectCollection snmainfEntries = model.getEntryEntity("mainfentry");
        DynamicObjectCollection sntrackEntries = model.getEntryEntity("trackentry");
        DynamicObjectCollection lotMFReturnEntries = model.getEntryEntity("lotmfreturnentry");
        if (!snmainfEntries.isEmpty()) {
            for (i = 0; i < snmainfEntries.size(); ++i) {
                model.setValue("mainfsrcbillcolno", null, i);
                model.setValue("mainfsrcbillcol", null, i);
            }
        }
        if (!sntrackEntries.isEmpty()) {
            for (i = 0; i < sntrackEntries.size(); ++i) {
                model.setValue("tracksrcbillcolno", null, i);
                model.setValue("tracksrcbillcol", null, i);
            }
        }
        if (!lotMFReturnEntries.isEmpty()) {
            for (i = 0; i < lotMFReturnEntries.size(); ++i) {
                model.setValue("lotmfreturnsrcbillcolno", null, i);
                model.setValue("lotmfreturnsrcbillcol", null, i);
            }
        }
        model.endInit();
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave(e);
                break;
            }
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String billFilterInfo = this.parseBillFilterInfo();
        model.setValue("billfilter", (Object)billFilterInfo);
    }

    private String parseBillFilterInfo() {
        FilterGrid grid = (FilterGrid)this.getControl("billfiltergrid");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        FieldFormTranslator translator = FieldFormTranslator.create(this.getModel());
        String billEntity = null;
        DynamicObject srcObj = (DynamicObject)this.getModel().getValue("srcbillobj");
        if (srcObj != null) {
            billEntity = srcObj.getString("number");
        }
        if (billEntity != null) {
            IDataEntityProperty prop;
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
            String entryKey = (String)this.getModel().getValue("srcbillentry");
            if (entryKey != null && (prop = entityType.findProperty(entryKey)) != null) {
                this.getModel().setValue("srcbillentryname", (Object)prop.getDisplayName().getLocaleValue());
            }
        }
        try {
            translator.entryToEntryTranslate("mainfentry", "bd_lot", "mainfcol", "mainfcolno");
            translator.entryToEntryTranslate("mainfentry", billEntity, "mainfsrcbillcol", "mainfsrcbillcolno");
            translator.entryToEntryTranslate("lotmfreturnentry", "bd_lot", "lotmfreturncol", "lotmfreturncolno");
            translator.entryToEntryTranslate("lotmfreturnentry", billEntity, "lotmfreturnsrcbillcol", "lotmfreturnsrcbillcolno");
            translator.entryToEntryTranslate("trackentry", "bd_lotmovetrack", "trackcol", "trackcolno");
            translator.entryToEntryTranslate("trackentry", billEntity, "tracksrcbillcol", "tracksrcbillcolno");
        }
        catch (Exception exception) {
            this.getView().showErrorNotification(exception.getMessage());
        }
        finally {
            this.getModel().setDataChanged(false);
        }
    }
}

