/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class LotMainFileBillConfigSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            this.validLotMainFileentry(extendedDataEntity);
        }
    }

    private void validLotMainFileentry(ExtendedDataEntity extendedDataEntity) {
        DynamicObject lotMainFilebillConfig = extendedDataEntity.getDataEntity();
        this.checkLotMainFentry(extendedDataEntity, lotMainFilebillConfig);
        this.checkLotMainfreturnentry(extendedDataEntity, lotMainFilebillConfig);
    }

    private void checkLotMainfreturnentry(ExtendedDataEntity extendedDataEntity, DynamicObject lotMainFilebillConfig) {
        DynamicObjectCollection entries = lotMainFilebillConfig.getDynamicObjectCollection("lotmfreturnentry");
        boolean materialFlag = false;
        for (DynamicObject entry : entries) {
            String returnMainfcol = entry.getString("lotmfreturncol");
            if (!"material".equals(returnMainfcol)) continue;
            materialFlag = true;
        }
        if (!materialFlag) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6279\u53f7\u4e3b\u6863\u8fd4\u56de\u5355\u636e\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u7269\u6599\u7f16\u7801\u5b57\u6bb5\u3002", (String)"LotMainFileBillConfigSaveValidator_ReturnMfEntryNotMaterial", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
    }

    private void checkLotMainFentry(ExtendedDataEntity extendedDataEntity, DynamicObject lotMainFilebillConfig) {
        DynamicObjectCollection entries = lotMainFilebillConfig.getDynamicObjectCollection("mainfentry");
        boolean orgFlag = false;
        boolean materialFlag = false;
        boolean lotNumberFlag = false;
        boolean firstIndateFlag = false;
        for (DynamicObject entry : entries) {
            String mainfcol = entry.getString("mainfcol");
            if ("createorg".equals(mainfcol)) {
                orgFlag = true;
            }
            if ("material".equals(mainfcol)) {
                materialFlag = true;
            }
            if ("number".equals(mainfcol)) {
                lotNumberFlag = true;
            }
            if (!"instockdate".equals(mainfcol)) continue;
            firstIndateFlag = true;
        }
        if (!orgFlag) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e3b\u6863\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u521b\u5efa\u7ec4\u7ec7\u5b57\u6bb5\u6620\u5c04\u3002", (String)"LotMainFileBillConfigSaveValidator_LotMainFileBillCfgMainfEntryNotOrg", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
        if (!materialFlag) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e3b\u6863\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u7269\u6599\u7f16\u7801\u5b57\u6bb5\u6620\u5c04\u3002", (String)"LotMainFileBillConfigSaveValidator_LotMainFileBillCfgMainfEntryNotMaterial", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
        if (!lotNumberFlag) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e3b\u6863\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u6279\u53f7\u5b57\u6bb5\u6620\u5c04\u3002", (String)"LotMainFileBillConfigSaveValidator_LotMainFileBillCfgMainfEntryNotLotNumber", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
        if (!firstIndateFlag) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e3b\u6863\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u9996\u6b21\u5165\u5e93\u65e5\u671f\u5b57\u6bb5\u6620\u5c04\u3002", (String)"LotMainFileBillConfigSaveValidator_LotMainFileBillCfgMainfEntryNotFirstInDate", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
    }
}

