/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.mservice.common.writeoff.WriteOffService;
import kd.mpscmm.mscommon.writeoff.business.engine.ReverseWriteOffEngine;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.WriteOffActionFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.action.WriteOffActionProcessor;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffHelpr;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WriteOffServiceImpl
extends BaseECService
implements WriteOffService,
IdempotentService {
    private static final Log logger = LogFactory.getLog(WriteOffServiceImpl.class);

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentProperties.generateCurTime((String)this.getClass().getName(), (Object)param);
    }

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        logger.info("WriteOffServiceImpl.doExecute()\u5f00\u59cb\u6d41\u7a0b\u6838\u9500\u670d\u52a1:");
        CommonParam commonParam = (CommonParam)param;
        String entitytype = (String)commonParam.get((Object)"entitytype");
        String operationKey = (String)commonParam.get((Object)"operationKey");
        String ids = (String)commonParam.get((Object)"ids");
        List idList = JSONObject.parseArray((String)ids, Object.class);
        CommonHelper.setUserId();
        this.startWriteOff(idList, entitytype, operationKey);
        return null;
    }

    @Override
    public void startWriteOff(List<Object> ids, String entityTypeName, String operationKey) {
        logger.info("\u5f00\u59cb\u4e86\u6d41\u7a0b\u6838\u9500info\uff0c\u53c2\u6570\u4e3a:ids:" + ids + ",entityTypeName:" + entityTypeName + ",operationKey:" + operationKey);
        try (TraceSpan span = Tracer.create((String)"WriteOffServiceImpl", (String)"startWriteOff");){
            WriteOffActionProcessor processor = WriteOffActionProcessor.build((List)WriteOffActionFactory.getFlowConfigLoadActions());
            processor.doProcess(WriteOffExecuteContext.createFlow((String)entityTypeName, ids, (String)operationKey));
        }
    }

    @Override
    @Deprecated
    public void startManualWriteOff(Long wfTypeId, Map<String, Object> schemaMap, Date wfDate, List<Map<Object, BigDecimal>> curMainFieldValueMaps, Map<String, Object> params) throws Exception {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                WriteOffActionProcessor processor = WriteOffActionProcessor.build((List)WriteOffActionFactory.getManualConfigLoadActions());
                processor.doProcess(WriteOffExecuteContext.createManual((Long)wfTypeId, schemaMap, (Date)wfDate, curMainFieldValueMaps, params));
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public void startAutoManualWriteOff(Long wfTypeId, Map<String, Object> schemaMap, Date wfDate, Map<String, Map<String, String>> conditionsMap, Map<String, Object> params) throws Exception {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                WriteOffActionProcessor processor = WriteOffActionProcessor.build((List)WriteOffActionFactory.getAutoConfigLoadActions());
                processor.doProcess(WriteOffExecuteContext.createAuto((Long)wfTypeId, schemaMap, (Date)wfDate, params, conditionsMap));
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    @Override
    public void backWriteOff(List<Object> pks, String billType, String operationKey) {
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)billType);
        DynamicObject[] load = null;
        if (null == operationKey || "chargeAgainstRecordKey".equals(operationKey) || "entryBackWf".equals(operationKey)) {
            load = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)billEntityType);
        } else {
            QFilter idFilter = new QFilter("id", "in", pks);
            String selectFields = StringUtils.join((Object[])new String[]{"org", billEntityType.getBillNo()}, (char)',');
            load = BusinessDataServiceHelper.load((String)billType, (String)selectFields, (QFilter[])idFilter.toArray());
        }
        if (load == null || load.length == 0) {
            logger.info("\u67e5\u8be2\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0cid\uff1a" + JSONObject.toJSONString(pks));
            return;
        }
        new ReverseWriteOffEngine();
        ReverseWriteOffEngine.execute((DynamicObject[])load, (String)operationKey, null);
    }

    @Override
    public Map<Long, Object> getPreMatchData(List<Object> ids, String entityTypeName, String operationKey) {
        logger.info("\u5f00\u59cb\u9884\u5339\u914d\u529f\u80fd");
        try (TraceSpan span = Tracer.create((String)"WriteOffServiceImpl", (String)"getPreMatchData");){
            WriteOffActionProcessor processor = WriteOffActionProcessor.build((List)WriteOffActionFactory.getPreMatchConfigLoadActions());
            WriteOffExecuteContext flowContext = WriteOffExecuteContext.createFlow((String)entityTypeName, ids, (String)operationKey);
            processor.doProcess(flowContext);
            List matchGroupMap = flowContext.getMatchGroupMap();
            HashMap<Long, Map> resultMap = new HashMap<Long, Map>(16);
            for (WriteOffMatchGroup group : matchGroupMap) {
                Map schemeData = flowContext.getTypeContext(group.getTypeConfig().getId().longValue()).getPreMatchMap();
                resultMap.put(group.getTypeConfig().getId(), schemeData);
            }
            HashMap<Long, Map> hashMap = resultMap;
            return hashMap;
        }
    }

    @Override
    public void entryBackWriteOff(Object pk, Object entryPk, String entityName, String operationKey) {
        DynamicObject wfRecord = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
        DynamicObjectCollection entryList = wfRecord.getDynamicObjectCollection("entry");
        DynamicObject entryDyna = entryList.stream().filter(n -> n.getPkValue().equals(entryPk)).findFirst().orElse(null);
        if (entryDyna == null) {
            return;
        }
        new ReverseWriteOffEngine();
        ReverseWriteOffEngine.execute((DynamicObject[])new DynamicObject[]{entryDyna}, (String)operationKey, null);
    }

    @Override
    public void chargeAgainstRecord(Map<String, Object> paramMap) {
        String billType = (String)paramMap.get("recordType");
        List pks = (List)paramMap.get("recordPk");
        logger.info("\u51b2\u9500\u6838\u9500\u8bb0\u5f55\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a\u5355\u636e\u7c7b\u578b:" + billType + ",\u5355\u636eid\uff1a" + JSONObject.toJSONString((Object)pks));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        QFilter qFilter = new QFilter("id", "in", (Object)pks);
        qFilter.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        qFilter.and("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)billType, (QFilter[])qFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType);
        new ReverseWriteOffEngine();
        ReverseWriteOffEngine.execute((DynamicObject[])load, (String)"chargeAgainstRecordKey", paramMap);
    }

    @Override
    public void chargeAgainstRecordByBillIds(Map<String, Object> paramMap) {
        String billType = (String)paramMap.get("billType");
        List pks = (List)paramMap.get("billId");
        QFilter qFilterBillType = new QFilter("writeoffbillentry.writeoffbilltype", "=", (Object)billType);
        DynamicObjectCollection writeoffRecordBills = QueryServiceHelper.query((String)"msmod_writeofftype", (String)"writeoffrecordbill", (QFilter[])qFilterBillType.toArray());
        Set recordBillSet = writeoffRecordBills.stream().map(n -> n.getString("writeoffrecordbill")).collect(Collectors.toSet());
        HashMap<DynamicObject[], DynamicObject[]> recordObject = new HashMap<DynamicObject[], DynamicObject[]>(8);
        for (DynamicObject[] record : recordBillSet) {
            DynamicObject[] load;
            List ids;
            QFilter qFilterTwo;
            QFilter qFilter;
            IDataEntityProperty iswrittenoff;
            WriteoffTemplateTypeEnum wfTemplateType = WriteOffRecordHelper.getWfTemplateTypeByChildEntity((String)record);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)record);
            if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == wfTemplateType) {
                iswrittenoff = dataEntityType.findProperty("e_iswrittenoff");
                if (null == iswrittenoff || StringUtils.isEmpty((CharSequence)iswrittenoff.getAlias())) continue;
                qFilter = new QFilter("billid", "in", (Object)pks);
                qFilter.and("billtype", "=", (Object)billType);
                qFilterTwo = new QFilter("entry.e_billid", "in", (Object)pks);
                qFilterTwo.and("entry.e_billtype", "=", (Object)billType);
                qFilter.or(qFilterTwo);
                qFilter.and("writeofftypeid", ">", (Object)BigDecimal.ZERO);
                qFilter.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
                qFilter.and("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE);
                ids = QueryServiceHelper.queryPrimaryKeys((String)record, (QFilter[])qFilter.toArray(), null, (int)-1);
                if (!CollectionUtils.isNotEmpty((Collection)ids)) continue;
                load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType);
                recordObject.put(record, load);
                continue;
            }
            if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfTemplateType) {
                iswrittenoff = dataEntityType.findProperty("iswrittenoff");
                if (null == iswrittenoff || StringUtils.isEmpty((CharSequence)iswrittenoff.getAlias())) continue;
                qFilter = new QFilter("entry.billid", "in", (Object)pks);
                qFilter.and("entry.billtype", "=", (Object)billType);
                qFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE);
                qFilter.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
                qFilter.and("writeofftypeid", ">", (Object)BigDecimal.ZERO);
                List ids2 = QueryServiceHelper.queryPrimaryKeys((String)record, (QFilter[])qFilter.toArray(), null, (int)-1);
                if (!CollectionUtils.isNotEmpty((Collection)ids2)) continue;
                DynamicObject[] load2 = BusinessDataServiceHelper.load((Object[])ids2.toArray(), (DynamicObjectType)dataEntityType);
                recordObject.put(record, load2);
                continue;
            }
            if (WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT != wfTemplateType || null == (iswrittenoff = dataEntityType.findProperty("iswrittenoff")) || StringUtils.isEmpty((CharSequence)iswrittenoff.getAlias())) continue;
            qFilter = new QFilter("entry.billid", "in", (Object)pks);
            qFilter.and("entry.billtype", "=", (Object)billType);
            qFilterTwo = new QFilter("entry.assbillid", "in", (Object)pks);
            qFilterTwo.and("entry.assbilltype", "=", (Object)billType);
            qFilter.or(qFilterTwo);
            qFilter.and("writeofftypeid", ">", (Object)BigDecimal.ZERO);
            qFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE);
            qFilter.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
            ids = QueryServiceHelper.queryPrimaryKeys((String)record, (QFilter[])qFilter.toArray(), null, (int)-1);
            if (!CollectionUtils.isNotEmpty((Collection)ids)) continue;
            load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType);
            recordObject.put(record, load);
        }
        for (DynamicObject[] record : recordObject.values()) {
            new ReverseWriteOffEngine();
            ReverseWriteOffEngine.execute((DynamicObject[])record, (String)"chargeAgainstRecordKey", paramMap);
        }
    }

    @Override
    public Map<Object, Set<Object>> getMatchedBillByScheme(List<Long> schemeIds, String entity, List<Object> billIds) {
        return WriteOffHelpr.getMatchedBillByScheme(schemeIds, (String)entity, billIds);
    }
}

