/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.backwfservice;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfParam;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.UnWfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.DynamicSerializeHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffTaskHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IKdtxUnWfPlugin;
import org.apache.commons.lang3.StringUtils;

public class BackWfPluginService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(BackWfPluginService.class);
    private static final String END_WRITE_BACK = "endWriteBack";
    private static final String CA_CAL_SERVICE = "caCalService";

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        BackWfParam backWfParam = (BackWfParam)param;
        Long taskId = backWfParam.getTaskId();
        try (TraceSpan span = Tracer.create((String)"BackWfPluginService", (String)"doExecute");){
            this.doBackWfPluginService((BackWfParam)param);
            UnWriteOffTaskHelper.updateSuccessTaskInfo((Long)taskId);
        }
        catch (Exception e) {
            UnWriteOffTaskHelper.updateFailTaskInfo((Long)taskId, (Exception)e);
            throw e;
        }
        return null;
    }

    private void doBackWfPluginService(BackWfParam param) {
        logger.info("\u8fdb\u5165\u65b9\u6cd5BackWfPluginService");
        BackWfParam ecParam = param;
        CommonHelper.setUserId();
        String methodName = ecParam.getPluginMethodName();
        logger.info("BackWfPluginService\u8c03\u7528\u65b9\u6cd5:{}", (Object)methodName);
        if (END_WRITE_BACK.equals(methodName)) {
            Map recordSerMap = ecParam.getRecordMap();
            String dbRout = ecParam.getDbRout();
            Map<Long, List<DynamicObject>> recordMap = this.resolveRcordMap(recordSerMap, ecParam.getSelectFields());
            UnWfPluginExtFactory proxyFactory = new UnWfPluginExtFactory();
            for (Map.Entry<Long, List<DynamicObject>> entry : recordMap.entrySet()) {
                proxyFactory.endWriteBack(dbRout, entry.getValue(), entry.getKey());
            }
        } else if (CA_CAL_SERVICE.equals(methodName)) {
            this.calDispatchService(ecParam);
        } else {
            List<DynamicObject> records = this.getWfRecord(ecParam);
            String pluginName = ecParam.getValue();
            List iKdtxUnWfPlugins = new UnWfPluginExtFactory().kdtxBackWfPlugin(ecParam.getTypeId());
            for (IKdtxUnWfPlugin plugin : iKdtxUnWfPlugins) {
                if (plugin == null || !plugin.getClass().getName().equals(pluginName)) continue;
                plugin.kdtxBackWfPlugin(records);
            }
        }
    }

    private Map<Long, List<DynamicObject>> resolveRcordMap(Map<String, String[]> recordSerMap, String selectFields) {
        HashMap<Long, List<DynamicObject>> resultMap = new HashMap<Long, List<DynamicObject>>(16);
        if (recordSerMap == null) {
            return resultMap;
        }
        for (Map.Entry<String, String[]> entry : recordSerMap.entrySet()) {
            String[] keys = entry.getKey().split("#");
            Long wfTypeId = Long.valueOf(keys[0]);
            String entity = keys[1];
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (StringUtils.isNotBlank((CharSequence)selectFields)) {
                String[] fields = StringUtils.split((String)selectFields, (char)',');
                entityType = entityType.getSubEntityType(new HashSet<String>(Arrays.asList(fields)));
            }
            String[] serializeBills = entry.getValue();
            DynamicObject[] records = DynamicSerializeHelper.deserializeTwo((EntityType)entityType, (String[])serializeBills);
            resultMap.put(wfTypeId, Arrays.asList(records));
        }
        return resultMap;
    }

    private List<DynamicObject> getWfRecord(BackWfParam ecParam) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)ecParam.getBillNumber());
        Object[] ids = ecParam.getRecordIds().toArray();
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dataEntityType);
        return Arrays.asList(load);
    }

    private Map<String, Long> calDispatchService(BackWfParam ecParam) {
        Set verifyRecordIds = ecParam.getVerifyRecordIds();
        List redVerifyRecordIds = ecParam.getRedVerifyRecordIds();
        HashMap<String, Long> calMap = new HashMap<String, Long>(16);
        DynamicObjectCollection redVerifyRecords = QueryServiceHelper.query((String)ecParam.getBillNumber(), (String)"verifydate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)redVerifyRecordIds)});
        Date maxVerifyDate = null;
        for (DynamicObject redVerifyRecord : redVerifyRecords) {
            Date verifydate = redVerifyRecord.getDate("verifydate");
            if (maxVerifyDate != null && (maxVerifyDate == null || verifydate == null || !maxVerifyDate.before(verifydate))) continue;
            maxVerifyDate = verifydate;
        }
        boolean systemCallParam = QueryServiceHelper.exists((String)"sbs_intersystemcallconf", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"KC0001"), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        logger.info("systemCallParam is " + systemCallParam);
        if (systemCallParam) {
            Map paramMap = ecParam.getParamMap();
            long end = System.currentTimeMillis();
            logger.info("verifyRecordIds is " + verifyRecordIds);
            Map calChargeOffMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalChargeOffService", (String)"chargeOffWriteRecord", (Object[])new Object[]{verifyRecordIds, paramMap.get("bizDate"), paramMap.get("bookDate"), maxVerifyDate, paramMap.get("remark")});
            logger.info("generateRedVerifyRecord calDispatchService consum time\uff1a" + (System.currentTimeMillis() - end) + "ms");
            for (Map.Entry map : calChargeOffMap.entrySet()) {
                calMap.put(String.valueOf(map.getKey()), (Long)map.getValue());
            }
        }
        return calMap;
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

