/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.refeeshareservice;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.feeshare.business.engine.plugin.UnFsPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfParam;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffTaskHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import org.apache.commons.collections.CollectionUtils;

public class ReFeeShareDelRecordService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(ReFeeShareDelRecordService.class);
    private static final String AP_FINAPBILL = "ap_finapbill";
    private static final String AR_REVCFMBILL = "ar_revcfmbill";
    private static final String CA_CAL_SERVICE = "caCalService";
    private static final String CA_SCM = "ca_scm";

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        BackWfParam backWfParam = (BackWfParam)param;
        Long taskId = backWfParam.getTaskId();
        try (TraceSpan span = Tracer.create((String)"WriteOffRecordDeleteService", (String)"doExecute");){
            this.doWfRecordDeleteService((BackWfParam)param);
            UnWriteOffTaskHelper.updateSuccessTaskInfo((Long)taskId);
        }
        catch (Exception e) {
            UnWriteOffTaskHelper.updateFailTaskInfo((Long)taskId, (Exception)e);
            throw e;
        }
        return null;
    }

    private void doWfRecordDeleteService(BackWfParam param) {
        logger.info("\u8fdb\u5165\u65b9\u6cd5WriteOffRecordDeleteService");
        BackWfParam ecParam = param;
        CommonHelper.setUserId();
        String billType = ecParam.getBillNumber();
        logger.info("WriteOffRecordDeleteService\u53cd\u6838\u9500\u5220\u9664\u6838\u9500\u8bb0\u5f55\u53c2\u6570:" + JSONObject.toJSONString((Object)ecParam));
        List<DynamicObject> recordList = this.getRecords(billType, ecParam.getRecordIds());
        if (CollectionUtils.isNotEmpty(recordList)) {
            Set ids = recordList.stream().map(n -> (Long)n.getPkValue()).collect(Collectors.toSet());
            logger.info("\u53cd\u6838\u9500\u5220\u9664\u6838\u9500\u8bb0\u5f55\u6210\u529f\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0c\u5355\u636eid\uff1a" + ids);
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
            this.doBackPlugin(ecParam.getTypeId(), recordList, Boolean.FALSE);
            try (TXHandle tx = TX.requiresNew();){
                DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])ids.toArray());
            }
            logger.info("\u53cd\u6838\u9500\u5220\u9664\u6838\u9500\u8bb0\u5f55\u6210\u529f");
        }
    }

    private void doBackPlugin(Long wfTypeId, List<DynamicObject> records, Boolean isCa) {
        new UnFsPluginExtFactory().beforeWfRecordDelete(records, wfTypeId, isCa);
    }

    private List<DynamicObject> getRecords(String billType, List<Object> ids) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType);
        if (load != null && load.length > 0) {
            return Arrays.asList(load);
        }
        return Collections.emptyList();
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        IdempotentProperties idempotentProperties = DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
        idempotentProperties.setAlivedTime(Long.valueOf(60000L));
        return idempotentProperties;
    }
}

