/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.wfservice;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.impl.AbstractWriteOffRecordStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.BillFieldParseHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.kdtxargs.WfParam;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WfEndWriteBackPluginProxy;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IKdtxWfPlugin;

public class WriteOffPluginService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(AbstractWriteOffRecordStrategy.class);
    private static final String END_WRITE_BACK = "endWriteBack";

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        WfParam ecParam = (WfParam)param;
        CommonHelper.setUserId();
        try (TraceSpan span = Tracer.create((String)"WriteOffPluginService", (String)"doExecute");){
            this.execute(ecParam);
            WriteOffLogHelper.updateTaskLogSuccess((long)ecParam.getLogId());
        }
        catch (Exception e) {
            logger.error("\u6838\u9500\u6267\u884c\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            WriteOffLogHelper.updateTaskLogFail((long)ecParam.getLogId(), (Exception)e);
            throw e;
        }
        return null;
    }

    private void execute(WfParam ecParam) {
        if (END_WRITE_BACK.equals(ecParam.getPluginMethodName())) {
            String dbRout = ecParam.getDbRout();
            logger.info("WriteOffPluginService END_WRITE_BACK\u8bf7\u6c42\u53c2\u6570\uff1a" + dbRout);
            String wfType = ecParam.getValue();
            Long wfTypeId = Long.valueOf(wfType);
            WfEndWriteBackPluginProxy endWriteBackProxy = WfPluginExtFactory.createEndWriteBackProxy((Long)wfTypeId, (Map)ecParam.getWfExtParams());
            DynamicObject[] records = this.getWfEndWriteBackRecords(ecParam, wfTypeId, endWriteBackProxy);
            List<DynamicObject> recordList = Arrays.asList(records);
            logger.info("WriteOffPluginService END_WRITE_BACK \u5f00\u59cb\u6267\u884c\uff1a" + dbRout);
            endWriteBackProxy.endWriteBack(dbRout, recordList);
            logger.info("WriteOffPluginService END_WRITE_BACK \u6267\u884c\u7ed3\u675f\uff1a" + dbRout);
        } else {
            String pluginName = ecParam.getValue();
            logger.info("WriteOffPluginService KDTX_PLUGIN\u8bf7\u6c42\u53c2\u6570\uff1a" + pluginName);
            IKdtxWfPlugin wfPlugin = this.getKDTXPlugin(ecParam);
            if (wfPlugin != null) {
                DynamicObject[] wfRecords = this.getWfRecords(ecParam);
                logger.info("WriteOffPluginService KDTX_PLUGIN \u5f00\u59cb\u6267\u884c\uff1a" + pluginName);
                wfPlugin.kdtxWfPlugin(Arrays.asList(wfRecords), ecParam.getKdtxWfPluginParam());
                logger.info("WriteOffPluginService KDTX_PLUGIN \u6267\u884c\u7ed3\u675f\uff1a" + pluginName);
            } else {
                logger.info("WriteOffPluginService KDTX_PLUGIN \u65e0\u63d2\u4ef6\u6267\u884c\uff1a" + pluginName);
            }
        }
    }

    private IKdtxWfPlugin getKDTXPlugin(WfParam ecParam) {
        String pluginName = ecParam.getValue();
        List iKdtxWfPlugins = WfPluginExtFactory.kdtxWfPlugin((Long)ecParam.getWfTypeId(), (Map)ecParam.getWfExtParams());
        for (IKdtxWfPlugin wfPlugin : iKdtxWfPlugins) {
            if (wfPlugin == null || !wfPlugin.getClass().getName().equals(pluginName)) continue;
            return wfPlugin;
        }
        return null;
    }

    private DynamicObject[] getWfEndWriteBackRecords(WfParam ecParam, Long wfTypeId, WfEndWriteBackPluginProxy endWriteBackProxy) {
        Set pluginField;
        String billNumber = ecParam.getBillNumber();
        List recordIds = ecParam.getIds();
        HashSet loadFields = new HashSet(16);
        WriteoffTemplateTypeEnum wfTemplateTypeByChildEntity = WriteOffRecordHelper.getWfTemplateTypeByChildEntity((String)billNumber);
        Set baseInfoFieldsByTpl = BillFieldParseHelper.getBaseInfoFieldsByTpl((WriteoffTemplateTypeEnum)wfTemplateTypeByChildEntity);
        if (baseInfoFieldsByTpl != null) {
            loadFields.addAll(baseInfoFieldsByTpl);
        }
        if ((pluginField = (Set)endWriteBackProxy.preparePropKey().get(billNumber)) != null) {
            loadFields.addAll(pluginField);
        }
        String join = String.join((CharSequence)",", loadFields);
        logger.info("\u52a0\u8f7dendWriteBack\u6240\u9700\u8981\u7684\u5b57\u6bb5\uff1a" + loadFields);
        return BusinessDataServiceHelper.load((String)billNumber, (String)join, (QFilter[])new QFilter("id", "in", (Object)recordIds).toArray());
    }

    private DynamicObject[] getWfRecords(WfParam ecParam) {
        String billNumber = ecParam.getBillNumber();
        List recordIds = ecParam.getIds();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billNumber);
        return BusinessDataServiceHelper.load((Object[])recordIds.toArray(), (DynamicObjectType)dataEntityType);
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

