/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ReWriteRuleSubentryUpgradeServiceImpl
implements IUpgradeService {
    private static final String INSERT_REWT_BILL_SQL = "insert into t_msmod_rewtbillentry (FID,FENTRYID,FSEQ,FREWTBILL,FALIAS)values(?,?,?,?,?)";
    private static final String INSERT_REWT_FORMUL_SQL = "insert into T_MSMOD_REWTFORMULSUB (FENTRYID,FDETAILID,FSEQ,FSUBREWTBILL,FREWTFIELD,FREWTFIELDNUM,FSELECTVAL,FWFFIELD,FWFFIELDNUM,FCALFORMULA,FREWTMETHOD,FCALFORMUDESC,FCALFORMUDESC_TAG)values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private Set<Long> ids = new HashSet<Long>(1024);
    private Set<Long> subIds = new HashSet<Long>(1024);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        if (this.subEntryIsEmpty(scmRoute)) {
            DataSet relDs = this.getRelationDs(scmRoute);
            this.buildAndInsertParams(relDs, scmRoute);
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private boolean subEntryIsEmpty(DBRoute scmRoute) {
        String sql = "select FDetailID from T_MSMOD_REWTFORMULSUB";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet.isEmpty();
    }

    private void buildAndInsertParams(DataSet relDs, DBRoute scmRoute) {
        ArrayList<Object[]> reFormualParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> reBillParams = new ArrayList<Object[]>(16);
        Map<Long, String> relationWfBill = this.getRelationWfBill();
        HashMap<String, Long> wfBills = new HashMap<String, Long>(16);
        HashMap<Long, Long> entrySeq = new HashMap<Long, Long>(16);
        HashMap<Long, Long> entrySubSeq = new HashMap<Long, Long>(16);
        for (Row row : relDs) {
            this.buildReBillParam(reBillParams, relationWfBill, wfBills, entrySeq, row);
            this.buildReFormualParam(reFormualParams, wfBills, entrySubSeq, relationWfBill, row);
        }
        try (TXHandle tx = TX.requiresNew();){
            if (!reBillParams.isEmpty()) {
                DB.executeBatch((DBRoute)scmRoute, (String)INSERT_REWT_BILL_SQL, reBillParams);
            }
            if (!reFormualParams.isEmpty()) {
                DB.executeBatch((DBRoute)scmRoute, (String)INSERT_REWT_FORMUL_SQL, reFormualParams);
            }
        }
    }

    private void buildReFormualParam(List<Object[]> reFormualParams, Map<String, Long> wfBills, Map<Long, Long> entrySubSeq, Map<Long, String> relationWfBill, Row row) {
        Long fid = row.getLong("fid");
        Long frewritebilllid = row.getLong("frewritebilllid");
        String key = fid + "-" + frewritebilllid;
        Long entryIdNew = wfBills.get(key);
        Long seq = entrySubSeq.get(entryIdNew);
        if (seq == null) {
            seq = 1L;
        }
        entrySubSeq.put(fid, seq + 1L);
        Long fsubdetailid = this.getReFormluDetailId();
        String billType = relationWfBill.get(frewritebilllid);
        String frewritebilllfield = row.getString("frewritebilllfield");
        String fbillfieldnumber = row.getString("fbillfieldnumber");
        String selectvalue = row.getString("fselectvalue");
        String writeofffield = row.getString("fwriteofffield");
        String writeofffieldnumber = row.getString("fwriteofffieldnumber");
        String fcalculateformula = row.getString("fcalculateformula");
        String rewritemethod = row.getString("frewritemethod");
        String fcalformuladesc = row.getString("fcalformuladesc");
        String fcalformuladescTag = row.getString("fcalformuladesc_tag");
        Object[] param = new Object[]{entryIdNew, fsubdetailid, seq, billType, frewritebilllfield, fbillfieldnumber, selectvalue, writeofffield, writeofffieldnumber, fcalculateformula, rewritemethod, fcalformuladesc, fcalformuladescTag};
        reFormualParams.add(param);
    }

    private void buildReBillParam(List<Object[]> reBillParams, Map<Long, String> relationWfBill, Map<String, Long> wfBills, Map<Long, Long> entrySeq, Row row) {
        Long fid = row.getLong("fid");
        Long frewritebilllid = row.getLong("frewritebilllid");
        String key = fid + "-" + frewritebilllid;
        Long entryId = wfBills.get(key);
        if (entryId == null) {
            Long fdetailid = this.getReBillDetailId();
            String billType = relationWfBill.get(frewritebilllid);
            Long seq = entrySeq.get(fid);
            if (seq == null) {
                seq = 1L;
            }
            Object[] param = new Object[]{fid, fdetailid, seq, billType, frewritebilllid};
            reBillParams.add(param);
            wfBills.put(key, fdetailid);
            entrySeq.put(fid, seq + 1L);
        }
    }

    private Long getReBillDetailId() {
        if (this.ids.isEmpty()) {
            long[] idArr;
            for (long id : idArr = DB.genLongIds((String)"t_msmod_rewtbillentry", (int)1000)) {
                this.ids.add(id);
            }
        }
        Iterator<Long> iterator = this.ids.iterator();
        Long id = iterator.next();
        iterator.remove();
        return id;
    }

    private Long getReFormluDetailId() {
        if (this.subIds.isEmpty()) {
            long[] idArr;
            for (long id : idArr = DB.genLongIds((String)"t_msmod_rewtformulsub", (int)1000)) {
                this.subIds.add(id);
            }
        }
        Iterator<Long> iterator = this.subIds.iterator();
        Long id = iterator.next();
        iterator.remove();
        return id;
    }

    private DataSet getRelationDs(DBRoute scmRoute) {
        String sql = "select fid,fentryid,fseq,frewritebilllid,frewritebilllfield,fselectvalue,fwriteofffield,fcalculateformula,foperationcolumnap,frewritemethod,fbillfieldnumber,fwriteofffieldnumber,fcalformuladesc,fcalformuladesc_tag from t_msmod_rewriteruleentry";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }

    private Map<Long, String> getRelationWfBill() {
        DBRoute scmRoute = new DBRoute("scm");
        String sql = "select fentryid,fwriteoffbillnumber from t_msmod_wfbillsetentry";
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        try (DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);){
            while (tableSet.hasNext()) {
                Row next = tableSet.next();
                Long fid = next.getLong("fentryid");
                String fwfbillnumber = next.getString("fwriteoffbillnumber");
                map.put(fid, fwfbillnumber);
            }
        }
        return map;
    }
}

