/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.collections.CollectionUtils;

public class WriteOffBillUpgradeServiceImpl
implements IUpgradeService {
    private static final String INSERT_WF_BILL_SQL = "insert into t_msmod_wfbill (FID,fnumber,fwfbill,falias,fwfbillnumber,fwftypenumber,fenable,fmasterid,fcreatetime,fmodifytime,fstatus,fcreatorid,fmodifierid)values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_WF_BILL_SQL = "UPDATE t_msmod_wfbillsetentry SET fwfbillalias = fentryid WHERE fwfbillalias = 0";
    private static final String UPDATE_AUTO_BILL_SQL = "UPDATE t_msmod_autogenebill_e SET fsrcbilltype = ?,ftargetbilltype = ? where fentryid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        HashMap<String, Long> wfBillMap = new HashMap<String, Long>(16);
        HashSet<Long> fids = new HashSet<Long>(16);
        DataSet relDS = this.getRelationDS(scmRoute);
        List<Object[]> params = this.buildInsertParams(relDS, wfBillMap, fids, scmRoute);
        List<Object[]> autoBillParams = this.buildWfBillUpdateParam(wfBillMap, fids, scmRoute);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (CollectionUtils.isNotEmpty(params)) {
                    DB.executeBatch((DBRoute)scmRoute, (String)INSERT_WF_BILL_SQL, params);
                }
                if (CollectionUtils.isNotEmpty(autoBillParams)) {
                    DB.executeBatch((DBRoute)scmRoute, (String)UPDATE_AUTO_BILL_SQL, autoBillParams);
                }
                DB.execute((DBRoute)scmRoute, (String)UPDATE_WF_BILL_SQL);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private List<Object[]> buildWfBillUpdateParam(Map<String, Long> wfBillMap, Set<Long> fids, DBRoute route) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        if (CollectionUtils.isEmpty(fids)) {
            return params;
        }
        String sql = "select fid,fentryid,fsrcbilltypeid,ftargetbilltypeid from t_msmod_autogenebill_e where fsrcbilltype = 0 and ftargetbilltype = 0 and ";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(sql, new Object[0]).appendIn("fid", fids.toArray());
        try (DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)route, (SqlBuilder)sqlBuilder);){
            for (Row row : tableSet) {
                Long fentryid = row.getLong("fentryid");
                String srcBillTypeId = row.getString("fsrcbilltypeid");
                String targetBillTypeId = row.getString("ftargetbilltypeid");
                Long fid = row.getLong("fid");
                Long srcAliasId = wfBillMap.get(srcBillTypeId + fid);
                Long tagAliasId = wfBillMap.get(targetBillTypeId + fid);
                params.add(new Object[]{srcAliasId, tagAliasId, fentryid});
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object[]> buildInsertParams(DataSet relDS, Map<String, Long> wfBillMap, Set<Long> fidList, DBRoute scmRoute) {
        Set<Long> wfBillIds = this.getWfBillIds(scmRoute);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        try {
            for (Row row : relDS) {
                Long fentryid = row.getLong("fentryid");
                String wfBillNumber = row.getString("fwriteoffbillnumber");
                String falias = row.getString("falias");
                String fwriteofftypenumber = row.getString("fwriteofftypenumber");
                String fbillstatus = row.getString("fbillstatus");
                String fwriteoffbilltenable = row.getString("fwriteoffbilltenable");
                Long fmasterid = row.getLong("fmasterid");
                Date fcreatetime = row.getDate("fcreatetime");
                Date fmodifytime = row.getDate("fmodifytime");
                Long fcreatorid = row.getLong("fcreatorid");
                Long fmodifierid = row.getLong("fmodifierid");
                Long fid = row.getLong("fid");
                String number = String.valueOf(fentryid);
                wfBillMap.put(falias + fid, fentryid);
                fidList.add(fid);
                if (wfBillIds.contains(fentryid)) continue;
                params.add(new Object[]{fentryid, number, wfBillNumber, falias, wfBillNumber, fwriteofftypenumber, fwriteoffbilltenable, fmasterid, fcreatetime, fmodifytime, fbillstatus, fcreatorid, fmodifierid});
            }
        }
        finally {
            relDS.close();
        }
        return params;
    }

    private Set<Long> getWfBillIds(DBRoute scmRoute) {
        String sql = "select fid from t_msmod_wfbill";
        HashSet<Long> wfBillIds = null;
        try (DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);){
            wfBillIds = new HashSet<Long>(16);
            for (Row row : tableSet) {
                Long fid = row.getLong("fid");
                wfBillIds.add(fid);
            }
        }
        return wfBillIds;
    }

    private DataSet getRelationDS(DBRoute scmRoute) {
        String sql = "select fid,fentryid,falias,fwriteoffbillnumber,fwriteofftypenumber,fbillstatus,fwriteoffbilltenable,fmasterid,fcreatetime,fmodifytime,fstatus,fcreatorid,fmodifierid  from t_msmod_wfbillsetentry where fwfbillalias = 0";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }
}

