/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.JoinBlockConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import org.apache.commons.lang3.StringUtils;

public class ReportConf {
    private Object id;
    private String reportEntity;
    private String repoEntity;
    private Map<String, DataType> dataTypeMap;
    private List<IReportDataHandle> plugins;
    private Map<String, String> controlPropMap;
    private int timeOut = 30;
    private int reqLimit = -1;
    private List<BigTableColConf> bigTableColConf;
    private List<SrcBlockConf> srcBlockConf;
    private List<JoinBlockConf> joinBlockConf;

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        if (timeOut >= 5 && timeOut <= 120) {
            this.timeOut = timeOut;
        }
    }

    public Map<String, DataType> getDataTypeMap() {
        return this.dataTypeMap;
    }

    public void setDataTypeMap(Map<String, DataType> dataTypeMap) {
        this.dataTypeMap = dataTypeMap;
    }

    public List<JoinBlockConf> getJoinBlockConf() {
        return this.joinBlockConf;
    }

    public void setJoinBlockConf(List<JoinBlockConf> JoinBlockConf2) {
        this.joinBlockConf = JoinBlockConf2;
    }

    public String getReportEntity() {
        return this.reportEntity;
    }

    public void setReportEntity(String reportEntity) {
        this.reportEntity = reportEntity;
    }

    public String getRepoEntity() {
        return this.repoEntity;
    }

    public void setRepoEntity(String repoEntity) {
        this.repoEntity = repoEntity;
    }

    public List<BigTableColConf> getBigTableColConf() {
        return this.bigTableColConf;
    }

    public void setBigTableColConf(List<BigTableColConf> colConf) {
        this.bigTableColConf = colConf;
    }

    public List<SrcBlockConf> getSrcBlockConf() {
        return this.srcBlockConf;
    }

    public void setSrcBlockConf(List<SrcBlockConf> blockConf) {
        this.srcBlockConf = blockConf;
    }

    public List<IReportDataHandle> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<IReportDataHandle> plugins) {
        this.plugins = plugins == null ? new ArrayList() : plugins;
    }

    public String toString() {
        return "ReportConf [reportEntity=" + this.reportEntity + ", repoEntity=" + this.repoEntity + "]";
    }

    public Map<String, String> getControlPropMap() {
        if (this.controlPropMap == null) {
            this.controlPropMap = this.buildQtyUnit();
        }
        return this.controlPropMap;
    }

    private Map<String, String> buildQtyUnit() {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)this.repoEntity);
        Collection cols = type.getAllFields().values();
        String controlProp = null;
        HashMap<String, String> controlPropMap = new HashMap<String, String>(8);
        for (IDataEntityProperty pro : cols) {
            if (pro instanceof QtyProp) {
                controlProp = ((QtyProp)pro).getControlPropName();
            } else if (pro instanceof AmountProp) {
                controlProp = ((AmountProp)pro).getControlPropName();
            }
            if (!StringUtils.isNotBlank((CharSequence)controlProp)) continue;
            controlPropMap.put(pro.getName(), controlProp);
        }
        this.controlPropMap = controlPropMap;
        return this.controlPropMap;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public int getReqLimit() {
        return this.reqLimit;
    }

    public void setReqLimit(int reqLimit) {
        if (reqLimit > 0) {
            this.reqLimit = reqLimit;
        }
    }
}

