/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.conf.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.form.ColMapUtil;
import kd.bplat.scmc.report.util.FormUtil;
import org.apache.commons.lang3.StringUtils;

public class ReportColMapEdit
extends AbstractBasePlugIn {
    private static final String[] PAESE_COLS = new String[]{"repocol", "srccol", "fullsrccol", "defval", "remark"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srccol"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control button = (Control)evt.getSource();
        switch (button.getKey()) {
            case "srccol": {
                this.clickSrcCol();
                break;
            }
        }
    }

    private void clickSrcCol() {
        IDataModel model = this.getModel();
        MainEntityType srcEntityType = ColMapUtil.getMainEntityType(model, "srcentity");
        MainEntityType repoEntityType = ColMapUtil.getMainEntityType(model, "repoentity");
        int rowIndex = model.getEntryCurrentRowIndex("mapentry");
        String repoCol = (String)this.getModel().getValue("repocol", rowIndex);
        PropTreeBuildOption ops = this.getColMatchTreeOp(repoEntityType, repoCol);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcEntityType, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "srccol");
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "srccol": {
                this.callBack4SrcCol(actionId, (String)returnData);
            }
        }
    }

    private void callBack4SrcCol(String colFlag, String returnCol) {
        if (StringUtils.isBlank((CharSequence)returnCol)) {
            return;
        }
        IDataModel model = this.getModel();
        MainEntityType srcEntity = ColMapUtil.getMainEntityType(model, "srcentity");
        int row = model.getEntryCurrentRowIndex("mapentry");
        model.setValue("srccol", (Object)returnCol, row);
        model.setValue("fullsrccol", (Object)ColMapUtil.getFullCol(srcEntity, returnCol), row);
        model.setValue("srccol_name", (Object)ColMapUtil.getColFullName(srcEntity, returnCol), row);
    }

    private PropTreeBuildOption getColMatchTreeOp(MainEntityType entity, String targetCol) {
        IDataEntityProperty pro = entity.findProperty(targetCol);
        if (pro == null) {
            String entityName = entity.getAlias();
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u201c{0}\u201d\u4e2d\u4e0d\u5b58\u5728\u5c5e\u6027\u201c{1}\u201d,\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u662f\u5426\u8bbe\u8ba1\u6b63\u786e\u3002", (String)"ReportColMapEdit_0", (String)"mpscmm-mscommon-report", (Object[])new Object[]{entityName, targetCol}));
        }
        PropTreeBuildOption ops = new PropTreeBuildOption();
        if (!(pro instanceof ComboProp)) {
            ops.setMatchedProperty(pro);
        }
        ops.setIncludePKField(true);
        return ops;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindMapInfo();
        this.getModel().setDataChanged(false);
    }

    private void bindMapInfo() {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        String info = data.getString("mapinfo_tag");
        DynamicObject repoEntity = data.getDynamicObject("repoentity");
        DynamicObject srcEntity = data.getDynamicObject("srcentity");
        if (repoEntity == null || srcEntity == null || StringUtils.isBlank((CharSequence)info)) {
            return;
        }
        JSONObject mapInfo = JSONObject.parseObject((String)info);
        MainEntityType repoEntitytype = MetadataServiceHelper.getDataEntityType((String)repoEntity.getString("id"));
        MainEntityType srcEntityType = MetadataServiceHelper.getDataEntityType((String)srcEntity.getString("id"));
        HashMap cols = new HashMap(repoEntitytype.getAllFields());
        DynamicObjectCollection rows = data.getDynamicObjectCollection("mapentry");
        rows.clear();
        String repoCol = null;
        String repoColName = null;
        IDataEntityProperty pro = null;
        String srcCol = null;
        DynamicObject row = null;
        JSONArray vals = null;
        JSONArray colInfos = mapInfo.getJSONArray("repocol");
        ArrayList<DynamicObject> createRows = new ArrayList<DynamicObject>(colInfos.size());
        int len = colInfos.size();
        for (int i = 0; i < len; ++i) {
            row = rows.addNew();
            for (String colName : PAESE_COLS) {
                vals = mapInfo.getJSONArray(colName);
                if (vals == null) continue;
                row.set(colName, (Object)vals.getString(i));
            }
            repoCol = row.getString("repocol");
            pro = (IDataEntityProperty)cols.remove(repoCol);
            if (pro == null) continue;
            repoColName = pro.getDisplayName().getLocaleValue();
            row.set("repocol_name", (Object)repoColName);
            srcCol = row.getString("srccol");
            if (StringUtils.isNotBlank((CharSequence)srcCol)) {
                row.set("srccol_name", (Object)ColMapUtil.getColFullName(srcEntityType, srcCol));
            }
            createRows.add(row);
        }
        rows.clear();
        rows.addAll(createRows);
        for (Map.Entry col : cols.entrySet()) {
            row = rows.addNew();
            row.set("repocol", col.getKey());
            row.set("repocol_name", (Object)((IDataEntityProperty)col.getValue()).getDisplayName().getLocaleValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "repoentity": {
                this.changedRepoEntity(e);
                break;
            }
            case "srcentity": {
                this.changedSrcEntity(e);
                break;
            }
            case "srccol": {
                this.changedSrcCol(e);
                break;
            }
        }
    }

    private void changedSrcCol(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        String val = (String)model.getValue("srccol", rowIndex);
        if (StringUtils.isBlank((CharSequence)val)) {
            model.setValue("srccol_name", null, rowIndex);
            model.setValue("fullsrccol", null, rowIndex);
        }
    }

    private void changedSrcEntity(PropertyChangedArgs e) {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection mapRows = data.getDynamicObjectCollection("mapentry");
        for (DynamicObject row : mapRows) {
            row.set("srccol", null);
            row.set("fullsrccol", null);
            row.set("srccol_name", null);
        }
        this.getView().updateView("mapentry");
    }

    private void initColsEntry(String repoEntity) {
        IDataModel model = this.getModel();
        MainEntityType type = null;
        try {
            type = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        }
        catch (KDException e) {
            throw new KDBizException(e.getMessage());
        }
        if (type == null) {
            return;
        }
        Map cols = type.getAllFields();
        if (cols.isEmpty()) {
            return;
        }
        int[] indexs = model.batchCreateNewEntryRow("mapentry", cols.size());
        int i = 0;
        for (Map.Entry col : cols.entrySet()) {
            model.setValue("repocol", col.getKey(), indexs[i]);
            model.setValue("repocol_name", (Object)((IDataEntityProperty)col.getValue()).getDisplayName().getLocaleValue(), indexs[i]);
            ++i;
        }
    }

    private void changedRepoEntity(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObject repoEntity = data.getDynamicObject("repoentity");
        model.deleteEntryData("mapentry");
        if (repoEntity != null) {
            this.initColsEntry(repoEntity.getString("id"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        switch (opKey = FormUtil.getOpKey(e)) {
            case "save": {
                this.parseMapInfo();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        switch (opKey = e.getOperateKey()) {
            case "save": {
                this.afterSave();
                break;
            }
        }
    }

    private void afterSave() {
        this.bindMapInfo();
        this.getView().updateView("mapentry");
        this.getModel().setDataChanged(false);
    }

    private void parseMapInfo() {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection colSettings = data.getDynamicObjectCollection("mapentry");
        JSONObject colInfo = new JSONObject();
        JSONArray vals = null;
        for (String col : PAESE_COLS) {
            vals = new JSONArray(colSettings.size());
            colInfo.put(col, (Object)vals);
            for (DynamicObject row : colSettings) {
                vals.add((Object)row.getString(col));
            }
        }
        this.getModel().setValue("mapinfo_tag", (Object)colInfo.toJSONString());
    }
}

