/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.conf.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.form.ColMapUtil;
import kd.bplat.scmc.report.util.FormUtil;
import kd.bplat.scmc.report.util.ReportUtil;
import org.apache.commons.lang3.StringUtils;

public class ReportConfEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fsset", "joinfsset", "showrefprops_name", "datasegorgname"});
        FormUtil.addF7Listener(this, "colmap", "joinentity", "datactrlstrategy");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control contrl = (Control)evt.getSource();
        switch (key = contrl.getKey()) {
            case "fsset": {
                this.clickFsSet(evt);
                break;
            }
            case "joinfsset": {
                this.clickQueryFsSet(evt);
                break;
            }
            case "showrefprops_name": {
                this.clickRefProps(evt);
                break;
            }
            case "datasegorgname": {
                this.clickDataSegOrg();
                break;
            }
        }
    }

    private void clickRefProps(EventObject evt) {
        int index = this.getModel().getEntryCurrentRowIndex("colsentry");
        TreeNode treeNode = this.getTreeNode(index);
        if (treeNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f15\u7528\u5c5e\u6027\u53ef\u914d\u7f6e\u3002", (String)"ReportConfEdit_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            return;
        }
        String refProps = (String)this.getModel().getValue("showrefprops", index);
        List<String> selectedProps = ReportUtil.splitCombColToList(refProps);
        FormShowParameter show = new FormShowParameter();
        show.setFormId("scmc_ref_col");
        show.getCustomParams().put("treeData", SerializationUtils.toJsonString((Object)treeNode));
        show.getCustomParams().put("refProps", SerializationUtils.toJsonString(selectedProps));
        show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showrefprops_name"));
        show.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(show);
    }

    private TreeNode getTreeNode(int index) {
        String repoCol = (String)this.getModel().getValue("repo_col", index);
        DynamicObject repo = this.getModel().getDataEntity().getDynamicObject("repo");
        if (repo != null) {
            MainEntityType repoType = MetadataServiceHelper.getDataEntityType((String)repo.getString("id"));
            return ReportUtil.buildRefColTree(repoType, repoCol);
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "fsset": {
                this.closedFsSet((String)returnData);
                break;
            }
            case "joinfsset": {
                this.closedQueryFsSet((String)returnData);
                break;
            }
            case "showrefprops_name": {
                this.closedRefProps((String)returnData);
                break;
            }
            case "datasegorgname": {
                this.handleDataSegOrg((String)returnData);
                break;
            }
        }
    }

    private void closedRefProps(String returnData) {
        Map params = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
        String colStr = (String)params.get("refProps");
        List refProps = (List)SerializationUtils.fromJsonString((String)colStr, List.class);
        int index = this.getModel().getEntryCurrentRowIndex("colsentry");
        this.getModel().setValue("showrefprops", (Object)String.join((CharSequence)",", refProps), index);
        this.showRefPropName(index, refProps);
    }

    private void showRefPropName(int index, List<String> refProps) {
        String name = "";
        if (!refProps.isEmpty()) {
            TreeNode treeNode = this.getTreeNode(index);
            name = this.buildRefPropName(treeNode, refProps);
        }
        this.getModel().setValue("showrefprops_name", (Object)name, index);
    }

    private String buildRefPropName(TreeNode treeNode, List<String> refProps) {
        StringBuilder showInfo = new StringBuilder();
        if (!refProps.isEmpty() && treeNode != null) {
            TreeNode node = null;
            for (String prop : refProps) {
                node = treeNode.getTreeNode(prop, 100);
                if (node == null) {
                    showInfo.append(ResManager.loadKDString((String)"\u5c5e\u6027\u4e0d\u5b58\u5728", (String)"ReportConfEdit_1", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
                } else {
                    showInfo.append(node.getText());
                }
                showInfo.append("(").append(prop).append(");");
            }
        }
        return showInfo.toString();
    }

    private void closedFsSet(String conditionJson) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String expression = condition.getExpression();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{expression})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9ad8\u7ea7\u201d\u8fc7\u6ee4\u6761\u4ef6\u6682\u4e0d\u652f\u6301\uff0c\u8bf7\u5173\u6ce8\u540e\u7eed\u7248\u672c\u3002", (String)"ReportConfEdit_2", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
                return;
            }
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex("srcentry");
            model.setValue("fsset", (Object)condition.getExprDesc(), row);
            model.setValue("datafs_tag", (Object)conditionJson, row);
        }
    }

    private void closedQueryFsSet(String conditionJson) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String expression = condition.getExpression();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{expression})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9ad8\u7ea7\u201d\u8fc7\u6ee4\u6761\u4ef6\u6682\u4e0d\u652f\u6301\uff0c\u8bf7\u5173\u6ce8\u540e\u7eed\u7248\u672c\u3002", (String)"ReportConfEdit_2", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
                return;
            }
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex("joinentry");
            model.setValue("joinfsset", (Object)condition.getExprDesc(), row);
            model.setValue("joindatafs_tag", (Object)conditionJson, row);
        }
    }

    private String buildDesc(CRCondition condition, String entityName) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)entityName);
        FilterBuilder filterBuilder = new FilterBuilder(mainType, condition.getFilterCondition());
        String[] scripts = filterBuilder.buildFilterScript();
        if (scripts != null && scripts.length >= 2) {
            return scripts[1];
        }
        return condition.getExprDesc();
    }

    private void clickFsSet(EventObject evt) {
        int row;
        IDataModel model = this.getModel();
        DynamicObject srcEntity = (DynamicObject)model.getValue("srcentity", row = model.getEntryCurrentRowIndex("srcentry"));
        if (srcEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b9e\u4f53\u5bf9\u8c61\u201d\u3002", (String)"ReportConfEdit_3", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            return;
        }
        String conditionJson = (String)model.getValue("datafs_tag", row);
        this.showConditionForm(srcEntity.getString("id"), conditionJson, "fsset");
    }

    private void clickQueryFsSet(EventObject evt) {
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex("joinentry");
        DynamicObject repoEntity = (DynamicObject)model.getValue("repo");
        if (repoEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b57\u6bb5\u5e93\u201d\u3002", (String)"ReportConfEdit_4", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            return;
        }
        String conditionJson = (String)model.getValue("joindatafs_tag", row);
        this.showConditionForm(repoEntity.getString("id"), conditionJson, "joinfsset");
    }

    private void showConditionForm(String entity, String conditionJson, String fieldKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("scmc_rpt_colfs");
        showParameter.setCustomParam("entity", (Object)entity);
        showParameter.setCustomParam("condition", (Object)conditionJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "repo": {
                this.changedRepo(e);
                break;
            }
            case "report": {
                this.changedReport(e);
                break;
            }
            case "caltype": {
                this.changedCalType(e);
                break;
            }
            case "srcentity": {
                this.changedSrcEntity(e);
                break;
            }
            case "datasegtype": {
                this.changedDataSegType(e);
                break;
            }
            case "datasegorgname": {
                this.changedDataSegOrg(e);
                break;
            }
        }
    }

    private void changedSrcEntity(PropertyChangedArgs e) {
        int idx = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        model.setValue("fsset", null, idx);
        model.setValue("datafs_tag", null, idx);
    }

    private void changedCalType(PropertyChangedArgs e) {
        int idx = e.getChangeSet()[0].getRowIndex();
        String type = (String)this.getModel().getValue("caltype", idx);
        if (!"B".equals(type)) {
            this.getModel().setValue("issummary", (Object)false, idx);
            if (!"A".equals(type)) {
                this.getModel().setValue("defshow", (Object)false, idx);
            }
        }
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject repo = data.getDynamicObject("repo");
        String col = (String)this.getModel().getValue("repo_col", idx);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)repo.getString("id"));
        IDataEntityProperty property = dataEntityType.findProperty(col);
        if (property instanceof BasedataProp && "A".equals(type) && !(property instanceof FlexProp)) {
            this.getView().setEnable(Boolean.TRUE, idx, new String[]{"datasegtype", "datactrlstrategy"});
        } else {
            this.getModel().setValue("datasegtype", null, idx);
            this.getModel().setValue("datactrlstrategy", null, idx);
            this.getView().setEnable(Boolean.FALSE, idx, new String[]{"datasegtype", "datactrlstrategy"});
        }
        this.getView().updateView("datasegtype", idx);
        this.getView().updateView("datactrlstrategy", idx);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        this.initDataSegTypeEnable();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObject repo = data.getDynamicObject("repo");
        if (repo == null) {
            return;
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)repo.getString("id"));
        HashMap cols = new HashMap(type.getAllFields());
        DynamicObjectCollection colEntryRows = data.getDynamicObjectCollection("colsentry");
        String repoCol = null;
        String repoColName = null;
        IDataEntityProperty pro = null;
        ArrayList<Object> showRows = new ArrayList<Object>(colEntryRows.size());
        for (Object row : colEntryRows) {
            repoCol = row.getString("repo_col");
            pro = (IDataEntityProperty)cols.remove(repoCol);
            if (pro == null) continue;
            repoColName = pro.getDisplayName().getLocaleValue();
            row.set("repo_col_name", (Object)repoColName);
            this.setRefPropsName((DynamicObject)row, type);
            showRows.add(row);
        }
        DynamicObjectCollection entryDatas = data.getDynamicObjectCollection("srcentry");
        for (DynamicObject srcDataRow : entryDatas) {
            this.showRowFs(srcDataRow);
        }
        entryDatas = data.getDynamicObjectCollection("joinentry");
        for (Object queryDataRow : entryDatas) {
            this.showQueryRowFs((DynamicObject)queryDataRow, type.getName());
        }
        colEntryRows.clear();
        colEntryRows.addAll(showRows);
        DynamicObject newColRow = null;
        for (Map.Entry entry : cols.entrySet()) {
            newColRow = colEntryRows.addNew();
            newColRow.set("repo_col", entry.getKey());
            newColRow.set("repo_col_name", (Object)((IDataEntityProperty)entry.getValue()).getDisplayName().getLocaleValue());
            newColRow.set("colname", (Object)((IDataEntityProperty)entry.getValue()).getDisplayName());
            newColRow.set("caltype", (Object)"D");
            newColRow.set("defshow", (Object)"0");
            newColRow.set("showprop", (Object)"0");
        }
        if (StringUtils.isNotBlank((CharSequence)data.getString("datasegorg"))) {
            MainEntityType entityType = ColMapUtil.getMainEntityType(this.getModel(), "report");
            IDataEntityProperty iDataEntityProperty = entityType.findProperty(data.getString("datasegorg"));
            data.set("datasegorgname", (Object)iDataEntityProperty.getDisplayName().getLocaleValue());
        }
    }

    private void setRefPropsName(DynamicObject row, MainEntityType repoType) {
        String refProps = row.getString("showrefprops");
        if (StringUtils.isBlank((CharSequence)refProps)) {
            return;
        }
        String repoCol = row.getString("repo_col");
        String propsName = this.buildRefPropName(ReportUtil.buildRefColTree(repoType, repoCol), ReportUtil.splitCombColToList(refProps));
        row.set("showrefprops_name", (Object)propsName);
    }

    private void showRowFs(DynamicObject srcDataRow) {
        String dataFs = srcDataRow.getString("datafs_tag");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dataFs})) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)dataFs, CRCondition.class);
            srcDataRow.set("fsset", (Object)this.buildDesc(condition, srcDataRow.getString("srcentity.id")));
        }
    }

    private void showQueryRowFs(DynamicObject queryDataRow, String entityName) {
        String dataFs = queryDataRow.getString("joindatafs_tag");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dataFs})) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)dataFs, CRCondition.class);
            queryDataRow.set("joinfsset", (Object)this.buildDesc(condition, entityName));
        }
    }

    private void changedReport(PropertyChangedArgs e) {
    }

    private void changedRepo(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObject repo = data.getDynamicObject("repo");
        model.deleteEntryData("colsentry");
        if (repo != null) {
            this.initColsEntry(repo.getString("id"));
        }
        this.reSetSrcEntry();
        this.reSetQueryEntry();
    }

    private void reSetQueryEntry() {
        int count = this.getModel().getEntryRowCount("joinentry");
        IDataModel model = this.getModel();
        for (int i = 0; i < count; ++i) {
            model.setValue("joinentity", null, i);
            model.setValue("joindatafs_tag", null, i);
            model.setValue("joinfsset", null, i);
        }
    }

    private void reSetSrcEntry() {
        int count = this.getModel().getEntryRowCount("srcentry");
        IDataModel model = this.getModel();
        for (int i = 0; i < count; ++i) {
            model.setValue("colmap", null, i);
            model.setValue("datafs_tag", null, i);
            model.setValue("fsset", null, i);
        }
    }

    private void initColsEntry(String repoEntity) {
        IDataModel model = this.getModel();
        MainEntityType type = null;
        try {
            type = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        }
        catch (KDException e) {
            throw new KDBizException(e.getMessage());
        }
        if (type == null) {
            return;
        }
        Map cols = type.getAllFields();
        if (cols.isEmpty()) {
            return;
        }
        int[] indexs = model.batchCreateNewEntryRow("colsentry", cols.size());
        int i = 0;
        for (Map.Entry col : cols.entrySet()) {
            model.setValue("repo_col", col.getKey(), indexs[i]);
            model.setValue("repo_col_name", (Object)((IDataEntityProperty)col.getValue()).getDisplayName().getLocaleValue(), indexs[i]);
            model.setValue("colname", (Object)((IDataEntityProperty)col.getValue()).getDisplayName(), indexs[i]);
            this.getView().setEnable(Boolean.valueOf(false), indexs[i], new String[]{"datasegtype", "datactrlstrategy"});
            ++i;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "colmap": {
                this.selectColMap(evt);
                break;
            }
            case "joinentity": {
                this.selectJoinEntity(evt);
                break;
            }
            case "datactrlstrategy": {
                this.selectDataCtrlStra(evt);
                break;
            }
        }
    }

    private void selectJoinEntity(BeforeF7SelectEvent evt) {
        DynamicObject repoEntity = this.checkAndGetRepoEntity();
        if (repoEntity == null) {
            evt.setCancel(true);
            return;
        }
        QFilter fs = new QFilter("repoentity", "=", repoEntity.getPkValue());
        FormUtil.addF7Filter(evt, fs);
    }

    private DynamicObject checkAndGetRepoEntity() {
        DynamicObject repoEntity = (DynamicObject)this.getModel().getValue("repo");
        if (repoEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b57\u6bb5\u5e93\u201d\u3002", (String)"ReportConfEdit_4", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
        }
        return repoEntity;
    }

    private void selectColMap(BeforeF7SelectEvent evt) {
        int row;
        IDataModel model = this.getModel();
        DynamicObject blockSrc = (DynamicObject)model.getValue("srcentity", row = evt.getRow());
        if (blockSrc == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b9e\u4f53\u5bf9\u8c61\u201d\u3002", (String)"ReportConfEdit_3", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject repoEntity = this.checkAndGetRepoEntity();
        if (repoEntity == null) {
            evt.setCancel(true);
            return;
        }
        QFilter fs = new QFilter("repoentity", "=", repoEntity.getPkValue());
        fs.and("srcentity", "=", blockSrc.getPkValue());
        FormUtil.addF7Filter(evt, fs);
    }

    private void selectDataCtrlStra(BeforeF7SelectEvent evt) {
        DynamicObject repoEntity = this.checkAndGetRepoEntity();
        if (repoEntity == null) {
            evt.setCancel(true);
            return;
        }
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection colEntryRows = data.getDynamicObjectCollection("colsentry");
        DynamicObject dynamicObject = (DynamicObject)colEntryRows.get(evt.getRow());
        QFilter fs = new QFilter("bizbill", "=", repoEntity.getPkValue());
        fs.and("ctrlfield", "=", (Object)dynamicObject.getString("repo_col"));
        FormUtil.addF7Filter(evt, fs);
    }

    private void clickDataSegOrg() {
        IDataModel model = this.getModel();
        DynamicObject report = (DynamicObject)model.getValue("report");
        if (report == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62a5\u8868\u5b9e\u4f53\u201d\u3002", (String)"ReportConfEdit_7", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            return;
        }
        MainEntityType entityType = ColMapUtil.getMainEntityType(model, "report");
        TreeNode srcBillNode = this.buildColTree(entityType);
        this.showSelectFieldForm(srcBillNode);
    }

    private void showSelectFieldForm(TreeNode srcBillNode) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "datasegorgname"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void handleDataSegOrg(String returnData) {
        if (StringUtils.isNotBlank((CharSequence)returnData)) {
            IDataModel model = this.getModel();
            MainEntityType srcEntity = ColMapUtil.getMainEntityType(model, "report");
            model.setValue("datasegorg", (Object)returnData);
            model.setValue("datasegorgname", (Object)ColMapUtil.getColFullName(srcEntity, returnData));
        }
    }

    private void initDataSegTypeEnable() {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObject repo = data.getDynamicObject("repo");
        if (repo == null) {
            return;
        }
        DynamicObjectCollection colEntryRows = data.getDynamicObjectCollection("colsentry");
        for (int i = 0; i < colEntryRows.size(); ++i) {
            DynamicObject row = (DynamicObject)colEntryRows.get(i);
            String type = row.getString("caltype");
            String repoCol = row.getString("repo_col");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)repo.getString("id"));
            IDataEntityProperty property = dataEntityType.findProperty(repoCol);
            if (!(property instanceof FlexProp) && property instanceof BasedataProp && "A".equals(type)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"datasegtype", "datactrlstrategy"});
        }
    }

    private void changedDataSegType(PropertyChangedArgs e) {
        int idx = e.getChangeSet()[0].getRowIndex();
        String type = (String)this.getModel().getValue("datasegtype", idx);
        if (StringUtils.isEmpty((CharSequence)type) || "A".equals(type)) {
            this.getModel().setValue("datactrlstrategy", null, idx);
        }
    }

    private TreeNode buildColTree(MainEntityType entityType) {
        TreeNode root = new TreeNode("", "selectcols", entityType.getDisplayName().getLocaleValue());
        ArrayList<TreeNode> colNodes = new ArrayList<TreeNode>(16);
        Map fields = entityType.getAllFields();
        for (IDataEntityProperty pro : fields.values()) {
            String refBaseDataType;
            if (pro instanceof OrgProp) {
                String id = pro.getName();
                String text = pro.getDisplayName() + "(" + id + ")";
                colNodes.add(new TreeNode("", id, text));
                continue;
            }
            if (!(pro instanceof MulBasedataProp) || !"bos_org".equals(refBaseDataType = ((MulBasedataProp)pro).getComplexType().getName())) continue;
            String id = pro.getName();
            String text = pro.getDisplayName() + "(" + id + ")";
            colNodes.add(new TreeNode("", id, text));
        }
        for (TreeNode node : colNodes) {
            node.setParentid(root.getId());
            root.addChild(node);
        }
        root.setIsOpened(true);
        root.setDisabled(true);
        return root;
    }

    private void changedDataSegOrg(PropertyChangedArgs e) {
        String type = (String)this.getModel().getValue("datasegorgname");
        if (StringUtils.isBlank((CharSequence)type)) {
            this.getModel().setValue("datasegorg", null);
        }
    }
}

