/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.conf.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.core.RptSqlParser;
import kd.bplat.scmc.report.util.FormUtil;
import org.apache.commons.lang3.StringUtils;

public class ReportJoinEntityEdit
extends AbstractBasePlugIn {
    private static String KEY_COL_TREE = "cache_coltree";
    private static String KEY_CHECKED = "cache_checked";
    private static final String[] PAESE_COLS = new String[]{"repocol", "srccol", "defval", "remark"};

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        super.beforeDoOperation(e);
        switch (opKey = FormUtil.getOpKey(e)) {
            case "save": {
                this.beforeSave(e);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "checksql": {
                this.checkSql();
                break;
            }
        }
    }

    private TreeNode parseSqlInfo(String selectSql) {
        RptSqlParser sqlParser = new RptSqlParser();
        sqlParser.parseSqlInfo(selectSql);
        TreeNode tree = sqlParser.buildColTree();
        String treeJson = SerializationUtils.toJsonString((Object)tree);
        this.getPageCache().put(KEY_COL_TREE, treeJson);
        return tree;
    }

    private void checkSql() {
        String selectSql = this.getSelectSql();
        if (StringUtils.isBlank((CharSequence)selectSql)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5b9e\u4f53\u67e5\u8be2\u7684SQL\u3002", (String)"ReportJoinEntityEdit_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            return;
        }
        try {
            RptSqlParser sqlParser = new RptSqlParser();
            sqlParser.parseSqlInfo(selectSql);
            selectSql = sqlParser.getReBuildSql();
            this.setSelectSql(selectSql);
            sqlParser.checkQuery(null);
            this.getModel().setValue("sqlinfo_tag", (Object)selectSql);
            this.getPageCache().put(KEY_CHECKED, "true");
            this.getPageCache().remove(KEY_COL_TREE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f", (String)"ReportJoinEntityEdit_1", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        if (!this.isSqlChecked()) {
            e.setCancel(true);
            return;
        }
        this.parseMapInfo();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        switch (opKey = e.getOperateKey()) {
            case "save": {
                this.afterSave();
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srccol"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control button = (Control)evt.getSource();
        switch (button.getKey()) {
            case "srccol": {
                this.clickSrcCol();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindSqlInfo();
    }

    private void bindSqlInfo() {
        String sql = this.getModel().getDataEntity().getString("sqlinfo_tag");
        if (StringUtils.isBlank((CharSequence)sql)) {
            return;
        }
        CodeEdit sqlEditor = (CodeEdit)this.getControl("selectsql");
        sqlEditor.setText(sql);
        this.getPageCache().put(KEY_CHECKED, "true");
    }

    private TreeNode getColTree() {
        TreeNode root = null;
        String treeJson = this.getPageCache().get(KEY_COL_TREE);
        if (StringUtils.isBlank((CharSequence)treeJson)) {
            String sql = this.getModel().getDataEntity().getString("sqlinfo_tag");
            if (StringUtils.isBlank((CharSequence)sql)) {
                return null;
            }
            root = this.parseSqlInfo(sql);
        } else {
            root = (TreeNode)SerializationUtils.fromJsonString((String)treeJson, TreeNode.class);
        }
        return root;
    }

    private boolean isSqlChecked() {
        String sqlCode;
        String sql = this.getModel().getDataEntity().getString("sqlinfo_tag");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sql, sqlCode = this.getSelectSql()})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5b9e\u4f53\u67e5\u8be2\u7684SQL\u3002", (String)"ReportJoinEntityEdit_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            return false;
        }
        if (!sql.equals(sqlCode)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"SQL\u6709\u53d8\u5316\uff0c\u8bf7\u5148\u6267\u884c\u201c\u6d4b\u8bd5SQL\u201d\u3002", (String)"ReportJoinEntityEdit_2", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            return false;
        }
        return this.getPageCache().get(KEY_CHECKED) != null;
    }

    private void clickSrcCol() {
        if (!this.isSqlChecked()) {
            return;
        }
        TreeNode tree = this.getColTree();
        if (tree == null) {
            return;
        }
        this.showSelectFieldForm(tree, "srccol");
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(false);
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "srccol": {
                this.callBack4SrcCol(actionId, (String)returnData);
            }
        }
    }

    private void callBack4SrcCol(String colFlag, String returnCol) {
        if (StringUtils.isBlank((CharSequence)returnCol)) {
            return;
        }
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex("mapentry");
        TreeNode root = this.getColTree();
        model.setValue("srccol", (Object)returnCol, row);
        model.setValue("srccol_name", (Object)this.getColNameFromTree(root, returnCol), row);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindDemoSQL();
        this.bindMapInfo();
        this.getModel().setDataChanged(false);
    }

    private void bindDemoSQL() {
        this.getModel().getDataEntity().set("demosql", (Object)"select t1.org,t1.billno,t1.billentry.material \r\nfrom im_purinbill t1 \r\ninner join im_purreceivebill t2 on t2.billentry.id=t1.billentry.srcbillentryid");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "repoentity": {
                this.changedRepoEntity(e);
                break;
            }
            case "srccol": {
                this.changedSrcCol(e);
                break;
            }
        }
    }

    private void changedSrcCol(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        String val = (String)model.getValue("srccol", rowIndex);
        if (StringUtils.isBlank((CharSequence)val)) {
            model.setValue("srccol_name", null, rowIndex);
        }
    }

    private void changedRepoEntity(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObject repoEntity = data.getDynamicObject("repoentity");
        model.deleteEntryData("mapentry");
        if (repoEntity != null) {
            this.initColsEntry(repoEntity.getString("id"));
        }
    }

    private void initColsEntry(String repoEntity) {
        IDataModel model = this.getModel();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)repoEntity);
        Map cols = type.getAllFields();
        if (cols.isEmpty()) {
            return;
        }
        int[] indexs = model.batchCreateNewEntryRow("mapentry", cols.size());
        int i = 0;
        for (Map.Entry col : cols.entrySet()) {
            model.setValue("repocol", col.getKey(), indexs[i]);
            model.setValue("repocol_name", (Object)((IDataEntityProperty)col.getValue()).getDisplayName().getLocaleValue(), indexs[i]);
            ++i;
        }
    }

    private void afterSave() {
        this.bindMapInfo();
        this.getView().updateView("mapentry");
        this.getModel().setDataChanged(false);
    }

    private String getColNameFromTree(TreeNode root, String col) {
        int idx;
        TreeNode node;
        String fullName = ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230", (String)"ReportJoinEntityEdit_3", (String)"mpscmm-mscommon-report", (Object[])new Object[0]);
        if (root != null && (node = root.getTreeNode(col)) != null && (idx = (fullName = node.getText()).lastIndexOf("(")) > 0) {
            fullName = fullName.substring(0, idx);
        }
        return fullName;
    }

    private void bindMapInfo() {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        String info = data.getString("mapinfo_tag");
        DynamicObject repoEntity = data.getDynamicObject("repoentity");
        if (repoEntity == null || StringUtils.isBlank((CharSequence)info)) {
            return;
        }
        JSONObject mapInfo = JSONObject.parseObject((String)info);
        MainEntityType repoEntitytype = MetadataServiceHelper.getDataEntityType((String)repoEntity.getString("id"));
        TreeNode root = this.getColTree();
        HashMap cols = new HashMap(repoEntitytype.getAllFields());
        DynamicObjectCollection rows = data.getDynamicObjectCollection("mapentry");
        rows.clear();
        String repoCol = null;
        String repoColName = null;
        IDataEntityProperty pro = null;
        String srcCol = null;
        DynamicObject row = null;
        JSONArray vals = null;
        JSONArray colInfos = mapInfo.getJSONArray("repocol");
        ArrayList<DynamicObject> createRows = new ArrayList<DynamicObject>(colInfos.size());
        int len = colInfos.size();
        for (int i = 0; i < len; ++i) {
            row = rows.addNew();
            for (String colName : PAESE_COLS) {
                vals = mapInfo.getJSONArray(colName);
                if (vals == null) continue;
                row.set(colName, (Object)vals.getString(i));
            }
            repoCol = row.getString("repocol");
            pro = (IDataEntityProperty)cols.remove(repoCol);
            if (pro == null) continue;
            repoColName = pro.getDisplayName().getLocaleValue();
            row.set("repocol_name", (Object)repoColName);
            srcCol = row.getString("srccol");
            if (StringUtils.isNotBlank((CharSequence)srcCol)) {
                row.set("srccol_name", (Object)this.getColNameFromTree(root, srcCol));
            }
            createRows.add(row);
        }
        rows.clear();
        rows.addAll(createRows);
        for (Map.Entry col : cols.entrySet()) {
            row = rows.addNew();
            row.set("repocol", col.getKey());
            row.set("repocol_name", (Object)((IDataEntityProperty)col.getValue()).getDisplayName().getLocaleValue());
        }
    }

    private void setSelectSql(String sql) {
        CodeEdit sqlEditor = (CodeEdit)this.getControl("selectsql");
        sqlEditor.setText(sql);
    }

    private String getSelectSql() {
        CodeEdit sqlEditor = (CodeEdit)this.getControl("selectsql");
        return sqlEditor.getText();
    }

    private void parseMapInfo() {
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection colSettings = data.getDynamicObjectCollection("mapentry");
        JSONObject colInfo = new JSONObject();
        JSONArray vals = null;
        for (String col : PAESE_COLS) {
            vals = new JSONArray(colSettings.size());
            colInfo.put(col, (Object)vals);
            for (DynamicObject row : colSettings) {
                vals.add((Object)row.getString(col));
            }
        }
        this.getModel().setValue("mapinfo_tag", (Object)colInfo.toJSONString());
    }
}

