/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.conf.op;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ReportConfSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataExts;
        for (ExtendedDataEntity dataExt : dataExts = this.getDataEntities()) {
            this.checkData(dataExt);
        }
    }

    private void checkData(ExtendedDataEntity dataExt) {
        DynamicObject data = dataExt.getDataEntity();
        DynamicObjectCollection colsEntry = data.getDynamicObjectCollection("colsentry");
        boolean dataSegFlag = false;
        for (DynamicObject entry : colsEntry) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getString("datasegtype"))) continue;
            dataSegFlag = true;
            break;
        }
        String dataSegOrg = data.getString("datasegorg");
        if (dataSegFlag && StringUtils.isBlank((CharSequence)dataSegOrg)) {
            this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6570\u636e\u9694\u79bb\u7ec4\u7ec7\u201d\u3002", (String)"ReportConfSaveValidator_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> tips = new ArrayList<String>();
        ArrayList<String> fieldNullLine = new ArrayList<String>();
        for (DynamicObject entry : colsEntry) {
            if ("B".equals(entry.getString("datasegtype")) && StringUtils.isBlank((CharSequence)entry.getString("datactrlstrategy"))) {
                fieldNullLine.add(entry.getString("seq"));
            }
            DynamicObject repo = data.getDynamicObject("repo");
            String repoCol = entry.getString("repo_col");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)repo.getString("id"));
            IDataEntityProperty property = dataEntityType.findProperty(repoCol);
            if (!"B".equals(entry.getString("datasegtype")) || !(property instanceof ItemClassProp)) continue;
            StringBuilder alertMsg = new StringBuilder();
            alertMsg.append(ResManager.loadKDString((String)"\u201c\u62a5\u8868\u5b57\u6bb5\u914d\u7f6e\u201d\u7b2c{0}\u884c\u201c{1}\u201d\u5b57\u6bb5\u53ea\u652f\u6301\u6309\u201c\u6570\u636e\u89c4\u5219\u6743\u9650\u201d\u9694\u79bb\u3002", (String)"ReportConfSaveValidator_1", (String)"mpscmm-mscommon-report", (Object[])new Object[]{entry.getInt("seq"), entry.getString("colname")}));
            tips.add(alertMsg.toString());
        }
        if (!CollectionUtils.isEmpty(fieldNullLine)) {
            StringBuilder msg = new StringBuilder();
            String seq = "[" + String.join((CharSequence)",", fieldNullLine) + "]";
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u62a5\u8868\u5b57\u6bb5\u914d\u7f6e\u201d\u7b2c{0}\u884c\u201c\u6570\u636e\u63a7\u5236\u7b56\u7565\u201d\u5b57\u6bb5\u3002", (String)"ReportConfSaveValidator_2", (String)"mpscmm-mscommon-report", (Object[])new Object[]{seq}));
            tips.add(msg.toString());
        }
        for (String tip : tips) {
            this.addMessage(dataExt, tip, ErrorLevel.Error);
        }
    }
}

