/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ColAlias;

public class EntityInfo
implements Serializable {
    private static final long serialVersionUID = 1700768907646685806L;
    private Map<String, String> colAs;
    private String name;
    private String alias;
    private boolean mainEntity;
    private List<ColAlias> selectCols = new ArrayList<ColAlias>(16);
    private Set<String> onCols = new HashSet<String>(4);
    private List<String> entityOnCols = new ArrayList<String>(4);
    private List<String> otherEntityOnCols = new ArrayList<String>(4);
    private EntityInfo joinEntity;
    private String joinType;
    private Map<String, Set<Object>> pushVals;
    private DataSet data;

    Input buildInput(QFilter fs) {
        String selectCols = this.buildEntitySelectCols();
        return new OrmInput("EntityInfo.buildInput", this.name, selectCols, fs == null ? null : fs.toArray());
    }

    void buildDataSet(QFilter fs) {
        String selectCols = this.buildEntitySelectCols();
        this.data = QueryServiceHelper.queryDataSet((String)"EntityInfo.buildDataSet", (String)this.name, (String)selectCols, (QFilter[])(fs == null ? null : fs.toArray()), null);
    }

    void testQuery(QFilter fs) {
        String selectCols = this.buildEntitySelectCols();
        DataSet data = QueryServiceHelper.queryDataSet((String)"EntityInfo.testQuery", (String)this.name, (String)selectCols, (QFilter[])(fs == null ? null : fs.toArray()), null);
        Throwable throwable = null;
        if (data != null) {
            if (throwable != null) {
                try {
                    data.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                data.close();
            }
        }
    }

    private String buildEntitySelectCols() {
        this.colAs = new HashMap<String, String>(32);
        String asCol = this.alias + "_c";
        int i = 1;
        String tempCol = null;
        for (ColAlias colAlias : this.selectCols) {
            tempCol = colAlias.getCol();
            this.colAs.put(tempCol, asCol + i++);
        }
        for (String string : this.onCols) {
            this.colAs.put(string, asCol + i++);
        }
        StringBuilder selectCols = new StringBuilder();
        i = 0;
        for (Map.Entry<String, String> entry : this.colAs.entrySet()) {
            if (i++ > 0) {
                selectCols.append(',');
            }
            selectCols.append(entry.getKey()).append(' ').append(entry.getValue());
        }
        return selectCols.toString();
    }

    JoinType buildJoinType() {
        if ("inner".equals(this.joinType)) {
            return JoinType.INNER;
        }
        if ("left".equals(this.joinType)) {
            return JoinType.LEFT;
        }
        if ("full".equals(this.joinType)) {
            return JoinType.FULL;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"EntityInfo_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]));
    }

    StringBuilder buildSqlPart() {
        StringBuilder sql = new StringBuilder();
        if (this.mainEntity) {
            sql.append("from ").append(this.name).append(' ').append(this.alias);
        } else {
            sql.append(this.joinType).append(" join ").append(this.name).append(' ').append(this.alias);
            sql.append(" on ");
            int len = this.entityOnCols.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(this.alias).append('.').append(this.entityOnCols.get(i)).append('=').append(this.joinEntity.alias).append('.').append(this.otherEntityOnCols.get(i)).append(' ');
            }
        }
        return sql;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityInfo other = (EntityInfo)obj;
        return !(this.alias == null ? other.alias != null : !this.alias.equals(other.alias));
    }

    public String toString() {
        return this.buildSqlPart().toString();
    }

    QFilter buildOnFilter() {
        QFilter fs = null;
        QFilter temp = null;
        Set<Object> vals = null;
        int len = this.entityOnCols.size();
        for (int i = 0; i < len; ++i) {
            vals = this.joinEntity.pushVals.get(this.otherEntityOnCols.get(i));
            temp = vals.isEmpty() ? new QFilter("1", "=", (Object)2) : new QFilter(this.entityOnCols.get(i), "in", vals);
            fs = fs == null ? temp : fs.and(temp);
        }
        return fs;
    }

    private Map<String, Set<Object>> buildEntityMap(Set<String> onCols) {
        HashMap<String, Set<Object>> vals = new HashMap<String, Set<Object>>(onCols.size());
        for (String col : onCols) {
            vals.put(col, new HashSet(512));
        }
        return vals;
    }

    Map<String, String> getColAs() {
        return this.colAs;
    }

    void setColAs(Map<String, String> colAs) {
        this.colAs = colAs;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isMainEntity() {
        return this.mainEntity;
    }

    void setMainEntity(boolean mainEntity) {
        this.mainEntity = mainEntity;
    }

    List<ColAlias> getSelectCols() {
        return this.selectCols;
    }

    void setSelectCols(List<ColAlias> selectCols) {
        this.selectCols = selectCols;
    }

    Set<String> getOnCols() {
        return this.onCols;
    }

    void setOnCols(Set<String> onCols) {
        this.onCols = onCols;
    }

    List<String> getEntityOnCols() {
        return this.entityOnCols;
    }

    void setEntityOnCols(List<String> entityOnCols) {
        this.entityOnCols = entityOnCols;
    }

    List<String> getOtherEntityOnCols() {
        return this.otherEntityOnCols;
    }

    void setOtherEntityOnCols(List<String> otherEntityOnCols) {
        this.otherEntityOnCols = otherEntityOnCols;
    }

    EntityInfo getJoinEntity() {
        return this.joinEntity;
    }

    void setJoinEntity(EntityInfo joinEntity) {
        this.joinEntity = joinEntity;
    }

    void buildPushVals() {
        if (this.pushVals == null) {
            HashSet<String> onCols = new HashSet<String>(this.onCols);
            onCols.removeAll(this.entityOnCols);
            if (onCols.isEmpty()) {
                return;
            }
            Map<String, Set<Object>> vals = this.buildEntityMap(onCols);
            StringBuilder selectCols = new StringBuilder();
            int i = 0;
            for (String onCol : onCols) {
                if (i++ > 0) {
                    selectCols.append(',');
                }
                selectCols.append(this.colAs.get(onCol));
            }
            DataSet onData = this.data.copy().select(selectCols.toString());
            for (Row row : onData) {
                for (String onCol : onCols) {
                    vals.get(onCol).add(row.get(this.colAs.get(onCol)));
                }
            }
            this.pushVals = Collections.unmodifiableMap(vals);
        }
    }

    DataSet getData() {
        return this.data;
    }

    void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    String getJoinType() {
        return this.joinType;
    }
}

