/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FsSplitListener
implements Serializable {
    private static final long serialVersionUID = -7202431409991551855L;
    private int dateStep = -1;
    private int idCount = -1;
    private String splitKey;

    public FsSplitListener(String splitKey, int dateStep, int idCount) {
        this.splitKey = splitKey;
        this.dateStep = dateStep;
        this.idCount = idCount;
    }

    public String getSplitKey() {
        return this.splitKey;
    }

    Date[] splitDateFromTo(Date from, Date to) {
        int size = this.getDateStepSize(from, to);
        if (size <= 0) {
            return new Date[]{from, to};
        }
        Calendar calendar = Calendar.getInstance();
        ArrayList<Date> dates = new ArrayList<Date>(8);
        Date node = from;
        calendar.setTime(node);
        while (node.before(to)) {
            dates.add(node);
            calendar.add(5, size);
            node = calendar.getTime();
        }
        dates.add(to);
        return dates.toArray(new Date[0]);
    }

    List<Set<Object>> splitIdVal(Set<Object> idVals) {
        ArrayList<Set<Object>> result = new ArrayList<Set<Object>>();
        int groupSize = this.getSplitIdCount(idVals);
        if (groupSize <= 0) {
            result.add(idVals);
            return result;
        }
        HashSet<Object> item = new HashSet<Object>(groupSize);
        for (Object id : idVals) {
            item.add(id);
            if (item.size() < groupSize) continue;
            result.add(item);
            item = new HashSet(groupSize);
        }
        if (!item.isEmpty()) {
            result.add(item);
        }
        return result;
    }

    protected int getDateStepSize(Date from, Date to) {
        return this.dateStep;
    }

    protected int getSplitIdCount(Set<Object> idVals) {
        return this.idCount;
    }
}

