/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core.tpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.metadata.entity.report.ReportColumnFactory;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.common.QueryType;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.mpscmm.mscommon.business.helper.datactrl.InvBizDataCtrlHelper;

public class AbstractReportQuery
extends AbstractReportListDataPlugin {
    private ReportDataCtx reportCtx;
    private Set<String> showCols;

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        return super.queryBatchBy(queryParam);
    }

    protected final ReportDataCtx getReportDataCtx() {
        if (this.reportCtx == null) {
            this.initCtx();
        }
        return this.reportCtx;
    }

    private void initCtx() {
        ReportDataCtx ctx = new ReportDataCtx();
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo info = queryParam.getFilter();
        String reportEntity = (String)queryParam.getCustomParam().get("report");
        ReportConf reportConf = ReportDataHandle.loadReportConf(reportEntity);
        ctx.setReportConf(reportConf);
        ctx.logInfo("==============load report conf successed==============");
        ctx.logInfo(reportEntity);
        ctx.setCommonFs(info.getCommFilter(reportConf.getRepoEntity()));
        Set<String> allQtyCols = ReportUtil.filterBigtableCols(reportConf, colConf -> "B".equals(colConf.getCalType()));
        Set<String> allKeyCols = ReportUtil.filterBigtableCols(reportConf, colConf -> "A".equals(colConf.getCalType()));
        FilterItemInfo item = info.getFilterItem("showkeycols");
        Set<String> keyCols = ReportUtil.splitCombColVal(item.getString());
        keyCols.retainAll(allKeyCols);
        ctx.setShowKeyCols(keyCols);
        item = info.getFilterItem("showqtycols");
        Set<String> qtyCols = ReportUtil.splitCombColVal(item.getString());
        qtyCols.retainAll(allQtyCols);
        ctx.setShowQtyCols(qtyCols);
        item = info.getFilterItem("sumkeycols");
        Set<String> sumKeyCol = ReportUtil.splitCombColVal(item.getString());
        sumKeyCol.retainAll(keyCols);
        ctx.setSumKeyCols(sumKeyCol);
        ctx.setSumKeyCols4Count(new HashSet<String>(ctx.getSumKeyCols()));
        ctx.setSumQtyCols4Count(new HashSet<String>(ctx.getShowQtyCols()));
        item = info.getFilterItem("showtotalqty");
        ctx.setShowTotalQty(item.getBoolean());
        ctx.setParams(queryParam.getCustomParam());
        List<QFilter> filters = this.initPageFilters(reportConf);
        ctx.setPageFs(filters);
        ctx.setPermFs(this.getPermissionFs(queryParam));
        ctx.logInfo("==============analysis view param successed,create context==============");
        ctx.logInfo(ctx);
        ctx.setQueryParam(queryParam);
        this.reportCtx = ctx;
    }

    private List<QFilter> initPageFilters(ReportConf reportConf) {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        List pageFs = filter.getQFilters();
        ArrayList<QFilter> resultFs = new ArrayList<QFilter>();
        Set<String> mapedCols = ReportUtil.filterBigtableCols(reportConf, colConf -> {
            String calType = colConf.getCalType();
            return !"D".equals(calType) && !"B".equals(calType);
        });
        for (QFilter fs : pageFs) {
            if (!this.checkFs(fs, mapedCols)) continue;
            resultFs.add(fs);
        }
        return resultFs;
    }

    private boolean checkFs(QFilter fs, Set<String> mapedCols) {
        List nests = fs.getNests(true);
        boolean isMatch = true;
        for (QFilter.QFilterNest fsNest : nests) {
            isMatch = ReportUtil.isMatchCol(fsNest.getFilter().getProperty(), mapedCols);
            if (!isMatch) continue;
            return isMatch;
        }
        return isMatch;
    }

    private void checkMsg(ReportQueryParam param, ReportDataCtx ctx) {
        IAppCache cache;
        String msg = null;
        String jobMsgKey = ctx.getJobMsgKey();
        if (StringUtils.isNotBlank((CharSequence)jobMsgKey) && StringUtils.isNotBlank((CharSequence)(msg = (String)(cache = AppCache.get((String)"bos")).get(jobMsgKey, String.class)))) {
            cache.remove(jobMsgKey);
        }
        param.setMessage(msg);
    }

    public final DataSet query(ReportQueryParam param, Object o) throws Throwable {
        ReportDataCtx ctx = this.getReportDataCtx();
        ctx.setQueryType(QueryType.RPT_QUERY);
        DataSet result = ReportDataHandle.queryDataSet(ctx);
        this.showCols = ReportUtil.getDataCols(result.getRowMeta());
        this.checkMsg(param, ctx);
        return result;
    }

    public DataSet export(ReportQueryParam queryParam, Object selectedObj) {
        ReportDataCtx ctx = this.getReportDataCtx();
        ctx.setQueryType(QueryType.RPT_EXPORT);
        DataSet result = ReportDataHandle.queryDataSet(ctx);
        return result;
    }

    private Map<String, AbstractReportColumn> parseExistsCol(List<AbstractReportColumn> columns) {
        HashMap<String, AbstractReportColumn> colMap = new HashMap<String, AbstractReportColumn>();
        for (AbstractReportColumn col : columns) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn reportcol = (ReportColumn)col;
            colMap.put(reportcol.getFieldKey(), col);
        }
        return colMap;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map<String, AbstractReportColumn> existsCols = this.parseExistsCol(columns);
        this.reportCtx.logInfo("==============original field==============");
        this.reportCtx.logInfo(columns);
        List<AbstractReportColumn> allCols = new ArrayList<AbstractReportColumn>(32);
        AbstractReportColumn existsCol = existsCols.get("linetype");
        if (existsCol != null) {
            allCols.add(existsCol);
        }
        if (this.showCols.remove("block_entity")) {
            String name = ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61", (String)"AbstractReportQuery_0", (String)"mpscmm-mscommon-report", (Object[])new Object[0]);
            allCols.add((AbstractReportColumn)ReportColumnFactory.createBaseDataColumn((LocaleString)new LocaleString(name), (String)"block_entity", (String)"bos_entityobject", (String)"name"));
        }
        ReportConf reportConf = this.reportCtx.getReportConf();
        List<BigTableColConf> bigTableColConf = reportConf.getBigTableColConf();
        MainEntityType repoEntityType = MetadataServiceHelper.getDataEntityType((String)reportConf.getRepoEntity());
        String col = null;
        List<String> showRefProps = null;
        Map<String, String> refPropNames = null;
        String name = null;
        for (BigTableColConf colConf : bigTableColConf) {
            col = colConf.getCol();
            if (!this.showCols.remove(col)) continue;
            existsCol = existsCols.get(col);
            if (existsCol == null) {
                existsCol = ReportUtil.createProLike(repoEntityType, colConf);
            }
            allCols.add(existsCol);
            showRefProps = colConf.getShowRefProps();
            if (showRefProps == null || showRefProps.size() <= 0) continue;
            refPropNames = colConf.getRefPropNames();
            for (String refCol : showRefProps) {
                name = refPropNames.get(refCol);
                if (name == null) continue;
                allCols.add((AbstractReportColumn)ReportColumnFactory.createBaseDataPropColumn((LocaleString)new LocaleString(colConf.getColName() + "." + name), (String)(col + "_ref_" + refCol), (String)col, (String)refCol, (String)"basedataprop"));
            }
        }
        this.reportCtx.logInfo("==============after deal baseclass==============");
        this.reportCtx.logInfo(allCols);
        List<IReportDataHandle> plugins = reportConf.getPlugins();
        for (IReportDataHandle plugin : plugins) {
            allCols = plugin.buildShowColumn(allCols, this.reportCtx);
            this.reportCtx.logInfo("==============after deal plugin[" + plugin.getClass().getName() + "]==============");
            this.reportCtx.logInfo(allCols);
        }
        return allCols;
    }

    private List<QFilter> getPermissionFs(ReportQueryParam queryParam) {
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        Map customParam = queryParam.getCustomParam();
        String reportEntity = (String)customParam.get("report");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)reportEntity);
        String appId = entityType.getAppId();
        DynamicObject conf = ReportDataHandle.loadConfModel(reportEntity);
        DynamicObjectCollection colsEntry = conf.getDynamicObjectCollection("colsentry");
        List dynamicObjectList = colsEntry.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getString("datasegtype"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return new ArrayList<QFilter>(0);
        }
        List<Long> orgs = this.getOrgs(queryParam, conf);
        DynamicObject repo = conf.getDynamicObject("repo");
        HashMap<String, Object> dataRuleParam = new HashMap<String, Object>(4);
        dataRuleParam.put("currUserId", currUserId);
        dataRuleParam.put("appId", appId);
        dataRuleParam.put("repoNumber", repo.getString("number"));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        for (DynamicObject dyn : dynamicObjectList) {
            dataRuleParam.put("repoCol", dyn.getString("repo_col"));
            String dataSegType = dyn.getString("datasegtype");
            if ("A".equals(dataSegType)) {
                this.appendQfFromPlatForm(qFilters, orgs, dataRuleParam);
                continue;
            }
            if (!"B".equals(dataSegType)) continue;
            Long strategyId = dyn.getDynamicObject("datactrlstrategy").getLong("id");
            this.appendQfFromDataCtrl(qFilters, orgs, strategyId, dyn.getString("repo_col"));
        }
        return qFilters;
    }

    private void appendQfFromDataCtrl(List<QFilter> qFilters, List<Long> orgs, Long strategyId, String repoCol) {
        Set dataByUser = InvBizDataCtrlHelper.buildF7Helper().getDataByUser(orgs, strategyId);
        if (!CollectionUtils.isEmpty((Collection)dataByUser)) {
            qFilters.add(new QFilter(repoCol, "in", (Object)dataByUser));
        }
    }

    private void appendQfFromPlatForm(List<QFilter> qFilters, List<Long> orgs, Map<String, Object> dataRuleParam) {
        String repoNumber = dataRuleParam.get("repoNumber").toString();
        String repoCol = dataRuleParam.get("repoCol").toString();
        Long currUserId = (Long)dataRuleParam.get("currUserId");
        String appId = dataRuleParam.get("appId").toString();
        MainEntityType repoEntityType = MetadataServiceHelper.getDataEntityType((String)repoNumber);
        String typePropName = null;
        ArrayList<String> basedataEntityNames = new ArrayList<String>();
        IDataEntityProperty property = repoEntityType.findProperty(repoCol);
        if (property instanceof ItemClassProp) {
            typePropName = ((ItemClassProp)MetadataServiceHelper.getDataEntityType((String)repoNumber).findProperty(repoCol)).getTypePropName();
            List baseDataTypes = ((ItemClassTypeProp)repoEntityType.findProperty(typePropName)).getBaseEntityIds();
            basedataEntityNames.addAll(baseDataTypes);
        } else if (property instanceof BasedataProp) {
            String basedataNumber = ((BasedataProp)MetadataServiceHelper.getDataEntityType((String)repoNumber).findProperty(repoCol)).getBaseEntityId();
            basedataEntityNames.add(basedataNumber);
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        QFilter filter = null;
        for (String entityname : basedataEntityNames) {
            QFilter dataRuleQf = permissionService.getDataRuleWithoutDim(currUserId.longValue(), appId, entityname, "47150e89000000ac", orgs);
            if (dataRuleQf == null) continue;
            filter = this.transQFilter(filter, dataRuleQf, entityname, typePropName, repoCol);
        }
        if (filter != null) {
            qFilters.add(filter);
        }
    }

    private QFilter transQFilter(QFilter filter, QFilter dataRuleQf, String entityname, String typePropName, String repoCol) {
        HashSet<String> props = new HashSet<String>();
        this.getProperties(dataRuleQf, props);
        String filterStr = dataRuleQf.toString();
        for (String prop : props) {
            filterStr = filterStr.replaceAll(prop, repoCol + "." + prop);
        }
        QFilter dataRuleQFilter = QFilter.of((String)filterStr, (Object[])new Object[0]);
        if (filter != null && StringUtils.isNotEmpty((CharSequence)typePropName)) {
            QFilter filter1 = this.dealMultiBaseDataField(dataRuleQFilter, entityname);
            filter = filter.or(filter1);
        } else {
            filter = StringUtils.isNotEmpty((CharSequence)typePropName) ? this.dealMultiBaseDataField(dataRuleQFilter, entityname) : dataRuleQFilter;
        }
        return filter;
    }

    private QFilter dealMultiBaseDataField(QFilter dataRuleQFilter, String entityname) {
        MultiBaseDataFilterValue multiBaseDataFilterValue = new MultiBaseDataFilterValue(entityname, dataRuleQFilter.getProperty(), dataRuleQFilter.getValue());
        QFilter filter1 = new QFilter(dataRuleQFilter.getProperty(), dataRuleQFilter.getCP(), (Object)multiBaseDataFilterValue);
        List nests = dataRuleQFilter.getNests(false);
        if (!CollectionUtils.isEmpty((Collection)nests)) {
            for (QFilter.QFilterNest nest : nests) {
                QFilter multiBaseDataQF = this.dealMultiBaseDataField(nest.getFilter(), entityname);
                if ("and".equalsIgnoreCase(nest.getOp())) {
                    filter1.and(multiBaseDataQF);
                    continue;
                }
                if (!"or".equalsIgnoreCase(nest.getOp())) continue;
                filter1.or(multiBaseDataQF);
            }
        }
        return filter1;
    }

    private void getProperties(QFilter dataRuleQf, Set<String> props) {
        props.add(dataRuleQf.getProperty());
        List nests = dataRuleQf.getNests(true);
        if (!CollectionUtils.isEmpty((Collection)nests)) {
            for (QFilter.QFilterNest nest : nests) {
                this.getProperties(nest.getFilter(), props);
            }
        }
    }

    private List<Long> getOrgs(ReportQueryParam queryParam, DynamicObject conf) {
        ArrayList<Long> orgs = new ArrayList<Long>();
        Object permOrgId = queryParam.getCustomParam().get("permOrgId");
        if (permOrgId != null) {
            orgs.add((Long)permOrgId);
        } else {
            FilterInfo filterInfo = queryParam.getFilter();
            String datasegorgField = conf.getString("datasegorg");
            if (StringUtils.isEmpty((CharSequence)datasegorgField)) {
                return new ArrayList<Long>(0);
            }
            Object datasegorg = filterInfo.getValue(datasegorgField);
            if (datasegorg instanceof DynamicObject) {
                orgs.add(((DynamicObject)datasegorg).getLong("id"));
            } else if (datasegorg instanceof DynamicObjectCollection) {
                orgs.add(((DynamicObject)((DynamicObjectCollection)datasegorg).get(0)).getLong("id"));
            }
        }
        return orgs;
    }
}

