/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core.transform;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.transform.func.Bool2StrMapFunc;

public class Bool2StrTransform
implements IDataXTransform {
    private Set<String> booleanCols;

    public Set<String> getBooleanCols() {
        return this.booleanCols;
    }

    public Bool2StrTransform setBooleanCols(Set<String> booleanCols) {
        this.booleanCols = booleanCols;
        return this;
    }

    public Bool2StrTransform(Set<String> booleanCols) {
        this.booleanCols = booleanCols;
    }

    @Override
    public DataSetX doTransform(DataSetX srcData) {
        RowMeta rowMeta = srcData.getRowMeta();
        ArrayList<Integer> colIdxs = new ArrayList<Integer>(8);
        Field[] fields = rowMeta.getFields();
        String name = null;
        for (Field field : fields) {
            name = field.getName();
            if (this.booleanCols != null && !this.booleanCols.contains(name) || !DataType.BooleanType.equals((Object)field.getDataType())) continue;
            colIdxs.add(rowMeta.getFieldIndex(name, false));
        }
        if (colIdxs.isEmpty()) {
            return srcData;
        }
        int[] idxs = new int[colIdxs.size()];
        int i = 0;
        for (Integer idx : colIdxs) {
            idxs[i++] = idx;
        }
        return srcData.map((MapFunction)new Bool2StrMapFunc(rowMeta, idxs));
    }
}

