/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.core.transform;

import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;

public class GroupTransform
implements IDataXTransform {
    private GroupPlan plan;

    public GroupTransform(GroupPlan plan) {
        this.plan = plan;
    }

    @Override
    public DataSetX doTransform(DataSetX srcData) {
        if (this.plan == null || this.plan.getKeyCols().isEmpty() || this.plan.getQtyCols().isEmpty()) {
            return srcData;
        }
        Grouper groupData = srcData.groupBy(this.plan.getKeyCols().toArray(new String[0]));
        int i = 0;
        for (String sumCol : this.plan.getQtyCols()) {
            srcData = i == 0 ? groupData.sum(sumCol) : srcData.sum(sumCol);
            ++i;
        }
        return srcData;
    }

    public String toString() {
        return "GroupTransform [plan=" + this.plan + "]";
    }
}

