/*
 * Decompiled with CFR 0.152.
 */
package kd.bplat.scmc.report.util;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bplat.scmc.report.common.QueryParam;
import kd.bplat.scmc.report.common.QueryType;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.core.tpl.IOutputHandle;
import kd.bplat.scmc.report.util.ReportUtil;

public class ReportQuery {
    public static ReportDataCtx buildReportDataCtx(QueryParam param) {
        ReportDataCtx ctx = new ReportDataCtx();
        ctx.setQueryType(QueryType.CODE_API);
        DynamicObject conf = param.getConf();
        ReportConf reportConf = ReportDataHandle.loadReportConf(conf);
        ctx.setReportConf(reportConf);
        ctx.logInfo("==============ReportQuery:Load Report Config Success==============");
        ctx.logInfo(reportConf);
        ctx.setCommonFs(param.getCommonFs());
        Set<String> allQtyCols = ReportUtil.filterBigtableCols(reportConf, colConf -> "B".equals(colConf.getCalType()));
        Set<String> allKeyCols = ReportUtil.filterBigtableCols(reportConf, colConf -> "A".equals(colConf.getCalType()));
        Set<String> keyCols = param.getShowKeyCols();
        keyCols.retainAll(allKeyCols);
        ctx.setShowKeyCols(keyCols);
        Set<String> qtyCols = param.getShowQtyCols();
        qtyCols.retainAll(allQtyCols);
        ctx.setShowQtyCols(qtyCols);
        Set<String> sumKeyCol = param.getSumKeyCols();
        sumKeyCol.retainAll(keyCols);
        ctx.setSumKeyCols(sumKeyCol);
        ctx.setSumKeyCols4Count(new HashSet<String>(ctx.getSumKeyCols()));
        ctx.setSumQtyCols4Count(new HashSet<String>(ctx.getShowQtyCols()));
        ctx.setShowTotalQty(param.isShowTotalQty());
        ctx.setParams(param.getCustomParam());
        ctx.logInfo("==============ReportQuery:Prase Form Param Success,Create Context==============");
        ctx.logInfo(ctx);
        return ctx;
    }

    public static void query(ReportDataCtx ctx, IOutputHandle outHandle) {
        ReportDataHandle.doAlgoXJob(ctx, outHandle);
    }

    public static DataSet queryData(ReportDataCtx ctx) {
        return ReportDataHandle.queryDataSet(ctx);
    }
}

