/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillFieldInfo;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MatcherUtil;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class BillFieldInfoManager {
    private Map<String, Map<String, Map<String, IDataEntityProperty>>> billKeyEntry = new HashMap<String, Map<String, Map<String, IDataEntityProperty>>>(16);
    private Map<String, Map<String, Set<String>>> billKeyRefField = new HashMap<String, Map<String, Set<String>>>(16);
    private Map<String, BillFieldInfo> infos = new HashMap<String, BillFieldInfo>(16);

    private BillFieldInfoManager() {
    }

    public List<String> getItemClassInfo(String entity, String entryKey) {
        Map<String, IDataEntityProperty> entryInfo;
        Map<String, Map<String, IDataEntityProperty>> fieldInfo = this.billKeyEntry.get(entity);
        HashMap<String, IDataEntityProperty> propInfo = new HashMap<String, IDataEntityProperty>(16);
        Map<String, IDataEntityProperty> headInfo = fieldInfo.get(null);
        if (headInfo != null) {
            propInfo.putAll(headInfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)entryKey) && (entryInfo = fieldInfo.get(entryKey)) != null) {
            propInfo.putAll(entryInfo);
        }
        ArrayList<String> itemClassProp = new ArrayList<String>(16);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
        for (Map.Entry entryInfo2 : propInfo.entrySet()) {
            ItemClassProp icProp;
            ItemClassTypeProp classProp;
            List baseEntityIds;
            IDataEntityProperty prop = (IDataEntityProperty)entryInfo2.getValue();
            if (!(prop instanceof ItemClassProp) || !(baseEntityIds = (classProp = (ItemClassTypeProp)entityType.findProperty((icProp = (ItemClassProp)prop).getTypePropName())).getBaseEntityIds()).contains("bd_customer") && !baseEntityIds.contains("bd_supplier")) continue;
            IDataEntityType parent = icProp.getParent();
            itemClassProp.add(prop.getName());
            if (parent instanceof MainEntityType) continue;
            itemClassProp.add(entryKey + "." + prop.getName());
        }
        return itemClassProp;
    }

    public static String buildSelectField(String entity, String entryKey, List<String> selectFields) {
        BillFieldInfoManager infoManager = BillFieldInfoManager.create();
        for (String field : selectFields) {
            infoManager.addFullFieldKey(entity, field);
        }
        return infoManager.buildSelectField(entity, entryKey);
    }

    public static BillFieldInfoManager create() {
        BillFieldInfoManager manager = new BillFieldInfoManager();
        return manager;
    }

    public String buildSelectField(String billentity, String entryKey) {
        BillFieldInfo billFieldInfo = this.getBillFieldInfo(billentity, entryKey);
        return billFieldInfo.getFullSelectField();
    }

    public BillFieldInfo getBillFieldInfo(String billentity, String entryKey) {
        BillFieldInfo billFieldInfo = this.infos.get(billentity + "-" + entryKey);
        if (billFieldInfo == null) {
            billFieldInfo = this.buildSelectFieldInfo(billentity, entryKey);
        }
        return billFieldInfo;
    }

    private BillFieldInfo buildSelectFieldInfo(String billentity, String entryKey) {
        Map<String, Map<String, IDataEntityProperty>> map = this.billKeyEntry.get(billentity);
        Map<String, Set<String>> refMap = this.billKeyRefField.get(billentity);
        BillFieldInfo fieldInfo = BillFieldInfo.build(billentity, entryKey, map, refMap);
        this.infos.put(billentity + "-" + entryKey, fieldInfo);
        return fieldInfo;
    }

    public void addFullFieldKey(String entity, String fullField) {
        String[] split;
        if (StringUtils.isEmpty((CharSequence)fullField)) {
            return;
        }
        MainEntityType mainEntiy = MetadataServiceHelper.getDataEntityType((String)entity);
        IDataEntityProperty fristPartProp = mainEntiy.findProperty((split = fullField.split("\\."))[0]);
        if (fristPartProp instanceof EntryProp && split.length >= 2) {
            if (!"seq".equals(split[1]) && !"id".equals(split[1])) {
                IDataEntityProperty scPartProp = mainEntiy.findProperty(split[1]);
                if (scPartProp instanceof EntryProp) {
                    throw new KDBizException("not support subentry!");
                }
                if (scPartProp == null) {
                    throw new KDBizException(entity + "." + split[1] + " field not exist!");
                }
                this.addFieldKey(entity, fristPartProp.getName(), scPartProp);
                if (split.length > 2) {
                    this.addRefInfo(entity, scPartProp.getName(), this.combineArray(split, 2));
                }
            } else {
                DataEntityPropertyCollection properties = ((EntityType)mainEntiy.getAllEntities().get(split[0])).getProperties();
                for (IDataEntityProperty prop : properties) {
                    if (!prop.getName().equalsIgnoreCase(split[1])) continue;
                    this.addFieldKey(entity, fristPartProp.getName(), prop);
                }
            }
        } else {
            if (fristPartProp == null) {
                throw new KDBizException(entity + "." + split[0] + " field not exist!");
            }
            this.addFieldKey(entity, null, fristPartProp);
            if (split.length > 1) {
                this.addRefInfo(entity, fristPartProp.getName(), this.combineArray(split, 1));
            }
        }
    }

    private String combineArray(String[] array, int removeFrontSize) {
        ArrayList<String> strings = new ArrayList<String>(16);
        for (int i = 0; i < array.length; ++i) {
            if (--removeFrontSize >= 0) continue;
            strings.add(array[i]);
        }
        return String.join((CharSequence)".", strings);
    }

    private void addFieldKey(String entity, String entryKey, IDataEntityProperty prop) {
        Map<String, Map<String, IDataEntityProperty>> entryToFields = MapUtils.mapGetMapValue(this.billKeyEntry, entity);
        MapUtils.mapGetMapValue(entryToFields, entryKey).put(prop.getName(), prop);
        if (prop instanceof BasedataProp) {
            String fieldKey = prop.getName();
            String propEntity = ((BasedataProp)prop).getBaseEntityId();
            if ("bd_measureunits".equals(propEntity)) {
                this.addRefInfo(entity, fieldKey, "precision", "precisionaccount");
            } else if ("bd_currency".equals(propEntity)) {
                this.addRefInfo(entity, fieldKey, "amtprecision");
            } else if (MatcherUtil.isUseMasterid(prop)) {
                this.addRefInfo(entity, fieldKey, "masterid");
            }
        }
    }

    private void addRefInfo(String entity, String fieldKey, String ... refProp) {
        Map<String, Set<String>> fieldToRefProp = MapUtils.mapGetMapValue(this.billKeyRefField, entity);
        Set<String> refField = MapUtils.mapGetSetValue(fieldToRefProp, fieldKey);
        for (String ref : refProp) {
            refField.add(ref);
        }
    }

    public Object getObjWithTransDO(WriteOffObjectBase writeOffObject, String sourceColumn) {
        DynamicObject wfDo = writeOffObject.getWriteOffObject();
        if ("PlainObject".equals(wfDo.getDataEntityType().getName())) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)writeOffObject.getWFBillEntityName());
            Map<String, Set<String>> refInfos = this.billKeyRefField.get(writeOffObject.getWFBillEntityName());
            if (refInfos != null && !refInfos.isEmpty()) {
                String[] split;
                for (String field : split = sourceColumn.split("\\.")) {
                    IDataEntityProperty prop = entityType.findProperty(field);
                    if (!(prop instanceof BasedataProp) || prop instanceof AssistantProp || ((BasedataProp)prop).getBaseEntityId() == null) continue;
                    Object dataId = wfDo.get(sourceColumn);
                    if (dataId == null || dataId instanceof Long && Long.compare(0L, (Long)dataId) == 0) {
                        return null;
                    }
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)((BasedataProp)prop).getBaseEntityId());
                    obj.set("id", dataId);
                    Set<String> refFields = refInfos.get(field);
                    if (refFields != null) {
                        for (String refField : refFields) {
                            obj.set(refField, wfDo.get(sourceColumn + "." + refField));
                        }
                    }
                    return obj;
                }
            }
        }
        return writeOffObject.getValue(sourceColumn);
    }
}

