/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import org.apache.commons.lang3.BooleanUtils;

public class WriteOffParamManager {
    private static final Log logger = LogFactory.getLog(WriteOffParamManager.class);
    private Map<String, Object> invParams = null;
    private Set<Long> mergeAutoBillTypes = new HashSet<Long>(16);
    private Map<Long, Set<String>> breakPluginMethods = new HashMap<Long, Set<String>>(16);

    public static WriteOffParamManager create() {
        WriteOffParamManager manager = new WriteOffParamManager();
        manager.loadFromDB();
        return manager;
    }

    private WriteOffParamManager() {
    }

    private void loadFromDB() {
        String key;
        if (this.invParams != null) {
            return;
        }
        this.invParams = new HashMap<String, Object>(16);
        DBRoute route = new DBRoute("scm");
        SqlBuilder imSqlBuilder = new SqlBuilder();
        imSqlBuilder.append("select forgid,fkey,fvalue from t_im_invdbparam where fkey in ('iswriteoffplan','wf_maxhandbillsize','wf_islogkdtxparam','wf_maxquerysize','wf_iswriteoffshare','wf_strictvalidate','wf_isnetctr','wf_newagency','wf_preindatachange')", new Object[0]);
        try (DataSet paramSet = DB.queryDataSet((String)"WriteOffParamManager", (DBRoute)route, (SqlBuilder)imSqlBuilder);){
            HashMap<Long, String> orgAndValueMap = new HashMap<Long, String>(16);
            for (Row param : paramSet) {
                key = param.getString("fkey");
                String paramValue = param.getString("fvalue");
                if ("iswriteoffplan".equals(key)) {
                    orgAndValueMap.put(param.getLong("forgid"), paramValue);
                    continue;
                }
                if (("wf_maxhandbillsize".equals(key) || "wf_maxquerysize".equals(key)) && StringUtils.isNotEmpty((CharSequence)paramValue)) {
                    this.invParams.put(key, Integer.valueOf(paramValue));
                    continue;
                }
                if ("wf_islogkdtxparam".equals(key) && "1".equals(paramValue)) {
                    this.invParams.put(key, Boolean.TRUE);
                    continue;
                }
                if ("wf_iswriteoffshare".equals(key)) {
                    this.parseBooleanValue(key, paramValue);
                    continue;
                }
                if ("wf_strictvalidate".equals(key) && "0".equals(paramValue)) {
                    this.invParams.put(key, Boolean.FALSE);
                    continue;
                }
                if ("wf_newagency".equals(key)) {
                    this.parseBooleanValue(key, paramValue);
                    continue;
                }
                if ("wf_isnetctr".equals(key)) {
                    this.parseBooleanValue(key, paramValue);
                    continue;
                }
                if ("wf_preindatachange".equals(key)) {
                    this.parseBooleanValue(key, paramValue);
                    continue;
                }
                this.invParams.put(key, paramValue);
            }
            this.invParams.put("iswriteoffplan", orgAndValueMap);
        }
        paramSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"msmod_wf_dbparam", (String)"id, writeofftype, key, value", (QFilter[])CommonHelper.getAllFilter().toArray(), (String)"");
        var4_4 = null;
        try {
            for (Row param : paramSet) {
                Long wfType = param.getLong("writeofftype");
                key = param.getString("key");
                String value = param.getString("value");
                if ("mergeAutoBill".equals(key) && "1".equals(value)) {
                    this.mergeAutoBillTypes.add(wfType);
                    continue;
                }
                if (!"breakplugin".equals(key) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                Set<String> classMethods = MapUtils.mapGetSetValue(this.breakPluginMethods, wfType);
                classMethods.add(value);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (paramSet != null) {
                if (var4_4 != null) {
                    try {
                        paramSet.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    paramSet.close();
                }
            }
        }
    }

    private void parseBooleanValue(String key, String paramValue) {
        if ("1".equals(paramValue)) {
            this.invParams.put(key, Boolean.TRUE);
        } else {
            this.invParams.put(key, Boolean.FALSE);
        }
    }

    private boolean getBooleanValue(String key, boolean defaultValue) {
        Boolean paramValue = this.getParamValue(key, Boolean.class);
        if (paramValue == null) {
            paramValue = defaultValue;
        }
        return paramValue;
    }

    private <T> T getParamValue(String key, Class<T> clazz) {
        this.initParam();
        return (T)this.invParams.get(key);
    }

    public Integer getMaxHandleBillSize() {
        Integer paramValue = this.getParamValue("wf_maxhandbillsize", Integer.class);
        if (paramValue == null) {
            paramValue = 5000;
        }
        return paramValue;
    }

    public boolean isLogKdtxParam() {
        Boolean paramValue = this.getParamValue("wf_islogkdtxparam", Boolean.class);
        if (paramValue != null) {
            return paramValue;
        }
        return false;
    }

    public Integer getMaxQuerySize() {
        Integer paramValue = this.getParamValue("wf_maxquerysize", Integer.class);
        if (paramValue == null) {
            paramValue = 10000;
        }
        return paramValue;
    }

    public boolean isWriteOffShare() {
        Boolean paramValue = this.getParamValue("wf_iswriteoffshare", Boolean.class);
        if (paramValue == null) {
            paramValue = true;
        }
        return paramValue;
    }

    public boolean isStrictValidate() {
        return this.getBooleanValue("wf_strictvalidate", true);
    }

    public boolean isNewAgency() {
        return this.getBooleanValue("wf_newagency", true);
    }

    public boolean isNetCtr() {
        return this.getBooleanValue("wf_isnetctr", true);
    }

    public Set<Long> getMergeAutoBillTypes() {
        return this.mergeAutoBillTypes;
    }

    public boolean isBreakPlugin(Long wftypeId, String className, String methodName) {
        Set<String> classNameMethod = this.breakPluginMethods.get(wftypeId);
        if (classNameMethod != null) {
            return classNameMethod.contains(className + "@" + methodName);
        }
        return false;
    }

    private void initParam() {
        if (this.invParams == null) {
            this.loadFromDB();
        }
    }

    public Map<Long, Set<String>> getBreakPluginMethods() {
        return this.breakPluginMethods;
    }

    public static boolean autoBillFullLoad() {
        DBRoute route = new DBRoute("scm");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fkey,fvalue from t_im_invdbparam where fkey in ('wf_autobillfullload')", new Object[0]);
        DataSet paramSet = DB.queryDataSet((String)"WriteOffParamManager", (DBRoute)route, (SqlBuilder)sqlBuilder);
        String value = null;
        for (Row param : paramSet) {
            value = param.getString("fvalue");
        }
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        return BooleanUtils.toBoolean(value);
    }

    public boolean allowUpdatePresetData() {
        return this.getBooleanValue("wf_preindatachange", false);
    }
}

