/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchConditionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.FilterFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.AbstractWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.impl.WFMatchFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.DataTable;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.common.util.MatcherUtil;

public class MatchRelationConfig
implements Cloneable {
    protected static final Log logger = LogFactory.getLog(MatchRelationConfig.class);
    private Long wfTypeId;
    private Long matchId;
    private Long matchEntryId;
    private String srcBillTypeKey;
    private String targetBillTypeKey;
    private String srcBillType;
    private String targetBillType;
    private MatchRuleConfig matchRuleConfig = null;
    private List<MatchConditionConfig> matchConditionConfigs;
    private List<MatchConditionConfig> containConfigs = new ArrayList<MatchConditionConfig>(16);
    private String trackRelation = null;

    static MatchRelationConfig build(MatchRuleConfig matchRuleConfig, DynamicObject matchRelation) {
        MatchRelationConfig matchRelationConfig = new MatchRelationConfig();
        matchRelationConfig.matchRuleConfig = matchRuleConfig;
        DynamicObject srcBillTypeObject = matchRelation.getDynamicObject("srcbilltype");
        String srcBillTypeKey = CommonHelper.getWfBillKey(srcBillTypeObject);
        matchRelationConfig.setSrcBillTypeKey(srcBillTypeKey);
        String srcBillType = srcBillTypeObject == null ? null : srcBillTypeObject.getDynamicObject("wfbill").getString("number");
        matchRelationConfig.setSrcBillType(srcBillType);
        DynamicObject parent = (DynamicObject)matchRelation.getParent();
        DynamicObject wfType = parent.getDynamicObject("writeofftype");
        matchRelationConfig.setMatchId((Long)parent.getPkValue());
        matchRelationConfig.setWfTypeId((Long)wfType.getPkValue());
        matchRelationConfig.setMatchEntryId((Long)matchRelation.getPkValue());
        DynamicObject targetBillTypeObject = matchRelation.getDynamicObject("targetbilltype");
        String targetBillTypeKey = CommonHelper.getWfBillKey(targetBillTypeObject);
        matchRelationConfig.setTargetBillTypeKey(targetBillTypeKey);
        String targetBillType = targetBillTypeObject == null ? null : targetBillTypeObject.getDynamicObject("wfbill").getString("number");
        matchRelationConfig.setTargetBillType(targetBillType);
        DynamicObjectCollection conditions = matchRelation.getDynamicObjectCollection("matchcditsubentry");
        ArrayList<MatchConditionConfig> matchConditionConfigs = new ArrayList<MatchConditionConfig>(16);
        for (DynamicObject matchCondition : conditions) {
            MatchConditionConfig conditionConfig = MatchConditionConfig.build(matchCondition);
            conditionConfig.setSrcBillType(srcBillType);
            conditionConfig.setTargetBillType(targetBillType);
            matchConditionConfigs.add(conditionConfig);
            if (!"C".equals(conditionConfig.getComparison()) && !"D".equals(conditionConfig.getComparison())) continue;
            matchRelationConfig.containConfigs.add(conditionConfig);
        }
        matchRelationConfig.setMatchConditionConfigs(matchConditionConfigs);
        return matchRelationConfig;
    }

    public MatchRelationConfig clone() {
        MatchRelationConfig config;
        try {
            config = (MatchRelationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.matchConditionConfigs != null) {
            ArrayList<MatchConditionConfig> list = new ArrayList<MatchConditionConfig>(16);
            ArrayList<MatchConditionConfig> containList = new ArrayList<MatchConditionConfig>(16);
            for (MatchConditionConfig matchConditionConfig : this.matchConditionConfigs) {
                MatchConditionConfig clone = matchConditionConfig.clone();
                list.add(clone);
                if (!"C".equals(clone.getComparison()) && !"D".equals(clone.getComparison())) continue;
                containList.add(clone);
            }
            config.matchConditionConfigs = list;
            config.containConfigs = containList;
        }
        return config;
    }

    public List<String> getMatchCondtionFields() {
        return this.matchConditionConfigs.stream().map(MatchConditionConfig::getSrcBillFieldKey).collect(Collectors.toList());
    }

    public List<MatchConditionConfig> getMatchConditionConfigs() {
        return this.matchConditionConfigs;
    }

    private void setMatchConditionConfigs(List<MatchConditionConfig> matchConditionConfigs) {
        this.matchConditionConfigs = matchConditionConfigs;
    }

    public String getSrcBillTypeKey() {
        return this.srcBillTypeKey;
    }

    public void setSrcBillTypeKey(String srcBillTypeKey) {
        this.srcBillTypeKey = srcBillTypeKey;
    }

    public String getTargetBillTypeKey() {
        return this.targetBillTypeKey;
    }

    public void setTargetBillTypeKey(String targetBillTypeKey) {
        this.targetBillTypeKey = targetBillTypeKey;
    }

    public String getSrcBillType() {
        return this.srcBillType;
    }

    public void setSrcBillType(String srcBillType) {
        this.srcBillType = srcBillType;
    }

    public String getTargetBillType() {
        return this.targetBillType;
    }

    public void setTargetBillType(String targetBillType) {
        this.targetBillType = targetBillType;
    }

    public Long getMatchEntryId() {
        return this.matchEntryId;
    }

    public void setMatchEntryId(Long matchEntryId) {
        this.matchEntryId = matchEntryId;
    }

    public Long getMatchId() {
        return this.matchId;
    }

    public void setMatchId(Long matchId) {
        this.matchId = matchId;
    }

    public Long getWfTypeId() {
        return this.wfTypeId;
    }

    public void setWfTypeId(Long wfTypeId) {
        this.wfTypeId = wfTypeId;
    }

    public List<MatchConditionConfig> getHintConfigs() {
        return this.getMatchConditionConfigs().stream().filter(n -> n.getHint()).collect(Collectors.toList());
    }

    public boolean isOnHint() {
        List<MatchConditionConfig> hintConfigs = this.getHintConfigs();
        return hintConfigs != null && !hintConfigs.isEmpty();
    }

    public String toString() {
        return "[srcBillType=" + this.srcBillType + ", targetBillType=" + this.targetBillType + "]";
    }

    public List<QFilter> getHintFilter(List<WriteOffMatchGroup> groups, String wfMainFieldId) {
        List<MatchConditionConfig> hintFieldConfigs = this.matchConditionConfigs.stream().filter(n -> n.getHint()).collect(Collectors.toList());
        String[] hintFields = new String[hintFieldConfigs.size()];
        int index = 0;
        for (MatchConditionConfig hintConfig : hintFieldConfigs) {
            hintFields[index] = hintConfig.getSrcBillFieldKey();
            ++index;
        }
        DataTable hintDataTable = DataTable.create(hintFields);
        int i = 0;
        for (MatchConditionConfig matchConditionConfig : this.matchConditionConfigs) {
            if (matchConditionConfig.getHint().booleanValue()) {
                long id = 0L;
                for (WriteOffMatchGroup writeOffMatchGroup : groups) {
                    Object dimValue = writeOffMatchGroup.getMatchKeys().get(i);
                    hintDataTable.addData(id, matchConditionConfig.getSrcBillFieldKey(), dimValue);
                    ++id;
                }
            }
            ++i;
        }
        List<QFilter> filters = MatcherUtil.buildQueryFilter(hintFieldConfigs, hintDataTable, wfMainFieldId);
        for (MatchConditionConfig containConfig : this.containConfigs) {
            filters.add(new QFilter(containConfig.getTargetBillFieldKey(), "not in", Arrays.asList("", " ", "  ")));
        }
        return filters;
    }

    public List<IWFFilter> buildMatchRuleFilter(WriteOffMatchGroup matchGroup, String matchWfFieldId, boolean isDBFilter) {
        List<MatchConditionConfig> conditions = this.getMatchConditionConfigs();
        String targetBillType = this.getTargetBillType();
        ArrayList<IWFFilter> filters = new ArrayList<IWFFilter>(16);
        List<Object> matchKeys = matchGroup.getMatchKeys();
        for (int i = 0; i < conditions.size(); ++i) {
            MatchConditionConfig config = conditions.get(i);
            String comparison = config.comparisonResver();
            if ("C".equals(comparison) || "D".equals(comparison)) {
                if (!isDBFilter) continue;
                filters.add(new WFMatchFilter(config.getTargetBillFieldKey(), "not in", Arrays.asList("", " ", "  ")));
                continue;
            }
            String fieldKey = config.getTargetBillFieldKey();
            IDataEntityProperty tgtPropType = config.getTgtPropType();
            if (MatcherUtil.isUseMasterid(tgtPropType) && !(tgtPropType instanceof ItemClassProp)) {
                fieldKey = fieldKey + ".masterid";
            }
            Object dataValue = matchKeys.get(i);
            Set<Object> targetValue = DynamicObjectUtil.getObjectPk(dataValue);
            if ("ap_finapbill".equals(targetBillType) && ("detailentry.e_sourcebillid".equals(fieldKey) || "detailentry.e_sourcebillentryid".equals(fieldKey))) {
                targetValue = String.valueOf(targetValue);
            }
            AbstractWFFilter qFilterConditon = null;
            if (config.checkEmptyValue(targetValue)) {
                qFilterConditon = config.getEmptyEqual().booleanValue() ? FilterFactory.createEqualsEmpty(config.getTargetBillFieldKey(), tgtPropType, targetValue) : FilterFactory.createFalse();
            } else if (targetValue instanceof List && "=".equals(comparison)) {
                qFilterConditon = new WFMatchFilter(fieldKey, "in", targetValue);
            } else if (isDBFilter && tgtPropType instanceof ItemClassProp) {
                IDataEntityProperty srcProp = config.getSrcPropType();
                if (srcProp instanceof BasedataProp) {
                    String srcEntity = ((BasedataProp)srcProp).getBaseEntityId();
                    if ("bd_customer".equals(srcEntity)) {
                        targetValue = this.getControlDataIds("bd_customer", targetValue);
                    } else if ("bd_supplier".equals(srcEntity)) {
                        targetValue = this.getControlDataIds("bd_supplier", targetValue);
                    }
                    qFilterConditon = new WFMatchFilter(fieldKey, "in", targetValue);
                }
            } else {
                qFilterConditon = new WFMatchFilter(fieldKey, comparison, targetValue);
            }
            filters.add(qFilterConditon);
            if (!(qFilterConditon instanceof AbstractWFFilter)) continue;
            WriteOffMatchConditionInfo matchCondition = new WriteOffMatchConditionInfo();
            matchCondition.setPropName(config.getTargetBillFieldName());
            matchCondition.setComparison(comparison);
            Object name = DynamicObjectUtil.getObjectName(dataValue);
            matchCondition.setValue(name == null ? "" : name.toString());
            ((AbstractWFFilter)qFilterConditon).setInfo(matchCondition);
        }
        return filters;
    }

    private Set<Object> getControlDataIds(String dataEntity, Object masterid) {
        Map values = BusinessDataServiceHelper.loadFromCache((String)dataEntity, (String)"id", (QFilter[])new QFilter("masterid", "=", masterid).toArray());
        HashSet<Object> ids = new HashSet<Object>(16);
        ids.add(masterid);
        ids.addAll(values.keySet());
        return ids;
    }

    public MatchRuleConfig getMatchRuleConfig() {
        return this.matchRuleConfig;
    }

    public String getTrackRelation() {
        return this.trackRelation;
    }

    public void setTrackRelation(String trackRelation) {
        this.trackRelation = trackRelation;
    }

    public boolean hasContainLogic() {
        return !this.containConfigs.isEmpty();
    }

    public List<DynamicObject> executeContainLogic(List<DynamicObject> matchedBillData, WriteOffMatchGroup writeOffMatchGroup) {
        List<WriteOffObject> objects = writeOffMatchGroup.getWriteOffObjects();
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<DynamicObject> iterator = matchedBillData.iterator();
        block0: while (iterator.hasNext()) {
            DynamicObject matchEntry = iterator.next();
            for (MatchConditionConfig cConfig : this.containConfigs) {
                String targetText = null;
                String containText = null;
                if ("C".equals(cConfig.getComparison())) {
                    targetText = (String)objects.get(0).getValue(cConfig.getSrcBillFieldKey());
                    containText = (String)matchEntry.get(cConfig.getTargetBillFieldKey());
                } else {
                    targetText = (String)matchEntry.get(cConfig.getTargetBillFieldKey());
                    containText = (String)objects.get(0).getValue(cConfig.getSrcBillFieldKey());
                }
                if (StringUtils.isBlank((CharSequence)containText) || StringUtils.isBlank((CharSequence)targetText)) {
                    iterator.remove();
                    continue block0;
                }
                if (targetText.contains(containText)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return matchedBillData;
    }
}

