/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;

public class RecordColumnFunctionConfig {
    private final String functionStr;
    private String entity;
    private CRCondition condition;
    private BOSExpression bosExpression;
    private Expr expr;
    private Set<String> params;
    private Map<String, String> paramsFullKey = new HashMap<String, String>();

    private RecordColumnFunctionConfig(String functionStr) {
        this.functionStr = functionStr;
    }

    public static RecordColumnFunctionConfig build(String entity, String functionStr) {
        RecordColumnFunctionConfig config = new RecordColumnFunctionConfig(functionStr);
        config.entity = entity;
        config.init();
        return config;
    }

    private void init() {
        if (StringUtils.isEmpty((CharSequence)this.functionStr)) {
            return;
        }
        this.condition = (CRCondition)SerializationUtils.fromJsonString((String)this.functionStr, CRCondition.class);
        String expression = this.condition.getExpression();
        this.bosExpression = new BOSExpression(expression);
        this.expr = ExprParser.parse((String)this.bosExpression.getExpression());
        this.params = this.bosExpression.getVars();
        if (this.params != null) {
            this.params.remove("curdata");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.entity);
            this.paramsFullKey = new HashMap<String, String>(16);
            for (String column : this.params) {
                IDataEntityProperty property = mainEntityType.findProperty(column);
                if (property != null && property.getParent() instanceof EntryType) {
                    this.paramsFullKey.put(column, property.getParent().getName() + "." + column);
                    continue;
                }
                this.paramsFullKey.put(column, column);
            }
        }
    }

    public Map<String, String> getParamFullKey() {
        return this.paramsFullKey;
    }

    public CRCondition getCondition() {
        return this.condition;
    }

    public String getFunctionStr() {
        return this.functionStr;
    }

    public Set<String> getParams() {
        return this.params;
    }

    public BOSExpression getBosExpression() {
        return this.bosExpression;
    }

    public Expr getExpr() {
        return this.expr;
    }
}

