/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.DecimalProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.plugin.mainfield.impl.BillFieldWFMainFieldCal;
import kd.mpscmm.mscommon.writeoff.business.engine.core.plugin.mainfield.impl.FormulaWFMainFieldCal;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class WFFieldInfo {
    private String billEntityType;
    private Long id;
    private String valueMethod;
    private String fieldKey;
    private IWriteOffMainFieldCalPlugin mainFieldCalClass;
    private String formula;

    private WFFieldInfo(String billEntityType, String valueMethod, String fieldKey, IWriteOffMainFieldCalPlugin mainFieldCalClass) {
        this.billEntityType = billEntityType;
        this.valueMethod = valueMethod;
        this.fieldKey = fieldKey;
        this.mainFieldCalClass = mainFieldCalClass;
    }

    public static WFFieldInfo buildFieldKey(String billEntityType, String fieldKey) {
        BillFieldWFMainFieldCal fieldCal = BillFieldWFMainFieldCal.build(fieldKey);
        if (StringUtils.isNotEmpty((CharSequence)billEntityType)) {
            String[] fieldInfos = fieldKey.split("\\.");
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityType);
            IDataEntityProperty property = entityType.findProperty(fieldInfos[fieldInfos.length - 1]);
            if (property instanceof DecimalProp) {
                String controlPropName = ((DecimalProp)property).getControlPropName();
                IDataEntityProperty controlProp = entityType.findProperty(controlPropName);
                fieldCal.setRelFieldProp(controlProp);
            }
        }
        return new WFFieldInfo(billEntityType, "A", fieldKey, fieldCal);
    }

    public static WFFieldInfo buildPlugin(String billEntityType, String pluginField, Long wfTypeBillEntryId) {
        IWriteOffMainFieldCalPlugin fieldPlugin = WfPluginExtFactory.getWfMainFiledPlugin(pluginField, wfTypeBillEntryId);
        String name = fieldPlugin.getClass().getName();
        return new WFFieldInfo(billEntityType, "C", name, fieldPlugin);
    }

    public static WFFieldInfo buildFormula(String billEntityType, DynamicObject configObj, String formula) {
        FormulaWFMainFieldCal fieldCal = FormulaWFMainFieldCal.build(configObj);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
        String expression = condition.getExpression();
        WFFieldInfo wfFieldInfo = new WFFieldInfo(billEntityType, "B", expression, fieldCal);
        wfFieldInfo.formula = formula;
        return wfFieldInfo;
    }

    public String getWriteOffFieldKey() {
        return this.fieldKey;
    }

    public boolean isWfBillField() {
        return !"B".equals(this.valueMethod) && !"C".equals(this.valueMethod);
    }

    public IWriteOffMainFieldCalPlugin getMainFieldCalClass() {
        return this.mainFieldCalClass;
    }

    public String getWfCalcFieldIdName() {
        if (this.isWfBillField()) {
            String mainField = this.getWriteOffFieldKey();
            String[] fields = mainField.split("\\.");
            String filed = fields[fields.length - 1];
            String fieldKey = mainField.substring(0, mainField.length() - filed.length());
            return fieldKey + "id";
        }
        if ("B".equals(this.valueMethod)) {
            String entryKey = WriteOffObjectManager.expressionEntry(this.formula, this.billEntityType);
            String result = entryKey == null ? "" : entryKey + ".";
            return result + "id";
        }
        if ("C".equals(this.valueMethod)) {
            String entryKey = this.mainFieldCalClass.mainFieldEntry();
            if (StringUtils.isEmpty((CharSequence)entryKey) || this.billEntityType.equalsIgnoreCase(entryKey)) {
                return "id";
            }
            return entryKey + ".id";
        }
        return null;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }
}

