/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.config.vo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.AbstractObjMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillBotpConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.EntityParseHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;

public class WriteOffTypeConfig
extends AbstractObjMappingConfig {
    private boolean leftRightRecord;
    private WriteoffTemplateTypeEnum wfRecordTemplateEnum;
    private String wfRecordTemplateNum;
    private String recordNum;
    private String recordEntryType;
    private String writeBackPluginName;
    private Integer priority = Integer.MAX_VALUE;
    private List<WriteOffBillConfig> billConfigs = new ArrayList<WriteOffBillConfig>(16);
    private String wfseq;
    @Deprecated
    private Map<String, Object> wfExtParams = new HashMap<String, Object>(16);
    private boolean isMergeAutoBill = false;

    public static WriteOffTypeConfig buildById(Long typeId) {
        DynamicObject writeOffObj = BusinessDataServiceHelper.loadSingleFromCache((Object)typeId, (String)"msmod_writeofftype");
        return WriteOffTypeConfig.build(writeOffObj);
    }

    public static WriteOffTypeConfig build(DynamicObject writeOffTypeEntity) {
        WriteOffTypeConfig config = new WriteOffTypeConfig(writeOffTypeEntity);
        config.initRecordInfo();
        config.initWriteOffBillConfig();
        return config;
    }

    private void initRecordInfo() {
        DynamicObject writeOffRecordObj = this.getObj().getDynamicObject("writeoffrecordbill");
        if (writeOffRecordObj != null) {
            WriteoffTemplateTypeEnum wfTemplateType;
            String recordNum;
            this.recordNum = recordNum = writeOffRecordObj.getString("number");
            this.recordEntryType = "entry";
            this.wfRecordTemplateEnum = wfTemplateType = WriteOffRecordHelper.getWfTemplateTypeByChildEntity(recordNum);
            MainEntityType inheritEntity = EntityParseHelper.getInheritEntity(recordNum);
            if (inheritEntity != null) {
                String templateName;
                this.wfRecordTemplateNum = templateName = inheritEntity.getName();
            }
        }
    }

    private void initWriteOffBillConfig() {
        DynamicObjectCollection writeOffBillEntities = this.getObj().getDynamicObjectCollection("writeoffbillentry");
        HashMap<String, WriteOffBillConfig> billConfigMap = new HashMap<String, WriteOffBillConfig>(writeOffBillEntities.size());
        for (DynamicObject writeOffBillEntry : writeOffBillEntities) {
            WriteOffBillConfig writeOffBillConfig = WriteOffBillConfig.build(writeOffBillEntry);
            writeOffBillConfig.setTypeConfig(this);
            billConfigMap.put(writeOffBillConfig.getBillAlias(), writeOffBillConfig);
            this.billConfigs.add(writeOffBillConfig);
        }
        this.billConfigs.sort(Comparator.comparingInt(WriteOffBillConfig::getSeq));
        DynamicObjectCollection autoGenerateBillEntities = this.getObj().getDynamicObjectCollection("autogenebillentry");
        for (DynamicObject autoGenerateBillEntry : autoGenerateBillEntities) {
            String tgtBillAlias;
            WriteOffBillConfig tgtWFBEntry;
            BillBotpConfig billBotpConfig = BillBotpConfig.build(autoGenerateBillEntry, this);
            String srcBillAlias = billBotpConfig.getSrcBillAlias();
            WriteOffBillConfig srcWFBEntry = (WriteOffBillConfig)billConfigMap.get(srcBillAlias);
            if (srcWFBEntry != null) {
                billBotpConfig.setSrcBillType(srcWFBEntry.getBillType());
                srcWFBEntry.getBillBotpConfigs().add(billBotpConfig);
            }
            if ((tgtWFBEntry = (WriteOffBillConfig)billConfigMap.get(tgtBillAlias = billBotpConfig.getTargetBillAlias())) == null) continue;
            billBotpConfig.setTargetBillType(tgtWFBEntry.getBillType());
            billBotpConfig.setNeedGenerate(tgtWFBEntry.getObj().getBoolean("isinvolved"));
        }
    }

    private WriteOffTypeConfig(DynamicObject obj) {
        super(obj);
    }

    public Long getId() {
        return DynamicObjectUtil.getPkValue(this.getObj());
    }

    public String getName() {
        return this.getObj().getString("name");
    }

    public boolean isNeedGenerate() {
        for (WriteOffBillConfig writeOffBillConfig : this.billConfigs) {
            if (!writeOffBillConfig.isNeedGenerate()) continue;
            return true;
        }
        return false;
    }

    public WriteOffBillConfig getBillConfigsById(Long wfBillId) {
        return this.billConfigs.stream().filter(n -> n.getObjId().equals(wfBillId)).findFirst().orElse(null);
    }

    public WriteOffBillConfig getBillConfigsByMainFieldId(Long wfBillId) {
        return this.billConfigs.stream().filter(n -> n.getWriteOffColumnConfig().getObjId().equals(wfBillId)).findFirst().orElse(null);
    }

    public boolean isLeftRightRecord() {
        return this.leftRightRecord;
    }

    public void setLeftRightRecord(boolean leftRightRecord) {
        this.leftRightRecord = leftRightRecord;
    }

    public WriteoffTemplateTypeEnum getWfRecordTemplateEnum() {
        return this.wfRecordTemplateEnum;
    }

    public String getWfRecordTemplateNum() {
        return this.wfRecordTemplateNum;
    }

    public String getRecordNum() {
        return this.recordNum;
    }

    @Deprecated
    public WriteoffTemplateTypeEnum getWfTemplateType() {
        return this.wfRecordTemplateEnum;
    }

    @Deprecated
    public String getWfRecordType() {
        return this.wfRecordTemplateNum;
    }

    @Deprecated
    public String getRecordBillType() {
        return this.recordNum;
    }

    public String getRecordEntryType() {
        return this.recordEntryType;
    }

    public String getWriteOffPluginName() {
        return this.getObj().getString("writeoffplugin");
    }

    public String getWriteBackPluginName() {
        return this.writeBackPluginName;
    }

    public void setWriteBackPluginName(String writeBackPluginName) {
        this.writeBackPluginName = writeBackPluginName;
    }

    public List<WriteOffBillConfig> getBillConfigs() {
        return this.billConfigs;
    }

    public List<WriteOffBillConfig> getNoAutoBillConfigs() {
        return this.billConfigs.stream().filter(n -> !n.isNeedGenerate()).collect(Collectors.toList());
    }

    public void setBillConfigs(List<WriteOffBillConfig> billConfigs) {
        this.billConfigs = billConfigs;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        if (priority != null) {
            this.priority = priority;
        }
    }

    public List<Long> getRecordMappingIdByWfType() {
        ArrayList<Long> mappingIds = new ArrayList<Long>(4);
        DynamicObjectCollection wfBills = this.getObj().getDynamicObjectCollection("writeoffbillentry");
        for (DynamicObject wfBill : wfBills) {
            DynamicObject mapping = wfBill.getDynamicObject("wfmapping");
            if (mapping == null) continue;
            mappingIds.add((Long)mapping.getPkValue());
        }
        return mappingIds;
    }

    public WriteOffBillConfig getBillConf(String billAlias) {
        return this.billConfigs.stream().filter(n -> n.getBillAlias().equals(billAlias)).findFirst().orElse(null);
    }

    public String getWriteoffType() {
        return this.getObj().getString("writeofftype");
    }

    @Deprecated
    public boolean isFeeShare() {
        return this.getObj().getBoolean("isfeeshare");
    }

    public String getWfseq() {
        return this.wfseq;
    }

    public void setWfseq(String wfseq) {
        this.wfseq = wfseq;
    }

    public Map<String, Object> getWfExtParams() {
        return this.wfExtParams;
    }

    public void setWfExtParams(Map<String, Object> wfExtParams) {
        this.wfExtParams = wfExtParams;
    }

    public boolean isMergeAutoBill() {
        return this.isMergeAutoBill;
    }

    public void setMergeAutoBill(boolean isMergeAutoBill) {
        this.isMergeAutoBill = isMergeAutoBill;
    }

    public String getType() {
        return this.getObj().getString("writeofftype");
    }

    public String getTypeName() {
        return this.getObj().getString("name");
    }

    public boolean isRBWriteOff() {
        try {
            List<WriteOffBillConfig> billConfigs = this.getBillConfigs();
            if (billConfigs.size() == 2) {
                return StringUtils.equals((CharSequence)billConfigs.get(0).getBillType(), (CharSequence)billConfigs.get(1).getBillType());
            }
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error("WriteOffTypeCheckRB erro:", (Throwable)e);
        }
        return false;
    }
}

