/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteBackConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.AutoBillContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.IWFSnapshotQtyHolder;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.WFSnapshotContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.HintDataMatcher;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WFRecordManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.PluginFactory;
import kd.sdk.mpscmm.mscommon.writeoff.params.GeneratorBillWf;

public class WriteOffTypeContext
implements IWFSnapshotQtyHolder {
    private String billTypeKey = "";
    private List<WriteOffMatchGroup> writeOffMatchGroups;
    private WriteOffTypeConfig typeConfig;
    private WriteOffNLogInfo writeOffLog;
    private WriteOffExecuteContext executeContext;
    private WFSnapshotContext snapshotContext;
    private AutoBillContext autoBillContext;
    private WFRecordManager recordManager = new WFRecordManager();
    private Map<String, Object> custParams = new HashMap<String, Object>(16);
    private HintDataMatcher hintDataLoader = new HintDataMatcher();
    private Map<Object, WriteOffObject> redBuleSrcObjs = new HashMap<Object, WriteOffObject>(16);

    public WriteOffTypeContext(WriteOffExecuteContext executeContext, WriteOffTypeConfig wfType) {
        this.typeConfig = wfType;
        this.executeContext = executeContext;
        this.autoBillContext = new AutoBillContext(wfType);
        this.snapshotContext = new WFSnapshotContext(wfType);
    }

    public void addRecordBill(WriteOffRecordMapper writeOffRecordMapper) {
        WriteBackConfig writeBackConfig = this.getExecuteContext().getConfigManager().getWriteBackConfigById(this.typeConfig.getId());
        writeOffRecordMapper.initBackWrite(this.typeConfig, writeBackConfig);
        this.snapshotContext.addSnapShots(writeOffRecordMapper.getNeedAddSnapShoot());
        this.recordManager.addRecord(writeOffRecordMapper);
    }

    @Override
    public BigDecimal getWriteOffQty(WriteOffObject writeOffObj) {
        return this.snapshotContext.getWriteOffQty(writeOffObj);
    }

    public String getBillTypeKey() {
        return this.billTypeKey;
    }

    public void setBillTypeKey(String billTypeKey) {
        this.billTypeKey = billTypeKey;
    }

    public WriteOffExecuteContext getExecuteContext() {
        return this.executeContext;
    }

    @Deprecated
    public void addAutoBill(List<GeneratorBillWf> generateBills) {
        this.autoBillContext.addAutoBill(generateBills);
    }

    public void loadSnapShootMap(Collection<Object> ids, String entityName) {
        this.snapshotContext.loadSnapShootMap(ids, entityName);
    }

    public AutoBillContext getAutoBillContext() {
        return this.autoBillContext;
    }

    @Deprecated
    public Map<String, DynamicObject> getAutoBillHeadMapping() {
        return this.autoBillContext.getAutoBillHeadMapping();
    }

    public boolean isMergeAutoBill() {
        return this.typeConfig.isMergeAutoBill();
    }

    public WriteOffTypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    public WFRecordManager getRecordManager() {
        return this.recordManager;
    }

    public WFSnapshotContext getSnapshotContext() {
        return this.snapshotContext;
    }

    public WriteOffNLogInfo getWriteOffLog() {
        return this.writeOffLog;
    }

    public boolean isMatch() {
        return this.getBooleanFromCustParam("ismatch");
    }

    public boolean isWriteOff() {
        return this.getBooleanFromCustParam("canwriteoff");
    }

    void setManualWriteOff(boolean manualWriteOff) {
        this.custParams.put("isManualWriteOff", manualWriteOff);
    }

    public boolean isManualWriteOff() {
        return this.getBooleanFromCustParam("isManualWriteOff");
    }

    private boolean getBooleanFromCustParam(String key) {
        Object isMatch = this.custParams.get(key);
        if (isMatch != null) {
            return (Boolean)isMatch;
        }
        return false;
    }

    void setWriteOffLog(WriteOffNLogInfo writeOffLog) {
        this.writeOffLog = writeOffLog;
    }

    public void addMatchParams(Long schemeId, Map<String, List<List<Map<String, Object>>>> value) {
        Map<Long, Map<String, List<List<Map<String, Object>>>>> preMatchData = this.getPreMatchMap();
        Map<String, List<List<Map<String, Object>>>> params = MapUtils.mapGetMapValue(preMatchData, schemeId);
        params.putAll(value);
    }

    public Map<Long, Map<String, List<List<Map<String, Object>>>>> getPreMatchMap() {
        HashMap preMatchData = (HashMap)this.custParams.get("preMatchData");
        if (preMatchData == null) {
            preMatchData = new HashMap(16);
            this.custParams.put("preMatchData", preMatchData);
        }
        return preMatchData;
    }

    public void addMatchParams(String key, Object value) {
        this.custParams.put(key, value);
    }

    public Map<String, Object> getCustParams() {
        return this.custParams;
    }

    public List<WriteOffMatchGroup> getMatchGroup() {
        return this.writeOffMatchGroups;
    }

    public void setMatchGroup(List<WriteOffMatchGroup> matchGroups) {
        this.writeOffMatchGroups = matchGroups;
    }

    public HintDataMatcher getHintDataLoader() {
        return this.hintDataLoader;
    }

    public PluginFactory getPluginFactory() {
        return this.executeContext.getPluginFactory();
    }

    public void addRedBuleSrcObject(Map<String, Map<Object, WriteOffObject>> billToObjs) {
        for (Map<Object, WriteOffObject> objs : billToObjs.values()) {
            this.redBuleSrcObjs.putAll(objs);
        }
    }

    public boolean isRBWriteOffTogether() {
        return !this.redBuleSrcObjs.isEmpty();
    }

    public WriteOffObject getRBWriteOffObject(Object pkValue) {
        return this.redBuleSrcObjs.get(pkValue);
    }
}

