/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffConfigManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.BillSortConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchConditionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WorkflowBillOperateConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WorkflowSchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteBackConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteBackRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MatcherUtil;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class BillSelectFieldLoadAction
extends AbstractWriteOffAction {
    @Override
    protected void doAction() {
        Set fields;
        Object sourceBillType;
        WriteOffConfigManager configManager = this.getConfigManager();
        HashMap entityConfigedFields = new HashMap(16);
        List<WriteOffTypeConfig> allWriteOffTypeConfigs = configManager.getAllWriteOffTypeConfigs();
        for (WriteOffTypeConfig typeConfig : allWriteOffTypeConfigs) {
            List<WriteOffBillConfig> billConfigs = typeConfig.getBillConfigs();
            Iterator<WriteOffBillConfig> iterator = billConfigs.iterator();
            while (iterator.hasNext()) {
                String wholeFieldKey;
                WriteOffBillConfig writeOffBillConfig = iterator.next();
                String string = writeOffBillConfig.getBillType();
                Set needFields = MapUtils.mapGetSetValue(entityConfigedFields, string);
                needFields.addAll(this.addFixFields(string));
                if (writeOffBillConfig.getWriteOffColumnConfig() != null) {
                    needFields.add(writeOffBillConfig.getWfCalcFieldIdName());
                }
                if (StringUtils.isNotEmpty((CharSequence)(wholeFieldKey = writeOffBillConfig.getWholeFieldKey()))) {
                    needFields.add(wholeFieldKey);
                }
                Set<String> fields2 = CommonUtils.wfTypeQfiterFieldPathDeal(string, writeOffBillConfig.getFieldList());
                needFields.addAll(fields2);
                List<WriteOffColumnConfig> columnConfigs = writeOffBillConfig.getWriteOffColumnConfigs();
                for (WriteOffColumnConfig columnConfig : columnConfigs) {
                    IWriteOffMainFieldCalPlugin fieldCalClass = columnConfig.mainFieldCalClass();
                    List<String> calNeedFields = fieldCalClass.calNeedFields();
                    needFields.addAll(calNeedFields);
                }
            }
            WriteBackConfig iterator2 = configManager.getWriteBackConfigById(typeConfig.getId());
            if (iterator2 == null) continue;
            List<WriteBackRuleConfig> list = iterator2.getBackRuleConfigs();
            for (WriteBackRuleConfig writeBackRuleConfig : list) {
                sourceBillType = writeBackRuleConfig.getSourceBillType();
                String recordColumn = writeBackRuleConfig.getSourceColumn();
                MapUtils.mapGetSetValue(entityConfigedFields, sourceBillType).add(recordColumn);
            }
        }
        Map<String, Set<String>> prePareFieldMap = WfPluginExtFactory.getPrePareFieldMap(allWriteOffTypeConfigs);
        MapUtils.addSet(entityConfigedFields, prePareFieldMap);
        Collection<RecordMappingConfig> allConfig = configManager.getAllConfig();
        for (RecordMappingConfig recordMappingConfig : allConfig) {
            String string = recordMappingConfig.getSrcEntity();
            Set set = (Set)entityConfigedFields.get(string);
            if (set == null) continue;
            List<RecordColumnConfig> recordColumnConfigs = recordMappingConfig.getRecordColumnConfigs();
            sourceBillType = recordColumnConfigs.iterator();
            while (sourceBillType.hasNext()) {
                RecordColumnConfig columnConifg = (RecordColumnConfig)sourceBillType.next();
                if ("0".equals(columnConifg.getSelectValue())) {
                    set.add(columnConifg.getSourceColumn());
                    continue;
                }
                if ("curdata".equals(columnConifg.getExpression())) continue;
                fields = CommonUtils.wfTypeQfiterFieldPathDeal(string, columnConifg.getFunctionParam());
                set.addAll(fields);
            }
        }
        List<SchemeConfig> allSchemeConfigs = configManager.getAllSchemeConfigs();
        for (SchemeConfig schemeConfig : allSchemeConfigs) {
            Object sortBillEntity;
            List<BillSortConfig> list = schemeConfig.getBillSortConfigs();
            for (BillSortConfig billSortConfig : list) {
                sortBillEntity = billSortConfig.getSortBillEntity();
                String fieldNo = billSortConfig.getFieldNo();
                MapUtils.mapGetSetValue(entityConfigedFields, sortBillEntity).add(fieldNo);
            }
            MatchRuleConfig matchRuleConfig = configManager.getMatchRuleConfigBySchemeId(schemeConfig.getId(), schemeConfig.getWriteOffTypeId());
            if (matchRuleConfig == null) continue;
            List<MatchRelationConfig> relationConfigs = matchRuleConfig.getRelationConfigs();
            sortBillEntity = relationConfigs.iterator();
            while (sortBillEntity.hasNext()) {
                MatchRelationConfig matchRelationConfig = (MatchRelationConfig)sortBillEntity.next();
                Set srcEntityField = MapUtils.mapGetSetValue(entityConfigedFields, matchRelationConfig.getSrcBillType());
                Set tgtEntityField = MapUtils.mapGetSetValue(entityConfigedFields, matchRelationConfig.getTargetBillType());
                List<MatchConditionConfig> matchConfigs = matchRelationConfig.getMatchConditionConfigs();
                for (MatchConditionConfig config : matchConfigs) {
                    IDataEntityProperty tgtPropType;
                    IDataEntityProperty srcPropType = config.getSrcPropType();
                    if (srcPropType != null) {
                        String srcBillFieldKey = config.getSrcBillFieldKey();
                        srcEntityField.add(srcBillFieldKey);
                        if (MatcherUtil.isUseMasterid(srcPropType)) {
                            srcEntityField.add(srcBillFieldKey + ".masterid");
                        }
                    }
                    if ((tgtPropType = config.getTgtPropType()) == null) continue;
                    String targetBillFieldKey = config.getTargetBillFieldKey();
                    tgtEntityField.add(targetBillFieldKey);
                    if (!MatcherUtil.isUseMasterid(tgtPropType)) continue;
                    tgtEntityField.add(targetBillFieldKey + ".masterid");
                }
            }
        }
        List<WorkflowSchemeConfig> list = this.getConfigManager().getAllWorkflowScheme();
        for (WorkflowSchemeConfig workflowSchemeConfig : list) {
            List<WorkflowBillOperateConfig> operateConfigs = workflowSchemeConfig.getOperateConfigs();
            for (WorkflowBillOperateConfig opConfig : operateConfigs) {
                String billType = opConfig.getBillType();
                Set needFields = MapUtils.mapGetSetValue(entityConfigedFields, billType);
                Set<String> fields3 = CommonUtils.wfTypeQfiterFieldPathDeal(billType, opConfig.getFieldList());
                needFields.addAll(fields3);
            }
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"msmod_loadbillfield", (String)"billentity, entryentity.fieldkey,entryentity.reffield", (QFilter[])new QFilter("billentity", "in", entityConfigedFields.keySet()).toArray());
        for (DynamicObject fieldConfig : dynamicObjectCollection) {
            String[] reffields;
            String billEntity = fieldConfig.getString("billentity");
            String fieldKey = fieldConfig.getString("entryentity.fieldkey");
            Set configFields = MapUtils.mapGetSetValue(entityConfigedFields, billEntity);
            configFields.add(fieldKey);
            String reffield = fieldConfig.getString("entryentity.reffield");
            if (!StringUtils.isNotEmpty((CharSequence)reffield)) continue;
            for (String field : reffields = reffield.split(",")) {
                configFields.add(fieldKey + "." + field);
            }
        }
        BillFieldInfoManager billFieldInfoManager = ((WriteOffExecuteContext)this.getExecuteContext()).getBillFieldInfo();
        for (Map.Entry entityConfigField : entityConfigedFields.entrySet()) {
            String entity = (String)entityConfigField.getKey();
            fields = (Set)entityConfigField.getValue();
            for (String field : fields) {
                billFieldInfoManager.addFullFieldKey(entity, field);
            }
        }
    }

    private Set<String> addFixFields(String billEntity) {
        HashSet<String> fileds = new HashSet<String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
        Map allFields = dataEntityType.getAllFields();
        IDataEntityProperty orgPro = (IDataEntityProperty)allFields.get("org");
        if (orgPro != null && orgPro.getParent() != null && orgPro.getParent() instanceof BillEntityType) {
            fileds.add("org");
        }
        fileds.add("id");
        fileds.add("billno");
        return fileds;
    }
}

