/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeContextManualConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.AbstractManualBillGroupAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.FilterFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffManualEntity;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffManualGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.ManualWriteOffReqParam;
import org.apache.commons.collections.CollectionUtils;

public class ManualBillGroupAction
extends AbstractManualBillGroupAction {
    public static final String WFFIELD_FORMULA = "B";
    public static final String WFFIELD_PLUGIN = "C";
    public static final String SPIT = "@@";

    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CollectionUtils.isEmpty(this.getConfigManager().getAllWriteOffTypeConfigs());
    }

    @Override
    protected List<WriteOffManualGroup> getManuBillGroup() {
        WriteOffExecuteContext executeContext = (WriteOffExecuteContext)this.getExecuteContext();
        Integer maxHandleBillSize = executeContext.getWfParam().getMaxHandleBillSize();
        ManualWriteOffReqParam reqParam = (ManualWriteOffReqParam)executeContext.getReqParam();
        WriteOffTypeConfig writeOffTypeConfig = this.getConfigManager().getWfTypeConfigById(reqParam.getWfTypeId());
        SchemeContextManualConfig schemeContextConfig = reqParam.getSchemeContextConfig();
        SchemeConfig schemeConfig = this.getConfigManager().getSchemeConfigById(schemeContextConfig.getSchemeId(), writeOffTypeConfig.getId());
        ArrayList<WriteOffManualGroup> groups = new ArrayList<WriteOffManualGroup>(16);
        List<WriteOffManualEntity> manualEntity = this.buildManualEntity(reqParam, writeOffTypeConfig);
        int i = 0;
        for (WriteOffManualEntity writeOffManualEntity : manualEntity) {
            WriteOffBillConfig billConfig = writeOffManualEntity.getBillConfig();
            WriteOffManualGroup writeOffManualGroup = WriteOffManualGroup.build(writeOffTypeConfig, billConfig, schemeConfig, executeContext.getBillDataSource());
            String billEntryIdKey = writeOffManualEntity.getMainFieldIdKey();
            String entityName = billConfig.getBillType();
            Map<Object, BigDecimal> curMainFieldValueMap = writeOffManualEntity.getCurMainFieldValueMap();
            writeOffManualGroup.setFilter(Collections.singletonList(FilterFactory.create(entityName, billEntryIdKey, "in", curMainFieldValueMap.keySet())), maxHandleBillSize);
            if (!schemeContextConfig.isLastWhole() && !schemeContextConfig.isWhole()) {
                writeOffManualGroup.setCurMainFieldValueMap(curMainFieldValueMap);
            }
            if (i == 0) {
                writeOffManualGroup.initWriteOffObject(schemeContextConfig.isSingle());
            }
            groups.add(writeOffManualGroup);
            ++i;
        }
        return groups;
    }

    private List<WriteOffManualEntity> buildManualEntity(ManualWriteOffReqParam reqParam, WriteOffTypeConfig writeOffTypeConfig) {
        ArrayList<WriteOffManualEntity> entitys = new ArrayList<WriteOffManualEntity>(16);
        List<Map<Object, BigDecimal>> curMainFieldValueMaps = reqParam.getCurMainFieldValueMaps();
        Map entryMap = (Map)reqParam.getParams().get("entry");
        Map mainFieldKey = (Map)reqParam.getParams().get("entrywfmainfieldmap");
        for (int i = 0; i < curMainFieldValueMaps.size(); ++i) {
            WriteOffBillConfig writeOffBillConfig = writeOffTypeConfig.getBillConfigs().get(i);
            Map<Object, BigDecimal> curMainFieldValueMap = curMainFieldValueMaps.get(i);
            WriteOffManualEntity entity = new WriteOffManualEntity(writeOffBillConfig, curMainFieldValueMap);
            String fieldKey = (String)mainFieldKey.get(entryMap.get(i));
            if (fieldKey != null) {
                String[] split = fieldKey.split(SPIT);
                String wfMainField = split[0];
                String wfMainFieldMethod = split[1];
                if ("A".equals(wfMainFieldMethod)) {
                    entity.setMainFieldKey(wfMainField);
                } else if (WFFIELD_FORMULA.equals(wfMainFieldMethod) || WFFIELD_PLUGIN.equals(wfMainFieldMethod)) {
                    String wfCalcFieldIdName = entity.getBillConfig().getWfCalcFieldIdName();
                    entity.setMainFieldKey(wfCalcFieldIdName);
                }
            }
            entitys.add(entity);
        }
        return entitys;
    }
}

