/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.RecordMappingConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.AbstractLoadConfigParamAction;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.AbstractManualReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.ManualAutoWfReqParam;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class ManualConfigLoadAction
extends AbstractLoadConfigParamAction<AbstractManualReqParam> {
    @Override
    protected void loadConfig() {
        SchemeConfig schemeConfig;
        AbstractManualReqParam reqParam = (AbstractManualReqParam)this.getReqParam();
        Long wfTypeId = reqParam.getWfTypeId();
        QFilter writeOffTypefilter = new QFilter("id", "=", (Object)wfTypeId).and("enable", "=", (Object)Boolean.TRUE).and("writeofftype", "=", (Object)"A");
        DynamicObject writeOffObj = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_writeofftype", (QFilter[])writeOffTypefilter.toArray());
        HashSet<Long> recordMappingIds = new HashSet<Long>(16);
        if (writeOffObj == null) {
            throw new KDBizException(EngineLang.writeOffTypeNoEnable());
        }
        WriteOffTypeConfig wftypeConfig = WriteOffTypeConfig.build(writeOffObj);
        this.getConfigManager().addWriteOffTypeConfig(wftypeConfig);
        recordMappingIds.addAll(wftypeConfig.getRecordMappingIdByWfType());
        QFilter mappingFilter = new QFilter("id", "in", recordMappingIds);
        Map allRecordMappingObjs = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])mappingFilter.toArray());
        for (DynamicObject mapping : allRecordMappingObjs.values()) {
            RecordMappingConfig rmConfig = RecordMappingConfig.build(mapping);
            this.getConfigManager().addRecordMappingConfig(rmConfig);
        }
        Long schemeId = (Long)reqParam.getSchemaMap().get("sub_wf_scheme");
        QFilter schemeFilter = new QFilter("id", "=", (Object)schemeId).and("enable", "=", (Object)Boolean.TRUE);
        DynamicObject schemeEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_scheme", (QFilter[])schemeFilter.toArray());
        if (schemeEntity != null) {
            schemeConfig = SchemeConfig.build(schemeEntity);
            if (schemeConfig.isNoCondition() && this.getReqParam() instanceof ManualAutoWfReqParam) {
                throw new KDBizException(EngineLang.autoWriteOffNoCondition(schemeConfig));
            }
        } else {
            throw new KDBizException(EngineLang.writeOffSchemeNoEnable());
        }
        this.getConfigManager().addSchemeContextConfig(schemeConfig);
    }
}

