/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl.schematch;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffAction;
import kd.mpscmm.mscommon.writeoff.business.engine.param.IWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.SchemeMatchReqParam;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;

public class SchemeMatchConfigLoadAction
extends AbstractWriteOffAction {
    @Override
    protected boolean isSkipAction() {
        IWriteOffReqParam reqParam = ((WriteOffExecuteContext)this.getExecuteContext()).getReqParam();
        return !(reqParam instanceof SchemeMatchReqParam);
    }

    @Override
    protected void doAction() {
        SchemeMatchReqParam reqParam = (SchemeMatchReqParam)((WriteOffExecuteContext)this.getExecuteContext()).getReqParam();
        String reqbillEntity = reqParam.getReqbillEntity();
        Map wfSchemeObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_scheme", (QFilter[])new QFilter("id", "in", reqParam.getSchemes()).toArray());
        HashMap wftToSchemes = new HashMap(16);
        for (DynamicObject schemeObj : wfSchemeObjs.values()) {
            DynamicObject matchRule = schemeObj.getDynamicObject("matchrule");
            if (schemeObj.getBoolean("isunconditionmatch") || matchRule == null || !schemeObj.getBoolean("enable")) continue;
            DynamicObject wfType = schemeObj.getDynamicObject("writeofftype");
            SchemeConfig schemeConfig = SchemeConfig.build(schemeObj);
            MapUtils.mapGetListValue(wftToSchemes, wfType.getLong("id")).add(schemeConfig);
            this.getConfigManager().addSchemeContextConfig(schemeConfig);
        }
        if (wftToSchemes.isEmpty()) {
            throw new KDBizException(new ErrorCode("MSWF-MBS-000001", FormLang.notFitScheme()), new Object[0]);
        }
        Map wfTypeObjs = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])new QFilter("id", "in", wftToSchemes.keySet()).toArray());
        for (DynamicObject wfType : wfTypeObjs.values()) {
            if ("B".equals(wfType.getString("writeofftype"))) continue;
            Boolean isContain = false;
            DynamicObjectCollection writeOffEntries = wfType.getDynamicObjectCollection("writeoffbillentry");
            for (DynamicObject writeOffEntry : writeOffEntries) {
                DynamicObject wfBillEntry;
                if (!writeOffEntry.getBoolean("isinvolved") || writeOffEntry.getBoolean("isautogenerate") || !StringUtils.equals((CharSequence)(wfBillEntry = writeOffEntry.getDynamicObject("wfbillalias")).getString("wfbill.number"), (CharSequence)reqbillEntity)) continue;
                isContain = true;
                break;
            }
            if (!isContain.booleanValue()) continue;
            WriteOffTypeConfig typeConfig = WriteOffTypeConfig.build(wfType);
            this.getConfigManager().addWriteOffTypeConfig(typeConfig);
        }
    }
}

