/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl.schematch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.AbstractBillGroupAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffBillGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.business.engine.param.IWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.FlowWriteOffReqParam;
import kd.mpscmm.mscommon.writeoff.business.engine.param.impl.SchemeMatchReqParam;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffGroupHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import org.apache.commons.collections.CollectionUtils;

public class SchemeMatchGroupAction
extends AbstractBillGroupAction {
    @Override
    protected boolean isSkipAction() {
        IWriteOffReqParam reqParam = ((WriteOffExecuteContext)this.getExecuteContext()).getReqParam();
        return !(reqParam instanceof SchemeMatchReqParam);
    }

    @Override
    protected List<WriteOffMatchGroup> getBillGroup() {
        WriteOffExecuteContext executeContext = (WriteOffExecuteContext)this.getExecuteContext();
        SchemeMatchReqParam reqParam = (SchemeMatchReqParam)executeContext.getReqParam();
        String reqbillEntity = reqParam.getReqbillEntity();
        ArrayList<WriteOffMatchGroup> groups = new ArrayList<WriteOffMatchGroup>(16);
        List<WriteOffTypeConfig> typeConfigs = this.getConfigManager().getAllWriteOffTypeConfigs();
        for (WriteOffTypeConfig typeConfig : typeConfigs) {
            log.info("\u8bfb\u53d6\u7c7b\u522b" + typeConfig.getName() + "\u5206\u7ec4\u914d\u7f6e");
            List<WriteOffBillConfig> bills = typeConfig.getBillConfigs().stream().filter(n -> n.getBillType().equals(reqbillEntity)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bills)) continue;
            List<WriteOffMatchGroup> billGroup = this.doGroup(typeConfig, bills, reqParam);
            groups.addAll(billGroup);
        }
        return groups;
    }

    private List<WriteOffMatchGroup> doGroup(WriteOffTypeConfig typeConfig, List<WriteOffBillConfig> bills, FlowWriteOffReqParam reqParam) {
        WriteOffBillConfig writeOffBillConfig = bills.get(0);
        if (writeOffBillConfig.isNeedGenerate()) {
            log.info("\u6838\u9500\u5e73\u53f0\uff1a\u81ea\u52a8\u751f\u6210\u5355\u636e\u4e0d\u80fd\u4f5c\u4e3a\u4e3b\u65b9\u8fdb\u884c\u6838\u9500\u2014\u2014" + typeConfig.getName());
            return Collections.emptyList();
        }
        String mainFieldEntry = writeOffBillConfig.getMainFieldEntry();
        ArrayList<QFilter> billFilter = new ArrayList<QFilter>(16);
        billFilter.add(new QFilter("id", "in", reqParam.getReqbillIds()));
        billFilter.addAll(writeOffBillConfig.getFilters());
        DynamicObjectCollection dataEntities = ((WriteOffExecuteContext)this.getExecuteContext()).getBillDataSource().queryBillData(reqParam.getReqbillEntity(), mainFieldEntry, billFilter.toArray(new QFilter[billFilter.size()]));
        if (dataEntities.isEmpty()) {
            log.info("\u6838\u9500\u5e73\u53f0\uff1a\u672a\u6ee1\u8db3\u5355\u636e\u8fc7\u6ee4\u6761\u4ef6\u2014" + typeConfig.getName());
            return Collections.emptyList();
        }
        List<WriteOffBillGroup> writeOffBillTypeGroups = this.groupBillByWriteOffType(typeConfig, writeOffBillConfig, dataEntities, reqParam.getReqbillEntity());
        if (CollectionUtils.isEmpty(writeOffBillTypeGroups)) {
            for (DynamicObject dataEntity : dataEntities) {
                ((WriteOffExecuteContext)this.getExecuteContext()).getExecuteInfo().addInfo(dataEntity.getPkValue(), typeConfig.getId(), EngineLang.writeOffTypeNotMatch(typeConfig));
            }
            return Collections.emptyList();
        }
        return this.splitGroup(typeConfig, reqParam, writeOffBillTypeGroups, false);
    }

    private List<WriteOffBillGroup> groupBillByWriteOffType(WriteOffTypeConfig typeConfig, WriteOffBillConfig writeOffBillConfig, DynamicObjectCollection dataEntities, String reqbillEntity) {
        HashSet<Object> groupedObjIds = new HashSet<Object>(16);
        ArrayList<WriteOffBillGroup> writeOffBillGroups = new ArrayList<WriteOffBillGroup>();
        ArrayList<WriteOffObject> writeOffObjects = new ArrayList<WriteOffObject>();
        for (DynamicObject dataEntity : dataEntities) {
            List<WriteOffObject> loadObjects = WriteOffGroupHelper.buildWriteOffObjects(typeConfig, writeOffBillConfig, dataEntity);
            for (WriteOffObject writeOffObject : loadObjects) {
                if (groupedObjIds.contains(writeOffObject.getWriteOffObjectPk()) || writeOffObject.isCurWriteOffZero() || writeOffObject.isWfComplete() || !writeOffBillConfig.checkHighCondtion(writeOffObject)) continue;
                writeOffObjects.add(writeOffObject);
                groupedObjIds.add(writeOffObject.getWriteOffObjectPk());
            }
        }
        if (CollectionUtils.isNotEmpty(writeOffObjects)) {
            WriteOffBillGroup writeOffGroup = new WriteOffBillGroup(typeConfig, writeOffBillConfig);
            writeOffGroup.addWriteOffObjects(writeOffObjects);
            writeOffBillGroups.add(writeOffGroup);
        }
        return writeOffBillGroups;
    }

    private List<WriteOffMatchGroup> splitGroup(WriteOffTypeConfig typeConfig, FlowWriteOffReqParam reqParam, List<WriteOffBillGroup> writeOffBillTypeGroups, boolean isShareAssist) {
        List<SchemeConfig> allSchemeConfigs = this.getConfigManager().getAllSchemeConfigs();
        HashMap typeToSchemeConfig = new HashMap(16);
        for (SchemeConfig schemeConfig : allSchemeConfigs) {
            MapUtils.mapGetListValue(typeToSchemeConfig, schemeConfig.getWriteOffTypeId()).add(schemeConfig);
        }
        ArrayList<WriteOffMatchGroup> groups = new ArrayList<WriteOffMatchGroup>(16);
        for (WriteOffBillGroup writeOffBillTypeGroup : writeOffBillTypeGroups) {
            WriteOffBillConfig billTypeConfig = writeOffBillTypeGroup.getBillTypeConfig();
            List<WriteOffObject> typeWriteOffObjs = writeOffBillTypeGroup.getWriteOffObjects();
            List schemeConfigs = (List)typeToSchemeConfig.get(typeConfig.getId());
            for (SchemeConfig schemeConfig : schemeConfigs) {
                MatchRuleConfig matchRuleConfig;
                if (schemeConfig.isNoCondition() || (matchRuleConfig = this.getConfigManager().getMatchRuleConfigById(schemeConfig.getMatchRuleId(), typeConfig.getId())) == null) continue;
                List<WriteOffMatchGroup> writeOffMatchGroups = WriteOffGroupHelper.groupByMatchRule(typeConfig, billTypeConfig, schemeConfig, matchRuleConfig, typeWriteOffObjs, ((WriteOffExecuteContext)this.getExecuteContext()).getPluginFactory());
                groups.addAll(writeOffMatchGroups);
            }
        }
        return groups;
    }
}

