/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillBotpLinkInfoManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchConditionConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffStepAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.BillDataSource;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.HintDataMatcher;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.entity.filter.IWFFilter;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffManualGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.MatchPluginProxy;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;

public class HintQueryBillSetpAction
extends AbstractWriteOffStepAction {
    @Override
    protected void doAction() {
        WriteOffTypeContext executeContext = (WriteOffTypeContext)this.getExecuteContext();
        Map<Long, List<WriteOffMatchGroup>> matchGroup = this.sortBySchemes(executeContext.getMatchGroup());
        for (List<WriteOffMatchGroup> schemeGroup : matchGroup.values()) {
            if (((WriteOffTypeContext)this.getExecuteContext()).getTypeConfig().isRBWriteOff()) {
                log.info("\u7ea2\u84dd\u6838\u9500Hint\u5339\u914d\uff0c\u9700\u8981\u6839\u636e\u89e6\u53d1\u7684\u5355\u636e\u518d\u5206\u4e00\u6b21\u3002");
                HashMap wbToGroups = new HashMap();
                for (WriteOffMatchGroup writeOffMatchGroup : schemeGroup) {
                    Object wbId = writeOffMatchGroup.getBillTypeConfig().getObjId();
                    MapUtils.mapGetListValue(wbToGroups, wbId).add(writeOffMatchGroup);
                }
                for (Map.Entry entry : wbToGroups.entrySet()) {
                    log.info("\u7ea2\u84dd\u6838\u9500Hint\u5339\u914d\uff1a\u53d1\u8d77\u5355\u636e\uff1a" + entry.getKey());
                    this.doHintQuery((List)entry.getValue());
                }
                continue;
            }
            this.doHintQuery(schemeGroup);
        }
    }

    private Map<Long, List<WriteOffMatchGroup>> sortBySchemes(List<WriteOffMatchGroup> matchGroup) {
        HashMap<Long, List<WriteOffMatchGroup>> schemeGroups = new HashMap<Long, List<WriteOffMatchGroup>>(16);
        for (WriteOffMatchGroup writeOffMatchGroup : matchGroup) {
            MapUtils.mapGetListValue(schemeGroups, writeOffMatchGroup.getSchemeConfig().getId()).add(writeOffMatchGroup);
        }
        return schemeGroups;
    }

    private void doHintQuery(List<WriteOffMatchGroup> groups) {
        WriteOffMatchGroup writeOffMatchGroup = groups.get(0);
        SchemeConfig schemeConfig = writeOffMatchGroup.getSchemeConfig();
        if (schemeConfig.isNoCondition()) {
            return;
        }
        SchemeContextConfig schemeContextConfig = writeOffMatchGroup.getSchemeContextConfig();
        if (schemeContextConfig != null && schemeContextConfig.isSingle()) {
            return;
        }
        WriteOffTypeConfig typeConfig = writeOffMatchGroup.getTypeConfig();
        WriteOffBillConfig srcBillConf = writeOffMatchGroup.getBillTypeConfig();
        String srcBillAlias = srcBillConf.getBillAlias();
        MatchRuleConfig matchRuleConfigById = this.getWFExecuteContext().getConfigManager().getMatchRuleConfigById(schemeConfig.getMatchRuleId(), typeConfig.getId());
        List<MatchRelationConfig> byPromoter = matchRuleConfigById.getByPromoter(srcBillAlias);
        for (MatchRelationConfig matchRelationConfig : byPromoter) {
            WriteOffBillConfig tgtBillConf = typeConfig.getBillConf(matchRelationConfig.getTargetBillTypeKey());
            MatchPluginProxy matchPluginProxy = ((WriteOffTypeContext)this.getExecuteContext()).getPluginFactory().createMatchPluginProxy(typeConfig, matchRuleConfigById);
            String botpTrackRelation = matchPluginProxy.botpTrackRelation(srcBillConf.getObj(), tgtBillConf.getObj());
            if ("trackup".equals(botpTrackRelation) || "trackdown".equals(botpTrackRelation)) {
                log.info(String.format("HintQueryBill\uff1a\u6838\u9500\u65b9\u6848\u3010%s\u3011\u6267\u884c\u6279\u91cfBotp\u5173\u7cfb\u67e5\u8be2\uff0c\u5173\u7cfb\u4e3a%s", schemeConfig.getName(), botpTrackRelation));
                this.doBotpLinkQuery(botpTrackRelation, groups, schemeConfig, matchRelationConfig, tgtBillConf);
                continue;
            }
            if (!matchRelationConfig.isOnHint()) continue;
            log.info(String.format("HintQueryBill\uff1a\u6838\u9500\u65b9\u6848\u3010%s\u3011\u6267\u884c\u6279\u91cfHint\u6761\u4ef6\u67e5\u8be2", schemeConfig.getName()));
            this.doHintQuery(groups, schemeConfig, matchRelationConfig, tgtBillConf);
        }
    }

    private void doBotpLinkQuery(String botpTrackRelation, List<WriteOffMatchGroup> groups, SchemeConfig schemeConfig, MatchRelationConfig matchRelationConfig, WriteOffBillConfig tgtBillConf) {
        WriteOffBillConfig srcBillConf = groups.get(0).getBillTypeConfig();
        if (srcBillConf.getWriteOffColumnConfig() == null) {
            return;
        }
        HashMap<Long, Set<Long>> billToFieldIds = new HashMap<Long, Set<Long>>(16);
        for (WriteOffMatchGroup group : groups) {
            List<WriteOffObject> writeOffObjects = group.getWriteOffObjects();
            Iterator<WriteOffObject> iterator = writeOffObjects.iterator();
            while (iterator.hasNext()) {
                WriteOffObject writeOffObject = iterator.next();
                MapUtils.mapGetSetValue(billToFieldIds, (Long)writeOffObject.getWriteOffBillPk()).add((Long)writeOffObject.getWriteOffObjectPk());
            }
        }
        Map<Long, List<BFRowId>> findNodes = null;
        if ("trackup".equals(botpTrackRelation)) {
            findNodes = new BillBotpLinkInfoManager().findLinkUpNodes(srcBillConf.getBillType(), srcBillConf.getMainFieldEntry(), billToFieldIds, tgtBillConf.getBillType());
        } else if ("trackdown".equals(botpTrackRelation)) {
            findNodes = new BillBotpLinkInfoManager().findLinkDownNodes(srcBillConf.getBillType(), srcBillConf.getMainFieldEntry(), billToFieldIds, tgtBillConf.getBillType());
        }
        if (findNodes == null || findNodes.isEmpty()) {
            HintDataMatcher hintDataLoader = ((WriteOffTypeContext)this.getExecuteContext()).getHintDataLoader();
            hintDataLoader.addMatchData(matchRelationConfig.getMatchId(), Collections.emptyList(), Collections.singletonList(CommonHelper.getEmptyFilter()), tgtBillConf, Collections.emptyList());
            return;
        }
        HashMap<Long, Set<Long>> srcToTgtList = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry entry : findNodes.entrySet()) {
            HashSet<Long> targetIds = new HashSet<Long>(16);
            for (BFRowId row : (List)entry.getValue()) {
                targetIds.add(row.getEntryId());
            }
            srcToTgtList.put((Long)entry.getKey(), (Set<Long>)targetIds);
        }
        String entryKey = this.getEntryKey(tgtBillConf, schemeConfig);
        List<QFilter> list = this.buildBotpLinkQueryFilter(matchRelationConfig, tgtBillConf, groups, entryKey, srcToTgtList);
        ArrayList<MatchConditionConfig> botpFields = new ArrayList<MatchConditionConfig>(2);
        botpFields.add(MatchConditionConfig.build(entryKey + ".id", entryKey + ".id"));
        BillDataSource billDataSource = this.getWFExecuteContext().getBillDataSource();
        DynamicObjectCollection hintQueryResults = billDataSource.queryBillData(tgtBillConf.getBillType(), entryKey, list.toArray(new QFilter[list.size()]));
        HintDataMatcher hintDataLoader = ((WriteOffTypeContext)this.getExecuteContext()).getHintDataLoader();
        hintDataLoader.addBotpLinkMatchData(matchRelationConfig.getMatchId(), (List<DynamicObject>)hintQueryResults, list, srcToTgtList, botpTrackRelation, tgtBillConf, botpFields);
    }

    public List<QFilter> buildBotpLinkQueryFilter(MatchRelationConfig matchRelationConfig, WriteOffBillConfig tgtBillConf, List<WriteOffMatchGroup> groups, String entryKey, Map<Long, Set<Long>> srcToTgtList) {
        String wfMainFieldId = null;
        wfMainFieldId = StringUtils.isNotEmpty((CharSequence)entryKey) ? entryKey + ".id" : "id";
        HashSet<Long> ids = new HashSet<Long>(16);
        for (Set<Long> rows : srcToTgtList.values()) {
            ids.addAll(rows);
        }
        ArrayList<QFilter> botpLinkFilters = new ArrayList<QFilter>(16);
        botpLinkFilters.add(new QFilter(wfMainFieldId, "in", ids));
        botpLinkFilters.addAll(this.getCommonFilter(tgtBillConf));
        return botpLinkFilters;
    }

    private void doHintQuery(List<WriteOffMatchGroup> groups, SchemeConfig schemeConfig, MatchRelationConfig matchRelationConfig, WriteOffBillConfig tgtBillConf) {
        String entryKey = this.getEntryKey(tgtBillConf, schemeConfig);
        List<QFilter> hintQueryFilters = this.buildHintQueryFilter(matchRelationConfig, tgtBillConf, groups, entryKey);
        List<MatchConditionConfig> hintConfigs = matchRelationConfig.getHintConfigs();
        this.queryHintData(tgtBillConf, matchRelationConfig, hintQueryFilters, entryKey, hintConfigs);
    }

    public List<QFilter> buildHintQueryFilter(MatchRelationConfig matchRelationConfig, WriteOffBillConfig tgtBillConf, List<WriteOffMatchGroup> groups, String entryKey) {
        String wfMainFieldId = null;
        if (StringUtils.isNotEmpty((CharSequence)entryKey)) {
            wfMainFieldId = entryKey + ".id";
        }
        ArrayList<QFilter> hintQueryFilters = new ArrayList<QFilter>(16);
        List<QFilter> hintFilter = matchRelationConfig.getHintFilter(groups, wfMainFieldId);
        hintQueryFilters.addAll(hintFilter);
        hintQueryFilters.addAll(this.getCommonFilter(tgtBillConf));
        return hintQueryFilters;
    }

    private String getEntryKey(WriteOffBillConfig tgtBillConf, SchemeConfig schemeConfig) {
        return tgtBillConf.getWriteOffColumnConfig().mainFieldCalClass().mainFieldEntry();
    }

    private List<QFilter> getCommonFilter(WriteOffBillConfig tgtBillConf) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        List<QFilter> wfTypeFilter = tgtBillConf.getFilters();
        filters.addAll(wfTypeFilter);
        List<WriteOffManualGroup> manualGroups = this.getWFExecuteContext().getWriteOffManualGroups();
        for (WriteOffManualGroup mGroup : manualGroups) {
            List<IWFFilter> filter = mGroup.getFilter();
            if (!tgtBillConf.getBillAlias().equals(mGroup.getBillTypeConfig().getBillAlias()) || filter.isEmpty()) continue;
            filters.add(IWFFilter.toSingleQFilter(mGroup.getFilter()));
        }
        WriteOffColumnConfig writeOffColumnConfig = tgtBillConf.getWriteOffColumnConfig();
        if (writeOffColumnConfig != null && writeOffColumnConfig.getWfFieldInfo().isWfBillField()) {
            String mainField = writeOffColumnConfig.getWriteOffFieldKey();
            filters.add(new QFilter(mainField, "!=", (Object)BigDecimal.ZERO));
        }
        return filters;
    }

    private void queryHintData(WriteOffBillConfig tgtBillConf, MatchRelationConfig matchRelationConfig, List<QFilter> hintQueryFilters, String entryKey, List<MatchConditionConfig> hintConfigs) {
        if (hintQueryFilters.isEmpty()) {
            log.info("\u6838\u9500Hint\u67e5\u8be2\u9519\u8bef\uff0c\u65e0\u6cd5\u751f\u6210Hint\u67e5\u8be2\u8fc7\u6ee4\u6761\u4ef6");
            return;
        }
        log.info("\u6838\u9500Hint\u67e5\u8be2\u8fc7\u6ee4\u6761\u4ef6\uff1a" + hintQueryFilters);
        boolean isExistEmptyQFilter = this.isExistEmptyQFilter(hintQueryFilters);
        DynamicObjectCollection hintQueryResults = null;
        if (isExistEmptyQFilter) {
            hintQueryResults = Collections.emptyList();
        } else {
            BillDataSource billDataSource = this.getWFExecuteContext().getBillDataSource();
            hintQueryResults = billDataSource.queryBillData(tgtBillConf.getBillType(), entryKey, hintQueryFilters.toArray(new QFilter[hintQueryFilters.size()]));
            log.info("Hint\u5339\u914d\u67e5\u8be2\u6570\u636e\u91cfSize\uff1a" + hintQueryResults.size());
        }
        HintDataMatcher hintDataLoader = ((WriteOffTypeContext)this.getExecuteContext()).getHintDataLoader();
        hintDataLoader.addMatchData(matchRelationConfig.getMatchId(), (List<DynamicObject>)hintQueryResults, hintQueryFilters, tgtBillConf, hintConfigs);
    }

    private boolean isExistEmptyQFilter(List<QFilter> hintQueryFilters) {
        for (QFilter qFilter : hintQueryFilters) {
            if (!"1 != 1".equals(qFilter.toString())) continue;
            return true;
        }
        return false;
    }
}

