/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffStepAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffBillGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;
import org.apache.commons.collections.CollectionUtils;

public class UpdateWriteOffNumberSetpAction
extends AbstractWriteOffStepAction {
    @Override
    protected boolean isSkipAction() {
        List<WriteOffMatchGroup> matchGroup = ((WriteOffTypeContext)this.getExecuteContext()).getMatchGroup();
        if (matchGroup == null || matchGroup.isEmpty()) {
            return true;
        }
        return super.isSkipAction();
    }

    @Override
    protected void doAction() {
        List<WriteOffMatchGroup> matchGroupList = ((WriteOffTypeContext)this.getExecuteContext()).getMatchGroup();
        this.updateWriteOffNumber(matchGroupList);
    }

    public void updateWriteOffNumber(List<WriteOffMatchGroup> matchGroupList) {
        WriteOffTypeContext executeContext = (WriteOffTypeContext)this.getExecuteContext();
        if (CollectionUtils.isEmpty(matchGroupList)) {
            return;
        }
        WriteOffBillConfig billTypeConfig = matchGroupList.get(0).getBillTypeConfig();
        ArrayList<Object> wfObIdList = new ArrayList<Object>(16);
        ArrayList<Object> wfBillIds = new ArrayList<Object>(16);
        for (WriteOffBillGroup writeOffBillGroup : matchGroupList) {
            List<WriteOffObject> writeOffObjects = writeOffBillGroup.getWriteOffObjects();
            for (WriteOffObject writeOffObject : writeOffObjects) {
                wfObIdList.add(writeOffObject.getWriteOffObjectPk());
                wfBillIds.add(writeOffObject.getWriteOffBillPk());
            }
        }
        String reqbillEntity = billTypeConfig.getBillType();
        executeContext.setBillTypeKey(reqbillEntity);
        executeContext.getSnapshotContext().loadSnapShootMap(wfBillIds, reqbillEntity);
        boolean bl = executeContext.isManualWriteOff();
        if (bl) {
            return;
        }
        Map<Object, BigDecimal> wfNumberMap = UpdateWriteOffNumberSetpAction.getWfNumberMap(billTypeConfig, wfObIdList);
        for (WriteOffBillGroup writeOffBillGroup : matchGroupList) {
            Iterator<WriteOffObject> iterator = writeOffBillGroup.getWriteOffObjects().iterator();
            while (iterator.hasNext()) {
                WriteOffObject writeOffObject = iterator.next();
                WriteOffObjectBase writeOffObjectBase = writeOffObject.getWriteOffObjectBase();
                BigDecimal srcWfNumber = writeOffObjectBase.getWriteOffNumber();
                if (BigDecimal.ZERO.compareTo(srcWfNumber) == 0) {
                    srcWfNumber = writeOffObjectBase.getCurWriteOffNumber();
                }
                BigDecimal newCurNumber = wfNumberMap.get(writeOffObject.getWriteOffObjectPk());
                writeOffObject.setCurWriteOffNumber(newCurNumber);
                BigDecimal newWfNumber = newCurNumber.subtract(executeContext.getWriteOffQty(writeOffObject));
                writeOffObject.setWriteOffNumber(newWfNumber);
                writeOffObjectBase.setAssistWriteOffNumber(newWfNumber, srcWfNumber);
                if (BigDecimal.ZERO.compareTo(newWfNumber) != 0) continue;
                iterator.remove();
            }
        }
    }

    private static Map<Object, BigDecimal> getWfNumberMap(WriteOffBillConfig writeOffBillConfig, List<Object> wfObjectIds) {
        HashMap<Object, BigDecimal> wfNumberMap = new HashMap<Object, BigDecimal>(16);
        String wfCalcFieldIdName = writeOffBillConfig.getWfCalcFieldIdName();
        IWriteOffMainFieldCalPlugin mainFieldCalPlugin = writeOffBillConfig.getWriteOffColumnConfig().mainFieldCalClass();
        List<String> fields = mainFieldCalPlugin.calNeedFields();
        String billType = writeOffBillConfig.getBillType();
        String selectFields = BillFieldInfoManager.buildSelectField(billType, mainFieldCalPlugin.mainFieldEntry(), fields);
        QFilter wfObjectIdFilter = new QFilter(wfCalcFieldIdName, "in", wfObjectIds);
        DynamicObjectCollection queryBills = QueryServiceHelper.query((String)billType, (String)(wfCalcFieldIdName + "," + selectFields), (QFilter[])wfObjectIdFilter.toArray());
        for (DynamicObject bill : queryBills) {
            BigDecimal wfNumber = writeOffBillConfig.getWriteOffColumnConfig().mainFieldCalClass().mainFieldCal(bill);
            wfNumberMap.put(bill.get(wfCalcFieldIdName), wfNumber);
        }
        return wfNumberMap;
    }
}

