/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.action.impl.step;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeContextFlowConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WorkflowBillOperateConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffStepAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.AbstractWfGroupExecutor;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;

public class WriteOffCoreSetpAction
extends AbstractWriteOffStepAction {
    private AbstractWfGroupExecutor wfGroupExecutor;

    public WriteOffCoreSetpAction(AbstractWfGroupExecutor wfGroupExecutor) {
        this.wfGroupExecutor = wfGroupExecutor;
    }

    @Override
    protected void doAction() {
        WriteOffTypeContext executeContext = (WriteOffTypeContext)this.getExecuteContext();
        List<WriteOffMatchGroup> allWriteOffGourps = executeContext.getMatchGroup();
        if (this.getWFExecuteContext().isFlowWriteOff()) {
            Map<String, Map<Object, WriteOffObject>> billToObjs;
            LinkedHashMap<String, List<WriteOffMatchGroup>> sortByFlows = this.sortByFlows(allWriteOffGourps);
            boolean isWBWf = ((WriteOffTypeContext)this.getExecuteContext()).getTypeConfig().isRBWriteOff();
            if (isWBWf && (billToObjs = this.sortByBillConfig(allWriteOffGourps)) != null && billToObjs.size() == 2) {
                log.info("\u6838\u9500\u5e73\u53f0\uff1a\u7ea2\u84dd\u6838\u9500\u2014\u2014\u7ea2\u5355\u548c\u84dd\u5355\u4e00\u8d77\u89e6\u53d1\u6838\u9500\u4e14\u53ef\u80fd\u76f8\u4e92\u6838\u9500");
                executeContext.addRedBuleSrcObject(billToObjs);
            }
            for (List<WriteOffMatchGroup> writeOffMatchGroup : sortByFlows.values()) {
                this.doWriteOff(writeOffMatchGroup);
            }
        } else {
            this.doWriteOff(allWriteOffGourps);
        }
    }

    private Map<String, Map<Object, WriteOffObject>> sortByBillConfig(List<WriteOffMatchGroup> allWriteOffGourps) {
        HashMap<String, Map<Object, WriteOffObject>> result = new HashMap<String, Map<Object, WriteOffObject>>(16);
        for (WriteOffMatchGroup group : allWriteOffGourps) {
            String billAlias = group.getBillTypeConfig().getBillAlias();
            Map<Object, WriteOffObject> idToObj = MapUtils.mapGetMapValue(result, billAlias);
            List<WriteOffObject> writeOffObjects = group.getWriteOffObjects();
            for (WriteOffObject writeOffObject : writeOffObjects) {
                idToObj.put(writeOffObject.getWriteOffObjectPk(), writeOffObject);
            }
        }
        return result;
    }

    private LinkedHashMap<String, List<WriteOffMatchGroup>> sortByFlows(List<WriteOffMatchGroup> allWriteOffGourps) {
        allWriteOffGourps.sort((o1, o2) -> {
            WorkflowBillOperateConfig wfFlowConfig = o1.getWfFlowConfig();
            WorkflowBillOperateConfig wfFlowConfig2 = o2.getWfFlowConfig();
            if (wfFlowConfig == null) {
                return -1;
            }
            if (wfFlowConfig2 == null) {
                return 1;
            }
            Integer seq1 = wfFlowConfig.getObj().getInt("seq");
            Integer seq2 = wfFlowConfig2.getObj().getInt("seq");
            if (Integer.compare(seq1, seq2) != 0) {
                return seq1 - seq2;
            }
            SchemeConfig schemeConfig1 = o1.getSchemeConfig();
            SchemeConfig schemeConfig2 = o2.getSchemeConfig();
            for (SchemeContextFlowConfig configs : wfFlowConfig.getSchemeContextConfigs()) {
                if (schemeConfig1.getId().equals(configs.getSchemeId())) {
                    return -1;
                }
                if (!schemeConfig2.getId().equals(configs.getSchemeId())) continue;
                return 1;
            }
            return 0;
        });
        LinkedHashMap<String, List<WriteOffMatchGroup>> sortedMap = new LinkedHashMap<String, List<WriteOffMatchGroup>>();
        for (WriteOffMatchGroup writeOffMatchGroup : allWriteOffGourps) {
            StringBuilder key = new StringBuilder();
            SchemeConfig schemeConfig = writeOffMatchGroup.getSchemeConfig();
            if (schemeConfig != null) {
                key.append(schemeConfig.getId());
            }
            key.append("-");
            WorkflowBillOperateConfig wfFlowConfig = writeOffMatchGroup.getWfFlowConfig();
            if (wfFlowConfig != null) {
                key.append(wfFlowConfig.getObjId());
            }
            MapUtils.mapGetListValue(sortedMap, key.toString()).add(writeOffMatchGroup);
        }
        return sortedMap;
    }

    private void doWriteOff(List<WriteOffMatchGroup> matchGroups) {
        log.info("\u6838\u9500\u5e73\u53f0\u6267\u884c\u6838\u9500\u65b9\u6848" + matchGroups.get(0).getSchemeConfig().getName());
        this.filterMatchGroups(matchGroups);
        if (matchGroups.isEmpty() && !this.getWFExecuteContext().isSingle()) {
            return;
        }
        ((WriteOffTypeContext)this.getExecuteContext()).addMatchParams("canwriteoff", true);
        this.wfGroupExecutor.init((WriteOffTypeContext)this.getExecuteContext());
        this.wfGroupExecutor.doExecute(matchGroups);
        if (this.wfGroupExecutor.getMatchObj().booleanValue()) {
            ((WriteOffTypeContext)this.getExecuteContext()).addMatchParams("ismatch", true);
        }
    }

    private void filterMatchGroups(List<WriteOffMatchGroup> matchGroups) {
        for (WriteOffMatchGroup matchGroup : matchGroups) {
            matchGroup.filter();
        }
    }
}

