/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.FlowWfGroupExecutor;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;
import org.apache.commons.collections.CollectionUtils;

public class FlowPreMatchGroupExecutor
extends FlowWfGroupExecutor {
    @Override
    public void doExecute(List<WriteOffMatchGroup> matchGroups) {
        WriteOffMatchGroup wfMatchGroup = matchGroups.get(0);
        WriteOffBillConfig billTypeConfig = wfMatchGroup.getBillTypeConfig();
        MatchRuleConfig matchRule = this.getMatchRule(wfMatchGroup);
        String billAlias = billTypeConfig.getBillAlias();
        this.getExecuteContext().getPluginFactory().createMatchPluginProxy(this.getTypeConfig(), matchRule).batchSetGroupMatchFilter(billAlias, matchGroups);
        for (WriteOffMatchGroup writeOffMatchGroup : matchGroups) {
            WriteOffQueueGroup queueGroup = new WriteOffQueueGroup(writeOffMatchGroup);
            WriteOffExecuteContext executeContext = this.getExecuteContext();
            List<MatchRelationConfig> relationConfigs = this.getMatchRule(writeOffMatchGroup).getByPromoter(billTypeConfig.getBillAlias());
            List<WriteOffObject> writeOffObjects = writeOffMatchGroup.getWriteOffObjects();
            this.getExecuteContext().getPluginFactory().createFilterPluginProxy(this.getTypeConfig()).filterObjCondition(writeOffObjects);
            if (CollectionUtils.isEmpty(writeOffObjects)) continue;
            for (int i = 0; i < relationConfigs.size(); ++i) {
                MatchRelationConfig relationConfig = relationConfigs.get(i);
                List<WriteOffObject> matchObjects = this.getMatchObjs(writeOffMatchGroup, relationConfig);
                queueGroup.createParticipantQueue(matchObjects);
            }
            queueGroup.sort();
            executeContext.addParam("isWriteLog", Boolean.TRUE);
            this.addPreMatchData(queueGroup, writeOffMatchGroup, executeContext);
        }
    }

    private void addPreMatchData(WriteOffQueueGroup dispatcher, WriteOffMatchGroup writeOffMatchGroup, WriteOffExecuteContext executeContext) {
        List<IWriteOffQueue> candidateQueues = dispatcher.getCandidateQueues();
        ArrayList preMatchResult = new ArrayList(16);
        for (IWriteOffQueue queue : candidateQueues) {
            List<WriteOffObjectBase> writeOffObjectBases = queue.peekAll();
            List objMap = writeOffObjectBases.stream().map(n -> {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("matchbill", n.getWfBillEntity());
                map.put("matchobjbillno", n.getWfBillBillNo());
                map.put("matchobjtype", "1");
                if (n.getWriteOffBillPk().equals(n.getPkValue())) {
                    map.put("matchobjtype", "0");
                }
                map.put("matchobjbillid", n.getPkValue());
                map.put("curmatchnum", n.getCurWriteOffNumber());
                map.put("matchnum", n.getWriteOffNumber());
                return map;
            }).collect(Collectors.toList());
            preMatchResult.add(objMap);
        }
        WriteOffTypeContext typeContext = executeContext.getTypeContext(writeOffMatchGroup.getTypeConfig().getId());
        HashMap<String, List<List<Map<String, Object>>>> map = new HashMap<String, List<List<Map<String, Object>>>>(16);
        Long typeAndscheme = writeOffMatchGroup.getSchemeConfig().getId();
        map.put(writeOffMatchGroup.getGroupKey(), preMatchResult);
        typeContext.addMatchParams(typeAndscheme, map);
    }
}

