/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core;

import java.util.ArrayList;
import java.util.List;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.AbstractWfGroupExecutor;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.WriteOffBillMatcher;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.lock.BizLockUtils;
import kd.mpscmm.mscommon.writeoff.common.lock.BizLocker;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import org.apache.commons.collections.CollectionUtils;

public class FlowWfGroupExecutor
extends AbstractWfGroupExecutor {
    @Override
    public void doExecute(List<WriteOffMatchGroup> matchGroups) {
        WriteOffNLogInfo logInfo = this.getExecuteContext().getWriteOffLogByTypeId(this.getTypeConfig().getId());
        WriteOffMatchGroup wfMatchGroup = matchGroups.get(0);
        WriteOffBillConfig billTypeConfig = wfMatchGroup.getBillTypeConfig();
        MatchRuleConfig matchRule = this.getMatchRule(wfMatchGroup);
        String billAlias = billTypeConfig.getBillAlias();
        this.getExecuteContext().getPluginFactory().createMatchPluginProxy(this.getTypeConfig(), matchRule).batchSetGroupMatchFilter(billAlias, matchGroups);
        List<MatchRelationConfig> relationConfigs = matchRule.getByPromoter(billAlias);
        if (!this.checkHintMatch(logInfo, wfMatchGroup, relationConfigs)) {
            return;
        }
        ArrayList<WriteOffObject> allObjs = new ArrayList<WriteOffObject>(16);
        for (WriteOffMatchGroup writeOffMatchGroup : matchGroups) {
            allObjs.addAll(writeOffMatchGroup.getWriteOffObjects());
        }
        try (BizLocker locker = BizLocker.create(BizLockUtils.getLockWfBill(allObjs, true), logInfo, this.getExecuteContext().getWfParam().isNetCtr());){
            ArrayList<WriteOffQueueGroup> queues = new ArrayList<WriteOffQueueGroup>(16);
            try (TraceSpan trace = Tracer.create((String)"WriteOff-Matcher", (String)"executeMatch");){
                for (WriteOffMatchGroup writeOffMatchGroup : matchGroups) {
                    WriteOffQueueGroup queueGroup = new WriteOffQueueGroup(writeOffMatchGroup);
                    List<WriteOffObject> writeOffObjects = writeOffMatchGroup.getWriteOffObjects();
                    this.getExecuteContext().getPluginFactory().createFilterPluginProxy(this.getTypeConfig()).filterObjCondition(writeOffObjects);
                    if (CollectionUtils.isEmpty(writeOffObjects)) continue;
                    queueGroup.createPromoterQueue(writeOffObjects);
                    boolean isMatched = false;
                    for (int i = 0; i < relationConfigs.size(); ++i) {
                        MatchRelationConfig relationConfig = relationConfigs.get(i);
                        List<WriteOffObject> matchObjects = this.getMatchObjs(writeOffMatchGroup, relationConfig);
                        if (CollectionUtils.isNotEmpty(matchObjects)) {
                            isMatched = true;
                            if (!"trackup".equals(relationConfig.getTrackRelation()) && !"B".equals(writeOffMatchGroup.getTypeConfig().getObj().getString("writeofftype"))) {
                                locker.doLock(BizLockUtils.getLockWfBill(matchObjects, false));
                            }
                        }
                        queueGroup.createParticipantQueue(matchObjects);
                    }
                    if (!isMatched) continue;
                    queueGroup.sort();
                    queues.add(queueGroup);
                }
            }
            if (!queues.isEmpty()) {
                this.doWriteOff(queues);
            }
        }
    }

    protected List<WriteOffObject> getMatchObjs(WriteOffMatchGroup writeOffMatchGroup, MatchRelationConfig relationConfig) {
        WriteOffBillMatcher writeOffBillMatcher = WriteOffBillMatcher.create(writeOffMatchGroup, relationConfig, this.getExecuteContext(), this.getHolder());
        List<WriteOffObject> matchObjects = writeOffBillMatcher.executeMatch();
        List<WriteOffMatchConditionInfo> matchchCondition = writeOffBillMatcher.getWriteOffMatchConditionInfos();
        WriteOffNLogInfo logInfo = this.getExecuteContext().getWriteOffLogByTypeId(writeOffMatchGroup.getTypeConfig().getId());
        String failInfo = EngineLang.matchBillFail(writeOffMatchGroup, relationConfig);
        if (matchObjects.isEmpty()) {
            this.getExecuteContext().getExecuteInfo().addInfo(writeOffMatchGroup.getWriteOffObjects(), failInfo);
            logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, relationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "B");
            return matchObjects;
        }
        this.getExecuteContext().getPluginFactory().createFilterPluginProxy(this.getTypeConfig()).filterObjCondition(matchObjects);
        if (matchObjects.isEmpty()) {
            this.getExecuteContext().getExecuteInfo().addInfo(writeOffMatchGroup.getWriteOffObjects(), failInfo);
            logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, relationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "C");
            return matchObjects;
        }
        logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, relationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "A");
        return matchObjects;
    }
}

