/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.business.engine.core;

import java.util.ArrayList;
import java.util.List;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRelationConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.MatchRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.SchemeConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.AbstractWfGroupExecutor;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.match.WriteOffBillMatcher;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffManualGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchConditionInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.lock.BizLockUtils;
import kd.mpscmm.mscommon.writeoff.common.lock.BizLocker;
import org.apache.commons.collections.CollectionUtils;

public class ManualWfGroupExecutor
extends AbstractWfGroupExecutor {
    @Override
    public void doExecute(List<WriteOffMatchGroup> matchGroups) {
        WriteOffNLogInfo logInfo = this.getExecuteContext().getWriteOffLogByTypeId(this.getTypeConfig().getId());
        WriteOffMatchGroup wfMatchGroup = matchGroups.get(0);
        if (!wfMatchGroup.getSchemeConfig().isNoCondition()) {
            WriteOffBillConfig billTypeConfig = wfMatchGroup.getBillTypeConfig();
            MatchRuleConfig matchRule = this.getMatchRule(wfMatchGroup);
            String billAlias = billTypeConfig.getBillAlias();
            this.getExecuteContext().getPluginFactory().createMatchPluginProxy(this.getTypeConfig(), matchRule).batchSetGroupMatchFilter(billAlias, matchGroups);
            List<MatchRelationConfig> relationConfigs = matchRule.getByPromoter(billAlias);
            if (!this.checkHintMatch(logInfo, wfMatchGroup, relationConfigs)) {
                return;
            }
        }
        ArrayList<WriteOffObject> allObjs = new ArrayList<WriteOffObject>(16);
        for (WriteOffMatchGroup writeOffMatchGroup : matchGroups) {
            allObjs.addAll(writeOffMatchGroup.getWriteOffObjects());
        }
        try (BizLocker locker = BizLocker.create(BizLockUtils.getLockWfBill(allObjs, false), logInfo, this.getExecuteContext().getWfParam().isNetCtr());){
            ArrayList<WriteOffQueueGroup> queues = new ArrayList<WriteOffQueueGroup>(16);
            try (TraceSpan trace = Tracer.create((String)"WriteOff-Matcher", (String)"executeManualMatch");){
                for (WriteOffMatchGroup writeOffMatchGroup : matchGroups) {
                    WriteOffQueueGroup queueGroup = new WriteOffQueueGroup(writeOffMatchGroup);
                    List<WriteOffObject> writeOffObjects = writeOffMatchGroup.getWriteOffObjects();
                    this.getExecuteContext().getPluginFactory().createFilterPluginProxy(this.getTypeConfig()).filterObjCondition(writeOffObjects);
                    if (CollectionUtils.isEmpty(writeOffObjects)) continue;
                    queueGroup.createPromoterQueue(writeOffObjects);
                    List<WriteOffManualGroup> manualGroups = this.getExecuteContext().getWriteOffManualGroups();
                    if (!this.createParticipantQueues(queueGroup, manualGroups)) {
                        this.setMatchObj(Boolean.FALSE);
                        continue;
                    }
                    queueGroup.sort();
                    queues.add(queueGroup);
                }
            }
            this.doWriteOff(queues);
        }
    }

    private boolean createParticipantQueues(WriteOffQueueGroup dispatcher, List<WriteOffManualGroup> manualGroups) {
        SchemeConfig schemeConfig = dispatcher.getGroup().getSchemeConfig();
        if (!schemeConfig.isNoCondition()) {
            return this.createMatchQueue(dispatcher, manualGroups);
        }
        this.noConditionMatchQueue(dispatcher, manualGroups);
        return true;
    }

    protected void noConditionMatchQueue(WriteOffQueueGroup dispatcher, List<WriteOffManualGroup> manualGroups) {
        WriteOffMatchGroup writeOffMatchGroup = dispatcher.getGroup();
        for (int i = 0; i < manualGroups.size(); ++i) {
            WriteOffManualGroup writeOffManualGroup = manualGroups.get(i);
            writeOffManualGroup.initWriteOffObject(writeOffMatchGroup.getSchemeContextConfig().isSingle());
            List<WriteOffObject> writeOffObjects = writeOffManualGroup.getWriteOffObjects();
            dispatcher.createParticipantQueue(writeOffObjects);
        }
    }

    protected boolean createMatchQueue(WriteOffQueueGroup dispatcher, List<WriteOffManualGroup> manualGroups) {
        WriteOffMatchGroup writeOffMatchGroup = dispatcher.getGroup();
        WriteOffBillConfig billTypeConfig = writeOffMatchGroup.getBillTypeConfig();
        List<MatchRelationConfig> relationConfigs = this.getMatchRule(writeOffMatchGroup).getByPromoter(billTypeConfig.getBillAlias());
        WriteOffNLogInfo logInfo = this.getExecuteContext().getWriteOffLogByTypeId(writeOffMatchGroup.getTypeConfig().getId());
        for (int i = 0; i < relationConfigs.size(); ++i) {
            MatchRelationConfig matchRelationConfig = relationConfigs.get(i);
            String targetBillTypeKey = matchRelationConfig.getTargetBillTypeKey();
            WriteOffManualGroup group = manualGroups.stream().filter(n -> targetBillTypeKey.equals(n.getBillTypeConfig().getBillAlias())).findFirst().orElse(null);
            if (group == null) {
                return false;
            }
            WriteOffBillMatcher writeOffBillMatcher = WriteOffBillMatcher.create(writeOffMatchGroup, matchRelationConfig, this.getExecuteContext(), this.getHolder());
            writeOffBillMatcher.addFilters(group.getFilter());
            writeOffBillMatcher.setCurMainFieldValueMap(group.getCurMainFieldValueMap());
            List<WriteOffObject> matchObjects = writeOffBillMatcher.executeMatch();
            List<WriteOffMatchConditionInfo> matchchCondition = writeOffBillMatcher.getWriteOffMatchConditionInfos();
            if (CollectionUtils.isEmpty(matchObjects)) {
                logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, matchRelationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "B");
                return false;
            }
            this.getExecuteContext().getPluginFactory().createFilterPluginProxy(this.getTypeConfig()).filterObjCondition(matchObjects);
            if (CollectionUtils.isEmpty(matchObjects)) {
                logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, matchRelationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "C");
                return false;
            }
            logInfo.setMatchLogsInfo(writeOffMatchGroup, matchObjects, matchRelationConfig, matchchCondition, writeOffBillMatcher.getMatchConditionQFilter(), "A");
            dispatcher.createParticipantQueue(matchObjects);
        }
        return true;
    }
}

